CREATE TABLE `tblactivitylog` (
  `id` int(11) NOT NULL,
  `description` mediumtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tbladminclientreminders` (
  `id` int(11) NOT NULL,
  `description` text,
  `date` date NOT NULL,
  `isnotified` int(11) NOT NULL DEFAULT '0',
  `clientid` int(11) NOT NULL,
  `staff` int(11) NOT NULL,
  `notify_by_email` int(11) NOT NULL DEFAULT '1',
  `creator` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tbladminemployeereminders` (
  `id` int(11) NOT NULL,
  `description` text,
  `date` date NOT NULL,
  `isnotified` int(11) NOT NULL DEFAULT '0',
  `empid` int(11) NOT NULL,
  `staff` int(11) NOT NULL,
  `notify_by_email` int(11) NOT NULL DEFAULT '1',
  `creator` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tbladminsupplierreminders` (
  `id` int(11) NOT NULL,
  `description` text,
  `date` date NOT NULL,
  `isnotified` int(11) NOT NULL DEFAULT '0',
  `clientid` int(11) NOT NULL,
  `staff` int(11) NOT NULL,
  `notify_by_email` int(11) NOT NULL DEFAULT '1',
  `creator` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tbladminwarehousereminders` (
  `id` int(11) NOT NULL,
  `description` text,
  `date` date NOT NULL,
  `isnotified` int(11) NOT NULL DEFAULT '0',
  `ware_id` int(11) NOT NULL,
  `staff` int(11) NOT NULL,
  `notify_by_email` int(11) NOT NULL DEFAULT '1',
  `creator` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `tblallowedledgers` (
  `id` int(11) NOT NULL,
  `vouchertype_id` int(11) NOT NULL,
  `ledgerorgroupid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `tblannouncements` (
  `announcementid` int(11) NOT NULL,
  `name` varchar(300) NOT NULL,
  `message` text,
  `showtousers` int(11) NOT NULL,
  `showtostaff` int(11) NOT NULL,
  `showname` int(11) NOT NULL,
  `dateadded` datetime NOT NULL,
  `userid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblbanckaccounttransfer` (
  `id` int(11) NOT NULL,
  `date` date NOT NULL,
  `fromBank` int(11) NOT NULL,
  `fromBranch` int(11) NOT NULL,
  `fromAccount` int(11) NOT NULL,
  `fromBalance` decimal(10,2) NOT NULL,
  `fromCurrency` int(11) NOT NULL,
  `amountToTransfer` decimal(10,2) NOT NULL,
  `fromBAT` decimal(10,2) NOT NULL,
  `toBank` int(11) NOT NULL,
  `toBranch` int(11) NOT NULL,
  `toAccount` int(11) NOT NULL,
  `toBalance` decimal(10,2) NOT NULL,
  `toCurrency` int(11) NOT NULL,
  `toBAT` decimal(10,2) NOT NULL,
  `createdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `note` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `tblbankbrancheattachments` (
  `id` int(11) NOT NULL,
  `clientid` int(11) NOT NULL,
  `file_name` varchar(50) NOT NULL,
  `filetype` varchar(25) NOT NULL,
  `datecreated` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblbankbranchecontacts` (
  `id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `salutation` text NOT NULL,
  `firstname` varchar(50) NOT NULL,
  `lastname` varchar(50) NOT NULL,
  `country` varchar(50) NOT NULL,
  `address` text NOT NULL,
  `city` varchar(50) NOT NULL,
  `state` varchar(50) NOT NULL,
  `zip` text NOT NULL,
  `phoneno` varchar(25) NOT NULL,
  `mobileno` varchar(25) NOT NULL,
  `fax` text NOT NULL,
  `email` text NOT NULL,
  `skypeid` varchar(100) NOT NULL,
  `position` varchar(50) NOT NULL,
  `status` varchar(50) NOT NULL,
  `bankbranchid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `tblbankbranches` (
  `bankbranchid` int(11) NOT NULL,
  `bankid` int(11) NOT NULL,
  `branchname` varchar(250) NOT NULL,
  `email` varchar(100) NOT NULL,
  `phonenumber` varchar(30) DEFAULT NULL,
  `fax` text NOT NULL,
  `website` varchar(100) NOT NULL,
  `password` varchar(255) NOT NULL,
  `country` int(11) NOT NULL,
  `city` varchar(100) DEFAULT NULL,
  `zip` varchar(15) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `address` varchar(100) DEFAULT NULL,
  `datecreated` datetime NOT NULL,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblbankbranchesnotes` (
  `usernoteid` int(11) NOT NULL,
  `description` text NOT NULL,
  `dateadded` datetime NOT NULL,
  `addedfrom` int(11) NOT NULL,
  `staff` int(11) NOT NULL,
  `branchid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblbankbranchesreminders` (
  `id` int(11) NOT NULL,
  `description` text,
  `date` date NOT NULL,
  `isnotified` int(11) NOT NULL DEFAULT '0',
  `bankbranchid` int(11) NOT NULL,
  `staff` int(11) NOT NULL,
  `notify_by_email` int(11) NOT NULL DEFAULT '1',
  `creator` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblbanks` (
  `bankid` int(11) NOT NULL,
  `bank` varchar(250) NOT NULL,
  `datecreated` datetime NOT NULL,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblbanksaccount` (
  `id` int(11) NOT NULL,
  `bank` int(11) NOT NULL,
  `branch` int(11) NOT NULL,
  `account_number` varchar(50) NOT NULL,
  `account_type` varchar(150) NOT NULL,
  `ledger` int(11) NOT NULL,
  `description` text NOT NULL,
  `dateOpened` date NOT NULL,
  `currency` varchar(10) NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `overdraft` decimal(20,2) NOT NULL,
  `available` decimal(20,2) NOT NULL,
  `interest` int(11) NOT NULL,
  `service_charge` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `tblbillitems` (
  `id` int(11) NOT NULL,
  `bill_id` int(11) NOT NULL,
  `sku` varchar(50) NOT NULL,
  `oursku` varchar(50) NOT NULL,
  `description` text NOT NULL,
  `qty` int(11) NOT NULL,
  `rate` decimal(11,2) NOT NULL,
  `disc` decimal(7,2) NOT NULL,
  `taxid` int(11) NOT NULL,
  `ledger` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tblbillpaymentrecords` (
  `id` int(11) NOT NULL,
  `billid` int(11) NOT NULL,
  `paidbillid` int(11) NOT NULL,
  `ledgerid` int(11) NOT NULL,
  `bank` int(11) NOT NULL,
  `branch` int(11) NOT NULL,
  `account_number` varchar(150) NOT NULL,
  `cheque_number` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `date` date NOT NULL,
  `description` text,
  `refrence` varchar(250) DEFAULT NULL,
  `invoiceid` varchar(100) DEFAULT NULL,
  `daterecorded` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblbills` (
  `billid` int(11) NOT NULL,
  `supplierid` int(11) NOT NULL,
  `po_id` int(11) NOT NULL DEFAULT '0',
  `bill_number` varchar(15) NOT NULL,
  `refrence` varchar(150) NOT NULL,
  `bill_date` date NOT NULL,
  `due_date` date NOT NULL,
  `currency` varchar(5) NOT NULL,
  `recurring_bill` varchar(5) NOT NULL,
  `payment_terms` int(11) NOT NULL,
  `contact` varchar(250) NOT NULL,
  `total` decimal(7,2) NOT NULL,
  `bill_total` decimal(10,2) NOT NULL,
  `note` text NOT NULL,
  `datecreated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `addedfrom` int(11) NOT NULL,
  `status` varchar(50) NOT NULL,
  `subtotal` decimal(20,2) NOT NULL,
  `vatpaid` decimal(20,2) NOT NULL,
  `discount_total` decimal(20,2) NOT NULL,
  `adjustment` decimal(20,2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `tblbins` (
  `bin_id` int(11) NOT NULL,
  `bin_name` varchar(100) NOT NULL,
  `ware_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  `aisle` varchar(100) NOT NULL,
  `row` varchar(30) NOT NULL,
  `level` varchar(50) NOT NULL,
  `label` varchar(100) NOT NULL,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `tblcategories` (
  `category_id` int(11) NOT NULL,
  `category_name` varchar(100) NOT NULL,
  `description` varchar(255) NOT NULL,
  `sales` int(11) NOT NULL,
  `inventory` int(11) NOT NULL,
  `cogs` int(11) NOT NULL,
  `active` tinyint(11) NOT NULL DEFAULT '1',
  `show_in_cart` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `tblclientattachments` (
  `id` int(11) NOT NULL,
  `clientid` int(11) NOT NULL,
  `file_name` varchar(50) NOT NULL,
  `filetype` varchar(25) NOT NULL,
  `datecreated` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblclientcontacts` (
  `id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `salutation` text NOT NULL,
  `firstname` varchar(50) NOT NULL,
  `lastname` varchar(50) NOT NULL,
  `country` varchar(50) NOT NULL,
  `address` text NOT NULL,
  `city` varchar(50) NOT NULL,
  `state` varchar(50) NOT NULL,
  `zip` text NOT NULL,
  `phoneno` varchar(25) NOT NULL,
  `mobileno` varchar(25) NOT NULL,
  `fax` text NOT NULL,
  `email` text NOT NULL,
  `skypeid` varchar(100) NOT NULL,
  `position` varchar(50) NOT NULL,
  `status` varchar(50) NOT NULL,
  `userid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `tblclients` (
  `userid` int(11) NOT NULL,
  `fax` varchar(20) NOT NULL,
  `firstname` varchar(50) NOT NULL,
  `lastname` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `company` varchar(100) DEFAULT NULL,
  `vat` varchar(50) DEFAULT NULL,
  `ledger` int(11) NOT NULL,
  `phonenumber` varchar(30) DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `country` int(11) NOT NULL,
  `city` varchar(100) DEFAULT NULL,
  `zip` varchar(15) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `address` varchar(100) DEFAULT NULL,
  `datecreated` datetime NOT NULL,
  `last_ip` varchar(40) DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `last_password_change` datetime DEFAULT NULL,
  `active` int(11) NOT NULL DEFAULT '1',
  `new_pass_key` varchar(32) DEFAULT NULL,
  `new_pass_key_requested` datetime DEFAULT NULL,
  `leadid` int(11) DEFAULT NULL,
  `billing_street` varchar(200) DEFAULT NULL,
  `billing_city` varchar(100) DEFAULT NULL,
  `billing_state` varchar(100) DEFAULT NULL,
  `billing_zip` varchar(100) DEFAULT NULL,
  `billing_country` int(11) DEFAULT NULL,
  `shipping_street` varchar(200) DEFAULT NULL,
  `shipping_city` varchar(100) DEFAULT NULL,
  `shipping_state` varchar(100) DEFAULT NULL,
  `shipping_zip` varchar(100) DEFAULT NULL,
  `shipping_country` int(11) DEFAULT NULL,
  `longitude` varchar(300) DEFAULT NULL,
  `latitude` varchar(300) DEFAULT NULL,
  `default_language` varchar(40) DEFAULT NULL,
  `default_currency` int(11) NOT NULL DEFAULT '0',
  `payment_term` int(11) NOT NULL,
  `accountname` varchar(100) NOT NULL,
  `account_number` varchar(100) NOT NULL,
  `website` varchar(100) NOT NULL,
  `credit_limit` decimal(20,2) NOT NULL,
  `account_req` int(11) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `opening_balance` tinyint(1) NOT NULL DEFAULT '0',
  `amount` float NOT NULL,
  `type_of_balance` int(1) NOT NULL,
  `note` text NOT NULL,
  `warehouse` int(11) NOT NULL,
  `billing_longitude` varchar(20) NOT NULL,
  `billing_latitude` varchar(20) NOT NULL,
  `shipping_longitude` varchar(20) NOT NULL,
  `shipping_latitude` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblcommentlikes` (
  `id` int(11) NOT NULL,
  `postid` int(11) NOT NULL,
  `commentid` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  `dateliked` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblcontact` (
  `id` int(11) NOT NULL,
  `empid` int(11) NOT NULL,
  `salutation` int(11) NOT NULL,
  `firstname` varchar(255) NOT NULL,
  `lastname` varchar(255) NOT NULL,
  `country` int(11) NOT NULL,
  `address` text NOT NULL,
  `city` varchar(255) NOT NULL,
  `state` varchar(255) NOT NULL,
  `postal_code` varchar(255) NOT NULL,
  `relationship` varchar(255) NOT NULL,
  `priority` varchar(255) NOT NULL,
  `phone_home` varchar(255) NOT NULL,
  `phone_work` varchar(255) NOT NULL,
  `mobile` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tblcontractattachments` (
  `id` int(11) NOT NULL,
  `contractid` int(11) NOT NULL,
  `file_name` mediumtext NOT NULL,
  `filetype` varchar(50) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblcontractrenewals` (
  `id` int(11) NOT NULL,
  `contractid` int(11) NOT NULL,
  `old_start_date` date NOT NULL,
  `new_start_date` date NOT NULL,
  `old_end_date` date DEFAULT NULL,
  `new_end_date` date DEFAULT NULL,
  `old_value` decimal(11,2) DEFAULT NULL,
  `new_value` decimal(11,2) DEFAULT NULL,
  `date_renewed` datetime NOT NULL,
  `renewed_by` int(11) NOT NULL,
  `is_on_old_expiry_notified` int(11) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblcontracts` (
  `id` int(11) NOT NULL,
  `description` text,
  `subject` varchar(300) DEFAULT NULL,
  `client` int(11) NOT NULL,
  `datestart` date DEFAULT NULL,
  `dateend` date DEFAULT NULL,
  `contract_type` int(11) DEFAULT NULL,
  `addedfrom` int(11) NOT NULL,
  `dateadded` datetime NOT NULL,
  `isexpirynotified` int(11) NOT NULL DEFAULT '0',
  `contract_value` decimal(20,2) DEFAULT NULL,
  `trash` tinyint(1) DEFAULT '0',
  `not_visible_to_client` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblcontracttypes` (
  `id` int(11) NOT NULL,
  `name` mediumtext NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblcountries` (
  `country_id` int(5) NOT NULL,
  `iso2` char(2) DEFAULT NULL,
  `short_name` varchar(80) NOT NULL DEFAULT '',
  `long_name` varchar(80) NOT NULL DEFAULT '',
  `iso3` char(3) DEFAULT NULL,
  `numcode` varchar(6) DEFAULT NULL,
  `un_member` varchar(12) DEFAULT NULL,
  `calling_code` varchar(8) DEFAULT NULL,
  `cctld` varchar(5) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES
(1, 'AF', 'Afghanistan', 'Islamic Republic of Afghanistan', 'AFG', '004', 'yes', '93', '.af'),
(2, 'AX', 'Aland Islands', '&Aring;land Islands', 'ALA', '248', 'no', '358', '.ax'),
(3, 'AL', 'Albania', 'Republic of Albania', 'ALB', '008', 'yes', '355', '.al'),
(4, 'DZ', 'Algeria', 'People\'s Democratic Republic of Algeria', 'DZA', '012', 'yes', '213', '.dz'),
(5, 'AS', 'American Samoa', 'American Samoa', 'ASM', '016', 'no', '1+684', '.as'),
(6, 'AD', 'Andorra', 'Principality of Andorra', 'AND', '020', 'yes', '376', '.ad'),
(7, 'AO', 'Angola', 'Republic of Angola', 'AGO', '024', 'yes', '244', '.ao'),
(9, 'AQ', 'Antarctica', 'Antarctica', 'ATA', '010', 'no', '672', '.aq'),
(12, 'AM', 'Armenia', 'Republic of Armenia', 'ARM', '051', 'yes', '374', '.am'),
(16, 'AZ', 'Azerbaijan', 'Republic of Azerbaijan', 'AZE', '031', 'yes', '994', '.az'),
(26, 'BT', 'Bhutan', 'Kingdom of Bhutan', 'BTN', '064', 'yes', '975', '.bt'),
(27, 'BO', 'Bolivia', 'Plurinational State of Bolivia', 'BOL', '068', 'yes', '591', '.bo'),
(29, 'BA', 'Bosnia and Herzegovina', 'Bosnia and Herzegovina', 'BIH', '070', 'yes', '387', '.ba'),
(30, 'BW', 'Botswana', 'Republic of Botswana', 'BWA', '072', 'yes', '267', '.bw'),
(31, 'BV', 'Bouvet Island', 'Bouvet Island', 'BVT', '074', 'no', 'NONE', '.bv'),
(33, 'IO', 'British Indian Ocean Territory', 'British Indian Ocean Territory', 'IOT', '086', 'no', '246', '.io'),
(34, 'BN', 'Brunei', 'Brunei Darussalam', 'BRN', '096', 'yes', '673', '.bn'),
(35, 'BG', 'Bulgaria', 'Republic of Bulgaria', 'BGR', '100', 'yes', '359', '.bg'),
(36, 'BF', 'Burkina Faso', 'Burkina Faso', 'BFA', '854', 'yes', '226', '.bf'),
(37, 'BI', 'Burundi', 'Republic of Burundi', 'BDI', '108', 'yes', '257', '.bi'),
(38, 'KH', 'Cambodia', 'Kingdom of Cambodia', 'KHM', '116', 'yes', '855', '.kh'),
(39, 'CM', 'Cameroon', 'Republic of Cameroon', 'CMR', '120', 'yes', '237', '.cm'),
(43, 'CF', 'Central African Republic', 'Central African Republic', 'CAF', '140', 'yes', '236', '.cf'),
(44, 'TD', 'Chad', 'Republic of Chad', 'TCD', '148', 'yes', '235', '.td'),
(47, 'CX', 'Christmas Island', 'Christmas Island', 'CXR', '162', 'no', '61', '.cx'),
(48, 'CC', 'Cocos (Keeling) Islands', 'Cocos (Keeling) Islands', 'CCK', '166', 'no', '61', '.cc'),
(50, 'KM', 'Comoros', 'Union of the Comoros', 'COM', '174', 'yes', '269', '.km'),
(53, 'CR', 'Costa Rica', 'Republic of Costa Rica', 'CRI', '188', 'yes', '506', '.cr'),
(56, 'CU', 'Cuba', 'Republic of Cuba', 'CUB', '192', 'yes', '53', '.cu'),
(57, 'CW', 'Curacao', 'Cura&ccedil;ao', 'CUW', '531', 'no', '599', '.cw'),
(63, 'DM', 'Dominica', 'Commonwealth of Dominica', 'DMA', '212', 'yes', '1+767', '.dm'),
(64, 'DO', 'Dominican Republic', 'Dominican Republic', 'DOM', '214', 'yes', '1+809, 8', '.do'),
(65, 'EC', 'Ecuador', 'Republic of Ecuador', 'ECU', '218', 'yes', '593', '.ec'),
(83, 'DE', 'Germany', 'Federal Republic of Germany', 'DEU', '276', 'yes', '49', '.de'),
(88, 'GD', 'Grenada', 'Grenada', 'GRD', '308', 'yes', '1+473', '.gd'),
(89, 'GP', 'Guadaloupe', 'Guadeloupe', 'GLP', '312', 'no', '590', '.gp'),
(91, 'GT', 'Guatemala', 'Republic of Guatemala', 'GTM', '320', 'yes', '502', '.gt'),
(95, 'GY', 'Guyana', 'Co-operative Republic of Guyana', 'GUY', '328', 'yes', '592', '.gy'),
(96, 'HT', 'Haiti', 'Republic of Haiti', 'HTI', '332', 'yes', '509', '.ht'),
(98, 'HN', 'Honduras', 'Republic of Honduras', 'HND', '340', 'yes', '504', '.hn'),
(99, 'HK', 'Hong Kong', 'Hong Kong', 'HKG', '344', 'no', '852', '.hk'),
(102, 'IN', 'India', 'Republic of India', 'IND', '356', 'yes', '91', '.in'),
(103, 'ID', 'Indonesia', 'Republic of Indonesia', 'IDN', '360', 'yes', '62', '.id'),
(110, 'JM', 'Jamaica', 'Jamaica', 'JAM', '388', 'yes', '1+876', '.jm'),
(111, 'JP', 'Japan', 'Japan', 'JPN', '392', 'yes', '81', '.jp'),
(138, 'MQ', 'Martinique', 'Martinique', 'MTQ', '474', 'no', '596', '.mq'),
(148, 'MS', 'Montserrat', 'Montserrat', 'MSR', '500', 'no', '1+664', '.ms'),
(170, 'PA', 'Panama', 'Republic of Panama', 'PAN', '591', 'yes', '507', '.pa'),
(174, 'PH', 'Phillipines', 'Republic of the Philippines', 'PHL', '608', 'yes', '63', '.ph'),
(178, 'PR', 'Puerto Rico', 'Commonwealth of Puerto Rico', 'PRI', '630', 'no', '1+939', '.pr'),
(181, 'RO', 'Romania', 'Romania', 'ROU', '642', 'yes', '40', '.ro'),
(182, 'RU', 'Russia', 'Russian Federation', 'RUS', '643', 'yes', '7', '.ru'),
(184, 'BL', 'Saint Barthelemy', 'Saint Barth&eacute;lemy', 'BLM', '652', 'no', '590', '.bl'),
(186, 'KN', 'Saint Kitts and Nevis', 'Federation of Saint Christopher and Nevis', 'KNA', '659', 'yes', '1+869', '.kn'),
(187, 'LC', 'Saint Lucia', 'Saint Lucia', 'LCA', '662', 'yes', '1+758', '.lc'),
(188, 'MF', 'Saint Martin', 'Saint Martin', 'MAF', '663', 'no', '590', '.mf'),
(190, 'VC', 'Saint Vincent and the Grenadines', 'Saint Vincent and the Grenadines', 'VCT', '670', 'yes', '1+784', '.vc'),
(200, 'SX', 'Sint Maarten', 'Sint Maarten', 'SXM', '534', 'no', '1+721', '.sx'),
(230, 'TC', 'Turks and Caicos Islands', 'Turks and Caicos Islands', 'TCA', '796', 'no', '1+649', '.tc'),
(234, 'AE', 'United Arab Emirates', 'United Arab Emirates', 'ARE', '784', 'yes', '971', '.ae'),
(235, 'GB', 'United Kingdom', 'United Kingdom of Great Britain and Nothern Ireland', 'GBR', '826', 'yes', '44', '.uk'),
(236, 'US', 'United States', 'United States of America', 'USA', '840', 'yes', '1', '.us'),
(237, 'UM', 'United States Minor Outlying Islands', 'United States Minor Outlying Islands', 'UMI', '581', 'no', 'NONE', 'NONE'),
(244, 'VG', 'Virgin Islands, British', 'British Virgin Islands', 'VGB', '092', 'no', '1+284', '.vg'),
(245, 'VI', 'Virgin Islands, US', 'Virgin Islands of the United States', 'VIR', '850', 'no', '1+340', '.vi');

CREATE TABLE `tblcurrencies` (
  `id` int(11) NOT NULL,
  `symbol` varchar(10) NOT NULL,
  `name` varchar(100) NOT NULL,
  `isdefault` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblcustomergroups_in` (
  `id` int(11) NOT NULL,
  `groupid` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `tblcustomergroups_in` (`id`, `groupid`, `customer_id`) VALUES
(1, 1, 19),
(3, 1, 18),
(5, 1, 16),
(6, 1, 17),
(8, 1, 20),
(11, 1, 2),
(12, 1, 3),
(42, 1, 4),
(47, 1, 6),
(52, 1, 8),
(53, 1, 9),
(55, 1, 10),
(56, 1, 11),
(58, 1, 12),
(59, 1, 1),
(60, 1, 5),
(61, 1, 7);

CREATE TABLE `tblcustomerpermissions` (
  `id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  `userid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `tblcustomerpermissions` (`id`, `permission_id`, `userid`) VALUES
(1, 1, 1),
(2, 2, 1),
(3, 3, 1),
(4, 4, 1),
(5, 5, 1),
(6, 5, 1),
(7, 1, 6),
(8, 2, 6),
(9, 4, 6),
(10, 1, 4),
(11, 2, 4),
(12, 3, 4),
(13, 4, 4),
(14, 5, 4),
(15, 5, 4),
(16, 1, 7),
(17, 2, 7),
(18, 3, 7),
(19, 4, 7),
(20, 5, 7),
(21, 5, 7),
(22, 3, 6),
(23, 5, 6),
(24, 1, 8),
(25, 2, 8),
(26, 3, 8),
(27, 5, 8),
(28, 1, 9),
(29, 2, 9),
(30, 3, 9),
(31, 1, 10),
(32, 2, 10),
(33, 3, 10),
(34, 4, 10),
(35, 5, 10),
(36, 5, 10);

CREATE TABLE `tblcustomersgroups` (
  `id` int(11) NOT NULL,
  `name` varchar(600) NOT NULL,
  `discription` text NOT NULL,
  `ledger` int(11) NOT NULL,
  `default_currency` varchar(50) NOT NULL,
  `default_language` varchar(50) NOT NULL,
  `payment_term` int(11) NOT NULL,
  `account_req` int(11) NOT NULL,
  `class_is_active` int(11) NOT NULL,
  `creditlimit` float(7,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblcustomfields` (
  `id` int(11) NOT NULL,
  `fieldto` varchar(50) NOT NULL,
  `name` varchar(150) NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `type` varchar(20) NOT NULL,
  `options` mediumtext,
  `field_order` int(11) DEFAULT '0',
  `active` int(11) NOT NULL DEFAULT '1',
  `show_on_pdf` int(11) NOT NULL DEFAULT '0',
  `show_on_table` tinyint(1) NOT NULL DEFAULT '0',
  `show_on_client_portal` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblcustomfieldsvalues` (
  `id` int(11) NOT NULL,
  `relid` int(11) NOT NULL,
  `fieldid` int(11) NOT NULL,
  `fieldto` varchar(50) NOT NULL,
  `value` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tbldeopsits` (
  `id` int(11) NOT NULL,
  `bank_id` int(11) NOT NULL,
  `branch_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `note` varchar(255) NOT NULL,
  `date` date NOT NULL,
  `transactionid` varchar(255) DEFAULT NULL,
  `customer` int(11) NOT NULL,
  `payment_type` int(11) NOT NULL,
  `transaction_type` varchar(255) NOT NULL,
  `currency` int(11) NOT NULL,
  `amount` float NOT NULL,
  `voucherlinesid` int(11) NOT NULL,
  `ledger_id` int(11) NOT NULL,
  `reconciled` tinyint(1) DEFAULT '0',
  `date_reconciled` date DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tbldepartments` (
  `departmentid` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `departmentemail` varchar(100) NOT NULL,
  `calendar_id` mediumtext,
  `hidefromclient` tinyint(1) NOT NULL DEFAULT '0',
  `sort_order` tinyint(4) NOT NULL,
  `is_active` tinyint(4) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tbldiscounts` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `discountrate` decimal(11,2) NOT NULL,
  `ledger` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tbldismissedannouncements` (
  `dismissedannouncementid` int(11) NOT NULL,
  `announcementid` int(11) NOT NULL,
  `staff` int(11) NOT NULL,
  `userid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tbldocuments` (
  `id` int(11) NOT NULL,
  `empid` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `document_type` varchar(100) NOT NULL,
  `serial_number` varchar(100) NOT NULL,
  `date_issued` date NOT NULL,
  `expiration` date NOT NULL,
  `reminder` date NOT NULL,
  `note` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tbleducation` (
  `id` int(11) NOT NULL,
  `empid` int(11) NOT NULL,
  `certificate` varchar(255) NOT NULL,
  `institutions` int(11) NOT NULL,
  `country` int(11) NOT NULL,
  `address` text NOT NULL,
  `city` varchar(255) NOT NULL,
  `state` varchar(255) NOT NULL,
  `postal_code` varchar(50) NOT NULL,
  `instition_type` varchar(100) NOT NULL,
  `tuition_method` varchar(100) NOT NULL,
  `start_date` date NOT NULL,
  `finish_date` date NOT NULL,
  `completion` varchar(100) NOT NULL,
  `grades` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tblemaillists` (
  `listid` int(11) NOT NULL,
  `name` mediumtext NOT NULL,
  `creator` int(11) NOT NULL,
  `datecreated` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblemailtemplates` (
  `emailtemplateid` int(11) NOT NULL,
  `type` mediumtext NOT NULL,
  `slug` varchar(100) NOT NULL,
  `name` mediumtext NOT NULL,
  `subject` mediumtext NOT NULL,
  `message` text NOT NULL,
  `fromname` mediumtext NOT NULL,
  `fromemail` varchar(100) DEFAULT NULL,
  `plaintext` int(11) NOT NULL DEFAULT '1',
  `active` tinyint(4) NOT NULL DEFAULT '0',
  `order` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES
(1, 'client', 'new-client-created', 'New client added', 'Welcome ', '<div>Hello {client_firstname}&nbsp;{client_lastname}</div><div><br></div><div>Welcome to {companyname}. </div><div><br></div><div>{email_signature}</div>', 'Customer Services', 'solomonapp@solomon.ekomplete.com', 0, 1, 0),
(2, 'invoice', 'invoice-send-to-client', 'Invoice sent to client', 'Your Invoice {invoice_number} is attached', '<div>Dear {salutation} {client_firstname}&nbsp;{client_lastname}</div><div><br></div><div>Thank you for your business and cooperation.</div><div><br></div><div>This invoice is with status:&nbsp;<b>{invoice_status}</b></div><div><br></div><div>We look forward to doing more business with you.</div><div><br></div><div>Best Regards</div><div><br></div><div>{email_signature}</div><div><br></div><div><b><i>{companyname}</i></b></div>', 'Company', '', 0, 1, 0),
(3, 'ticket', 'new-ticket-opened-admin', 'New Ticket Opened (Admin)', 'New Ticket Opened (Admin)', '<p>New ticket opened&nbsp;{ticket_url}<br />{email_signature}</p>', '{ticket_department}', '', 0, 1, 0),
(4, 'ticket', 'ticket-reply', 'Ticket Reply', 'New Ticket Reply', '<p>You have new ticket reply&nbsp;{ticket_url}<br />{email_signature}</p>', '{ticket_department}', '', 0, 1, 0),
(5, 'ticket', 'ticket-autoresponse', 'New Ticket Open Autoresponse', 'Ticket Opened', '<div>New ticket opened&nbsp;{ticket_url}</div><div>We will reply as soon as possible.</div><div>{email_signature}</div><div>{client_phonenumber}</div>', 'sss', '', 0, 1, 0),
(6, 'invoice', 'invoice-payment-recorded', 'Payment Recorded', 'Invoice Payment Recorded', '<div>Payment Recorded for invoice&nbsp;{invoice_number}</div><div><br></div><div>{invoice_link}</div><div><br></div><div>{email_signature}</div>', '{companyname}', '', 0, 1, 0),
(7, 'invoice', 'invoice-overdue-notice', 'Invoice Overdue Notice', 'Invoice Overdue Notice {invoice_number}', '<p>This is a overdue notice email for invoice&nbsp;{invoice_link}<br /><br />{email_signature}</p>', 'Company', '', 0, 1, 0),
(8, 'invoice', 'invoice-already-send', 'Customer Invoice Resend Request', 'Requested copy of your invoice', '<div>Hello {client_firstname} {client_lastname}</div><div><br></div><div>Here is a copy of the requested invoice {invoice_number} created on {invoice_date} and due on {invoice_duedate} .</div><div>{invoice_link}</div><div>{email_signature}</div><div><br></div><div>{logo_url}</div><div>{companyname}</div>', 'Company', 'solomonapp@solomon.ekomplete.com', 0, 1, 0),
(9, 'ticket', 'new-ticket-created-staff', 'New Ticket Created (Staff)', 'New Ticket Created (Staff)', '', '{ticket_department}', '', 0, 1, 0),
(10, 'quote', 'quote-send-to-client', 'Quote sent to client', 'Your Quotation {quote_number} - {companyname}', '<div>Dear {client_firstname}&nbsp;{client_lastname}</div><div><br></div><div>Please find your quote with number {quote_number} attach.</div><div>This quote&nbsp;is with status:&nbsp;<b>{quote_status}</b></div><div><br></div><div>We look forward to doing more business with you.</div><div>Best Regards</div><div>{email_signature}</div>', 'Company', 'solomonapp@solomon.ekomplete.com', 0, 1, 0),
(11, 'quote', 'quote-already-send', 'Customer Quote Resend Request', 'Requested copy of your quote', '<div>On your command here is the quote you asked for.</div><div><br></div><div>{quote_number}</div><div><br></div><div>{email_signature}</div>', 'Customer Services {companyname}', 'solomonapp@solomon.ekomplete.com', 0, 1, 0),
(12, 'ticket', 'ticket-reply-to-admin', 'Ticket Reply (To Admin)', 'New Ticket Reply', '<p>New ticket reply from&nbsp;{client_firstname}&nbsp;{client_lastname}<br /><br />{signature}</p>', 'Company', '', 0, 1, 0),
(13, 'contract', 'contract-expiration', 'Contract Expiration', 'Contract Expiration Reminder', '', 'Polaris', '', 0, 1, 1),
(14, 'tasks', 'task-assigned', 'New Task Assigned to You', 'New Task Assigned to You', '<div>Hello {staff_firstname} a new task is assigned to you.</div>', 'Company Name', '', 0, 0, 0),
(15, 'tasks', 'task-added-as-follower', 'You are added as follower on task', 'You are added as follower on task', '<div>Hello {staff_firstname} you are added as follower on task</div>', 'Company Name', '', 0, 0, 0),
(16, 'tasks', 'task-commented', 'New Comment on Task', 'New Comment on Task', '<div>New task comment</div>', 'Company Name', '', 0, 0, 0),
(17, 'tasks', 'task-marked-as-finished', 'Task Marked as Finished', 'Task Marked as Finished', '<div>{staff_firstname} marked task as finished</div>', 'Company Name', '', 0, 0, 0),
(18, 'tasks', 'task-added-attachment', 'New Attachment on Task', 'New Attachment on Task', '<div>{staff_firstname} added attachment on task</div>', 'Company Name', '', 0, 0, 0),
(19, 'tasks', 'task-unmarked-as-finished', 'Task Unmkared as Finished', 'Task Unmkared as Finished', '<div>{staff_firstname} unmarked task as finished</div>', 'Company Name', '', 0, 0, 0),
(20, 'quote', 'quote-declined-to-staff', 'Quote Declined (Sent to Staff)', 'Customer Declined Quote', '<div>Hello.</div><div><br></div><div>Customer (<span style=\"font-family: Helvetica, Arial, sans-serif; background-color: inherit;\">{client_firstname} {client_lastname}</span>) declined quote with number <span style=\"font-family: Helvetica, Arial, sans-serif; background-color: inherit;\">{quote_number}</span></div><div><br></div><div>You can view the quote on the following link <span style=\"font-family: Helvetica, Arial, sans-serif; background-color: inherit;\">{quote_link}</span></div><div><br></div><div>{email_signature}</div><div><br></div>', '{client_company}', '', 0, 1, 0),
(21, 'quote', 'quote-accepted-to-staff', 'Quote Accepted (Sent to Staff)', 'Customer Accepted Quote', '<div>Hello.</div><div><br></div><div>Customer (<span style=\"font-family: Helvetica, Arial, sans-serif; background-color: inherit;\">{client_firstname} {client_lastname}</span>) accepted quote with number <span style=\"font-family: Helvetica, Arial, sans-serif; background-color: inherit;\">{quote_number}</span></div><div><br></div><div>You can view the quote on the following link <span style=\"font-family: Helvetica, Arial, sans-serif; background-color: inherit;\">{quote_link}</span></div><div><br></div><div>{email_signature}</div>', '{companyname}', '', 0, 1, 0),
(22, 'proposals', 'proposal-client-accepted', 'Customer Action - Accepted (Sent to Staff)', 'Customer Accepted Proposal', '<div>Customer <span style=\"font-family: Helvetica, Arial, sans-serif;\">{proposal_proposal_to}</span> Accepted Proposal</div><div><br></div><div>View the proposal on the following link: {proposal_link}</div><div><br></div><div>{email_signature}</div><div><br></div>', '{companyname}', '', 0, 1, 0),
(23, 'proposals', 'proposal-send-to-customer', 'Proposal Send to Customer', 'Proposal', '', '{companyname}', '', 0, 1, 0),
(24, 'proposals', 'proposal-client-declined', 'Customer Action - Declined (Sent to Staff)', 'Client Declined Proposal', '<div>Client Declined proposal</div>', '{companyname}', '', 0, 1, 0),
(25, 'proposals', 'proposal-client-thank-you', 'Customer Thank You Email (After Accept)', 'Thank for you accepting proposal', '<div>Hello <span style=\"font-family: Helvetica, Arial, sans-serif;\">{proposal_proposal_to}</span></div><div><br></div><div>Thank for for accepting the proposal.</div><div><br></div><div>We look forward doing business with you.</div><div><br></div><div>Our staff will call you asap.</div><div><br></div><div>{email_signature}</div>', '{companyname}', '', 0, 1, 0),
(26, 'proposals', 'proposal-comment-to-client', 'New Comment (Customer)', 'New Proposal Comment', '<div>New Proposal Comment</div>', '{companyname}', '', 0, 1, 0),
(27, 'proposals', 'proposal-comment-to-admin', 'New Comment (Sent to Staff) ', 'New Proposal Comment', '<div>New Proposal Comment</div>', '{companyname}', '', 0, 1, 0),
(28, 'quote', 'quote-thank-you-to-customer', 'Customer Thank You Email (After Accept)', 'Thank for you accepting quote', '<div>Hello <span style=\"background-color: inherit; font-family: Helvetica, Arial, sans-serif;\">{client_firstname} {client_lastname}</span></div><div><br></div><div>Thank for for accepting the quote.</div><div><br></div><div>We look forward doing business with you.</div><div><br></div><div>Our staff will call you asap.</div><div><br></div><div>{email_signature}</div><div><br></div><div><br></div>', '{companyname}', '', 0, 1, 0),
(29, 'order', 'order-send-to-client', 'Order sent to client', 'Your Order {order_number} - {companyname}', '<div>Dear {client_firstname}&nbsp;{client_lastname}</div><div><br></div><div>Please find your order with number {order_number} attach.</div><div>This order is with status:&nbsp;<b>{order_status}</b></div><div><br></div><div>We look forward to doing more business with you.</div><div>Best Regards</div><div>{email_signature}</div>', 'Company', 'solomonapp@solomon.ekomplete.com', 0, 1, 0),
(30, 'order', 'order-already-send', 'Customer Order Resend Request', 'Requested copy of your order', '<div>On your command here is the order you asked for.</div><div><br></div><div>{order_number}</div><div><br></div><div>{email_signature}</div>', 'Customer Services {companyname}', 'solomonapp@solomon.ekomplete.com', 0, 1, 0),
(31, 'order', 'order-declined-to-staff', 'Order Declined (Sent to Staff)', 'Customer Declined Order', '<div>Hello.</div><div><br></div><div>Customer (<span style=\"font-family: Helvetica, Arial, sans-serif; background-color: inherit;\">{client_firstname} {client_lastname}</span>) declined order with number <span style=\"font-family: Helvetica, Arial, sans-serif; background-color: inherit;\">{order_number}</span></div><div><br></div><div>You can view the order on the following link <span style=\"font-family: Helvetica, Arial, sans-serif; background-color: inherit;\">{order_link}</span></div><div><br></div><div>{email_signature}</div><div><br></div>', '{client_company}', '', 0, 1, 0),
(32, 'order', 'order-accepted-to-staff', 'Order Accepted (Sent to Staff)', 'Customer Accepted Order', '<div>Hello.</div><div><br></div><div>Customer (<span style=\"font-family: Helvetica, Arial, sans-serif; background-color: inherit;\">{client_firstname} {client_lastname}</span>) accepted order with number <span style=\"font-family: Helvetica, Arial, sans-serif; background-color: inherit;\">{order_number}</span></div><div><br></div><div>You can view the order on the following link <span style=\"font-family: Helvetica, Arial, sans-serif; background-color: inherit;\">{order_link}</span></div><div><br></div><div>{email_signature}</div>', '{companyname}', '', 0, 1, 0),
(33, 'order', 'order-thank-you-to-customer', 'Customer Thank You Email (After Accept)', 'Thank for you accepting order', '<div>Hello <span style=\"font-family: Helvetica, Arial, sans-serif;\">{client_firstname} {client_lastname}</span></div><div><br></div><div>Thank for for accepting the order.</div><div><br></div><div>We look forward doing business with you.</div><div><br></div><div>Our staff will call you asap.</div><div><br></div><div>{email_signature}</div><div><br></div><div><br></div><div><br></div>', '{companyname}', '', 0, 1, 0);

CREATE TABLE `tblemployee` (
  `empid` int(11) NOT NULL,
  `staffid` int(11) NOT NULL,
  `salutation` varchar(100) NOT NULL,
  `firstname` varchar(100) NOT NULL,
  `lastname` varchar(100) NOT NULL,
  `account_number` varchar(100) NOT NULL,
  `starting_date` date DEFAULT NULL,
  `country` int(11) NOT NULL,
  `address` text,
  `city` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `postal_code` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  `mobile` varchar(100) DEFAULT NULL,
  `department` int(11) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `username` varchar(100) DEFAULT NULL,
  `password` varchar(100) DEFAULT NULL,
  `role` int(11) DEFAULT NULL,
  `account_status` varchar(100) DEFAULT NULL,
  `national_id` varchar(50) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `gender` varchar(50) DEFAULT NULL,
  `marital_status` varchar(50) DEFAULT NULL,
  `blood_type` varchar(50) DEFAULT NULL,
  `race` int(11) DEFAULT NULL,
  `nationality` int(11) DEFAULT NULL,
  `dependents` int(11) DEFAULT NULL,
  `bank` int(11) DEFAULT NULL,
  `branch` int(11) DEFAULT NULL,
  `accountno` varchar(50) DEFAULT NULL,
  `medicalinfo` text,
  `image` varchar(100) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tblemployeeadminnotes` (
  `empnoteid` int(11) NOT NULL,
  `description` text NOT NULL,
  `dateadded` datetime NOT NULL,
  `addedfrom` int(11) NOT NULL,
  `staff` int(11) NOT NULL,
  `empid` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tblemployeeattachments` (
  `id` int(11) NOT NULL,
  `empid` int(11) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `filetype` varchar(255) NOT NULL,
  `datecreated` datetime NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tblemp_department` (
  `id` int(11) NOT NULL,
  `empid` int(11) NOT NULL,
  `department` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tblestimateactivity` (
  `id` int(11) NOT NULL,
  `estimateid` int(11) NOT NULL,
  `description` text NOT NULL,
  `staffid` varchar(11) DEFAULT NULL,
  `date` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblestimateitems` (
  `id` int(11) NOT NULL,
  `estimateid` int(11) NOT NULL,
  `qty` int(11) NOT NULL,
  `sku` varchar(50) NOT NULL,
  `description` mediumtext NOT NULL,
  `long_description` text,
  `rate` decimal(11,2) NOT NULL,
  `taxid` int(11) DEFAULT NULL,
  `disc` decimal(7,2) NOT NULL,
  `item_order` int(11) DEFAULT NULL,
  `itemorder_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblestimates` (
  `id` int(11) NOT NULL,
  `sent` tinyint(1) NOT NULL DEFAULT '0',
  `datesend` datetime DEFAULT NULL,
  `clientid` int(11) NOT NULL,
  `number` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `datecreated` datetime NOT NULL,
  `date` date NOT NULL,
  `expirydate` date DEFAULT NULL,
  `currency` varchar(20) NOT NULL,
  `subtotal` decimal(20,2) NOT NULL,
  `total` decimal(20,2) NOT NULL,
  `vatpaid` decimal(20,2) NOT NULL,
  `adjustment` decimal(20,2) DEFAULT NULL,
  `addedfrom` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `clientnote` text,
  `adminnote` text,
  `discount_percent` int(11) DEFAULT NULL,
  `discount_total` int(11) DEFAULT NULL,
  `discount_type` varchar(30) DEFAULT NULL,
  `invoiceid` int(11) DEFAULT NULL,
  `invoiced_date` datetime DEFAULT NULL,
  `orderid` int(11) DEFAULT NULL,
  `order_date` datetime DEFAULT NULL,
  `terms` text,
  `reference_no` varchar(100) DEFAULT NULL,
  `sale_agent` int(11) NOT NULL DEFAULT '0',
  `payment_term` int(11) NOT NULL,
  `hash` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblevents` (
  `eventid` int(11) NOT NULL,
  `title` mediumtext NOT NULL,
  `userid` int(11) NOT NULL,
  `start` date NOT NULL,
  `end` date DEFAULT NULL,
  `public` int(11) NOT NULL DEFAULT '0',
  `isstartnotified` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tbleview_item` (
  `id` int(11) NOT NULL,
  `eview_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tblexpenses` (
  `id` int(11) NOT NULL,
  `category` int(11) NOT NULL,
  `amount` decimal(11,2) NOT NULL,
  `tax` int(11) DEFAULT NULL,
  `reference_no` varchar(100) DEFAULT NULL,
  `note` text,
  `attachment` mediumtext NOT NULL,
  `filetype` varchar(50) DEFAULT NULL,
  `clientid` int(11) NOT NULL,
  `billable` int(11) DEFAULT '0',
  `invoiceid` int(11) DEFAULT NULL,
  `paymentmode` int(11) DEFAULT NULL,
  `date` date NOT NULL,
  `recurring_type` varchar(10) DEFAULT NULL,
  `repeat_every` int(11) DEFAULT NULL,
  `recurring` int(11) NOT NULL DEFAULT '0',
  `custom_recurring` int(11) NOT NULL DEFAULT '0',
  `last_recurring_date` date DEFAULT NULL,
  `create_invoice_billable` tinyint(1) DEFAULT NULL,
  `send_invoice_to_customer` tinyint(1) NOT NULL,
  `recurring_from` int(11) DEFAULT NULL,
  `dateadded` datetime NOT NULL,
  `addedfrom` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblexpensescategories` (
  `id` int(11) NOT NULL,
  `name` varchar(300) NOT NULL,
  `description` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblgoals` (
  `id` int(11) NOT NULL,
  `subject` varchar(400) NOT NULL,
  `description` text NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `goal_type` int(11) NOT NULL,
  `contract_type` int(11) NOT NULL DEFAULT '0',
  `achievement` int(11) NOT NULL,
  `addedfrom` int(11) NOT NULL,
  `assigned` int(11) DEFAULT NULL COMMENT 'test',
  `notify_when_fail` tinyint(1) NOT NULL DEFAULT '1',
  `notify_when_achieve` tinyint(1) NOT NULL DEFAULT '1',
  `notified` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblgrades` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `tblgrades` (`id`, `name`) VALUES
(2, 'Bachelor of Arts'),
(3, 'Bachelor of Science'),
(4, 'Associate of Science'),
(5, 'Associate of Applied Science'),
(6, 'Associate of Engineering'),
(7, 'Associate of Applied Arts'),
(8, 'Associate of Political Science'),
(9, 'Bachelor of Fine Arts'),
(10, 'Bachelor of Business Administration'),
(11, 'Bachelor of Architecture'),
(12, 'MA (Master of Arts)'),
(13, 'MS (Master of Science)'),
(14, 'M.Res (Master of Research)'),
(15, 'M.Phil (Master of Philosophy)'),
(16, 'Polytechnic Certificate'),
(17, 'LL.M (Master of Laws)'),
(18, 'MBA (Master of Business Administration)'),
(19, 'PhD (Doctor of Philosophy)'),
(20, 'MD (Doctor of Medicine)'),
(21, 'Ed.D (Doctor of Education)'),
(22, 'B.Arch (Bachelor of Architecture)');

CREATE TABLE `tblgrnitems` (
  `id` int(11) NOT NULL,
  `grnid` int(11) NOT NULL,
  `qty` int(11) NOT NULL,
  `suppliersku` varchar(50) NOT NULL,
  `oursku` varchar(50) NOT NULL,
  `description` mediumtext NOT NULL,
  `rate` decimal(11,2) NOT NULL,
  `manufacture` int(11) NOT NULL,
  `item_order` int(11) DEFAULT NULL,
  `itemid` int(11) NOT NULL,
  `itemorder_id` int(11) NOT NULL,
  `ordered` int(11) NOT NULL,
  `received` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblgrns` (
  `grnid` int(11) NOT NULL,
  `warehouse` int(11) NOT NULL,
  `po_id` int(11) NOT NULL,
  `supplierid` int(11) NOT NULL,
  `number` bigint(20) NOT NULL,
  `refrence` varchar(150) NOT NULL,
  `date` date NOT NULL,
  `reciverBy` int(11) NOT NULL,
  `checkedBy` int(11) NOT NULL,
  `enteredBy` int(11) NOT NULL,
  `note` text NOT NULL,
  `totalskurecived` int(11) NOT NULL,
  `totalitemrecived` int(11) NOT NULL,
  `total` decimal(20,2) NOT NULL,
  `datecreated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `hash` text NOT NULL,
  `vchid` int(11) NOT NULL,
  `cicharge` decimal(20,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `tblholidays` (
  `id` int(11) NOT NULL,
  `date` date NOT NULL,
  `occasion` varchar(255) NOT NULL,
  `note` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tblinstitutions` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tblinternaltransfer` (
  `id` int(11) NOT NULL,
  `transfer_id` varchar(255) NOT NULL,
  `from_warehouse` int(11) NOT NULL,
  `from_location` int(11) NOT NULL,
  `to_location` int(11) NOT NULL,
  `date` date NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tblinternaltransfer_item` (
  `id` int(11) NOT NULL,
  `internaltransfer_id` int(11) NOT NULL,
  `suppliersku` varchar(255) NOT NULL,
  `oursku` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `qty` int(11) NOT NULL,
  `uom` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tblinvoiceactivity` (
  `id` int(11) NOT NULL,
  `invoiceid` int(11) NOT NULL,
  `description` text NOT NULL,
  `staffid` varchar(11) DEFAULT NULL,
  `date` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblinvoiceattachments` (
  `id` int(11) NOT NULL,
  `invoiceid` int(11) NOT NULL,
  `file_name` varchar(50) NOT NULL,
  `original_file_name` mediumtext NOT NULL,
  `filetype` varchar(25) NOT NULL,
  `datecreated` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblinvoiceitems` (
  `id` int(11) NOT NULL,
  `invoiceid` int(11) NOT NULL,
  `qty` int(11) NOT NULL,
  `sku` varchar(50) NOT NULL,
  `description` mediumtext NOT NULL,
  `long_description` text,
  `rate` decimal(11,2) NOT NULL,
  `taxid` int(11) DEFAULT NULL,
  `disc` int(11) NOT NULL,
  `item_order` int(11) DEFAULT NULL,
  `itemid` int(11) NOT NULL,
  `itemorder_id` int(11) NOT NULL,
  `ideal_level` int(11) NOT NULL DEFAULT '-1',
  `restock_level` int(11) NOT NULL DEFAULT '-1',
  `warning_level` int(11) NOT NULL DEFAULT '-1',
  `reorder_level` int(11) NOT NULL DEFAULT '-1',
  `reorder_quantity` int(11) NOT NULL DEFAULT '-1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblinvoiceitemslist` (
  `id` int(11) NOT NULL,
  `description` varchar(255) NOT NULL,
  `long_description` text,
  `rate` decimal(11,2) NOT NULL,
  `tax` int(11) DEFAULT NULL,
  `purchase_tax_id` int(11) DEFAULT NULL,
  `sku` varchar(100) NOT NULL,
  `manufacturersku` varchar(100) NOT NULL,
  `itemtype` int(11) NOT NULL,
  `department` int(11) NOT NULL,
  `category` int(11) NOT NULL,
  `subcategory` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `unitofmeasure` int(11) NOT NULL,
  `ware_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  `supplier` int(11) NOT NULL,
  `manufacturer` int(11) NOT NULL,
  `costprice` double(15,2) NOT NULL,
  `salesprice` decimal(11,2) NOT NULL,
  `suggested_price` int(11) DEFAULT NULL,
  `image` varchar(100) NOT NULL,
  `ledger` int(11) NOT NULL,
  `sales` int(11) DEFAULT NULL,
  `inventory` int(11) DEFAULT NULL,
  `cogs` int(11) DEFAULT NULL,
  `specification` longtext NOT NULL,
  `status` varchar(25) DEFAULT NULL,
  `discount` int(11) NOT NULL,
  `allow_discount` int(11) NOT NULL,
  `discounts` text NOT NULL,
  `components` text NOT NULL,
  `qtycomponent` text,
  `onhold` int(11) NOT NULL DEFAULT '0',
  `onorder` int(11) NOT NULL DEFAULT '0',
  `intransit` int(11) NOT NULL DEFAULT '0',
  `receiving` int(11) NOT NULL DEFAULT '0',
  `show_in_eview` tinyint(1) NOT NULL DEFAULT '1',
  `landed_cost` decimal(11,2) DEFAULT NULL,
  `pricing_method` varchar(255) DEFAULT NULL,
  `amount` decimal(11,2) DEFAULT NULL,
  `margin_percent` decimal(11,2) DEFAULT NULL,
  `markup_percent` decimal(11,2) DEFAULT NULL,
  `suggested_retail_price` decimal(11,2) DEFAULT NULL,
  `retail_price` decimal(11,2) DEFAULT NULL,
  `ideal_level` int(11) NOT NULL DEFAULT '-1',
  `restock_level` int(11) NOT NULL DEFAULT '-1',
  `warning_level` int(11) NOT NULL DEFAULT '-1',
  `reorder_level` int(11) NOT NULL DEFAULT '-1',
  `reorder_quantity` int(11) NOT NULL DEFAULT '-1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblinvoiceitems_eview` (
  `id` int(11) NOT NULL,
  `invoiceitems_id` int(11) NOT NULL,
  `details` text NOT NULL,
  `is_featured` tinyint(1) NOT NULL DEFAULT '1',
  `main_image` varchar(255) NOT NULL,
  `image1` varchar(255) NOT NULL,
  `image2` varchar(255) NOT NULL,
  `image3` varchar(255) NOT NULL,
  `image4` varchar(255) NOT NULL,
  `image5` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tblinvoiceitmnotes` (
  `usernoteid` int(11) NOT NULL,
  `description` text NOT NULL,
  `dateadded` datetime NOT NULL,
  `addedfrom` int(11) NOT NULL,
  `staff` int(11) NOT NULL,
  `itemid` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `tblinvoicepaymentrecords` (
  `id` int(11) NOT NULL,
  `invoiceid` int(11) NOT NULL,
  `bank` int(11) NOT NULL,
  `receipt_number` varchar(255) NOT NULL,
  `account_number` varchar(150) NOT NULL,
  `cheque_number` varchar(150) NOT NULL,
  `idenpresented` int(11) NOT NULL,
  `identification` varchar(150) NOT NULL,
  `amount` decimal(11,2) NOT NULL,
  `paymentmode` varchar(40) DEFAULT NULL,
  `date` date NOT NULL,
  `daterecorded` datetime NOT NULL,
  `note` text NOT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transactionid` mediumtext,
  `deopsits` tinyint(1) NOT NULL DEFAULT '0',
  `voucherlines_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblinvoicepaymentsmodes` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `dueDays` int(11) NOT NULL,
  `interestRate` decimal(7,2) NOT NULL,
  `paymentledger` int(11) NOT NULL,
  `interrestledger` int(11) NOT NULL,
  `description` text,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `deleted` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `tblinvoicepaymentsmodes` (`id`, `name`, `dueDays`, `interestRate`, `paymentledger`, `interrestledger`, `description`, `active`, `deleted`) VALUES
(1, 'Cash', 0, '0.00', 0, 0, 'Cash only payments', 1, 1),
(2, 'Cheque', 0, '0.00', 0, 0, 'Cheque only payments', 1, 0);

CREATE TABLE `tblinvoices` (
  `id` int(11) NOT NULL,
  `sent` tinyint(1) NOT NULL DEFAULT '0',
  `datesend` datetime DEFAULT NULL,
  `clientid` int(11) NOT NULL,
  `number` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `datecreated` datetime NOT NULL,
  `date` date NOT NULL,
  `duedate` date DEFAULT NULL,
  `currency` int(11) NOT NULL,
  `subtotal` decimal(20,2) NOT NULL,
  `total` decimal(20,2) NOT NULL,
  `vatpaid` decimal(20,2) NOT NULL,
  `adjustment` decimal(20,2) DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `hash` varchar(32) NOT NULL,
  `status` int(11) DEFAULT '1',
  `clientnote` text,
  `adminnote` text,
  `last_overdue_reminder` date DEFAULT NULL,
  `allowed_payment_modes` mediumtext,
  `token` mediumtext,
  `discount_percent` int(11) NOT NULL DEFAULT '0',
  `discount_total` decimal(20,2) DEFAULT '0.00',
  `discount_type` varchar(30) NOT NULL,
  `recurring` int(11) NOT NULL DEFAULT '0',
  `is_recurring_from` int(11) DEFAULT NULL,
  `last_recurring_date` date DEFAULT NULL,
  `terms` text,
  `sale_agent` int(11) NOT NULL DEFAULT '0',
  `payment_term` int(11) NOT NULL,
  `createstatus` int(11) NOT NULL,
  `vchid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblitemtypes` (
  `typeid` int(11) NOT NULL,
  `name` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `tblitemtypes` (`typeid`, `name`) VALUES
(1, 'Stock'),
(2, 'Non Stock'),
(3, 'Serialization'),
(4, 'Lot Numbers'),
(5, 'Services'),
(6, 'Assembly');

CREATE TABLE `tblknowledgebase` (
  `articleid` int(11) NOT NULL,
  `articlegroup` int(11) NOT NULL,
  `subject` mediumtext NOT NULL,
  `description` text NOT NULL,
  `slug` mediumtext NOT NULL,
  `active` tinyint(4) NOT NULL,
  `datecreated` datetime NOT NULL,
  `article_order` int(11) NOT NULL DEFAULT '0',
  `staff_article` int(11) NOT NULL DEFAULT '0',
  `views` int(11) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `tblknowledgebasearticleanswers` (
  `articleanswerid` int(11) NOT NULL,
  `articleid` int(11) NOT NULL,
  `answer` int(11) NOT NULL,
  `ip` varchar(40) NOT NULL,
  `date` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblknowledgebasegroups` (
  `groupid` int(11) NOT NULL,
  `name` mediumtext NOT NULL,
  `description` mediumtext,
  `active` tinyint(4) NOT NULL,
  `color` varchar(10) DEFAULT '#28B8DA',
  `group_order` int(11) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `tblleadactivitylog` (
  `id` int(11) NOT NULL,
  `leadid` int(11) NOT NULL,
  `description` mediumtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` int(11) NOT NULL,
  `noteid` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblleadattachments` (
  `id` int(11) NOT NULL,
  `leadid` int(11) NOT NULL,
  `file_name` mediumtext NOT NULL,
  `filetype` varchar(50) DEFAULT NULL,
  `addedfrom` int(11) NOT NULL,
  `dateadded` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblleadnotes` (
  `id` int(11) NOT NULL,
  `leadid` int(11) NOT NULL,
  `staffid` int(11) NOT NULL,
  `description` text NOT NULL,
  `dateadded` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblleads` (
  `id` int(11) NOT NULL,
  `name` varchar(300) NOT NULL,
  `firstname` varchar(50) NOT NULL,
  `lastname` varchar(50) NOT NULL,
  `country` int(11) NOT NULL,
  `address` text NOT NULL,
  `city` varchar(100) NOT NULL,
  `state` varchar(100) NOT NULL,
  `postalcode` varchar(10) NOT NULL,
  `details` text NOT NULL,
  `assigned` int(11) NOT NULL,
  `dateadded` datetime NOT NULL,
  `status` int(11) NOT NULL,
  `source` int(11) NOT NULL,
  `description` text NOT NULL,
  `industry` int(11) NOT NULL,
  `lastcontact` datetime DEFAULT NULL,
  `last_status_change` datetime DEFAULT NULL,
  `addedfrom` int(11) NOT NULL,
  `email` varchar(150) DEFAULT NULL,
  `leadorder` int(11) DEFAULT '1',
  `phonenumber` varchar(50) DEFAULT NULL,
  `notes` text,
  `date_converted` datetime DEFAULT NULL,
  `lost` tinyint(1) NOT NULL DEFAULT '0',
  `junk` int(11) NOT NULL DEFAULT '0',
  `is_imported_from_email_integration` tinyint(1) NOT NULL DEFAULT '0',
  `email_integration_uid` varchar(30) DEFAULT NULL,
  `is_public` tinyint(1) NOT NULL DEFAULT '0',
  `createddate` date NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblleadsemailintegration` (
  `id` int(11) NOT NULL COMMENT 'the ID always must be 1',
  `active` int(11) NOT NULL,
  `email` varchar(100) NOT NULL,
  `imap_server` varchar(100) NOT NULL,
  `port` int(11) NOT NULL,
  `password` mediumtext NOT NULL,
  `check_every` int(11) NOT NULL DEFAULT '5',
  `responsible` int(11) NOT NULL,
  `lead_source` int(11) NOT NULL,
  `lead_status` int(11) NOT NULL,
  `encryption` varchar(3) DEFAULT NULL,
  `folder` varchar(100) NOT NULL,
  `last_run` varchar(50) DEFAULT NULL,
  `notify_lead_imported` tinyint(1) NOT NULL DEFAULT '1',
  `notify_lead_contact_more_times` tinyint(1) NOT NULL DEFAULT '1',
  `notify_type` varchar(20) DEFAULT NULL,
  `notify_ids` mediumtext,
  `only_loop_on_unseen_emails` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `tblleadsemailintegration` (`id`, `active`, `email`, `imap_server`, `port`, `password`, `check_every`, `responsible`, `lead_source`, `lead_status`, `encryption`, `folder`, `last_run`, `notify_lead_imported`, `notify_lead_contact_more_times`, `notify_type`, `notify_ids`, `only_loop_on_unseen_emails`) VALUES
(1, 0, '', '', 0, '', 10, 0, 0, 0, '', 'inbox', '', 1, 1, 'specific_staff', 'a:0:{}', 1);

CREATE TABLE `tblleadsemailintegrationemails` (
  `id` int(11) NOT NULL,
  `subject` mediumtext,
  `body` mediumtext,
  `dateadded` datetime NOT NULL,
  `leadid` int(11) NOT NULL,
  `emailid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblleadsindustries` (
  `id` int(11) NOT NULL,
  `name` varchar(150) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `tblleadsindustries` (`id`, `name`) VALUES
(1, 'Construction'),
(3, 'IT'),
(4, 'Mining'),
(5, 'Transportation'),
(6, 'Airline'),
(7, 'Medical');

CREATE TABLE `tblleadssources` (
  `id` int(11) NOT NULL,
  `name` varchar(150) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `tblleadssources` (`id`, `name`) VALUES
(1, 'Newspaper Advertisement'),
(2, 'Google Ad'),
(3, 'Trade Show'),
(4, 'Friend'),
(5, 'Email Blast'),
(6, 'Existing Customer'),
(7, 'Cold Call'),
(8, 'Website');

CREATE TABLE `tblleadsstatus` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `statusorder` int(11) DEFAULT NULL,
  `color` varchar(10) DEFAULT '#28B8DA',
  `isdefault` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `tblleadsstatus`
--

INSERT INTO `tblleadsstatus` (`id`, `name`, `statusorder`, `color`, `isdefault`) VALUES
(1, 'Converted', 50, '#298f07', 1),
(2, 'New', 10, '#606060', 0),
(3, 'Contacted', 20, '#026abf', 0),
(4, 'Lost', 80, '#000000', 0),
(5, 'Needs Followup', 4, '#000000', 0),
(6, 'Disqualified', 6, '#0000ff', 0);

CREATE TABLE `tblledgergroups` (
  `id` int(11) NOT NULL,
  `accountid` varchar(20) NOT NULL,
  `name` varchar(250) NOT NULL,
  `description` text NOT NULL,
  `type` varchar(7) NOT NULL,
  `parent` int(11) NOT NULL,
  `path` text NOT NULL,
  `inherit_from_parent` int(11) NOT NULL,
  `can_have_child` int(11) NOT NULL,
  `allow_manual_entry` int(11) NOT NULL,
  `negative_balance_check` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `sort` int(5) NOT NULL,
  `report_type` int(1) NOT NULL,
  `entry_impact` int(1) NOT NULL,
  `credit` int(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `tblledgergroups` (`id`, `accountid`, `name`, `description`, `type`, `parent`, `path`, `inherit_from_parent`, `can_have_child`, `allow_manual_entry`, `negative_balance_check`, `status`, `sort`, `report_type`, `entry_impact`, `credit`) VALUES
(1, 'GRP-01', 'Assets', 'Debit', 'Group', 0, 'Assets', 0, 0, 0, 0, 0, 1, 1, 0, 2),
(2, 'GRP-02', 'Liabilities', 'Credit', 'Group', 0, 'Liabilities', 0, 0, 0, 0, 0, 2, 1, 1, 1),
(3, 'GRP-03', 'Income', 'Cerdit', 'Group', 0, 'Income', 0, 0, 0, 0, 0, 4, 2, 1, 1),
(4, 'GRP-04', 'Equity', 'Credit', 'Group', 0, 'Equity', 0, 0, 0, 0, 0, 3, 1, 1, 1),
(5, 'GRP-05', 'Expenses', 'Debit', 'Group', 0, 'Expenses', 0, 0, 0, 0, 0, 5, 2, 0, 2),
(6, 'GRP-06', 'Current Asset', '', 'Group', 1, 'Assets/Current Asset', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(7, 'GRP-07', 'Non-current Asset', '', 'Group', 1, 'Assets/Non-current Asset', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(8, 'GRP-08', 'Current Liabilitites', '', 'Group', 2, 'Liabilities/Current Liabilitites', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(9, 'GRP-09', 'Non-current Liabilitites', '', 'Group', 2, 'Liabilities/Non-current Liabilitites', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(10, 'GRP-10', 'Costs of goods sold', '', 'Group', 5, 'Expenses/Costs of goods sold', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(11, 'GRP-11', 'Operating Expenses', '', 'Group', 5, 'Expenses/Operating Expenses', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(12, 'GRP-12', 'Cash and Cash Equivalents', '', 'Group', 6, 'Assets/Current Asset/Cash and Cash Equivalents', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(13, 'GRP-13', 'Short-term Investments', '', 'Group', 6, 'Assets/Current Asset/Short-term Investments', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(14, 'GRP-14', 'Receivables', '', 'Group', 6, 'Assets/Current Asset/Receivables', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(15, 'GRP-15', 'Inventories', '', 'Group', 6, 'Assets/Current Asset/Inventories', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(16, 'GRP-16', 'Prepaid Expenses & Other Current Assets', '', 'Group', 6, 'Assets/Current Asset/Prepaid Expenses & Other Current Assets', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(17, 'GRP-17', 'Property Plant & Equipment', '', 'Group', 7, 'Assets/Non-current Asset/Property Plant & Equipment', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(18, 'GRP-18', 'Accumulated Depreciation and Amortization', '', 'Group', 7, 'Assets/Non-current Asset/Accumulated Depreciation and Amortization', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(19, 'GRP-19', 'Non-current Receivables', '', 'Group', 7, 'Assets/Non-current Asset/Non-current Receivables', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(20, 'GRP-20', 'Inter-company Receivables', '', 'Group', 7, 'Assets/Non-current Asset/Inter-company Receivables', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(21, 'GRP-21', 'Other Non-current Assets', '', 'Group', 7, 'Assets/Non-current Asset/Other Non-current Assets', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(22, '1000-1010', 'Cash on Hand', '', 'Ledger', 12, 'Assets/Current Asset/Cash and Cash Equivalents/Cash on Hand', 0, 1, 0, 1, 0, 0, 0, 0, 1),
(24, '1000-1030', 'Undeposited Funds', '', 'Ledger', 12, 'Assets/Current Asset/Cash and Cash Equivalents/Undeposited Funds', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(25, '1000-1200', 'Accounts Receivable', '', 'Ledger', 14, 'Assets/Current Asset/Receivables/Accounts Receivable', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(26, '1000-1210', ' Notes Receivable', '', 'Ledger', 14, 'Assets/Current Asset/Receivables/ Notes Receivable', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(27, '1000-1220', 'Interest Receivable', '', 'Ledger', 14, 'Assets/Current Asset/Receivables/Interest Receivable', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(28, '1000-1230', 'Other receivable', '', 'Ledger', 14, 'Assets/Current Asset/Receivables/Other receivable', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(29, '1000-1240', 'Allowance for Uncollectible Accounts', '', 'Ledger', 14, 'Assets/Current Asset/Receivables/Allowance for Uncollectible Accounts', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(30, '1000-1300', 'Raw Materials Inventory', '', 'Ledger', 15, 'Assets/Current Asset/Inventories/Raw Materials Inventory', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(31, '1000-1320', 'Work-in-Progress', '', 'Ledger', 15, 'Assets/Current Asset/Inventories/Work-in-Progress', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(32, '1000-1330', 'Finished Goods', '', 'Ledger', 15, 'Assets/Current Asset/Inventories/Finished Goods', 0, 0, 0, 1, 0, 0, 0, 0, 1),
(33, '1000-1340', 'Supplies Inventory', '', 'Ledger', 15, 'Assets/Current Asset/Inventories/Supplies Inventory', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(34, '1000-1400', 'Prepaid Insurance', '', 'Ledger', 16, 'Assets/Current Asset/Prepaid Expenses & Other Current Assets/Prepaid Insurance', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(35, '1000-1410', 'Prepaid Rent', '', 'Ledger', 16, 'Assets/Current Asset/Prepaid Expenses & Other Current Assets/Prepaid Rent', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(36, '1000-1420', 'Employee Advances', '', 'Ledger', 16, 'Assets/Current Asset/Prepaid Expenses & Other Current Assets/Employee Advances', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(37, '1000-1499', ' Input VAT ( Purchase )', '', 'Ledger', 16, 'Assets/Current Asset/Prepaid Expenses & Other Current Assets/ Input VAT ( Purchase )', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(38, '1000-1500', 'Land', '', 'Ledger', 17, 'Assets/Non-current Asset/Property Plant & Equipment/Land', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(39, '1000-1510', 'Buildings', '', 'Ledger', 17, 'Assets/Non-current Asset/Property Plant & Equipment/Buildings', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(40, '1000-1520', ' Improvements', '', 'Ledger', 17, 'Assets/Non-current Asset/Property Plant & Equipment/ Improvements', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(41, '1000-1530', 'Factory Machinery', '', 'Ledger', 17, 'Assets/Non-current Asset/Property Plant & Equipment/Factory Machinery', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(42, '1000-1540', 'Office Equipment', '', 'Ledger', 17, 'Assets/Non-current Asset/Property Plant & Equipment/Office Equipment', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(43, '1000-1550', ' Vehicles', '', 'Ledger', 17, 'Assets/Non-current Asset/Property Plant & Equipment/ Vehicles', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(44, '1000-1560', 'Furniture and Fixtures', '', 'Ledger', 17, 'Assets/Non-current Asset/Property Plant & Equipment/Furniture and Fixtures', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(45, '1000-1900', 'Organization Costs', '', 'Ledger', 21, 'Assets/Non-current Asset/Other Non-current Assets/Organization Costs', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(46, '1000-1910', 'Patents & Licenses', '', 'Ledger', 21, 'Assets/Non-current Asset/Other Non-current Assets/Patents & Licenses', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(47, '2000-2000', 'Accounts Payables', '', 'Ledger', 8, 'Liabilities/Current Liabilitites/Accounts Payables', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(48, '2000-2100', 'Accrued Expense', '', 'Ledger', 8, 'Liabilities/Current Liabilitites/Accrued Expense', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(49, '2000-2200', 'Output VAT ( Sales )', '', 'Ledger', 8, 'Liabilities/Current Liabilitites/Output VAT ( Sales )', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(50, '2000-2300', ' Unearned Revenue', '', 'Ledger', 8, 'Liabilities/Current Liabilitites/ Unearned Revenue', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(51, '2000-2400', 'Other Current Liabilities', '', 'Ledger', 8, 'Liabilities/Current Liabilitites/Other Current Liabilities', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(52, '2000-2500', ' Goods received but not invoiced', '', 'Ledger', 8, 'Liabilities/Current Liabilitites/ Goods received but not invoiced', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(53, '2000-2700', 'Notes Payable', '', 'Ledger', 9, 'Liabilities/Non-current Liabilitites/Notes Payable', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(54, '2000-2710', 'Mortgages Payable', '', 'Ledger', 9, 'Liabilities/Non-current Liabilitites/Mortgages Payable', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(55, '2000-2800', 'Intercompany Payables', '', 'Ledger', 9, 'Liabilities/Non-current Liabilitites/Intercompany Payables', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(56, '2000-2900', 'Other non-current payables', '', 'Ledger', 9, 'Liabilities/Non-current Liabilitites/Other non-current payables', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(57, '3000-3000', 'Owner\'s Investment', '', 'Ledger', 4, 'Equity/Owner\'s Investment', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(58, '3000-3100', 'Owner\'s Expense', '', 'Ledger', 4, 'Equity/Owner\'s Expense', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(59, '3000-3900', 'Retained Earnings', '', 'Ledger', 4, 'Equity/Retained Earnings', 0, 0, 0, 1, 0, 0, 0, 0, 1),
(60, '4000-4000', 'Sales revenue', '', 'Ledger', 61, 'Income/Income from Operations/Sales revenue', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(61, 'GRP-22', 'Income from Operations', '', 'Group', 3, 'Income/Income from Operations', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(62, 'GRP-23', 'Other Income', '', 'Group', 3, 'Income/Other Income', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(63, '4000-4600', ' Interest Revenue', '', 'Ledger', 62, 'Income/Other Income/ Interest Revenue', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(64, '4000-4700', 'Gain on sale of assets', '', 'Ledger', 62, 'Income/Other Income/Gain on sale of assets', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(65, '5000-5000', 'Costs of goods sold', '', 'Ledger', 10, 'Expenses/Costs of goods sold/Costs of goods sold', 0, 1, 0, 0, 0, 0, 0, 0, 1),
(66, '5000-5100', 'Purchase of Raw Materials', '', 'Ledger', 10, 'Expenses/Costs of goods sold/Purchase of Raw Materials', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(67, '5000-5200', 'labor Cost', '', 'Ledger', 10, 'Expenses/Costs of goods sold/labor Cost', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(68, '5000-5300', 'COGS - Freight', '', 'Ledger', 10, 'Expenses/Costs of goods sold/COGS - Freight', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(69, '5000-5800', 'Inventory Adjustments', '', 'Ledger', 10, 'Expenses/Costs of goods sold/Inventory Adjustments', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(70, '6000-6000', 'Advertising Expense', '', 'Ledger', 11, 'Expenses/Operating Expenses/Advertising Expense', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(71, '6000-6050', 'Amortization Expense', '', 'Ledger', 11, 'Expenses/Operating Expenses/Amortization Expense', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(72, '6000-6100', 'Automobile Expense', '', 'Ledger', 11, 'Expenses/Operating Expenses/Automobile Expense', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(73, '6000-6150', 'Bad Debt Expense', '', 'Ledger', 11, 'Expenses/Operating Expenses/Bad Debt Expense', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(74, '6000-6200', 'Bank Charges', '', 'Ledger', 11, 'Expenses/Operating Expenses/Bank Charges', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(75, '6000-6250', 'Cash Over and Short', '', 'Ledger', 11, 'Expenses/Operating Expenses/Cash Over and Short', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(76, '6000-6300', 'Commission Expense', '', 'Ledger', 11, 'Expenses/Operating Expenses/Commission Expense', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(77, '6000-6350', 'Depreciation Expense', '', 'Ledger', 11, 'Expenses/Operating Expenses/Depreciation Expense', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(78, '6000-6400', 'Employee Benefit Program', '', 'Ledger', 11, 'Expenses/Operating Expenses/Employee Benefit Program', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(79, '6000-6550', 'Freight Expense', '', 'Ledger', 11, 'Expenses/Operating Expenses/Freight Expense', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(80, '6000-6600', ' Gifts & Donations', '', 'Ledger', 11, 'Expenses/Operating Expenses/ Gifts & Donations', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(81, '6000-6650', 'Insurance Expense', '', 'Ledger', 11, 'Expenses/Operating Expenses/Insurance Expense', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(82, '6000-6700', 'Interest Expense', '', 'Ledger', 11, 'Expenses/Operating Expenses/Interest Expense', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(83, '6000-6800', 'License Expense', '', 'Ledger', 11, 'Expenses/Operating Expenses/License Expense', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(84, '6000-6850', 'Repair & Maintenance', '', 'Ledger', 11, 'Expenses/Operating Expenses/Repair & Maintenance', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(85, '6000-6900', 'Meals and Entertainment', '', 'Ledger', 11, 'Expenses/Operating Expenses/Meals and Entertainment', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(86, '6000-6950', 'Office Expense', '', 'Ledger', 11, 'Expenses/Operating Expenses/Office Expense', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(87, '6000-7050', 'Printing', '', 'Ledger', 11, 'Expenses/Operating Expenses/Printing', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(88, '6000-7150', 'Postage', '', 'Ledger', 11, 'Expenses/Operating Expenses/Postage', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(89, '6000-7200', ' Rent Expense', '', 'Ledger', 11, 'Expenses/Operating Expenses/ Rent Expense', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(90, '6000-7300', 'Salaries Expense', '', 'Ledger', 11, 'Expenses/Operating Expenses/Salaries Expense', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(91, '6000-7350', ' Supplies Expense', '', 'Ledger', 11, 'Expenses/Operating Expenses/ Supplies Expense', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(92, '6000-7400', 'Tax Expense ( FIT )', '', 'Ledger', 11, 'Expenses/Operating Expenses/Tax Expense ( FIT )', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(93, '6000-7500', ' Utilities Expense', '', 'Ledger', 11, 'Expenses/Operating Expenses/ Utilities Expense', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(94, '6000-7900', ' Loss on Sale of Assets', '', 'Ledger', 11, 'Expenses/Operating Expenses/ Loss on Sale of Assets', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(97, '3000-3000', 'Opening Balance Equity', '', 'Ledger', 4, 'Equity/Opening Balance Equity', 0, 0, 0, 0, 0, 0, 0, 0, 1),
(98, '6000-6400', 'Accumulated Depreciation and Amortization', '', 'Ledger', 18, 'Assets/Non-current Asset/Accumulated Depreciation and Amortization/Accumulated Depreciation and Amortization', 0, 0, 0, 0, 0, 0, 0, 0, 1),

CREATE TABLE `tbllistemails` (
  `emailid` int(11) NOT NULL,
  `listid` int(11) NOT NULL,
  `email` varchar(250) NOT NULL,
  `dateadded` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tbllocations` (
  `location_id` int(11) NOT NULL,
  `ware_id` int(11) NOT NULL,
  `default_location` tinyint(1) NOT NULL,
  `location_name` varchar(100) NOT NULL,
  `stock_type` varchar(100) NOT NULL,
  `length` varchar(50) NOT NULL,
  `width` varchar(50) NOT NULL,
  `height` varchar(50) NOT NULL,
  `volume` varchar(50) NOT NULL,
  `remarks` text NOT NULL,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `tblmaillistscustomfields` (
  `customfieldid` int(11) NOT NULL,
  `listid` int(11) NOT NULL,
  `fieldname` varchar(150) NOT NULL,
  `fieldslug` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblmaillistscustomfieldvalues` (
  `customfieldvalueid` int(11) NOT NULL,
  `listid` int(11) NOT NULL,
  `customfieldid` int(11) NOT NULL,
  `emailid` int(11) NOT NULL,
  `value` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblmanufacturers` (
  `mfid` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `phonenumber` varchar(30) DEFAULT NULL,
  `fax` text NOT NULL,
  `website` varchar(100) NOT NULL,
  `country` int(11) NOT NULL,
  `city` varchar(100) DEFAULT NULL,
  `zip` varchar(15) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `address` varchar(100) DEFAULT NULL,
  `datecreated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblmanufacturersnotes` (
  `usernoteid` int(11) NOT NULL,
  `description` text NOT NULL,
  `dateadded` datetime NOT NULL,
  `addedfrom` int(11) NOT NULL,
  `staff` int(11) NOT NULL,
  `userid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblmigrations` (
  `version` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblnationality` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `tblnationality` (`id`, `name`) VALUES
(2, 'Ameriacan'),
(3, 'Indian'),
(4, 'Kittian'),
(5, 'Barbadian'),
(6, 'St Lucian'),
(7, 'British'),
(8, 'African'),
(9, 'Ukrainian'),
(10, 'Trinidadian'),
(11, 'Taiwanese'),
(12, 'Swiss'),
(13, 'Spanish'),
(14, 'South African'),
(15, 'Russian'),
(16, 'Romanian'),
(17, 'Philippine'),
(18, 'Panamanian'),
(19, 'Pakistani'),
(20, 'Nigerian'),
(21, 'Dutch'),
(23, 'Moroccan'),
(24, 'Mexican'),
(25, 'Malaysian'),
(26, 'Jamaican');

CREATE TABLE `tblnotifications` (
  `id` int(11) NOT NULL,
  `isread` int(11) NOT NULL DEFAULT '0',
  `date` datetime NOT NULL,
  `description` text NOT NULL,
  `fromuserid` int(11) NOT NULL,
  `touserid` int(11) NOT NULL,
  `fromcompany` int(11) DEFAULT NULL,
  `link` mediumtext
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tbloptions` (
  `id` int(11) NOT NULL,
  `name` varchar(60) NOT NULL,
  `value` longtext NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `tbloptions` (`id`, `name`, `value`) VALUES
(1, 'dateformat', 'd/m/Y|dd/mm/yyyy'),
(2, 'companyname', ''),
(3, 'services', '0'),
(4, 'maximum_allowed_ticket_attachments', '4'),
(5, 'staff_access_only_assigned_departments', '1'),
(6, 'use_knowledge_base', '1'),
(7, 'ticket_attachments_file_extensions', 'jpg|png|pdf'),
(8, 'smtp_email', 'solomonapp@solomon.ekomplete.com'),
(9, 'smtp_password', 'Rret$K6~}ZE7'),
(10, 'smtp_port', '25'),
(12, 'smtp_host', 'mail.solomon.ekomplete.com'),
(13, 'smtp_email_charset', 'utf-8'),
(14, 'default_timezone', 'America/La_Paz'),
(15, 'clients_default_theme', 'polaris'),
(16, 'company_logo', 'logo.png'),
(18, 'main_domain', 'http://testgatewayproductsllc.com'),
(19, 'tables_pagination_limit', '20'),
(20, 'allow_registration', '0'),
(21, 'knowledge_base_without_registration', '0'),
(22, 'default_staff_role', '1'),
(23, 'newsfeed_upload_file_extensions', '.jpg,.png,.pdf,.psd'),
(24, 'newsfeed_maximum_files_upload', '20'),
(25, 'newsfeed_maximum_file_size', '10'),
(26, 'contract_expiration_before', '4'),
(27, 'invoice_prefix', 'INV-'),
(28, 'decimal_separator', '.'),
(29, 'thousand_separator', ','),
(30, 'currency_placement', 'before'),
(31, 'invoice_company_name', 'Customer Support Services'),
(32, 'invoice_company_address', '# 16 Copenhagen Industrial Park\r\nEast West Boulevard '),
(33, 'invoice_company_city', 'Miami'),
(34, 'invoice_company_country_code', '236'),
(35, 'invoice_company_postal_code', '331905'),
(36, 'invoice_company_phonenumber', '(000) 876-5543'),
(39, 'email_signature', ''),
(41, 'view_invoice_only_logged_in', '1'),
(42, 'invoice_number_format', '1'),
(43, 'next_invoice_number', '12352'),
(44, 'invoice_year', '2017'),
(46, 'cron_send_invoice_overdue_reminder', '1'),
(47, 'invoice_number_decrement_on_delete', '0'),
(48, 'active_language', 'english'),
(50, 'automatically_send_invoice_overdue_reminder_after', '1'),
(51, 'automatically_resend_invoice_overdue_reminder_after', '3'),
(52, 'paymentmethod_paypal_label', 'PayPal'),
(53, 'paymentmethod_paypal_active', '0'),
(54, 'paymentmethod_paypal_username', ''),
(55, 'paymentmethod_paypal_password', ''),
(56, 'paymentmethod_paypal_signature', ''),
(59, 'paymentmethod_paypal_currencies', 'EUR,USD'),
(60, 'paymentmethod_paypal_test_mode_enabled', '1'),
(64, 'paymentmethod_stripe_label', 'Stripe'),
(65, 'paymentmethod_stripe_active', '0'),
(66, 'paymentmethod_stripe_test_mode_enabled', '1'),
(67, 'paymentmethod_stripe_api_secret_key', ''),
(68, 'paymentmethod_stripe_currencies', 'USD,CAD'),
(70, 'paymentmethod_stripe_api_publishable_key', ''),
(71, 'create_invoice_from_recurring_only_on_paid_invoices', '0'),
(72, 'send_renewed_invoice_from_recurring_to_email', '0'),
(76, 'limit_top_search_bar_results_to', '20'),
(77, 'rtl_support_client', '0'),
(78, 'allow_payment_amount_to_be_modified', '1'),
(79, 'survey_send_emails_per_cron_run', '25'),
(80, 'delete_only_on_last_invoice', '0'),
(81, 'delete_only_on_last_quote', '1'),
(82, 'quote_prefix', 'EST-'),
(83, 'next_quote_number', '10009'),
(84, 'quote_number_decrement_on_delete', '1'),
(85, 'quote_number_format', '1'),
(86, 'quote_year', '2016'),
(87, 'quote_auto_convert_to_invoice_on_client_accept', '0'),
(88, 'exclude_quote_from_client_area_with_draft_status', '1'),
(89, 'rtl_support_admin', '0'),
(90, 'last_recurring_invoices_cron', '1498494316'),
(91, 'last_cron_run', '1498494316'),
(92, 'show_sale_agent_on_quotes', '1'),
(93, 'show_sale_agent_on_invoices', '1'),
(94, 'predefined_terms_invoice', 'Invoices issued must be paid by the due date unless otherwise agreed. Company may charge interest on the amount outstanding after the due date at the rate of 5 % per month.'),
(96, 'predefined_terms_quote', ''),
(98, 'predefined_clientnote_invoice', 'Thank you for your business'),
(99, 'predefined_clientnote_quote', ''),
(100, 'custom_pdf_logo_image_url', ''),
(101, 'number_padding_invoice_and_quote', '4'),
(110, 'last_recurring_expenses_cron', '1498494316'),
(114, 'invoice_due_after', '0'),
(115, 'google_api_key', 'AIzaSyDm8j8AlOSiRYXmPnFAPd-DcDQraO2azgQ'),
(116, 'google_calendar_main_calendar', ''),
(117, 'show_invoices_on_calendar', '1'),
(118, 'show_quotes_on_calendar', '1'),
(119, 'show_contracts_on_calendar', '1'),
(120, 'show_tasks_on_calendar', '1'),
(121, 'show_client_reminders_on_calendar', '1'),
(122, 'default_tax', ''),
(123, 'output_client_pdfs_from_admin_area_in_client_language', '0'),
(124, 'auto_backup_enabled', '0'),
(125, 'auto_backup_every', '7'),
(127, 'last_auto_backup', ''),
(130, 'favicon', ''),
(131, 'show_leads_reminders_on_calendar', '1'),
(132, 'customer_default_country', '63'),
(133, 'view_quote_only_logged_in', '0'),
(134, 'show_status_on_pdf_ei', '1'),
(135, 'email_piping_only_replies', '0'),
(136, 'email_piping_only_registered', '1'),
(137, 'email_piping_enabled', '0'),
(138, 'email_piping_default_priority', ''),
(139, 'setup_menu_inactive', '{\"setup_menu_inactive\":[]}'),
(140, 'aside_menu_inactive', '{\"aside_menu_inactive\":[]}'),
(141, 'aside_menu_active', '{\"aside_menu_active\":[{\"name\":\"als_dashboard\",\"url\":\"\\/\",\"permission\":\"\",\"icon\":\"fa fa-tachometer\",\"id\":\"dashboard\"},{\"name\":\"als_calendar_submenu\",\"url\":\"utilities\\/calendar\",\"permission\":\"\",\"icon\":\"fa fa-calendar\",\"id\":\"child-calendar\"},{\"name\":\"CRM\",\"url\":\"#\",\"permission\":\"manageSurveys\",\"icon\":\"fa fa-tty\",\"id\":\"crm\",\"children\":[{\"name\":\"als_leads\",\"url\":\"leads\",\"permission\":\"\",\"icon\":\"fa fa-tty\",\"id\":\"leads\"},{\"name\":\"To Do\",\"url\":\"tasks\\/list_tasks\",\"permission\":\"\",\"icon\":\"fa fa-tasks\",\"id\":\"tasks\"},{\"name\":\"Campaign\",\"url\":\"campaign\",\"permission\":\"\",\"icon\":\"fa fa-line-chart\",\"id\":\"campaign\"},{\"name\":\"Opportunity\",\"url\":\"opportunity\",\"permission\":\"\",\"icon\":\"fa fa-line-chart\",\"id\":\"opportunity\"},{\"name\":\"als_media\",\"url\":\"utilities\\/media\",\"permission\":\"manageClients\",\"icon\":\"fa fa-tty\",\"id\":\"child-media\"},{\"name\":\"als_surveys\",\"url\":\"surveys\",\"permission\":\"manageSurveys\",\"icon\":\"fa fa-tasks\",\"id\":\"child-surveys\"},{\"name\":\"Setup\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-cogs\",\"id\":\"setup\",\"children\":[{\"name\":\"Sources\",\"url\":\"leads\\/sources\",\"permission\":\"\",\"icon\":\"fa fa-file-o\",\"id\":\"sources\"},{\"name\":\"Industries\",\"url\":\"leads\\/industries\",\"permission\":\"\",\"icon\":\"fa fa-file-o\",\"id\":\"industries\"},{\"name\":\"Statuses\",\"url\":\"leads\\/statuses\",\"permission\":\"\",\"icon\":\"fa fa-file-o\",\"id\":\"statuses\"}]}]},{\"name\":\"als_sales\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-balance-scale\",\"id\":\"sales\",\"children\":[{\"name\":\"als_clients\",\"url\":\"clients\",\"permission\":\"\",\"icon\":\"fa fa-users\",\"id\":\"customers\"},{\"name\":\"invoices\",\"url\":\"invoices\\/list_invoices\",\"permission\":\"\",\"icon\":\"fa fa-money\",\"id\":\"child-invoices\"},{\"name\":\"Orders\",\"url\":\"orders\",\"permission\":\"\",\"icon\":\"fa fa-line-chart\",\"id\":\"child-orders\"},{\"name\":\"quotes\",\"url\":\"estimates\",\"permission\":\"\",\"icon\":\"fa fa-pencil\",\"id\":\"child-quotes\"},{\"name\":\"Receipts\",\"url\":\"payments\",\"permission\":\"\",\"icon\":\"fa fa-money\",\"id\":\"child-payments\"},{\"name\":\"Returns\",\"url\":\"returns\",\"permission\":\"\",\"icon\":\"fa fa-file-o\",\"id\":\"child-bulk-pdf-exporter\"},{\"name\":\"proposals\",\"url\":\"proposals\",\"permission\":\"\",\"icon\":\"fa fa-file-o\",\"id\":\"child-proposals\"},{\"name\":\"als_contracts\",\"url\":\"contracts\",\"permission\":\"\",\"icon\":\"fa fa-pencil\",\"id\":\"contracts\"},{\"name\":\"Setup\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-cogs\",\"id\":\"setup\",\"children\":[{\"name\":\"Customer Class\",\"url\":\"clients\\/groups\",\"permission\":\"\",\"icon\":\"fa fa-file\",\"id\":\"class\"},{\"name\":\"acs_contract_types\",\"url\":\"contracts\\/types\",\"permission\":\"\",\"icon\":\"fa fa-file\",\"id\":\"contract-types\"},{\"name\":\"Discount\",\"url\":\"discounts\",\"permission\":\"\",\"icon\":\"fa fa-percent\",\"id\":\"discounts\"}]}]},{\"name\":\"Help Desk\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-life-ring\",\"id\":\"tickets\",\"children\":[{\"name\":\"Tickets\",\"url\":\"tickets\",\"permission\":\"\",\"icon\":\"fa fa-life-ring\",\"id\":\"child-all-tickets\"},{\"name\":\"Knowledge Base\",\"url\":\"knowledge_base\",\"permission\":\"\",\"icon\":\"fa fa-life-ring\",\"id\":\"child-all-articles\"},{\"name\":\"New Article\",\"url\":\"knowledge_base\\/article\",\"permission\":\"\",\"icon\":\"fa fa-file\",\"id\":\"child-add-article\"},{\"name\":\"Setup\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-cogs\",\"id\":\"child-all-setup\",\"children\":[{\"name\":\"acs_ticket_statuses_submenu\",\"url\":\"tickets\\/statuses\",\"permission\":\"is_admin\",\"icon\":\"fa fa-file\",\"id\":\"ticket-statuses\"},{\"name\":\"acs_ticket_priority_submenu\",\"url\":\"tickets\\/priorities\",\"permission\":\"is_admin\",\"icon\":\"fa fa-file\",\"id\":\"ticket-priority\"},{\"name\":\"acs_ticket_predefined_replies_submenu\",\"url\":\"tickets\\/predifined_replies\",\"permission\":\"is_admin\",\"icon\":\"fa fa-file\",\"id\":\"predifined-replies\"},{\"name\":\"acs_ticket_services_submenu\",\"url\":\"tickets\\/services\",\"permission\":\"is_admin\",\"icon\":\"fa fa-file\",\"id\":\"services\"},{\"name\":\"spam_filters\",\"url\":\"tickets\\/spam_filters\",\"permission\":\"is_admin\",\"icon\":\"fa fa-file\",\"id\":\"spam-filters\"},{\"name\":\"KB Groups\",\"url\":\"knowledge_base\\/manage_groups\",\"permission\":\"\",\"icon\":\"fa fa-file\",\"id\":\"child-groups\"}]}]},{\"name\":\"Purchasing\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-heartbeat\",\"id\":\"purchasing\",\"children\":[{\"name\":\"Suppliers\",\"url\":\"suppliers\",\"permission\":\"\",\"icon\":\"fa fa-users\",\"id\":\"Suppliers\"},{\"name\":\"Goods Received\",\"url\":\"grns\",\"permission\":\"\",\"icon\":\"fa fa-users\",\"id\":\"grn\"},{\"name\":\"Purchase Order\",\"url\":\"Purchaseorders\",\"permission\":\"\",\"icon\":\"fa fa-users\",\"id\":\"PurchaseOrder\"},{\"name\":\"Purchase Request\",\"url\":\"rfqs\",\"permission\":\"\",\"icon\":\"fa fa-users\",\"id\":\"rfq\"},{\"name\":\"Returns\",\"url\":\"returns\",\"permission\":\"\",\"icon\":\"fa fa-file-o\",\"id\":\"child-quotes\"},{\"name\":\"Setup\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-cogs\",\"id\":\"purchasing-setup\",\"children\":[{\"name\":\"Supplier Class\",\"url\":\"suppliers\\/groups\",\"permission\":\"\",\"icon\":\"fa fa-file menu-icon\",\"id\":\"test\"}]}]},{\"id\":\"inventory\",\"name\":\"Inventory\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-heartbeat\",\"children\":[{\"name\":\"items\",\"url\":\"invoice_items\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"child-items\"},{\"name\":\"Warehouse\",\"url\":\"warehouse\",\"permission\":\"\",\"icon\":\"fa fa-building\",\"id\":\"warehouse\"},{\"name\":\"Warehouse Transfer \",\"url\":\"warehouse_transfer\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"child-items\"},{\"name\":\"Internal Transfer \",\"url\":\"internal_transfer\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"child-items\"},{\"name\":\"Bin Transfer \",\"url\":\"bin_transfer\\/bin_transfer\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"child-items\"},{\"name\":\"Setup\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-cogs\",\"id\":\"inventory-setup\",\"children\":[{\"name\":\"Category\",\"url\":\"categories\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"category\"},{\"name\":\"Sub Category\",\"url\":\"subcategories\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"subcategory\"},{\"name\":\"Bins\",\"url\":\"bins\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"bins\"},{\"name\":\"Locations\",\"url\":\"locations\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"locations\"},{\"name\":\"Department\",\"url\":\"item_departments\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"item_departments\"},{\"name\":\"Manufacturer\",\"url\":\"manufacturers\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"manufacturer\"},{\"name\":\"Unit Of Measure\",\"url\":\"units\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"UnitOfMeasure\"}]}]},{\"name\":\"Financial\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-money\",\"id\":\"financial\",\"children\":[{\"name\":\"Ledgers\",\"url\":\"ledgers\",\"permission\":\"\",\"icon\":\"fa fa-newspaper-o\",\"id\":\"ledgers\"},{\"name\":\"Journals\",\"url\":\"vouchers\",\"permission\":\"\",\"icon\":\"fa fa-newspaper-o\",\"id\":\"vouchers\"},{\"name\":\"Bills\",\"url\":\"bills\",\"permission\":\"\",\"icon\":\"fa fa-newspaper-o\",\"id\":\"bills\"},{\"name\":\"Payment\",\"url\":\"bills\\/make_payment\",\"permission\":\"\",\"icon\":\"fa fa-file-o\",\"id\":\"writecheck\"},{\"name\":\"Banking\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-building-o\",\"id\":\"banking\",\"children\":[{\"name\":\"Bank Accounts\",\"url\":\"banksaccounts\",\"permission\":\"\",\"icon\":\"fa fa-money\",\"id\":\"bankaccounts\"},{\"name\":\"Account Register\",\"url\":\"account_register\",\"permission\":\"\",\"icon\":\"fa fa-file-o\",\"id\":\"accountregister\"},{\"name\":\"Deposits\",\"url\":\"deopsits\",\"permission\":\"\",\"icon\":\"fa fa-file-o\",\"id\":\"deposits\"},{\"name\":\"Transfers\",\"url\":\"bankingaccounttransfer\",\"permission\":\"\",\"icon\":\"fa fa-file-o\",\"id\":\"transfers\"},{\"name\":\"Reconcile\",\"url\":\"reconcile\",\"permission\":\"\",\"icon\":\"fa fa-file-o\",\"id\":\"reconcile\"}]},{\"name\":\"Setup\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-cogs\",\"id\":\"financial-setup\",\"children\":[{\"name\":\"Banks\",\"url\":\"banks\",\"permission\":\"\",\"icon\":\"fa fa-institution\",\"id\":\"bank\"},{\"name\":\"Bank Branches\",\"url\":\"bankbranches\",\"permission\":\"\",\"icon\":\"fa fa-institution\",\"id\":\"bankbranches\"},{\"name\":\"Account Groups\",\"url\":\"subgroups\",\"permission\":\"\",\"icon\":\"fa fa-tasks\",\"id\":\"subgroup\"},{\"name\":\"Voucher Types\",\"url\":\"vouchers\\/vouchertypes\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"vouchertypes\"},{\"name\":\"Period\",\"url\":\"periods\",\"permission\":\"\",\"icon\":\"fa fa-fa-tasks\",\"id\":\"Period\"},{\"name\":\"acs_sales_taxes_submenu\",\"url\":\"taxes\",\"permission\":\"\",\"icon\":\"fa fa-percent\",\"id\":\"taxes\"},{\"name\":\"acs_sales_currencies_submenu\",\"url\":\"currencies\",\"permission\":\"\",\"icon\":\"fa fa-usd\",\"id\":\"currencies\"},{\"name\":\"acs_sales_payment_modes_submenu\",\"url\":\"paymentmodes\",\"permission\":\"\",\"icon\":\"fa fa-credit-card\",\"id\":\"payment-modes\"}]}]},{\"name\":\"HRM\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-money\",\"id\":\"hrm\",\"children\":[{\"name\":\"Employees\",\"url\":\"employee\",\"permission\":\"\",\"icon\":\"fa fa-users\",\"id\":\"ledgers\"},{\"name\":\"Payroll\",\"url\":\"payroll\",\"permission\":\"\",\"icon\":\"fa fa-ticket\",\"id\":\"vouchers\"},{\"name\":\"Setup\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-cogs\",\"id\":\"financial-setup\",\"children\":[{\"name\":\"Holidays\",\"url\":\"holidays\",\"permission\":\"\",\"icon\":\"fa fa-sun-o \",\"id\":\"bank\"},{\"name\":\"Race\",\"url\":\"race\",\"permission\":\"is_admin\",\"icon\":\"fa fa-user-secret\",\"id\":\"bankbranches\"},{\"name\":\"Nationality\",\"url\":\"nationality\",\"permission\":\"is_admin\",\"icon\":\"fa fa-map\",\"id\":\"subgroup\"},{\"name\":\"Salaries\",\"url\":\"salary\",\"permission\":\"manageGoals\",\"icon\":\"fa fa-money\",\"id\":\"vouchertypes\"},{\"name\":\"Institutions\",\"url\":\"institutions\",\"permission\":\"is_admin\",\"icon\":\"fa fa-newspaper-o\",\"id\":\"Period\"},{\"name\":\"Grades\",\"url\":\"grades\",\"permission\":\"\",\"icon\":\"fa fa-newspaper-o\",\"id\":\"taxes\"},{\"name\":\"Time Lock\",\"url\":\"timelock\",\"permission\":\"\",\"icon\":\"fa fa-clock-o\",\"id\":\"timelock\"}]}]},{\"name\":\"als_reports\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-area-chart\",\"id\":\"reports\",\"children\":[{\"id\":\"reports-sales\",\"name\":\"Sales\",\"url\":\"reports\\/sales\",\"permission\":\"manageClients\",\"icon\":\"fa fa-balance-scale\",\"children\":[{\"name\":\"Invoices\",\"url\":\"invoices_rep\",\"permission\":\"\",\"icon\":\"fa fa-area-chart\",\"id\":\"campaign\"},{\"name\":\"Orders\",\"url\":\"orders_rep\",\"permission\":\"\",\"icon\":\"fa fa-pie-chart\",\"id\":\"opportunity\"},{\"name\":\"Quotes\",\"url\":\"quotes_rep\",\"permission\":\"\",\"icon\":\"fa fa-bar-chart\",\"id\":\"campaign\"},{\"name\":\"Sales By Item\",\"url\":\"items_sales\",\"permission\":\"manageClients\",\"icon\":\"fa fa-line-chart\",\"id\":\"child-media\"},{\"name\":\"Customer Statement\",\"url\":\"reports\\/statement\",\"permission\":\"\",\"icon\":\"fa fa-bar-chart\",\"id\":\"statement\"},{\"name\":\"Report By Salesman\",\"url\":\"report_salesman\",\"permission\":\"manageClients\",\"icon\":\"fa fa-area-chart\",\"id\":\"child-media\"}]},{\"id\":\"reports-purchasing\",\"name\":\"Purchasing\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-heartbeat\",\"children\":[{\"id\":\"opportunity\",\"name\":\"AR Aging\",\"url\":\"reports\\/purchase_orders\",\"permission\":\"\",\"icon\":\"fa fa-bar-chart\"}]},{\"id\":\"reports-inventory\",\"name\":\"Inventory\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-heartbeat\",\"children\":[{\"name\":\"Inventory Valuation\",\"url\":\"inven_val\",\"permission\":\"\",\"icon\":\"fa fa-bar-chart\",\"id\":\"child-media\"},{\"name\":\"Stock Take Sheet\",\"url\":\"stock_take\",\"permission\":\"\",\"icon\":\"fa fa-bar-chart\",\"id\":\"opportunity\"}]},{\"id\":\"reports-financials\",\"name\":\"Financials\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-money\",\"children\":[{\"name\":\"COA\",\"url\":\"coa\",\"permission\":\"\",\"icon\":\"fa fa-bar-chart\",\"id\":\"opportunity\"},{\"name\":\"COA Compared\",\"url\":\"coa_compared\",\"permission\":\"\",\"icon\":\"fa fa-pie-chart\",\"id\":\"campaign\"},{\"name\":\"Profit And Loss\",\"url\":\"reports\\/profitlossaccount\",\"permission\":\"is_admin\",\"icon\":\"fa fa-money\",\"id\":\"child-sales\"},{\"name\":\"Balance Sheet\",\"url\":\"reports\\/balancesheet\",\"permission\":\"is_admin\",\"icon\":\"fa fa-money\",\"id\":\"child-sales\"},{\"name\":\"Trial Balance\",\"url\":\"reports\\/trial_balance\",\"permission\":\"\",\"icon\":\"fa fa-money\",\"id\":\"reports\"},{\"name\":\"Sales Tax\",\"url\":\"sales_tax\",\"permission\":\"\",\"icon\":\"fa fa-money\",\"id\":\"child-media\"},{\"name\":\"Customer Ageing\",\"url\":\"reports\\/ageing\",\"permission\":\"is_admin\",\"icon\":\"fa fa-line-chart\",\"id\":\"accounts\"},{\"name\":\"Supplier Aging\",\"url\":\"reports\\/supplier_ageing\",\"permission\":\"\",\"icon\":\"fa fa-line-chart\",\"id\":\"campaign\"}]}]},{\"name\":\"als_utilities\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-cogs\",\"id\":\"utilities\",\"children\":[{\"name\":\"als_activity_log_submenu\",\"url\":\"utilities\\/activity_log\",\"permission\":\"is_admin\",\"icon\":\"fa fa-file-o\",\"id\":\"child-activity-log\"}]}]}'),
(142, 'setup_menu_active', '{\"setup_menu_active\":[{\"name\":\"Settings\",\"url\":\"settings\",\"permission\":\"manageRoles\",\"icon\":\"fa fa-users\",\"id\":\"settings\"},{\"name\":\"Companies\",\"url\":\"companies\",\"permission\":\"manageRoles\",\"icon\":\"fa fa-building\",\"id\":\"companies\"},{\"name\":\"Companies Types\",\"url\":\"companies\\/types\",\"permission\":\"manageRoles\",\"icon\":\"fa fa-building\",\"id\":\"companies-types\"},{\"name\":\"Staff\",\"url\":\"staff\",\"permission\":\"manageStaff\",\"icon\":\"fa fa-users\",\"id\":\"staff\"},{\"name\":\"acs_departments\",\"url\":\"departments\",\"permission\":\"manageDepartments\",\"icon\":\"fa fa-users\",\"id\":\"departments\"},{\"name\":\"acs_roles\",\"url\":\"roles\",\"permission\":\"manageRoles\",\"icon\":\"fa fa-users\",\"id\":\"roles\"},{\"name\":\"Dictionary\",\"url\":\"dictionary\",\"permission\":\"is_admin\",\"icon\":\"fa fa-users\",\"id\":\"dictionary\"},{\"name\":\"acs_email_templates\",\"url\":\"emails\",\"permission\":\"editEmailTemplates\",\"icon\":\"fa fa-users\",\"id\":\"email-templates\"},{\"name\":\"menu_builder\",\"url\":\"#\",\"permission\":\"is_admin\",\"icon\":\"fa fa-users\",\"id\":\"menu-builder\",\"children\":[{\"name\":\"main_menu\",\"url\":\"utilities\\/main_menu\",\"permission\":\"\",\"icon\":\"fa fa-users\",\"id\":\"organize-sidebar\"},{\"name\":\"setup_menu\",\"url\":\"utilities\\/setup_menu\",\"permission\":\"is_admin\",\"icon\":\"fa fa-users\",\"id\":\"setup-menu\"}]}]}'),
(143, 'invoice_company_registration_id', '324234'),
(144, 'invoice_company_vat_registration_id', '16008364'),
(145, 'invoice_company_state', 'FL'),
(146, 'invoice_company_fax', ''),
(147, 'invoice_company_email', 'someemail@somecompany.com'),
(148, 'customer_startnumber', '1200162'),
(149, 'next_customer', '1200163'),
(150, 'customer_prefix', 'CUS'),
(151, 'customer_separator', '-'),
(152, 'number_padding_invoice_and_estimate', '5'),
(153, 'next_estimate_number', '1007'),
(154, 'estimate_year', '2017'),
(155, 'estimate_number_decrement_on_delete', '1'),
(157, 'estimate_auto_convert_to_invoice_on_client_accept', '0'),
(158, 'exclude_estimate_from_client_area_with_draft_status', '1'),
(159, 'estimate_number_format', '2'),
(160, 'predefined_terms_estimate', 'The prices, quantities and delivery time stated in any quotation are valid for 7 days from the date of creation and are commercial estimates only which the Company will make reasonable efforts to achieve.'),
(161, 'predefined_clientnote_estimate', 'Thank you for choosing our company'),
(162, 'estimate_prefix', 'QTE-'),
(163, 'delete_only_on_last_estimate', '0'),
(166, 'order_prefix', 'ORD-'),
(167, 'settings_sales_order_prefix', ''),
(168, 'next_order_number', '6'),
(169, 'order_year', '2017'),
(170, 'order_number_decrement_on_delete', '0'),
(171, 'show_sale_agent_on_estimates', '1'),
(172, 'order_auto_convert_to_invoice_on_client_accept', '0'),
(173, 'exclude_order_from_client_area_with_draft_status', '1'),
(174, 'order_number_format', '2'),
(175, 'predefined_terms_order', 'Orders will be deemed to have been placed when an email confirmation has been received from a representative of the client company or an quote has been accepted in the Customer Portal.'),
(176, 'predefined_clientnote_order', 'Thank you for your order.\r\nIt has been a pleasure to serve you'),
(177, 'quote_expiration_days', '14'),
(178, 'automatically_expire_quote', '0'),
(179, 'show_sale_agent_on_orders', '1'),
(180, 'next_rfq_number', '47'),
(181, 'predefined_ledger', '40'),
(182, 'customer_ledger', ''),
(183, 'supplier_ledger', ''),
(184, 'inventory_ledger', '32'),
(185, 'sales_ledger', '60'),
(186, 'cost_of_goods_sold', '65'),
(187, 'sales_discount', '100'),
(188, 'cash_ledger', '66'),
(189, 'bank_ledger', '99'),
(190, 'account_receivable', '25'),
(191, 'accounts_payable', '47'),
(192, 'account_req', ''),
(193, 'next_purchaseorder_number', '212'),
(194, 'purchaseorder_number_format', '1'),
(195, 'purchaseorder_prefix', 'PO-'),
(196, 'purchaseorder_year', '2016'),
(197, 'next_rfqsqoute_number', '151'),
(198, 'rfqs_number_format', '1'),
(199, 'rfqsqoute_prefix', 'RFQ-'),
(200, 'rfqsqoute_year', '2016'),
(201, 'payment_prefix', 'PMT-'),
(202, 'next_payment_number', '1'),
(203, 'next_paybillnumber_number ', '14'),
(204, 'billpayment_prefix', 'SPT-'),
(205, 'next_paybillnumber_number', '14'),
(206, 'billpayment_prefix', 'SPT-'),
(207, 'next_grn_number', '152'),
(208, 'grn_prefix', 'GRN-'),
(209, 'shipping_ledger', '79'),
(210, 'GR_ledger', '52'),
(211, 'customer_discounts_ledger', '24'),
(212, 'retained_earning', '59'),
(213, 'input_vat', '37'),
(214, 'output_vat', '49'),
(215, 'supplier_discount', '101'),
(216, 'opening_balance', '97'),
(217, 'employee_default_country', '236'),
(218, 'employee_startnumber', '10012'),
(219, 'next_employee', '1003'),
(220, 'employee_prefix', 'EMP'),
(221, 'employee_separator', '-'),
(222, 'employee_ledger', ''),
(223, 'employee_discounts_ledger', ''),
(224, 'aside_permission_active', '{\"aside_menu_active\":[{\"name\":\"als_dashboard\",\"url\":\"\\/\",\"permission\":\"\",\"icon\":\"fa fa-tachometer\",\"id\":\"dashboard\"},{\"name\":\"Dashboard Details\",\"url\":\"\\/\",\"permission\":\"\",\"icon\":\"fa fa-tachometer\",\"id\":\"dashboard-details\"},{\"name\":\"als_calendar_submenu\",\"url\":\"utilities\\/calendar\",\"permission\":\"\",\"icon\":\"fa fa-calendar\",\"id\":\"child-calendar\"},{\"name\":\"CRM\",\"url\":\"crm\",\"permission\":\"\",\"icon\":\"fa fa-tty\",\"id\":\"crm\",\"children\":[{\"name\":\"als_leads\",\"url\":\"leads\",\"permission\":\"\",\"icon\":\"fa fa-tty\",\"id\":\"leads\"},{\"name\":\"als_media\",\"url\":\"utilities\\/media\",\"permission\":\"\",\"icon\":\"fa fa-tty\",\"id\":\"child-media\"},{\"name\":\"als_tasks\",\"url\":\"tasks\\/list_tasks\",\"permission\":\"\",\"icon\":\"fa fa-tasks\",\"id\":\"tasks\"},{\"name\":\"Event\",\"url\":\"event\",\"permission\":\"\",\"icon\":\"fa fa-line-chart\",\"id\":\"event\"},{\"name\":\"Campaign\",\"url\":\"campaign\",\"permission\":\"\",\"icon\":\"fa fa-line-chart\",\"id\":\"campaign\"},{\"name\":\"Opportunity\",\"url\":\"opportunity\",\"permission\":\"\",\"icon\":\"fa fa-line-chart\",\"id\":\"opportunity\"}]},{\"name\":\"als_sales\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-balance-scale\",\"id\":\"sales\",\"children\":[{\"name\":\"als_clients\",\"url\":\"clients\",\"permission\":\"manageClients\",\"icon\":\"fa fa-users\",\"id\":\"customers\",\"children\":[{\"name\":\"als_clients\",\"url\":\"clients\",\"permission\":\"customerProfile\",\"icon\":\"fa fa-users\",\"id\":\"customers\"},{\"name\":\"als_clients\",\"url\":\"clients\",\"permission\":\"customerProfile\",\"icon\":\"fa fa-users\",\"id\":\"customerprofile\"},{\"name\":\"als_clients\",\"url\":\"clients\",\"permission\":\"customerProposals\",\"icon\":\"fa fa-users\",\"id\":\"customerproposals\"},{\"name\":\"als_clients\",\"url\":\"clients\",\"permission\":\"customerInvoice\",\"icon\":\"fa fa-users\",\"id\":\"customerinvoice\"},{\"name\":\"als_clients\",\"url\":\"clients\",\"permission\":\"customerQuotes\",\"icon\":\"fa fa-users\",\"id\":\"customerquotes\"}]},{\"name\":\"invoices\",\"url\":\"invoices\\/list_invoices\",\"permission\":\"\",\"icon\":\"fa fa-money\",\"id\":\"child-invoices\"},{\"name\":\"Invoices Details\",\"url\":\"invoices\\/list_invoices\",\"permission\":\"\",\"icon\":\"fa fa-money\",\"id\":\"child-invoices-details\"},{\"name\":\"Orders\",\"url\":\"orders\",\"permission\":\"\",\"icon\":\"fa fa-line-chart\",\"id\":\"child-orders\"},{\"name\":\"Orders Details\",\"url\":\"orders\",\"permission\":\"\",\"icon\":\"fa fa-line-chart\",\"id\":\"child-orders-details\"},{\"name\":\"quotes\",\"url\":\"estimates\",\"permission\":\"\",\"icon\":\"fa fa-pencil\",\"id\":\"child-quotes\"},{\"name\":\"Quotes-Details\",\"url\":\"estimates\",\"permission\":\"\",\"icon\":\"fa fa-pencil\",\"id\":\"child-quotes-details\"},{\"name\":\"proposals\",\"url\":\"proposals\",\"permission\":\"\",\"icon\":\"fa fa-file-o\",\"id\":\"child-proposals\"},{\"name\":\"als_contracts\",\"url\":\"contracts\",\"permission\":\"manageContracts\",\"icon\":\"fa fa-pencil\",\"id\":\"contracts\"},{\"name\":\"Contracts Details\",\"url\":\"contracts\",\"permission\":\"\",\"icon\":\"fa fa-pencil\",\"id\":\"child-contracts-details\"},{\"name\":\"Receipts\",\"url\":\"payments\",\"permission\":\"\",\"icon\":\"fa fa-money\",\"id\":\"child-payments\"},{\"name\":\"Setup\",\"url\":\"setup\",\"permission\":\"\",\"icon\":\"fa fa-cogs\",\"id\":\"setup\",\"children\":[{\"name\":\"Customer Class\",\"url\":\"clients\\/groups\",\"permission\":\"\",\"icon\":\"fa fa-file\",\"id\":\"class\"},{\"name\":\"acs_contract_types\",\"url\":\"contracts\\/types\",\"permission\":\"\",\"icon\":\"fa fa-file\",\"id\":\"contract-types\"},{\"name\":\"Discount\",\"url\":\"discounts\",\"permission\":\"\",\"icon\":\"fa fa-percent\",\"id\":\"discounts\"}]}]},{\"name\":\"Purchasing\",\"url\":\"purchasing\",\"permission\":\"\",\"icon\":\"fa fa-heartbeat\",\"id\":\"purchasing\",\"children\":[{\"name\":\"Suppliers\",\"url\":\"suppliers\",\"permission\":\"\",\"icon\":\"fa fa-users\",\"id\":\"Suppliers\"},{\"name\":\"Goods Received\",\"url\":\"grns\",\"permission\":\"\",\"icon\":\"fa fa-users\",\"id\":\"grn\"},{\"name\":\"Purchase Order\",\"url\":\"Purchaseorders\",\"permission\":\"\",\"icon\":\"fa fa-users\",\"id\":\"PurchaseOrder\"},{\"name\":\"Purchase Request\",\"url\":\"rfqs\",\"permission\":\"\",\"icon\":\"fa fa-users\",\"id\":\"rfq\"},{\"name\":\"Setup\",\"url\":\"purchasing\",\"permission\":\"\",\"icon\":\"fa fa-cogs\",\"id\":\"purchasing-setup\",\"children\":[{\"name\":\"Supplier Class\",\"url\":\"suppliers\\/groups\",\"permission\":\"\",\"icon\":\"fa fa-file menu-icon\",\"id\":\"test\"}]}]},{\"name\":\"Inventory\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-heartbeat\",\"id\":\"inventory\",\"children\":[{\"name\":\"items\",\"url\":\"invoice_items\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"child-items\"},{\"name\":\"Warehouse\",\"url\":\"warehouse\",\"permission\":\"\",\"icon\":\"fa fa-building\",\"id\":\"warehouse\"},{\"name\":\"Warehouse Transfer \",\"url\":\"warehouse_transfer\\/warehouse_transfer\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"child-items\"},{\"name\":\"Internal Transfer \",\"url\":\"internal_transfer\\/internal_transfer\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"child-items\"},{\"name\":\"Bin Transfer \",\"url\":\"bin_transfer\\/bin_transfer\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"child-items\"},{\"name\":\"Setup\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-cogs\",\"id\":\"inventory-setup\",\"children\":[{\"name\":\"Category\",\"url\":\"categories\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"category\"},{\"name\":\"Sub Category\",\"url\":\"subcategories\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"subcategory\"},{\"name\":\"Bins\",\"url\":\"bins\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"bins\"},{\"name\":\"Locations\",\"url\":\"locations\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"locations\"},{\"name\":\"Department\",\"url\":\"item_departments\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"item_departments\"},{\"name\":\"Manufacturer\",\"url\":\"manufacturers\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"manufacturer\"},{\"name\":\"Unit Of Measure\",\"url\":\"units\",\"permission\":\"\",\"icon\":\"fa fa-tags\",\"id\":\"UnitOfMeasure\"}]}]},{\"name\":\"Financial\",\"url\":\"financial\",\"permission\":\"\",\"icon\":\"fa fa-money\",\"id\":\"financial\",\"children\":[{\"name\":\"Ledgers\",\"url\":\"ledgers\",\"permission\":\"\",\"icon\":\"fa-newspaper-o\",\"id\":\"ledgers\"},{\"name\":\"Journals\",\"url\":\"vouchers\",\"permission\":\"\",\"icon\":\"fa-newspaper-o\",\"id\":\"vouchers\"},{\"name\":\"Bills\",\"url\":\"bills\",\"permission\":\"\",\"icon\":\"fa-newspaper-o\",\"id\":\"bills\"},{\"name\":\"Payment\",\"url\":\"bills\\/make_payment\",\"permission\":\"\",\"icon\":\"fa fa-file-o\",\"id\":\"writecheck\"},{\"name\":\"Banking\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa-building-o\",\"id\":\"banking\",\"children\":[{\"name\":\"Bank Accounts\",\"url\":\"banksaccounts\",\"permission\":\"\",\"icon\":\"fa fa-money\",\"id\":\"bankaccounts\"},{\"name\":\"Account Register\",\"url\":\"account_register\",\"permission\":\"\",\"icon\":\"fa fa-file-o\",\"id\":\"accountregister\"},{\"name\":\"Deposits\",\"url\":\"deopsits\",\"permission\":\"\",\"icon\":\"fa fa-file-o\",\"id\":\"deposits\"},{\"name\":\"Transfers\",\"url\":\"bankingaccounttransfer\",\"permission\":\"\",\"icon\":\"fa fa-file-o\",\"id\":\"transfers\"},{\"name\":\"Reconcile\",\"url\":\"reconcile\",\"permission\":\"\",\"icon\":\"fa fa-file-o\",\"id\":\"reconcile\"}]},{\"name\":\"Setup\",\"url\":\"financial\",\"permission\":\"\",\"icon\":\"fa fa-cogs\",\"id\":\"financial-setup\",\"children\":[{\"name\":\"Banks\",\"url\":\"banks\",\"permission\":\"\",\"icon\":\"fa fa-institution\",\"id\":\"bank\"},{\"name\":\"Bank Branches\",\"url\":\"bankbranches\",\"permission\":\"\",\"icon\":\"fa fa-institution\",\"id\":\"bankbranches\"},{\"name\":\"Account Groups\",\"url\":\"subgroups\",\"permission\":\"\",\"icon\":\"\",\"id\":\"subgroup\"},{\"name\":\"Voucher Types\",\"url\":\"vouchers\\/vouchertypes\",\"permission\":\"\",\"icon\":\"\",\"id\":\"vouchertypes\"},{\"name\":\"Period\",\"url\":\"periods\",\"permission\":\"\",\"icon\":\"\",\"id\":\"Period\"},{\"name\":\"acs_sales_taxes_submenu\",\"url\":\"taxes\",\"permission\":\"\",\"icon\":\"\",\"id\":\"taxes\"},{\"name\":\"acs_sales_currencies_submenu\",\"url\":\"currencies\",\"permission\":\"\",\"icon\":\"\",\"id\":\"currencies\"},{\"name\":\"acs_sales_payment_modes_submenu\",\"url\":\"paymentmodes\",\"permission\":\"\",\"icon\":\"\",\"id\":\"payment-modes\"}]}]},{\"name\":\"HRM\",\"url\":\"#\",\"permission\":\"\",\"icon\":\"fa fa-money\",\"id\":\"financial\",\"children\":[{\"name\":\"Employees\",\"url\":\"employee\",\"permission\":\"\",\"icon\":\"fa-newspaper-o\",\"id\":\"ledgers\"},{\"name\":\"Payroll\",\"url\":\"payroll\",\"permission\":\"\",\"icon\":\"fa-newspaper-o\",\"id\":\"vouchers\"},{\"name\":\"Setup\",\"url\":\"financial\",\"permission\":\"\",\"icon\":\"fa fa-cogs\",\"id\":\"financial-setup\",\"children\":[{\"name\":\"Holidays\",\"url\":\"holidays\",\"permission\":\"\",\"icon\":\"\",\"id\":\"bank\"},{\"name\":\"Race\",\"url\":\"race\",\"permission\":\"\",\"icon\":\"\",\"id\":\"bankbranches\"},{\"name\":\"Nationality\",\"url\":\"nationality\",\"permission\":\"\",\"icon\":\"\",\"id\":\"subgroup\"},{\"name\":\"Salaries\",\"url\":\"salary\",\"permission\":\"\",\"icon\":\"\",\"id\":\"vouchertypes\"},{\"name\":\"Institutions\",\"url\":\"institutions\",\"permission\":\"\",\"icon\":\"\",\"id\":\"Period\"},{\"name\":\"Grades\",\"url\":\"grades\",\"permission\":\"\",\"icon\":\"\",\"id\":\"taxes\"}]}]},{\"name\":\"als_reports\",\"url\":\"#\",\"permission\":\"watchReports\",\"icon\":\"fa fa-area-chart\",\"id\":\"reports\",\"children\":[{\"name\":\"Sales\",\"url\":\"reports\\/sales\",\"permission\":\"\",\"icon\":\"fa fa-balance-scale\",\"id\":\"reports-sales\",\"children\":[{\"name\":\"Customer Accounts\",\"url\":\"reports\\/ageing\",\"permission\":\"\",\"icon\":\"fa fa-file-text-o\",\"id\":\"accounts\"},{\"name\":\"Customer Statement\",\"url\":\"reports\\/statement\",\"permission\":\"\",\"icon\":\"fa fa-file-text-o\",\"id\":\"statement\"}]},{\"name\":\"Purchasing\",\"url\":\"reports\\/purchasing\",\"permission\":\"\",\"icon\":\"fa fa-heartbeat\",\"id\":\"reports-purchasing\"},{\"name\":\"Inventory\",\"url\":\"reports\\/inventory\",\"permission\":\"\",\"icon\":\"fa fa-heartbeat\",\"id\":\"reports-inventory\"},{\"name\":\"Financials\",\"url\":\"reports\\/financials\",\"permission\":\"\",\"icon\":\"fa fa-money\",\"id\":\"reports-financials\",\"children\":[{\"name\":\"Trial Balance\",\"url\":\"reports\\/trial_balance\",\"permission\":\"\",\"icon\":\"\",\"id\":\"trial-balance\"},{\"name\":\"Balance Sheet\",\"url\":\"reports\\/balancesheet\",\"permission\":\"\",\"icon\":\"\",\"id\":\"balance-sheet\"},{\"name\":\"Profit And Loss\",\"url\":\"reports\\/profitlossaccount\",\"permission\":\"\",\"icon\":\"\",\"id\":\"profit-and-loss\"}]}]}]}'),
(225, 'receipt_startnumber', '7'),
(226, 'next_receipt', '8'),
(227, 'receipt_prefix', 'RCV'),
(228, 'receipt_separator', '-'),
(229, 'show_in_cart', '0'),
(230, 'cpanel_host', 'alpha.redplanethost.com'),
(231, 'cpanel_username', 'alphadpanetho'),
(232, 'cpanel_password', 'awF8o$H$oGKUeRhgW#'),
(233, 'cpanel_port', '2082'),
(234, 'default_currency', '$'),
(235, 'default_currency_title', 'USD'),
(236, 'google_api_key', 'AIzaSyDm8j8AlOSiRYXmPnFAPd-DcDQraO2azgQ');

CREATE TABLE `tblorderactivity` (
  `id` int(11) NOT NULL,
  `orderid` int(11) NOT NULL,
  `description` text NOT NULL,
  `staffid` varchar(11) DEFAULT NULL,
  `date` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblorderitems` (
  `id` int(11) NOT NULL,
  `orderid` int(11) NOT NULL,
  `qty` int(11) NOT NULL,
  `sku` varchar(50) NOT NULL,
  `description` mediumtext NOT NULL,
  `long_description` text,
  `rate` decimal(11,2) NOT NULL,
  `taxid` int(11) DEFAULT NULL,
  `disc` decimal(7,2) NOT NULL,
  `item_order` int(11) DEFAULT NULL,
  `itemorder_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblorders` (
  `id` int(11) NOT NULL,
  `sent` tinyint(1) NOT NULL DEFAULT '0',
  `datesend` datetime DEFAULT NULL,
  `clientid` int(11) NOT NULL,
  `number` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `datecreated` datetime NOT NULL,
  `date` date NOT NULL,
  `expirydate` date DEFAULT NULL,
  `currency` varchar(20) NOT NULL,
  `subtotal` decimal(20,2) NOT NULL,
  `total` decimal(20,2) NOT NULL,
  `vatpaid` decimal(20,2) NOT NULL,
  `adjustment` decimal(20,2) DEFAULT NULL,
  `addedfrom` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `clientnote` text,
  `adminnote` text,
  `discount_percent` int(11) DEFAULT NULL,
  `discount_total` int(11) DEFAULT NULL,
  `discount_type` varchar(30) DEFAULT NULL,
  `invoiceid` int(11) DEFAULT NULL,
  `invoiced_date` datetime DEFAULT NULL,
  `terms` text,
  `reference_no` varchar(100) DEFAULT NULL,
  `sale_agent` int(11) NOT NULL DEFAULT '0',
  `payment_term` int(11) NOT NULL,
  `hash` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblpaidbills` (
  `id` int(11) NOT NULL,
  `number` int(11) NOT NULL,
  `bill_date` date NOT NULL,
  `billamount` decimal(20,2) NOT NULL,
  `type` varchar(20) NOT NULL,
  `supplierid` int(11) NOT NULL,
  `note` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `tblperiod` (
  `id` int(11) NOT NULL,
  `fromdate` date NOT NULL,
  `todate` date NOT NULL,
  `description` text NOT NULL,
  `status` varchar(50) NOT NULL,
  `module` varchar(250) NOT NULL,
  `access` varchar(15) NOT NULL,
  `note` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `tblperiod` (`id`, `fromdate`, `todate`, `description`, `status`, `module`, `access`, `note`) VALUES
(21, '2017-01-01', '2017-12-31', 'Financial Year ( Jan - Dec ) 2017', 'Open', '', '', ''),
(24, '2018-01-01', '2018-12-31', 'Financial Year ( Jan - Dec ) 2018', 'On Hold', '', '', '');

CREATE TABLE `tblperiodmodules` (
  `id` int(11) NOT NULL,
  `periodid` int(11) NOT NULL,
  `module` int(11) NOT NULL,
  `access` int(11) NOT NULL,
  `note` text NOT NULL,
  `item_order` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `tblperiodmodules` (`id`, `periodid`, `module`, `access`, `note`, `item_order`) VALUES
(1, 3, 3, 2, 'dfsdfsdf', 0),
(2, 3, 4, 1, 'fghfgfg', 0);

CREATE TABLE `tblpermissions` (
  `permissionid` int(11) NOT NULL,
  `name` mediumtext NOT NULL,
  `shortname` mediumtext NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `tblpermissions` (`permissionid`, `name`, `shortname`) VALUES
(1, 'Manage Contracts', 'manageContracts'),
(2, 'Manage Tasks', 'manageTasks'),
(3, 'Watch Reports', 'watchReports'),
(4, 'Edit Settings', 'editSettings'),
(5, 'Manage Mail Lists', 'manageMailLists'),
(6, 'Manage Surveys', 'manageSurveys'),
(7, 'Manage Staff', 'manageStaff'),
(8, 'Manage Clients', 'manageClients'),
(9, 'Edit Email Templates', 'editEmailTemplates'),
(10, 'Manage Roles', 'manageRoles'),
(11, 'Manage Departments', 'manageDepartments'),
(12, 'Manage Knowledge base', 'manageKnowledgeBase'),
(13, 'Manage Sales', 'manageSales'),
(14, 'Translate', 'isTranslator'),
(15, 'Manage Goals', 'manageGoals'),
(16, 'Manage Expenses', 'manageExpenses'),
(17, 'Use Bulk PDF Exporter', 'useBulkPdfExporter'),
(18, 'Manage Orders', 'manageOrders');

CREATE TABLE `tblposition` (
  `id` int(11) NOT NULL,
  `description` varchar(100) NOT NULL,
  `is_active` int(11) NOT NULL,
  `sort_order` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `tblposition` (`id`, `description`, `is_active`, `sort_order`) VALUES
(1, 'Sales Manager', 1, 1),
(2, 'Financial Controller', 0, 2),
(3, 'Service Manager', 1, 2),
(4, 'Accountant', 1, 2),
(5, 'Technician', 1, 3),
(6, 'Sales Representative', 1, 21),
(7, 'Warehouse Manager', 1, 0),
(8, 'Personal Secretary', 1, 0),
(9, 'Secretary', 0, 0),
(10, 'position111', 0, 10),
(11, 'Account Manager', 1, 0),
(12, 'System Administrator', 1, 0),
(13, 'Technical Support Manager', 1, 0);

CREATE TABLE `tblpostattachments` (
  `id` int(11) NOT NULL,
  `filename` mediumtext NOT NULL,
  `postid` int(11) NOT NULL,
  `filetype` varchar(20) DEFAULT NULL,
  `datecreated` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

CREATE TABLE `tblpostcomments` (
  `id` int(11) NOT NULL,
  `content` text,
  `userid` int(11) NOT NULL,
  `postid` int(11) NOT NULL,
  `dateadded` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblpostlikes` (
  `id` int(11) NOT NULL,
  `postid` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  `dateliked` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblposts` (
  `postid` int(11) NOT NULL,
  `creator` int(11) NOT NULL,
  `datecreated` datetime NOT NULL,
  `visibility` varchar(100) NOT NULL,
  `content` text NOT NULL,
  `pinned` int(11) NOT NULL,
  `datepinned` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblpredifinedreplies` (
  `id` int(11) NOT NULL,
  `name` varchar(300) NOT NULL,
  `message` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblpriorities` (
  `priorityid` int(11) NOT NULL,
  `name` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `tblpriorities` (`priorityid`, `name`) VALUES
(1, 'Low'),
(2, 'Medium'),
(3, 'High'),
(4, 'Emergency');

CREATE TABLE `tblproposalcomments` (
  `id` int(11) NOT NULL,
  `content` mediumtext,
  `proposalid` int(11) NOT NULL,
  `staffid` int(11) NOT NULL,
  `dateadded` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblproposals` (
  `id` int(11) NOT NULL,
  `subject` varchar(500) DEFAULT NULL,
  `content` longtext,
  `addedfrom` int(11) NOT NULL,
  `datecreated` datetime NOT NULL,
  `total` decimal(11,2) DEFAULT NULL,
  `currency` int(11) NOT NULL,
  `open_till` date DEFAULT NULL,
  `date` date NOT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(40) DEFAULT NULL,
  `assigned` int(11) DEFAULT NULL,
  `hash` varchar(32) NOT NULL,
  `proposal_to` varchar(600) DEFAULT NULL,
  `address` varchar(200) DEFAULT NULL,
  `email` varchar(150) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `country` int(11) NOT NULL,
  `city` varchar(200) NOT NULL,
  `state` varchar(200) NOT NULL,
  `zip` varchar(100) NOT NULL,
  `allow_comments` tinyint(1) NOT NULL DEFAULT '1',
  `status` int(11) NOT NULL,
  `quote_id` int(11) DEFAULT NULL,
  `invoice_id` int(11) DEFAULT NULL,
  `date_converted` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblpurchaseorderactivity` (
  `id` int(11) NOT NULL,
  `orderid` int(11) NOT NULL,
  `description` text NOT NULL,
  `staffid` varchar(11) DEFAULT NULL,
  `date` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblpurchaseorderitems` (
  `id` int(11) NOT NULL,
  `orderid` int(11) NOT NULL,
  `qty` int(11) NOT NULL,
  `sku` varchar(50) NOT NULL,
  `description` mediumtext NOT NULL,
  `long_description` text,
  `rate` decimal(11,2) NOT NULL,
  `taxid` int(11) DEFAULT NULL,
  `disc` decimal(7,2) NOT NULL,
  `item_order` int(11) DEFAULT NULL,
  `itemorder_id` int(11) NOT NULL,
  `oursku` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblpurchaseorders` (
  `id` int(11) NOT NULL,
  `rfq_id` int(11) NOT NULL,
  `sent` tinyint(1) NOT NULL DEFAULT '0',
  `datesend` datetime DEFAULT NULL,
  `supplierid` int(11) NOT NULL,
  `number` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `datecreated` datetime NOT NULL,
  `podate` date NOT NULL,
  `expecteddate` date DEFAULT NULL,
  `currency` varchar(20) NOT NULL,
  `subtotal` decimal(20,2) NOT NULL,
  `total` decimal(20,2) NOT NULL,
  `vatpaid` decimal(20,2) NOT NULL,
  `adjustment` decimal(20,2) DEFAULT NULL,
  `addedfrom` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `clientnote` text,
  `adminnote` text,
  `discount_percent` int(11) DEFAULT NULL,
  `discount_total` decimal(20,2) DEFAULT NULL,
  `discount_type` varchar(30) DEFAULT NULL,
  `invoiceid` int(11) DEFAULT NULL,
  `invoiced_date` datetime DEFAULT NULL,
  `terms` text,
  `reference_no` varchar(100) DEFAULT NULL,
  `contact` int(11) NOT NULL,
  `payment_term` int(11) NOT NULL,
  `hash` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblrace` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `tblrace` (`id`, `name`) VALUES
(2, 'Black'),
(3, 'Indian'),
(4, 'Caucasian'),
(5, 'Asian'),
(6, 'Hispanic');

CREATE TABLE `tblreconcilations` (
  `id` int(11) NOT NULL,
  `bank_id` int(11) NOT NULL,
  `branch_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `startbalance` float NOT NULL,
  `endbalance` float NOT NULL,
  `servicecharge` float NOT NULL,
  `interestreceived` float NOT NULL,
  `note` varchar(255) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tblreminders` (
  `id` int(11) NOT NULL,
  `description` text,
  `date` date NOT NULL,
  `isnotified` int(11) NOT NULL DEFAULT '0',
  `rel_id` int(11) NOT NULL,
  `rel_type` varchar(40) NOT NULL,
  `staff` int(11) NOT NULL,
  `notify_by_email` int(11) NOT NULL DEFAULT '1',
  `creator` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblrfqsqouteactivity` (
  `id` int(11) NOT NULL,
  `orderid` int(11) NOT NULL,
  `description` text NOT NULL,
  `staffid` varchar(11) DEFAULT NULL,
  `date` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblrfqsqouteitems` (
  `id` int(11) NOT NULL,
  `orderid` int(11) NOT NULL,
  `qty` int(11) NOT NULL,
  `suppliersku` varchar(50) NOT NULL,
  `description` mediumtext NOT NULL,
  `long_description` text,
  `oursku` varchar(250) NOT NULL,
  `manufacture` varchar(250) DEFAULT NULL,
  `item_order` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblrfqsqoutes` (
  `id` int(11) NOT NULL,
  `sent` tinyint(1) NOT NULL DEFAULT '0',
  `datesend` datetime DEFAULT NULL,
  `number` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `datecreated` datetime NOT NULL,
  `requisitiondate` date NOT NULL,
  `addedfrom` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `clientnote` text,
  `adminnote` text,
  `invoiceid` int(11) DEFAULT NULL,
  `invoiced_date` datetime DEFAULT NULL,
  `terms` text,
  `reference_no` varchar(100) DEFAULT NULL,
  `contact` int(11) NOT NULL,
  `payment_term` int(11) NOT NULL,
  `hash` text NOT NULL,
  `requiredby` date DEFAULT NULL,
  `warehouse` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblrolepermissions` (
  `rolepermissionid` int(11) NOT NULL,
  `roleid` int(11) NOT NULL,
  `permissionid` varchar(250) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `tblrolepermissions` (`rolepermissionid`, `roleid`, `permissionid`) VALUES
(31, 1, 'sales'),
(32, 1, 'customers'),
(33, 1, 'child-invoices'),
(34, 1, 'child-orders'),
(35, 1, 'child-quotes'),
(36, 1, 'child-proposals'),
(37, 1, 'contracts'),
(38, 1, 'child-payments'),
(39, 1, 'purchasing'),
(40, 1, 'Suppliers'),
(41, 1, 'grn'),
(42, 1, 'PurchaseOrder'),
(43, 1, 'rfq'),
(44, 1, 'inventory'),
(45, 1, 'child-items'),
(47, 6, 'sales'),
(134, 7, 'inventory'),
(138, 7, 'child-items'),
(139, 7, 'financial'),
(140, 7, 'ledgers_add'),
(141, 7, 'ledgers_edit'),
(142, 7, 'ledgers_delete'),
(143, 7, 'ledgers'),
(144, 7, 'vouchers_add'),
(145, 7, 'vouchers_edit'),
(146, 7, 'vouchers_delete'),
(147, 7, 'vouchers'),
(148, 7, 'bills_add'),
(149, 7, 'bills_edit'),
(150, 7, 'bills_delete'),
(151, 7, 'bills'),
(152, 7, 'writecheck_add'),
(153, 7, 'writecheck_edit'),
(154, 7, 'writecheck_delete'),
(155, 7, 'writecheck'),
(165, 7, 'reports'),
(166, 7, 'accounts_add'),
(167, 7, 'accounts_edit'),
(168, 7, 'accounts_delete'),
(169, 7, 'accounts'),
(170, 7, 'statement_add'),
(171, 7, 'statement_edit'),
(172, 7, 'statement_delete'),
(173, 7, 'statement'),
(177, 7, 'reports'),
(189, 6, 'child-invoices'),
(196, 7, 'sales'),
(198, 7, 'child-invoices'),
(199, 7, 'child-quotes'),
(203, 7, 'reports-financials'),
(204, 7, 'customers'),
(205, 7, 'child-orders'),
(206, 7, 'banking'),
(207, 7, 'bankaccounts'),
(208, 7, 'accountregister'),
(209, 7, 'deposits'),
(210, 7, 'transfers'),
(211, 7, 'reconcile'),
(216, 6, 'inventory'),
(218, 6, 'child-items'),
(219, 6, 'warehouse_edit'),
(220, 6, 'warehouse'),
(221, 6, 'child-items_add'),
(222, 6, 'reports'),
(235, 6, 'customers'),
(238, 6, 'child-invoices_add'),
(239, 6, 'child-invoices_edit'),
(245, 1, 'reports'),
(246, 1, 'reports-sales'),
(247, 1, 'reports-financials'),
(248, 1, 'reports_add'),
(249, 1, 'reports_edit'),
(250, 1, 'reports_delete'),
(253, 6, 'contracts'),
(258, 6, 'child-orders_add'),
(259, 6, 'child-orders_edit'),
(260, 6, 'child-orders'),
(283, 6, 'crm'),
(284, 6, 'leads_add'),
(285, 6, 'leads_edit'),
(286, 6, 'leads'),
(287, 6, 'tasks_add'),
(288, 6, 'tasks_edit'),
(289, 6, 'tasks'),
(290, 6, 'customers_add'),
(302, 6, 'warehouse_add'),
(304, 6, 'customers_edit'),
(306, 6, 'reports-sales'),
(307, 6, 'accounts'),
(308, 6, 'statement'),
(309, 6, 'accounts_add'),
(310, 6, 'accounts_edit'),
(311, 6, 'statement_add'),
(312, 6, 'statement_edit'),
(315, 6, 'customerprofile'),
(316, 7, 'customers_add'),
(317, 7, 'customers_edit'),
(318, 7, 'customers_delete'),
(319, 7, 'customerprofile_add'),
(320, 7, 'customerprofile_edit'),
(321, 7, 'customerprofile_delete'),
(322, 7, 'customerprofile'),
(323, 7, 'customerproposals_add'),
(324, 7, 'customerproposals_edit'),
(325, 7, 'customerproposals_delete'),
(326, 7, 'customerproposals'),
(327, 7, 'customerinvoice_add'),
(328, 7, 'customerinvoice_edit'),
(329, 7, 'customerinvoice_delete'),
(330, 7, 'customerinvoice'),
(331, 7, 'customerquotes_add'),
(332, 7, 'customerquotes_edit'),
(333, 7, 'customerquotes_delete'),
(334, 7, 'customerquotes'),
(335, 7, 'child-invoices_add'),
(336, 7, 'child-invoices_edit'),
(337, 7, 'child-invoices_delete'),
(338, 7, 'child-invoices-details_add'),
(339, 7, 'child-invoices-details_edit'),
(340, 7, 'child-invoices-details_delete'),
(341, 7, 'child-invoices-details'),
(342, 7, 'child-orders_add'),
(343, 7, 'child-orders_edit'),
(344, 7, 'child-orders_delete'),
(345, 7, 'child-orders-details_add'),
(346, 7, 'child-orders-details_edit'),
(347, 7, 'child-orders-details_delete'),
(348, 7, 'child-orders-details'),
(349, 7, 'child-quotes_add'),
(350, 7, 'child-quotes_edit'),
(351, 7, 'child-quotes_delete'),
(352, 7, 'child-quotes-details_add'),
(353, 7, 'child-quotes-details_edit'),
(354, 7, 'child-quotes-details_delete'),
(355, 7, 'child-quotes-details'),
(356, 7, 'child-proposals_add'),
(357, 7, 'child-proposals_edit'),
(358, 7, 'child-proposals_delete'),
(359, 7, 'child-proposals'),
(360, 7, 'contracts_add'),
(361, 7, 'contracts_edit'),
(362, 7, 'contracts_delete'),
(363, 7, 'contracts'),
(364, 7, 'child-contracts-details_add'),
(365, 7, 'child-contracts-details_edit'),
(366, 7, 'child-contracts-details_delete'),
(367, 7, 'child-contracts-details'),
(368, 7, 'child-payments_add'),
(369, 7, 'child-payments_edit'),
(370, 7, 'child-payments_delete'),
(371, 7, 'child-payments'),
(372, 7, 'setup'),
(373, 7, 'class_add'),
(374, 7, 'class_edit'),
(375, 7, 'class_delete'),
(376, 7, 'class'),
(377, 7, 'contract-types_add'),
(378, 7, 'contract-types_edit'),
(379, 7, 'contract-types_delete'),
(380, 7, 'contract-types'),
(381, 7, 'discounts_add'),
(382, 7, 'discounts_edit'),
(383, 7, 'discounts_delete'),
(384, 7, 'discounts'),
(385, 7, 'purchasing'),
(386, 7, 'Suppliers_add'),
(387, 7, 'Suppliers_edit'),
(388, 7, 'Suppliers_delete'),
(389, 7, 'Suppliers'),
(390, 7, 'grn_add'),
(391, 7, 'grn_edit'),
(392, 7, 'grn_delete'),
(393, 7, 'grn'),
(394, 7, 'PurchaseOrder_add'),
(395, 7, 'PurchaseOrder_edit'),
(396, 7, 'PurchaseOrder_delete'),
(397, 7, 'PurchaseOrder'),
(398, 7, 'rfq_add'),
(399, 7, 'rfq_edit'),
(400, 7, 'rfq_delete'),
(401, 7, 'rfq'),
(402, 7, 'purchasing-setup'),
(403, 7, 'test_add'),
(404, 7, 'test_edit'),
(405, 7, 'test_delete'),
(406, 7, 'test'),
(407, 7, 'child-items_add'),
(408, 7, 'child-items_edit'),
(409, 7, 'child-items_delete'),
(410, 7, 'warehouse_add'),
(411, 7, 'warehouse_edit'),
(412, 7, 'warehouse_delete'),
(413, 7, 'warehouse'),
(414, 7, 'inventory-setup'),
(415, 7, 'category_add'),
(416, 7, 'category_edit'),
(417, 7, 'category_delete'),
(418, 7, 'category'),
(419, 7, 'subcategory_add'),
(420, 7, 'subcategory_edit'),
(421, 7, 'subcategory_delete'),
(422, 7, 'subcategory'),
(423, 7, 'bins_add'),
(424, 7, 'bins_edit'),
(425, 7, 'bins_delete'),
(426, 7, 'bins'),
(427, 7, 'locations_add'),
(428, 7, 'locations_edit'),
(429, 7, 'locations_delete'),
(430, 7, 'locations'),
(431, 7, 'item_departments_add'),
(432, 7, 'item_departments_edit'),
(433, 7, 'item_departments_delete'),
(434, 7, 'item_departments'),
(435, 7, 'manufacturer_add'),
(436, 7, 'manufacturer_edit'),
(437, 7, 'manufacturer_delete'),
(438, 7, 'manufacturer'),
(439, 7, 'UnitOfMeasure_add'),
(440, 7, 'UnitOfMeasure_edit'),
(441, 7, 'UnitOfMeasure_delete'),
(442, 7, 'UnitOfMeasure'),
(443, 7, 'bankaccounts_add'),
(444, 7, 'bankaccounts_edit'),
(445, 7, 'bankaccounts_delete'),
(446, 7, 'accountregister_add'),
(447, 7, 'accountregister_edit'),
(448, 7, 'accountregister_delete'),
(449, 7, 'deposits_add'),
(450, 7, 'deposits_edit'),
(451, 7, 'deposits_delete'),
(452, 7, 'transfers_add'),
(453, 7, 'transfers_edit'),
(454, 7, 'transfers_delete'),
(455, 7, 'reconcile_add'),
(456, 7, 'reconcile_edit'),
(457, 7, 'reconcile_delete'),
(458, 7, 'financial-setup'),
(459, 7, 'bank_add'),
(460, 7, 'bank_edit'),
(461, 7, 'bank_delete'),
(462, 7, 'bank'),
(463, 7, 'bankbranches_add'),
(464, 7, 'bankbranches_edit'),
(465, 7, 'bankbranches_delete'),
(466, 7, 'bankbranches'),
(467, 7, 'subgroup_add'),
(468, 7, 'subgroup_edit'),
(469, 7, 'subgroup_delete'),
(470, 7, 'subgroup'),
(471, 7, 'vouchertypes_add'),
(472, 7, 'vouchertypes_edit'),
(473, 7, 'vouchertypes_delete'),
(474, 7, 'vouchertypes'),
(475, 7, 'Period_add'),
(476, 7, 'Period_edit'),
(477, 7, 'Period_delete'),
(478, 7, 'Period'),
(479, 7, 'taxes_add'),
(480, 7, 'taxes_edit'),
(481, 7, 'taxes_delete'),
(482, 7, 'taxes'),
(483, 7, 'currencies_add'),
(484, 7, 'currencies_edit'),
(485, 7, 'currencies_delete'),
(486, 7, 'currencies'),
(487, 7, 'payment-modes_add'),
(488, 7, 'payment-modes_edit'),
(489, 7, 'payment-modes_delete'),
(490, 7, 'payment-modes'),
(491, 7, 'reports-sales'),
(492, 7, 'reports-purchasing_add'),
(493, 7, 'reports-purchasing_edit'),
(494, 7, 'reports-purchasing_delete'),
(495, 7, 'reports-purchasing'),
(496, 7, 'reports-inventory_add'),
(497, 7, 'reports-inventory_edit'),
(498, 7, 'reports-inventory_delete'),
(499, 7, 'reports-inventory'),
(500, 7, 'trial-balance_add'),
(501, 7, 'trial-balance_edit'),
(502, 7, 'trial-balance_delete'),
(503, 7, 'trial-balance'),
(504, 7, 'balance-sheet_add'),
(505, 7, 'balance-sheet_edit'),
(506, 7, 'balance-sheet_delete'),
(507, 7, 'balance-sheet'),
(508, 7, 'profit-and-loss_add'),
(509, 7, 'profit-and-loss_edit'),
(510, 7, 'profit-and-loss_delete'),
(511, 7, 'profit-and-loss'),
(512, 7, 'dashboard-details_add'),
(513, 7, 'dashboard-details_edit'),
(514, 7, 'dashboard-details_delete'),
(515, 7, 'dashboard-details'),
(516, 7, 'child-calendar'),
(517, 6, 'purchasing'),
(518, 6, 'grn_add'),
(520, 6, 'grn_delete'),
(521, 6, 'grn'),
(522, 6, 'purchasing-setup'),
(523, 6, 'test_add'),
(524, 6, 'test_edit'),
(525, 6, 'test_delete'),
(526, 6, 'test'),
(527, 6, 'PurchaseOrder_add'),
(530, 6, 'PurchaseOrder'),
(531, 6, 'rfq_add'),
(532, 6, 'rfq_edit'),
(533, 6, 'rfq_delete'),
(534, 6, 'rfq'),
(535, 10, 'dashboard-details_add'),
(536, 10, 'dashboard-details_edit'),
(537, 10, 'dashboard-details_delete'),
(538, 10, 'dashboard-details'),
(539, 10, 'child-calendar'),
(540, 10, 'crm'),
(541, 10, 'leads_add'),
(542, 10, 'leads_edit'),
(543, 10, 'leads_delete'),
(544, 10, 'leads'),
(545, 10, 'child-media_add'),
(546, 10, 'child-media_edit'),
(547, 10, 'child-media_delete'),
(548, 10, 'child-media'),
(549, 10, 'tasks_add'),
(550, 10, 'tasks_edit'),
(551, 10, 'tasks_delete'),
(552, 10, 'tasks'),
(553, 10, 'event_add'),
(554, 10, 'event_edit'),
(555, 10, 'event_delete'),
(556, 10, 'event'),
(557, 10, 'campaign_add'),
(558, 10, 'campaign_edit'),
(559, 10, 'campaign_delete'),
(560, 10, 'campaign'),
(561, 10, 'opportunity_add'),
(562, 10, 'opportunity_edit'),
(563, 10, 'opportunity_delete'),
(564, 10, 'opportunity'),
(565, 10, 'sales'),
(566, 10, 'customers'),
(567, 10, 'customers_add'),
(568, 10, 'customers_edit'),
(569, 10, 'customers_delete'),
(570, 10, 'customers'),
(571, 10, 'customerprofile_add'),
(572, 10, 'customerprofile_edit'),
(573, 10, 'customerprofile_delete'),
(574, 10, 'customerprofile'),
(575, 10, 'customerproposals_add'),
(576, 10, 'customerproposals_edit'),
(577, 10, 'customerproposals_delete'),
(578, 10, 'customerproposals'),
(579, 10, 'customerinvoice_add'),
(580, 10, 'customerinvoice_edit'),
(581, 10, 'customerinvoice_delete'),
(582, 10, 'customerinvoice'),
(583, 10, 'customerquotes_add'),
(584, 10, 'customerquotes_edit'),
(585, 10, 'customerquotes_delete'),
(586, 10, 'customerquotes'),
(587, 10, 'child-invoices_add'),
(588, 10, 'child-invoices_edit'),
(589, 10, 'child-invoices_delete'),
(590, 10, 'child-invoices'),
(591, 10, 'child-invoices-details_add'),
(592, 10, 'child-invoices-details_edit'),
(593, 10, 'child-invoices-details_delete'),
(594, 10, 'child-invoices-details'),
(595, 10, 'child-orders_add'),
(596, 10, 'child-orders_edit'),
(597, 10, 'child-orders_delete'),
(598, 10, 'child-orders'),
(599, 10, 'child-orders-details_edit'),
(600, 10, 'child-orders-details'),
(601, 10, 'child-quotes_edit'),
(602, 10, 'child-quotes'),
(603, 10, 'child-quotes-details_edit'),
(604, 10, 'child-quotes-details'),
(605, 10, 'child-proposals'),
(606, 10, 'contracts_edit'),
(607, 10, 'contracts'),
(608, 10, 'child-contracts-details_edit'),
(609, 10, 'child-contracts-details'),
(610, 10, 'child-payments_edit'),
(611, 10, 'child-payments'),
(612, 10, 'setup'),
(613, 10, 'class_add'),
(614, 10, 'class_edit'),
(615, 10, 'class_delete'),
(616, 10, 'class'),
(617, 10, 'contract-types_add'),
(618, 10, 'contract-types_edit'),
(619, 10, 'contract-types_delete'),
(620, 10, 'contract-types'),
(621, 10, 'discounts_add'),
(622, 10, 'discounts_edit'),
(623, 10, 'discounts_delete'),
(624, 10, 'discounts'),
(625, 10, 'purchasing'),
(626, 10, 'Suppliers_add'),
(627, 10, 'Suppliers_edit'),
(628, 10, 'Suppliers_delete'),
(629, 10, 'Suppliers'),
(630, 10, 'grn_add'),
(631, 10, 'grn_edit'),
(632, 10, 'grn_delete'),
(633, 10, 'grn'),
(634, 10, 'PurchaseOrder_add'),
(635, 10, 'PurchaseOrder_edit'),
(636, 10, 'PurchaseOrder_delete'),
(637, 10, 'PurchaseOrder'),
(638, 10, 'rfq_add'),
(639, 10, 'rfq_edit'),
(640, 10, 'rfq_delete'),
(641, 10, 'rfq'),
(642, 10, 'purchasing-setup'),
(643, 10, 'test_add'),
(644, 10, 'test_edit'),
(645, 10, 'test_delete'),
(646, 10, 'test'),
(647, 10, 'inventory'),
(648, 10, 'child-items_add'),
(649, 10, 'child-items_edit'),
(650, 10, 'child-items_delete'),
(651, 10, 'child-items'),
(652, 10, 'warehouse_add'),
(653, 10, 'warehouse_edit'),
(654, 10, 'warehouse_delete'),
(655, 10, 'warehouse'),
(656, 10, 'child-items_add'),
(657, 10, 'child-items_edit'),
(658, 10, 'child-items_delete'),
(659, 10, 'child-items'),
(660, 10, 'child-items_add'),
(661, 10, 'child-items_edit'),
(662, 10, 'child-items_delete'),
(663, 10, 'child-items'),
(664, 10, 'child-items_add'),
(665, 10, 'child-items_edit'),
(666, 10, 'child-items_delete'),
(667, 10, 'child-items'),
(668, 10, 'inventory-setup'),
(669, 10, 'category_add'),
(670, 10, 'category_edit'),
(671, 10, 'category_delete'),
(672, 10, 'category'),
(673, 10, 'subcategory_add'),
(674, 10, 'subcategory_edit'),
(675, 10, 'subcategory_delete'),
(676, 10, 'subcategory'),
(677, 10, 'bins_add'),
(678, 10, 'bins_edit'),
(679, 10, 'bins_delete'),
(680, 10, 'bins'),
(681, 10, 'locations_add'),
(682, 10, 'locations_edit'),
(683, 10, 'locations_delete'),
(684, 10, 'locations'),
(685, 10, 'item_departments_add'),
(686, 10, 'item_departments_edit'),
(687, 10, 'item_departments_delete'),
(688, 10, 'item_departments'),
(689, 10, 'manufacturer_add'),
(690, 10, 'manufacturer_edit'),
(691, 10, 'manufacturer_delete'),
(692, 10, 'manufacturer'),
(693, 10, 'UnitOfMeasure_add'),
(694, 10, 'UnitOfMeasure_edit'),
(695, 10, 'UnitOfMeasure_delete'),
(696, 10, 'UnitOfMeasure'),
(697, 10, 'financial'),
(698, 10, 'ledgers_add'),
(699, 10, 'ledgers_edit'),
(700, 10, 'ledgers_delete'),
(701, 10, 'ledgers'),
(702, 10, 'vouchers_add'),
(703, 10, 'vouchers_edit'),
(704, 10, 'vouchers_delete'),
(705, 10, 'vouchers'),
(706, 10, 'bills_add'),
(707, 10, 'bills_edit'),
(708, 10, 'bills_delete'),
(709, 10, 'bills'),
(710, 10, 'writecheck_add'),
(711, 10, 'writecheck_edit'),
(712, 10, 'writecheck_delete'),
(713, 10, 'writecheck'),
(714, 10, 'banking'),
(715, 10, 'bankaccounts_add'),
(716, 10, 'bankaccounts_edit'),
(717, 10, 'bankaccounts_delete'),
(718, 10, 'bankaccounts'),
(719, 10, 'accountregister_add'),
(720, 10, 'accountregister_edit'),
(721, 10, 'accountregister_delete'),
(722, 10, 'accountregister'),
(723, 10, 'deposits_add'),
(724, 10, 'deposits_edit'),
(725, 10, 'deposits_delete'),
(726, 10, 'deposits'),
(727, 10, 'transfers_add'),
(728, 10, 'transfers_edit'),
(729, 10, 'transfers_delete'),
(730, 10, 'transfers'),
(731, 10, 'reconcile_add'),
(732, 10, 'reconcile_edit'),
(733, 10, 'reconcile_delete'),
(734, 10, 'reconcile'),
(735, 10, 'financial-setup'),
(736, 10, 'bank_add'),
(737, 10, 'bank_edit'),
(738, 10, 'bank_delete'),
(739, 10, 'bank'),
(740, 10, 'bankbranches_add'),
(741, 10, 'bankbranches_edit'),
(742, 10, 'bankbranches_delete'),
(743, 10, 'bankbranches'),
(744, 10, 'subgroup_add'),
(745, 10, 'subgroup_edit'),
(746, 10, 'subgroup_delete'),
(747, 10, 'subgroup'),
(748, 10, 'vouchertypes_add'),
(749, 10, 'vouchertypes_edit'),
(750, 10, 'vouchertypes_delete'),
(751, 10, 'vouchertypes'),
(752, 10, 'Period_add'),
(753, 10, 'Period_edit'),
(754, 10, 'Period_delete'),
(755, 10, 'Period'),
(756, 10, 'taxes_add'),
(757, 10, 'taxes_edit'),
(758, 10, 'taxes_delete'),
(759, 10, 'taxes'),
(760, 10, 'currencies_add'),
(761, 10, 'currencies_edit'),
(762, 10, 'currencies_delete'),
(763, 10, 'currencies'),
(764, 10, 'payment-modes_add'),
(765, 10, 'payment-modes_edit'),
(766, 10, 'payment-modes_delete'),
(767, 10, 'payment-modes'),
(768, 10, 'financial'),
(769, 10, 'ledgers_add'),
(770, 10, 'ledgers_edit'),
(771, 10, 'ledgers_delete'),
(772, 10, 'ledgers'),
(773, 10, 'vouchers_add'),
(774, 10, 'vouchers_edit'),
(775, 10, 'vouchers_delete'),
(776, 10, 'vouchers'),
(777, 10, 'financial-setup'),
(778, 10, 'bank_add'),
(779, 10, 'bank_edit'),
(780, 10, 'bank_delete'),
(781, 10, 'bank'),
(782, 10, 'bankbranches_add'),
(783, 10, 'bankbranches_edit'),
(784, 10, 'bankbranches_delete'),
(785, 10, 'bankbranches'),
(786, 10, 'subgroup_add'),
(787, 10, 'subgroup_edit'),
(788, 10, 'subgroup_delete'),
(789, 10, 'subgroup'),
(790, 10, 'vouchertypes_add'),
(791, 10, 'vouchertypes_edit'),
(792, 10, 'vouchertypes_delete'),
(793, 10, 'vouchertypes'),
(794, 10, 'Period_add'),
(795, 10, 'Period_edit'),
(796, 10, 'Period_delete'),
(797, 10, 'Period'),
(798, 10, 'taxes_add'),
(799, 10, 'taxes_edit'),
(800, 10, 'taxes_delete'),
(801, 10, 'taxes'),
(802, 10, 'reports'),
(803, 10, 'reports-sales'),
(804, 10, 'accounts_add'),
(805, 10, 'accounts_edit'),
(806, 10, 'accounts_delete'),
(807, 10, 'accounts'),
(808, 10, 'statement_add'),
(809, 10, 'statement_edit'),
(810, 10, 'statement_delete'),
(811, 10, 'statement'),
(812, 10, 'reports-purchasing_add'),
(813, 10, 'reports-purchasing_edit'),
(814, 10, 'reports-purchasing_delete'),
(815, 10, 'reports-purchasing'),
(816, 10, 'reports-inventory_add'),
(817, 10, 'reports-inventory_edit'),
(818, 10, 'reports-inventory_delete'),
(819, 10, 'reports-inventory'),
(820, 10, 'reports-financials'),
(821, 10, 'trial-balance_add'),
(822, 10, 'trial-balance_edit'),
(823, 10, 'trial-balance_delete'),
(824, 10, 'trial-balance'),
(825, 10, 'balance-sheet_add'),
(826, 10, 'balance-sheet_edit'),
(827, 10, 'balance-sheet_delete'),
(828, 10, 'balance-sheet'),
(829, 10, 'profit-and-loss_add'),
(830, 10, 'profit-and-loss_edit'),
(831, 10, 'profit-and-loss_delete'),
(832, 10, 'profit-and-loss');

CREATE TABLE `tblroles` (
  `roleid` int(11) NOT NULL,
  `name` varchar(150) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblsalutation` (
  `id` int(11) NOT NULL,
  `description` varchar(100) NOT NULL,
  `is_active` int(11) NOT NULL,
  `sort_order` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `tblservices` (
  `serviceid` int(11) NOT NULL,
  `name` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblstaff` (
  `staffid` int(11) NOT NULL,
  `salutation` int(11) NOT NULL,
  `firstname` varchar(50) NOT NULL,
  `lastname` varchar(50) NOT NULL,
  `username` varchar(255) NOT NULL,
  `country` int(11) NOT NULL,
  `address` text NOT NULL,
  `city` varchar(255) NOT NULL,
  `state` varchar(255) NOT NULL,
  `postal_code` varchar(255) NOT NULL,
  `position` int(11) NOT NULL,
  `facebook` mediumtext,
  `linkedin` mediumtext,
  `phonenumber` varchar(30) DEFAULT NULL,
  `email` varchar(100) NOT NULL,
  `skype` varchar(50) DEFAULT NULL,
  `password` varchar(250) NOT NULL,
  `datecreated` datetime NOT NULL,
  `profile_image` varchar(40) DEFAULT NULL,
  `last_ip` varchar(40) DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `last_password_change` datetime DEFAULT NULL,
  `new_pass_key` varchar(32) DEFAULT NULL,
  `new_pass_key_requested` datetime DEFAULT NULL,
  `admin` int(11) NOT NULL DEFAULT '0',
  `role` int(11) DEFAULT NULL,
  `active` int(11) NOT NULL DEFAULT '1',
  `default_language` varchar(40) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblstaffdepartments` (
  `staffdepartmentid` int(11) NOT NULL,
  `staffid` int(11) NOT NULL,
  `departmentid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblstaffpermissions` (
  `staffpermid` int(11) NOT NULL,
  `permissionid` int(11) NOT NULL,
  `staffid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblstafftaskassignees` (
  `id` int(11) NOT NULL,
  `staffid` int(11) NOT NULL,
  `taskid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblstafftaskcomments` (
  `id` int(11) NOT NULL,
  `content` text NOT NULL,
  `taskid` int(11) NOT NULL,
  `staffid` int(11) NOT NULL,
  `dateadded` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblstafftasks` (
  `id` int(11) NOT NULL,
  `name` mediumtext,
  `description` text,
  `priority` varchar(10) DEFAULT NULL,
  `dateadded` datetime NOT NULL,
  `startdate` date NOT NULL,
  `duedate` date DEFAULT NULL,
  `datefinished` datetime NOT NULL,
  `addedfrom` int(11) NOT NULL,
  `finished` int(11) NOT NULL DEFAULT '0',
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(30) DEFAULT NULL,
  `is_public` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblstafftasksattachments` (
  `id` int(11) NOT NULL,
  `file_name` mediumtext NOT NULL,
  `filetype` varchar(50) DEFAULT NULL,
  `dateadded` datetime NOT NULL,
  `taskid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblstafftasksfollowers` (
  `id` int(11) NOT NULL,
  `staffid` int(11) NOT NULL,
  `taskid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblstatus` (
  `status_id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `tblstatus` (`status_id`, `name`) VALUES
(1, 'Active'),
(2, 'Inactive'),
(3, 'Suspended');

CREATE TABLE `tblsubcategories` (
  `subcategory_id` int(11) NOT NULL,
  `catid` int(11) NOT NULL,
  `subcategory_name` varchar(100) NOT NULL,
  `description` varchar(255) NOT NULL,
  `sales` int(11) NOT NULL,
  `inventory` int(11) NOT NULL,
  `cogs` int(11) NOT NULL,
  `active` tinyint(11) NOT NULL DEFAULT '1',
  `show_in_cart` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `tblsupplieradminnotes` (
  `usernoteid` int(11) NOT NULL,
  `description` text NOT NULL,
  `dateadded` datetime NOT NULL,
  `addedfrom` int(11) NOT NULL,
  `staff` int(11) NOT NULL,
  `userid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblsupplierbill_item` (
  `id` int(11) NOT NULL,
  `bill_id` int(11) NOT NULL,
  `ledger_id` int(11) NOT NULL,
  `description` varchar(255) NOT NULL,
  `amount` decimal(20,2) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tblsuppliercontacts` (
  `id` int(11) NOT NULL,
  `salutation` int(11) NOT NULL,
  `firstname` varchar(50) NOT NULL,
  `lastname` varchar(50) NOT NULL,
  `country` varchar(50) NOT NULL,
  `address` text NOT NULL,
  `city` varchar(50) NOT NULL,
  `state` varchar(50) NOT NULL,
  `zip` text NOT NULL,
  `phoneno` varchar(20) NOT NULL,
  `mobileno` varchar(20) NOT NULL,
  `fax` text NOT NULL,
  `email` text NOT NULL,
  `skypeid` varchar(100) NOT NULL,
  `position` varchar(50) NOT NULL,
  `status` varchar(50) NOT NULL,
  `userid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `tblsuppliergroups_in` (
  `id` int(11) NOT NULL,
  `groupid` int(11) NOT NULL,
  `supplier_id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `tblsuppliergroups_in` (`id`, `groupid`, `supplier_id`) VALUES
(8, 4, 3),
(3, 2, 1),
(24, 2, 4),
(5, 4, 5),
(6, 2, 6),
(35, 12, 7),
(56, 2, 2),
(53, 2, 8),
(14, 2, 9),
(64, 2, 10),
(16, 2, 11),
(17, 2, 12),
(39, 2, 13),
(63, 2, 14),
(29, 13, 15);

CREATE TABLE `tblsuppliers` (
  `userid` int(11) NOT NULL,
  `supplier` varchar(100) NOT NULL,
  `account_number` text NOT NULL,
  `email` varchar(100) NOT NULL,
  `vat_number` varchar(100) DEFAULT NULL,
  `phonenumber` varchar(30) DEFAULT NULL,
  `fax` text NOT NULL,
  `website` varchar(100) NOT NULL,
  `portalwebsite` text NOT NULL,
  `password` varchar(255) NOT NULL,
  `country` int(11) NOT NULL,
  `city` varchar(100) DEFAULT NULL,
  `zip` varchar(15) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `address` varchar(100) DEFAULT NULL,
  `datecreated` datetime NOT NULL,
  `new_pass_key` varchar(32) DEFAULT NULL,
  `ledger` int(11) NOT NULL,
  `active` int(11) NOT NULL,
  `opening_balance` tinyint(1) NOT NULL DEFAULT '0',
  `type_of_balance` tinyint(2) NOT NULL,
  `amount` float NOT NULL,
  `note` text NOT NULL,
  `default_language` varchar(50) NOT NULL,
  `default_currency` int(11) NOT NULL,
  `payment_term` int(11) NOT NULL,
  `credit_limit` decimal(20,2) NOT NULL,
  `account_payable_ledger` int(11) NOT NULL,
  `expense_ledger` int(11) NOT NULL,
  `image` varchar(100) NOT NULL,
  `longitude` varchar(20) NOT NULL,
  `latitude` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblsuppliersgroups` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `discription` text NOT NULL,
  `default_language` varchar(50) NOT NULL,
  `account_payable_ledger` int(11) NOT NULL,
  `expense_ledger` int(11) NOT NULL,
  `payment_term` int(11) NOT NULL,
  `default_currency` varchar(50) NOT NULL,
  `class_is_active` int(11) NOT NULL,
  `creditlimit` float(10,2) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tblsurveyquestionboxes` (
  `boxid` int(11) NOT NULL,
  `boxtype` varchar(10) NOT NULL,
  `questionid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblsurveyquestionboxesdescription` (
  `questionboxdescriptionid` int(11) NOT NULL,
  `description` mediumtext NOT NULL,
  `boxid` mediumtext NOT NULL,
  `questionid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblsurveyquestions` (
  `questionid` int(11) NOT NULL,
  `surveyid` int(11) NOT NULL,
  `question` mediumtext NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `question_order` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblsurveyresults` (
  `resultid` int(11) NOT NULL,
  `boxid` int(11) NOT NULL,
  `boxdescriptionid` int(11) DEFAULT NULL,
  `surveyid` int(11) NOT NULL,
  `questionid` int(11) NOT NULL,
  `answer` text,
  `resultsetid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblsurveyresultsets` (
  `resultsetid` int(11) NOT NULL,
  `surveyid` int(11) NOT NULL,
  `ip` varchar(40) NOT NULL,
  `useragent` varchar(150) NOT NULL,
  `userid` int(11) DEFAULT NULL,
  `date` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblsurveys` (
  `surveyid` int(11) NOT NULL,
  `subject` mediumtext NOT NULL,
  `slug` mediumtext NOT NULL,
  `description` text NOT NULL,
  `viewdescription` text,
  `datecreated` datetime NOT NULL,
  `creator` int(11) NOT NULL,
  `redirect_url` varchar(100) DEFAULT NULL,
  `send` tinyint(1) NOT NULL DEFAULT '0',
  `onlyforloggedin` int(11) DEFAULT '0',
  `fromname` varchar(100) DEFAULT NULL,
  `iprestrict` tinyint(1) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `hash` varchar(32) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblsurveysemailsendcron` (
  `id` int(11) NOT NULL,
  `surveyid` int(11) NOT NULL,
  `email` varchar(100) NOT NULL,
  `emailid` int(11) DEFAULT NULL,
  `listid` varchar(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblsurveysendlog` (
  `id` int(11) NOT NULL,
  `surveyid` int(11) NOT NULL,
  `total` int(11) NOT NULL,
  `date` datetime NOT NULL,
  `iscronfinished` int(11) NOT NULL DEFAULT '0',
  `send_to_mail_lists` varchar(500) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tbltaskchecklists` (
  `id` int(11) NOT NULL,
  `taskid` int(11) NOT NULL,
  `description` varchar(500) NOT NULL,
  `finished` int(11) NOT NULL DEFAULT '0',
  `dateadded` datetime NOT NULL,
  `addedfrom` int(11) NOT NULL,
  `list_order` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tbltaxes` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `taxrate` decimal(11,2) NOT NULL,
  `ledger` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tbltemdepartments` (
  `departmentid` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `description` text,
  `is_active` tinyint(4) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblticketassignments` (
  `ticketassignemtnid` int(11) NOT NULL,
  `ticketid` int(11) NOT NULL,
  `staffid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblticketattachments` (
  `id` int(11) NOT NULL,
  `ticketid` int(11) NOT NULL,
  `replyid` int(11) DEFAULT NULL,
  `file_name` mediumtext NOT NULL,
  `filetype` varchar(50) DEFAULT NULL,
  `dateadded` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblticketnotes` (
  `ticketnoteid` int(11) NOT NULL,
  `note` text NOT NULL,
  `ticketid` int(11) NOT NULL,
  `admin` int(11) NOT NULL,
  `date` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblticketpipelog` (
  `id` int(11) NOT NULL,
  `date` datetime NOT NULL,
  `email_to` varchar(500) NOT NULL,
  `name` varchar(200) NOT NULL,
  `subject` varchar(500) NOT NULL,
  `message` mediumtext NOT NULL,
  `email` varchar(300) NOT NULL,
  `status` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblticketreplies` (
  `id` int(11) NOT NULL,
  `ticketid` int(11) NOT NULL,
  `userid` int(11) DEFAULT NULL,
  `name` text,
  `email` text,
  `date` datetime NOT NULL,
  `message` text,
  `attachment` int(11) DEFAULT NULL,
  `admin` int(11) DEFAULT NULL,
  `ip` varchar(40) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tbltickets` (
  `ticketid` int(11) NOT NULL,
  `adminreplying` int(11) NOT NULL DEFAULT '0',
  `userid` int(11) NOT NULL,
  `email` text,
  `name` text,
  `department` int(11) NOT NULL,
  `priority` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `service` int(11) DEFAULT NULL,
  `ticketkey` varchar(32) NOT NULL,
  `subject` varchar(300) NOT NULL,
  `message` text,
  `admin` int(11) DEFAULT NULL,
  `date` datetime NOT NULL,
  `lastreply` datetime DEFAULT NULL,
  `clientread` int(11) NOT NULL DEFAULT '0',
  `adminread` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(40) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblticketsspamcontrol` (
  `id` int(11) NOT NULL,
  `type` varchar(40) NOT NULL,
  `value` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblticketstatus` (
  `ticketstatusid` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `isdefault` int(11) NOT NULL DEFAULT '0',
  `statuscolor` varchar(7) DEFAULT NULL,
  `statusorder` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `tblticketstatus` (`ticketstatusid`, `name`, `isdefault`, `statuscolor`, `statusorder`) VALUES
(1, 'Open', 1, '#ff2d42', 1),
(2, 'In progress', 1, '#259b24', 2),
(3, 'Answered', 1, '#0000ff', 3),
(4, 'On Hold', 1, '#c0c0c0', 4),
(5, 'Closed', 1, '#03a9f4', 5);

CREATE TABLE `tbltodoitems` (
  `todoid` int(11) NOT NULL,
  `description` text NOT NULL,
  `staffid` int(11) NOT NULL,
  `dateadded` datetime NOT NULL,
  `finished` tinyint(1) NOT NULL,
  `datefinished` datetime DEFAULT NULL,
  `item_order` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblunitsofmeasure` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `description` varchar(250) NOT NULL,
  `quantity` int(11) NOT NULL,
  `is_active` tinyint(4) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `tblunitsofmeasure` (`id`, `name`, `description`, `quantity`, `is_active`) VALUES
(4, 'Each', 'Each', 1, 1),
(6, 'Case 10', 'Case of 10 Units', 10, 1);

CREATE TABLE `tbluseradminnotes` (
  `usernoteid` int(11) NOT NULL,
  `description` text NOT NULL,
  `dateadded` datetime NOT NULL,
  `addedfrom` int(11) NOT NULL,
  `staff` int(11) NOT NULL,
  `userid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `tbluseradminnotes` (`usernoteid`, `description`, `dateadded`, `addedfrom`, `staff`, `userid`) VALUES
(1, 'This is note test', '2017-09-28 07:08:47', 10, 0, 1),
(6, 'test', '2017-09-29 08:41:24', 10, 0, 1),
(9, 'Another note', '2017-09-29 08:41:28', 1, 0, 1);

CREATE TABLE `tbluserautologin` (
  `key_id` char(32) NOT NULL,
  `user_id` int(11) NOT NULL,
  `user_agent` varchar(150) NOT NULL,
  `last_ip` varchar(40) NOT NULL,
  `last_login` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `staff` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblusersettings` (
  `id` int(11) NOT NULL,
  `name` varchar(250) NOT NULL,
  `value` varchar(250) NOT NULL,
  `user` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `tblusersettings` (`id`, `name`, `value`, `user`) VALUES
(0, 'name', 'value', 1);

CREATE TABLE `tblvoucher` (
  `vchid` int(11) NOT NULL,
  `voucher` varchar(250) NOT NULL,
  `vchtype` int(11) NOT NULL,
  `docdate` date NOT NULL,
  `trxdate` date NOT NULL,
  `currency` varchar(5) NOT NULL,
  `created_by` int(11) NOT NULL,
  `datecreated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `posteddate` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `invoiceid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `tblvoucherlines` (
  `id` int(11) NOT NULL,
  `vchid` int(11) NOT NULL,
  `ledger` int(11) NOT NULL,
  `amount_type` int(11) NOT NULL,
  `amount` float NOT NULL,
  `description` text NOT NULL,
  `refrence` mediumtext,
  `invoiceid` varchar(15) NOT NULL,
  `poid` int(11) DEFAULT NULL,
  `item_order` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tblvouchertypes` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `description` text NOT NULL,
  `vtypecode` varchar(10) NOT NULL,
  `status` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `tblvouchertypes` (`id`, `name`, `description`, `vtypecode`, `status`) VALUES
(1, 'General Journal', 'Adjusting Entries', 'GJ-', 0),
(2, 'Opening Balance Equity', 'Opening Balance Equity', 'OP-000', 0),
(3, 'Payment', 'Payment', 'PV-000', 0),
(4, 'Receipt', 'Receipt', 'RV-000', 0);

CREATE TABLE `tblwarehouse` (
  `ware_id` int(11) NOT NULL,
  `warehouse_name` varchar(100) NOT NULL,
  `warehouse_id` varchar(50) NOT NULL,
  `country` int(11) NOT NULL,
  `address` text NOT NULL,
  `state` varchar(50) NOT NULL,
  `city` varchar(50) NOT NULL,
  `postal_code` int(11) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `fax` varchar(20) NOT NULL,
  `email_id` varchar(50) NOT NULL,
  `locations` int(11) NOT NULL,
  `locations_list` text NOT NULL,
  `active` int(11) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `tblwarehousecontacts` (
  `contact_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `salutation` text NOT NULL,
  `firstname` varchar(50) NOT NULL,
  `lastname` varchar(50) NOT NULL,
  `country` varchar(50) NOT NULL,
  `address` text NOT NULL,
  `city` varchar(50) NOT NULL,
  `state` varchar(50) NOT NULL,
  `zip` text NOT NULL,
  `phoneno` varchar(25) NOT NULL,
  `mobileno` varchar(25) NOT NULL,
  `fax` text NOT NULL,
  `email` text NOT NULL,
  `skypeid` varchar(100) NOT NULL,
  `position` varchar(50) NOT NULL,
  `status` varchar(50) NOT NULL,
  `ware_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `tblwarehousestock` (
  `id` int(11) NOT NULL,
  `suppliersku` varchar(255) NOT NULL,
  `oursku` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `qty` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  `date` date NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tblwarehousetransfer` (
  `id` int(11) NOT NULL,
  `transfer_id` varchar(255) NOT NULL,
  `from_warehouse` int(11) NOT NULL,
  `from_location` int(11) NOT NULL,
  `to_warehouse` int(11) NOT NULL,
  `to_location` int(11) NOT NULL,
  `date` date NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tblwarehousetransfer_item` (
  `id` int(11) NOT NULL,
  `warehousetransfer_id` int(11) NOT NULL,
  `suppliersku` varchar(255) NOT NULL,
  `oursku` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `qty` int(11) NOT NULL,
  `uom` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `tblactivitylog`
--
ALTER TABLE `tblactivitylog`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tbladminclientreminders`
--
ALTER TABLE `tbladminclientreminders`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tbladminemployeereminders`
--
ALTER TABLE `tbladminemployeereminders`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tbladminsupplierreminders`
--
ALTER TABLE `tbladminsupplierreminders`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tbladminwarehousereminders`
--
ALTER TABLE `tbladminwarehousereminders`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblallowedledgers`
--
ALTER TABLE `tblallowedledgers`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblannouncements`
--
ALTER TABLE `tblannouncements`
  ADD PRIMARY KEY (`announcementid`);

--
-- Indexes for table `tblbanckaccounttransfer`
--
ALTER TABLE `tblbanckaccounttransfer`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblbankbrancheattachments`
--
ALTER TABLE `tblbankbrancheattachments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `clientid` (`clientid`);

--
-- Indexes for table `tblbankbranchecontacts`
--
ALTER TABLE `tblbankbranchecontacts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `bankbranchid` (`bankbranchid`),
  ADD KEY `department_id` (`department_id`);

--
-- Indexes for table `tblbankbranches`
--
ALTER TABLE `tblbankbranches`
  ADD PRIMARY KEY (`bankbranchid`),
  ADD KEY `bankid` (`bankid`);

--
-- Indexes for table `tblbankbranchesnotes`
--
ALTER TABLE `tblbankbranchesnotes`
  ADD PRIMARY KEY (`usernoteid`),
  ADD KEY `branchid` (`branchid`);

--
-- Indexes for table `tblbankbranchesreminders`
--
ALTER TABLE `tblbankbranchesreminders`
  ADD PRIMARY KEY (`id`),
  ADD KEY `bankbranchid` (`bankbranchid`);

--
-- Indexes for table `tblbanks`
--
ALTER TABLE `tblbanks`
  ADD PRIMARY KEY (`bankid`);

--
-- Indexes for table `tblbanksaccount`
--
ALTER TABLE `tblbanksaccount`
  ADD PRIMARY KEY (`id`),
  ADD KEY `bank` (`bank`),
  ADD KEY `branch` (`branch`);

--
-- Indexes for table `tblbillitems`
--
ALTER TABLE `tblbillitems`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblbillpaymentrecords`
--
ALTER TABLE `tblbillpaymentrecords`
  ADD PRIMARY KEY (`id`),
  ADD KEY `invoiceid` (`billid`);

--
-- Indexes for table `tblbills`
--
ALTER TABLE `tblbills`
  ADD PRIMARY KEY (`billid`);

--
-- Indexes for table `tblbins`
--
ALTER TABLE `tblbins`
  ADD PRIMARY KEY (`bin_id`);

--
-- Indexes for table `tblcategories`
--
ALTER TABLE `tblcategories`
  ADD PRIMARY KEY (`category_id`);

--
-- Indexes for table `tblclientattachments`
--
ALTER TABLE `tblclientattachments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `clientid` (`clientid`);

--
-- Indexes for table `tblclientcontacts`
--
ALTER TABLE `tblclientcontacts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `userid` (`userid`),
  ADD KEY `country` (`country`);

--
-- Indexes for table `tblclients`
--
ALTER TABLE `tblclients`
  ADD PRIMARY KEY (`userid`),
  ADD KEY `ledger` (`ledger`),
  ADD KEY `country` (`country`);

--
-- Indexes for table `tblcommentlikes`
--
ALTER TABLE `tblcommentlikes`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblcontact`
--
ALTER TABLE `tblcontact`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblcontractattachments`
--
ALTER TABLE `tblcontractattachments`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblcontractrenewals`
--
ALTER TABLE `tblcontractrenewals`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblcontracts`
--
ALTER TABLE `tblcontracts`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblcontracttypes`
--
ALTER TABLE `tblcontracttypes`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblcountries`
--
ALTER TABLE `tblcountries`
  ADD PRIMARY KEY (`country_id`);

--
-- Indexes for table `tblcurrencies`
--
ALTER TABLE `tblcurrencies`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblcustomergroups_in`
--
ALTER TABLE `tblcustomergroups_in`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblcustomerpermissions`
--
ALTER TABLE `tblcustomerpermissions`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblcustomersgroups`
--
ALTER TABLE `tblcustomersgroups`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblcustomfields`
--
ALTER TABLE `tblcustomfields`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblcustomfieldsvalues`
--
ALTER TABLE `tblcustomfieldsvalues`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tbldeopsits`
--
ALTER TABLE `tbldeopsits`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tbldepartments`
--
ALTER TABLE `tbldepartments`
  ADD PRIMARY KEY (`departmentid`);

--
-- Indexes for table `tbldiscounts`
--
ALTER TABLE `tbldiscounts`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tbldismissedannouncements`
--
ALTER TABLE `tbldismissedannouncements`
  ADD PRIMARY KEY (`dismissedannouncementid`);

--
-- Indexes for table `tbldocuments`
--
ALTER TABLE `tbldocuments`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tbleducation`
--
ALTER TABLE `tbleducation`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblemaillists`
--
ALTER TABLE `tblemaillists`
  ADD PRIMARY KEY (`listid`);

--
-- Indexes for table `tblemailtemplates`
--
ALTER TABLE `tblemailtemplates`
  ADD PRIMARY KEY (`emailtemplateid`);

--
-- Indexes for table `tblemployee`
--
ALTER TABLE `tblemployee`
  ADD PRIMARY KEY (`empid`);

--
-- Indexes for table `tblemployeeadminnotes`
--
ALTER TABLE `tblemployeeadminnotes`
  ADD PRIMARY KEY (`empnoteid`);

--
-- Indexes for table `tblemployeeattachments`
--
ALTER TABLE `tblemployeeattachments`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblemp_department`
--
ALTER TABLE `tblemp_department`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblestimateactivity`
--
ALTER TABLE `tblestimateactivity`
  ADD PRIMARY KEY (`id`),
  ADD KEY `estimateid` (`estimateid`);

--
-- Indexes for table `tblestimateitems`
--
ALTER TABLE `tblestimateitems`
  ADD PRIMARY KEY (`id`),
  ADD KEY `estimateid` (`estimateid`);

--
-- Indexes for table `tblestimates`
--
ALTER TABLE `tblestimates`
  ADD PRIMARY KEY (`id`),
  ADD KEY `clientid` (`clientid`);

--
-- Indexes for table `tblevents`
--
ALTER TABLE `tblevents`
  ADD PRIMARY KEY (`eventid`);

--
-- Indexes for table `tbleview_item`
--
ALTER TABLE `tbleview_item`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblexpenses`
--
ALTER TABLE `tblexpenses`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblexpensescategories`
--
ALTER TABLE `tblexpensescategories`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblgoals`
--
ALTER TABLE `tblgoals`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblgrades`
--
ALTER TABLE `tblgrades`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblgrnitems`
--
ALTER TABLE `tblgrnitems`
  ADD PRIMARY KEY (`id`),
  ADD KEY `invoiceid` (`grnid`);

--
-- Indexes for table `tblgrns`
--
ALTER TABLE `tblgrns`
  ADD PRIMARY KEY (`grnid`);

--
-- Indexes for table `tblholidays`
--
ALTER TABLE `tblholidays`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblinstitutions`
--
ALTER TABLE `tblinstitutions`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblinternaltransfer`
--
ALTER TABLE `tblinternaltransfer`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblinternaltransfer_item`
--
ALTER TABLE `tblinternaltransfer_item`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblinvoiceactivity`
--
ALTER TABLE `tblinvoiceactivity`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblinvoiceattachments`
--
ALTER TABLE `tblinvoiceattachments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `invoiceid` (`invoiceid`);

--
-- Indexes for table `tblinvoiceitems`
--
ALTER TABLE `tblinvoiceitems`
  ADD PRIMARY KEY (`id`),
  ADD KEY `invoiceid` (`invoiceid`);

--
-- Indexes for table `tblinvoiceitemslist`
--
ALTER TABLE `tblinvoiceitemslist`
  ADD PRIMARY KEY (`id`),
  ADD KEY `ware_id` (`ware_id`),
  ADD KEY `supplier` (`supplier`),
  ADD KEY `manufacturer` (`manufacturer`),
  ADD KEY `ledger` (`ledger`),
  ADD KEY `subcategory` (`subcategory`),
  ADD KEY `department` (`department`),
  ADD KEY `category` (`category`);

--
-- Indexes for table `tblinvoiceitems_eview`
--
ALTER TABLE `tblinvoiceitems_eview`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblinvoiceitmnotes`
--
ALTER TABLE `tblinvoiceitmnotes`
  ADD PRIMARY KEY (`usernoteid`);

--
-- Indexes for table `tblinvoicepaymentrecords`
--
ALTER TABLE `tblinvoicepaymentrecords`
  ADD PRIMARY KEY (`id`),
  ADD KEY `invoiceid` (`invoiceid`);

--
-- Indexes for table `tblinvoicepaymentsmodes`
--
ALTER TABLE `tblinvoicepaymentsmodes`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblinvoices`
--
ALTER TABLE `tblinvoices`
  ADD PRIMARY KEY (`id`),
  ADD KEY `clientid` (`clientid`);

--
-- Indexes for table `tblitemtypes`
--
ALTER TABLE `tblitemtypes`
  ADD PRIMARY KEY (`typeid`);

--
-- Indexes for table `tblleadactivitylog`
--
ALTER TABLE `tblleadactivitylog`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblleadattachments`
--
ALTER TABLE `tblleadattachments`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblleadnotes`
--
ALTER TABLE `tblleadnotes`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblleads`
--
ALTER TABLE `tblleads`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblleadsemailintegration`
--
ALTER TABLE `tblleadsemailintegration`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblleadsemailintegrationemails`
--
ALTER TABLE `tblleadsemailintegrationemails`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblleadsindustries`
--
ALTER TABLE `tblleadsindustries`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblleadssources`
--
ALTER TABLE `tblleadssources`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblleadsstatus`
--
ALTER TABLE `tblleadsstatus`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblledgergroups`
--
ALTER TABLE `tblledgergroups`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tbllistemails`
--
ALTER TABLE `tbllistemails`
  ADD PRIMARY KEY (`emailid`);

--
-- Indexes for table `tbllocations`
--
ALTER TABLE `tbllocations`
  ADD PRIMARY KEY (`location_id`);

--
-- Indexes for table `tblmaillistscustomfields`
--
ALTER TABLE `tblmaillistscustomfields`
  ADD PRIMARY KEY (`customfieldid`);

--
-- Indexes for table `tblmaillistscustomfieldvalues`
--
ALTER TABLE `tblmaillistscustomfieldvalues`
  ADD PRIMARY KEY (`customfieldvalueid`);

--
-- Indexes for table `tblmanufacturers`
--
ALTER TABLE `tblmanufacturers`
  ADD PRIMARY KEY (`mfid`);

--
-- Indexes for table `tblmanufacturersnotes`
--
ALTER TABLE `tblmanufacturersnotes`
  ADD PRIMARY KEY (`usernoteid`);

--
-- Indexes for table `tblnationality`
--
ALTER TABLE `tblnationality`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblnotifications`
--
ALTER TABLE `tblnotifications`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tbloptions`
--
ALTER TABLE `tbloptions`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblorderactivity`
--
ALTER TABLE `tblorderactivity`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblorderitems`
--
ALTER TABLE `tblorderitems`
  ADD PRIMARY KEY (`id`),
  ADD KEY `orderid` (`orderid`);

--
-- Indexes for table `tblorders`
--
ALTER TABLE `tblorders`
  ADD PRIMARY KEY (`id`),
  ADD KEY `clientid` (`clientid`);

--
-- Indexes for table `tblpaidbills`
--
ALTER TABLE `tblpaidbills`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblperiod`
--
ALTER TABLE `tblperiod`
  ADD PRIMARY KEY (`id`),
  ADD KEY `id` (`id`);

--
-- Indexes for table `tblperiodmodules`
--
ALTER TABLE `tblperiodmodules`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblpermissions`
--
ALTER TABLE `tblpermissions`
  ADD PRIMARY KEY (`permissionid`);

--
-- Indexes for table `tblposition`
--
ALTER TABLE `tblposition`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblpostattachments`
--
ALTER TABLE `tblpostattachments`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblpostcomments`
--
ALTER TABLE `tblpostcomments`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblpostlikes`
--
ALTER TABLE `tblpostlikes`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblposts`
--
ALTER TABLE `tblposts`
  ADD PRIMARY KEY (`postid`);

--
-- Indexes for table `tblpredifinedreplies`
--
ALTER TABLE `tblpredifinedreplies`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblpriorities`
--
ALTER TABLE `tblpriorities`
  ADD PRIMARY KEY (`priorityid`);

--
-- Indexes for table `tblproposalcomments`
--
ALTER TABLE `tblproposalcomments`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblproposals`
--
ALTER TABLE `tblproposals`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblpurchaseorderactivity`
--
ALTER TABLE `tblpurchaseorderactivity`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblpurchaseorderitems`
--
ALTER TABLE `tblpurchaseorderitems`
  ADD PRIMARY KEY (`id`),
  ADD KEY `orderid` (`orderid`);

--
-- Indexes for table `tblpurchaseorders`
--
ALTER TABLE `tblpurchaseorders`
  ADD PRIMARY KEY (`id`),
  ADD KEY `clientid` (`supplierid`);

--
-- Indexes for table `tblrace`
--
ALTER TABLE `tblrace`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblreconcilations`
--
ALTER TABLE `tblreconcilations`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblreminders`
--
ALTER TABLE `tblreminders`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblrfqsqouteactivity`
--
ALTER TABLE `tblrfqsqouteactivity`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblrfqsqouteitems`
--
ALTER TABLE `tblrfqsqouteitems`
  ADD PRIMARY KEY (`id`),
  ADD KEY `orderid` (`orderid`);

--
-- Indexes for table `tblrfqsqoutes`
--
ALTER TABLE `tblrfqsqoutes`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblrolepermissions`
--
ALTER TABLE `tblrolepermissions`
  ADD PRIMARY KEY (`rolepermissionid`);

--
-- Indexes for table `tblroles`
--
ALTER TABLE `tblroles`
  ADD PRIMARY KEY (`roleid`);

--
-- Indexes for table `tblsalutation`
--
ALTER TABLE `tblsalutation`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblservices`
--
ALTER TABLE `tblservices`
  ADD PRIMARY KEY (`serviceid`);

--
-- Indexes for table `tblstaff`
--
ALTER TABLE `tblstaff`
  ADD PRIMARY KEY (`staffid`);

--
-- Indexes for table `tblstaffdepartments`
--
ALTER TABLE `tblstaffdepartments`
  ADD PRIMARY KEY (`staffdepartmentid`),
  ADD KEY `staffid` (`staffid`),
  ADD KEY `departmentid` (`departmentid`);

--
-- Indexes for table `tblstaffpermissions`
--
ALTER TABLE `tblstaffpermissions`
  ADD PRIMARY KEY (`staffpermid`),
  ADD KEY `staffid` (`staffid`);

--
-- Indexes for table `tblstafftaskassignees`
--
ALTER TABLE `tblstafftaskassignees`
  ADD PRIMARY KEY (`id`),
  ADD KEY `staffid` (`staffid`),
  ADD KEY `taskid` (`taskid`);

--
-- Indexes for table `tblstafftaskcomments`
--
ALTER TABLE `tblstafftaskcomments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `taskid` (`taskid`);

--
-- Indexes for table `tblstafftasks`
--
ALTER TABLE `tblstafftasks`
  ADD PRIMARY KEY (`id`),
  ADD KEY `rel_id` (`rel_id`);

--
-- Indexes for table `tblstafftasksattachments`
--
ALTER TABLE `tblstafftasksattachments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `taskid` (`taskid`);

--
-- Indexes for table `tblstafftasksfollowers`
--
ALTER TABLE `tblstafftasksfollowers`
  ADD PRIMARY KEY (`id`),
  ADD KEY `staffid` (`staffid`),
  ADD KEY `taskid` (`taskid`);

--
-- Indexes for table `tblstatus`
--
ALTER TABLE `tblstatus`
  ADD PRIMARY KEY (`status_id`);

--
-- Indexes for table `tblsubcategories`
--
ALTER TABLE `tblsubcategories`
  ADD PRIMARY KEY (`subcategory_id`),
  ADD KEY `catid` (`catid`);

--
-- Indexes for table `tblsupplieradminnotes`
--
ALTER TABLE `tblsupplieradminnotes`
  ADD PRIMARY KEY (`usernoteid`),
  ADD KEY `userid` (`userid`);

--
-- Indexes for table `tblsupplierbill_item`
--
ALTER TABLE `tblsupplierbill_item`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblsuppliercontacts`
--
ALTER TABLE `tblsuppliercontacts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `userid` (`userid`),
  ADD KEY `country` (`country`);

--
-- Indexes for table `tblsuppliergroups_in`
--
ALTER TABLE `tblsuppliergroups_in`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblsuppliers`
--
ALTER TABLE `tblsuppliers`
  ADD PRIMARY KEY (`userid`),
  ADD KEY `ledger` (`ledger`),
  ADD KEY `country` (`country`);

--
-- Indexes for table `tblsuppliersgroups`
--
ALTER TABLE `tblsuppliersgroups`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblsurveyquestionboxes`
--
ALTER TABLE `tblsurveyquestionboxes`
  ADD PRIMARY KEY (`boxid`),
  ADD KEY `questionid` (`questionid`);

--
-- Indexes for table `tblsurveyquestionboxesdescription`
--
ALTER TABLE `tblsurveyquestionboxesdescription`
  ADD PRIMARY KEY (`questionboxdescriptionid`),
  ADD KEY `questionid` (`questionid`);

--
-- Indexes for table `tblsurveyquestions`
--
ALTER TABLE `tblsurveyquestions`
  ADD PRIMARY KEY (`questionid`),
  ADD KEY `surveyid` (`surveyid`);

--
-- Indexes for table `tblsurveyresults`
--
ALTER TABLE `tblsurveyresults`
  ADD PRIMARY KEY (`resultid`),
  ADD KEY `questionid` (`questionid`),
  ADD KEY `surveyid` (`surveyid`),
  ADD KEY `boxdescriptionid` (`boxdescriptionid`),
  ADD KEY `resultsetid` (`resultsetid`),
  ADD KEY `boxid` (`boxid`);

--
-- Indexes for table `tblsurveyresultsets`
--
ALTER TABLE `tblsurveyresultsets`
  ADD PRIMARY KEY (`resultsetid`),
  ADD KEY `surveyid` (`surveyid`),
  ADD KEY `userid` (`userid`);

--
-- Indexes for table `tblsurveys`
--
ALTER TABLE `tblsurveys`
  ADD PRIMARY KEY (`surveyid`);

--
-- Indexes for table `tblsurveysemailsendcron`
--
ALTER TABLE `tblsurveysemailsendcron`
  ADD PRIMARY KEY (`id`),
  ADD KEY `surveyid` (`surveyid`);

--
-- Indexes for table `tblsurveysendlog`
--
ALTER TABLE `tblsurveysendlog`
  ADD PRIMARY KEY (`id`),
  ADD KEY `surveyid` (`surveyid`);

--
-- Indexes for table `tbltaskchecklists`
--
ALTER TABLE `tbltaskchecklists`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tbltaxes`
--
ALTER TABLE `tbltaxes`
  ADD PRIMARY KEY (`id`),
  ADD KEY `ledger` (`ledger`);

--
-- Indexes for table `tbltemdepartments`
--
ALTER TABLE `tbltemdepartments`
  ADD PRIMARY KEY (`departmentid`);

--
-- Indexes for table `tblticketassignments`
--
ALTER TABLE `tblticketassignments`
  ADD PRIMARY KEY (`ticketassignemtnid`);

--
-- Indexes for table `tblticketattachments`
--
ALTER TABLE `tblticketattachments`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblticketnotes`
--
ALTER TABLE `tblticketnotes`
  ADD PRIMARY KEY (`ticketnoteid`);

--
-- Indexes for table `tblticketpipelog`
--
ALTER TABLE `tblticketpipelog`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblticketreplies`
--
ALTER TABLE `tblticketreplies`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tbltickets`
--
ALTER TABLE `tbltickets`
  ADD PRIMARY KEY (`ticketid`);

--
-- Indexes for table `tblticketsspamcontrol`
--
ALTER TABLE `tblticketsspamcontrol`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblticketstatus`
--
ALTER TABLE `tblticketstatus`
  ADD PRIMARY KEY (`ticketstatusid`);

--
-- Indexes for table `tbltodoitems`
--
ALTER TABLE `tbltodoitems`
  ADD PRIMARY KEY (`todoid`);

--
-- Indexes for table `tblunitsofmeasure`
--
ALTER TABLE `tblunitsofmeasure`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tbluseradminnotes`
--
ALTER TABLE `tbluseradminnotes`
  ADD PRIMARY KEY (`usernoteid`);

--
-- Indexes for table `tblvoucher`
--
ALTER TABLE `tblvoucher`
  ADD PRIMARY KEY (`vchid`),
  ADD KEY `vchtype` (`vchtype`);

--
-- Indexes for table `tblvoucherlines`
--
ALTER TABLE `tblvoucherlines`
  ADD PRIMARY KEY (`id`),
  ADD KEY `vchid` (`vchid`),
  ADD KEY `ledger` (`ledger`);

--
-- Indexes for table `tblvouchertypes`
--
ALTER TABLE `tblvouchertypes`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblwarehouse`
--
ALTER TABLE `tblwarehouse`
  ADD PRIMARY KEY (`ware_id`);

--
-- Indexes for table `tblwarehousecontacts`
--
ALTER TABLE `tblwarehousecontacts`
  ADD PRIMARY KEY (`contact_id`);

--
-- Indexes for table `tblwarehousestock`
--
ALTER TABLE `tblwarehousestock`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblwarehousetransfer`
--
ALTER TABLE `tblwarehousetransfer`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tblwarehousetransfer_item`
--
ALTER TABLE `tblwarehousetransfer_item`
  ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `tblactivitylog`
--
ALTER TABLE `tblactivitylog`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tbladminclientreminders`
--
ALTER TABLE `tbladminclientreminders`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tbladminemployeereminders`
--
ALTER TABLE `tbladminemployeereminders`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tbladminsupplierreminders`
--
ALTER TABLE `tbladminsupplierreminders`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tbladminwarehousereminders`
--
ALTER TABLE `tbladminwarehousereminders`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblallowedledgers`
--
ALTER TABLE `tblallowedledgers`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
--
-- AUTO_INCREMENT for table `tblannouncements`
--
ALTER TABLE `tblannouncements`
  MODIFY `announcementid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblbanckaccounttransfer`
--
ALTER TABLE `tblbanckaccounttransfer`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblbankbrancheattachments`
--
ALTER TABLE `tblbankbrancheattachments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblbankbranchecontacts`
--
ALTER TABLE `tblbankbranchecontacts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblbankbranches`
--
ALTER TABLE `tblbankbranches`
  MODIFY `bankbranchid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblbankbranchesnotes`
--
ALTER TABLE `tblbankbranchesnotes`
  MODIFY `usernoteid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblbankbranchesreminders`
--
ALTER TABLE `tblbankbranchesreminders`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblbanks`
--
ALTER TABLE `tblbanks`
  MODIFY `bankid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblbanksaccount`
--
ALTER TABLE `tblbanksaccount`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblbillitems`
--
ALTER TABLE `tblbillitems`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblbillpaymentrecords`
--
ALTER TABLE `tblbillpaymentrecords`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblbills`
--
ALTER TABLE `tblbills`
  MODIFY `billid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblbins`
--
ALTER TABLE `tblbins`
  MODIFY `bin_id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblcategories`
--
ALTER TABLE `tblcategories`
  MODIFY `category_id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblclientattachments`
--
ALTER TABLE `tblclientattachments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblclientcontacts`
--
ALTER TABLE `tblclientcontacts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblclients`
--
ALTER TABLE `tblclients`
  MODIFY `userid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblcommentlikes`
--
ALTER TABLE `tblcommentlikes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblcontact`
--
ALTER TABLE `tblcontact`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblcontractattachments`
--
ALTER TABLE `tblcontractattachments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblcontractrenewals`
--
ALTER TABLE `tblcontractrenewals`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblcontracts`
--
ALTER TABLE `tblcontracts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblcontracttypes`
--
ALTER TABLE `tblcontracttypes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
--
-- AUTO_INCREMENT for table `tblcountries`
--
ALTER TABLE `tblcountries`
  MODIFY `country_id` int(5) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=246;
--
-- AUTO_INCREMENT for table `tblcurrencies`
--
ALTER TABLE `tblcurrencies`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
--
-- AUTO_INCREMENT for table `tblcustomergroups_in`
--
ALTER TABLE `tblcustomergroups_in`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=62;
--
-- AUTO_INCREMENT for table `tblcustomerpermissions`
--
ALTER TABLE `tblcustomerpermissions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=37;
--
-- AUTO_INCREMENT for table `tblcustomersgroups`
--
ALTER TABLE `tblcustomersgroups`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
--
-- AUTO_INCREMENT for table `tblcustomfields`
--
ALTER TABLE `tblcustomfields`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblcustomfieldsvalues`
--
ALTER TABLE `tblcustomfieldsvalues`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tbldeopsits`
--
ALTER TABLE `tbldeopsits`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tbldepartments`
--
ALTER TABLE `tbldepartments`
  MODIFY `departmentid` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
--
-- AUTO_INCREMENT for table `tbldiscounts`
--
ALTER TABLE `tbldiscounts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
--
-- AUTO_INCREMENT for table `tbldismissedannouncements`
--
ALTER TABLE `tbldismissedannouncements`
  MODIFY `dismissedannouncementid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tbldocuments`
--
ALTER TABLE `tbldocuments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
--
-- AUTO_INCREMENT for table `tbleducation`
--
ALTER TABLE `tbleducation`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
--
-- AUTO_INCREMENT for table `tblemaillists`
--
ALTER TABLE `tblemaillists`
  MODIFY `listid` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;
--
-- AUTO_INCREMENT for table `tblemailtemplates`
--
ALTER TABLE `tblemailtemplates`
  MODIFY `emailtemplateid` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=34;
--
-- AUTO_INCREMENT for table `tblemployee`
--
ALTER TABLE `tblemployee`
  MODIFY `empid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblemployeeadminnotes`
--
ALTER TABLE `tblemployeeadminnotes`
  MODIFY `empnoteid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblemployeeattachments`
--
ALTER TABLE `tblemployeeattachments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblemp_department`
--
ALTER TABLE `tblemp_department`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
--
-- AUTO_INCREMENT for table `tblestimateactivity`
--
ALTER TABLE `tblestimateactivity`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblestimateitems`
--
ALTER TABLE `tblestimateitems`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblestimates`
--
ALTER TABLE `tblestimates`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblevents`
--
ALTER TABLE `tblevents`
  MODIFY `eventid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tbleview_item`
--
ALTER TABLE `tbleview_item`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblexpenses`
--
ALTER TABLE `tblexpenses`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblexpensescategories`
--
ALTER TABLE `tblexpensescategories`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblgoals`
--
ALTER TABLE `tblgoals`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblgrades`
--
ALTER TABLE `tblgrades`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=23;
--
-- AUTO_INCREMENT for table `tblgrnitems`
--
ALTER TABLE `tblgrnitems`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblgrns`
--
ALTER TABLE `tblgrns`
  MODIFY `grnid` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
--
-- AUTO_INCREMENT for table `tblholidays`
--
ALTER TABLE `tblholidays`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblinstitutions`
--
ALTER TABLE `tblinstitutions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblinternaltransfer`
--
ALTER TABLE `tblinternaltransfer`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblinternaltransfer_item`
--
ALTER TABLE `tblinternaltransfer_item`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblinvoiceactivity`
--
ALTER TABLE `tblinvoiceactivity`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblinvoiceattachments`
--
ALTER TABLE `tblinvoiceattachments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblinvoiceitems`
--
ALTER TABLE `tblinvoiceitems`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblinvoiceitemslist`
--
ALTER TABLE `tblinvoiceitemslist`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblinvoiceitems_eview`
--
ALTER TABLE `tblinvoiceitems_eview`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblinvoiceitmnotes`
--
ALTER TABLE `tblinvoiceitmnotes`
  MODIFY `usernoteid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblinvoicepaymentrecords`
--
ALTER TABLE `tblinvoicepaymentrecords`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblinvoicepaymentsmodes`
--
ALTER TABLE `tblinvoicepaymentsmodes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;
--
-- AUTO_INCREMENT for table `tblinvoices`
--
ALTER TABLE `tblinvoices`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblitemtypes`
--
ALTER TABLE `tblitemtypes`
  MODIFY `typeid` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;
--
-- AUTO_INCREMENT for table `tblleadactivitylog`
--
ALTER TABLE `tblleadactivitylog`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblleadattachments`
--
ALTER TABLE `tblleadattachments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblleadnotes`
--
ALTER TABLE `tblleadnotes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblleads`
--
ALTER TABLE `tblleads`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblleadsemailintegration`
--
ALTER TABLE `tblleadsemailintegration`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'the ID always must be 1', AUTO_INCREMENT=2;
--
-- AUTO_INCREMENT for table `tblleadsemailintegrationemails`
--
ALTER TABLE `tblleadsemailintegrationemails`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblleadsindustries`
--
ALTER TABLE `tblleadsindustries`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;
--
-- AUTO_INCREMENT for table `tblleadssources`
--
ALTER TABLE `tblleadssources`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;
--
-- AUTO_INCREMENT for table `tblleadsstatus`
--
ALTER TABLE `tblleadsstatus`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;
--
-- AUTO_INCREMENT for table `tblledgergroups`
--
ALTER TABLE `tblledgergroups`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=99;
--
-- AUTO_INCREMENT for table `tbllistemails`
--
ALTER TABLE `tbllistemails`
  MODIFY `emailid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tbllocations`
--
ALTER TABLE `tbllocations`
  MODIFY `location_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
--
-- AUTO_INCREMENT for table `tblmaillistscustomfields`
--
ALTER TABLE `tblmaillistscustomfields`
  MODIFY `customfieldid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblmaillistscustomfieldvalues`
--
ALTER TABLE `tblmaillistscustomfieldvalues`
  MODIFY `customfieldvalueid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblmanufacturers`
--
ALTER TABLE `tblmanufacturers`
  MODIFY `mfid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblmanufacturersnotes`
--
ALTER TABLE `tblmanufacturersnotes`
  MODIFY `usernoteid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblnationality`
--
ALTER TABLE `tblnationality`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=27;
--
-- AUTO_INCREMENT for table `tblnotifications`
--
ALTER TABLE `tblnotifications`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tbloptions`
--
ALTER TABLE `tbloptions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=237;
--
-- AUTO_INCREMENT for table `tblorderactivity`
--
ALTER TABLE `tblorderactivity`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblorderitems`
--
ALTER TABLE `tblorderitems`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblorders`
--
ALTER TABLE `tblorders`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblpaidbills`
--
ALTER TABLE `tblpaidbills`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblperiod`
--
ALTER TABLE `tblperiod`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=25;
--
-- AUTO_INCREMENT for table `tblperiodmodules`
--
ALTER TABLE `tblperiodmodules`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;
--
-- AUTO_INCREMENT for table `tblpermissions`
--
ALTER TABLE `tblpermissions`
  MODIFY `permissionid` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=19;
--
-- AUTO_INCREMENT for table `tblposition`
--
ALTER TABLE `tblposition`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=14;
--
-- AUTO_INCREMENT for table `tblpostattachments`
--
ALTER TABLE `tblpostattachments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblpostcomments`
--
ALTER TABLE `tblpostcomments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblpostlikes`
--
ALTER TABLE `tblpostlikes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblposts`
--
ALTER TABLE `tblposts`
  MODIFY `postid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblpredifinedreplies`
--
ALTER TABLE `tblpredifinedreplies`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblpriorities`
--
ALTER TABLE `tblpriorities`
  MODIFY `priorityid` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;
--
-- AUTO_INCREMENT for table `tblproposalcomments`
--
ALTER TABLE `tblproposalcomments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblproposals`
--
ALTER TABLE `tblproposals`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblpurchaseorderactivity`
--
ALTER TABLE `tblpurchaseorderactivity`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblpurchaseorderitems`
--
ALTER TABLE `tblpurchaseorderitems`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblpurchaseorders`
--
ALTER TABLE `tblpurchaseorders`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblrace`
--
ALTER TABLE `tblrace`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;
--
-- AUTO_INCREMENT for table `tblreconcilations`
--
ALTER TABLE `tblreconcilations`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblreminders`
--
ALTER TABLE `tblreminders`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblrfqsqouteactivity`
--
ALTER TABLE `tblrfqsqouteactivity`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblrfqsqouteitems`
--
ALTER TABLE `tblrfqsqouteitems`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblrfqsqoutes`
--
ALTER TABLE `tblrfqsqoutes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblrolepermissions`
--
ALTER TABLE `tblrolepermissions`
  MODIFY `rolepermissionid` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=833;
--
-- AUTO_INCREMENT for table `tblroles`
--
ALTER TABLE `tblroles`
  MODIFY `roleid` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
--
-- AUTO_INCREMENT for table `tblsalutation`
--
ALTER TABLE `tblsalutation`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
--
-- AUTO_INCREMENT for table `tblservices`
--
ALTER TABLE `tblservices`
  MODIFY `serviceid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblstaff`
--
ALTER TABLE `tblstaff`
  MODIFY `staffid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblstaffdepartments`
--
ALTER TABLE `tblstaffdepartments`
  MODIFY `staffdepartmentid` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
--
-- AUTO_INCREMENT for table `tblstaffpermissions`
--
ALTER TABLE `tblstaffpermissions`
  MODIFY `staffpermid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblstafftaskassignees`
--
ALTER TABLE `tblstafftaskassignees`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblstafftaskcomments`
--
ALTER TABLE `tblstafftaskcomments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblstafftasks`
--
ALTER TABLE `tblstafftasks`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblstafftasksattachments`
--
ALTER TABLE `tblstafftasksattachments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblstafftasksfollowers`
--
ALTER TABLE `tblstafftasksfollowers`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblstatus`
--
ALTER TABLE `tblstatus`
  MODIFY `status_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;
--
-- AUTO_INCREMENT for table `tblsubcategories`
--
ALTER TABLE `tblsubcategories`
  MODIFY `subcategory_id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblsupplieradminnotes`
--
ALTER TABLE `tblsupplieradminnotes`
  MODIFY `usernoteid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblsupplierbill_item`
--
ALTER TABLE `tblsupplierbill_item`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblsuppliercontacts`
--
ALTER TABLE `tblsuppliercontacts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblsuppliergroups_in`
--
ALTER TABLE `tblsuppliergroups_in`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=65;
--
-- AUTO_INCREMENT for table `tblsuppliers`
--
ALTER TABLE `tblsuppliers`
  MODIFY `userid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblsuppliersgroups`
--
ALTER TABLE `tblsuppliersgroups`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblsurveyquestionboxes`
--
ALTER TABLE `tblsurveyquestionboxes`
  MODIFY `boxid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblsurveyquestionboxesdescription`
--
ALTER TABLE `tblsurveyquestionboxesdescription`
  MODIFY `questionboxdescriptionid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblsurveyquestions`
--
ALTER TABLE `tblsurveyquestions`
  MODIFY `questionid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblsurveyresults`
--
ALTER TABLE `tblsurveyresults`
  MODIFY `resultid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblsurveyresultsets`
--
ALTER TABLE `tblsurveyresultsets`
  MODIFY `resultsetid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblsurveys`
--
ALTER TABLE `tblsurveys`
  MODIFY `surveyid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblsurveysemailsendcron`
--
ALTER TABLE `tblsurveysemailsendcron`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblsurveysendlog`
--
ALTER TABLE `tblsurveysendlog`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tbltaskchecklists`
--
ALTER TABLE `tbltaskchecklists`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tbltaxes`
--
ALTER TABLE `tbltaxes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
--
-- AUTO_INCREMENT for table `tbltemdepartments`
--
ALTER TABLE `tbltemdepartments`
  MODIFY `departmentid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblticketassignments`
--
ALTER TABLE `tblticketassignments`
  MODIFY `ticketassignemtnid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblticketattachments`
--
ALTER TABLE `tblticketattachments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblticketnotes`
--
ALTER TABLE `tblticketnotes`
  MODIFY `ticketnoteid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblticketpipelog`
--
ALTER TABLE `tblticketpipelog`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblticketreplies`
--
ALTER TABLE `tblticketreplies`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tbltickets`
--
ALTER TABLE `tbltickets`
  MODIFY `ticketid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblticketsspamcontrol`
--
ALTER TABLE `tblticketsspamcontrol`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblticketstatus`
--
ALTER TABLE `tblticketstatus`
  MODIFY `ticketstatusid` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;
--
-- AUTO_INCREMENT for table `tbltodoitems`
--
ALTER TABLE `tbltodoitems`
  MODIFY `todoid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblunitsofmeasure`
--
ALTER TABLE `tblunitsofmeasure`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;
--
-- AUTO_INCREMENT for table `tbluseradminnotes`
--
ALTER TABLE `tbluseradminnotes`
  MODIFY `usernoteid` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;
--
-- AUTO_INCREMENT for table `tblvoucher`
--
ALTER TABLE `tblvoucher`
  MODIFY `vchid` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblvoucherlines`
--
ALTER TABLE `tblvoucherlines`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblvouchertypes`
--
ALTER TABLE `tblvouchertypes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;
--
-- AUTO_INCREMENT for table `tblwarehouse`
--
ALTER TABLE `tblwarehouse`
  MODIFY `ware_id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblwarehousecontacts`
--
ALTER TABLE `tblwarehousecontacts`
  MODIFY `contact_id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblwarehousestock`
--
ALTER TABLE `tblwarehousestock`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblwarehousetransfer`
--
ALTER TABLE `tblwarehousetransfer`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tblwarehousetransfer_item`
--
ALTER TABLE `tblwarehousetransfer_item`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- Constraints for dumped tables
--

--
-- Constraints for table `tblbankbranchecontacts`
--
ALTER TABLE `tblbankbranchecontacts`
  ADD CONSTRAINT `tblbankbranchecontacts_ibfk_1` FOREIGN KEY (`bankbranchid`) REFERENCES `tblbankbranches` (`bankbranchid`) ON UPDATE CASCADE;

--
-- Constraints for table `tblbankbranches`
--
ALTER TABLE `tblbankbranches`
  ADD CONSTRAINT `tblbankbranches_ibfk_1` FOREIGN KEY (`bankid`) REFERENCES `tblbanks` (`bankid`) ON UPDATE CASCADE;

--
-- Constraints for table `tblbankbranchesnotes`
--
ALTER TABLE `tblbankbranchesnotes`
  ADD CONSTRAINT `tblbankbranchesnotes_ibfk_1` FOREIGN KEY (`branchid`) REFERENCES `tblbankbranches` (`bankbranchid`) ON UPDATE CASCADE;

--
-- Constraints for table `tblbankbranchesreminders`
--
ALTER TABLE `tblbankbranchesreminders`
  ADD CONSTRAINT `tblbankbranchesreminders_ibfk_1` FOREIGN KEY (`bankbranchid`) REFERENCES `tblbankbranches` (`bankbranchid`) ON UPDATE CASCADE;

--
-- Constraints for table `tblbanksaccount`
--
ALTER TABLE `tblbanksaccount`
  ADD CONSTRAINT `tblbanksaccount_ibfk_1` FOREIGN KEY (`bank`) REFERENCES `tblbanks` (`bankid`) ON UPDATE CASCADE,
  ADD CONSTRAINT `tblbanksaccount_ibfk_2` FOREIGN KEY (`branch`) REFERENCES `tblbankbranches` (`bankbranchid`) ON UPDATE CASCADE;

--
-- Constraints for table `tblestimateactivity`
--
ALTER TABLE `tblestimateactivity`
  ADD CONSTRAINT `tblestimateactivity_ibfk_1` FOREIGN KEY (`estimateid`) REFERENCES `tblestimates` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `tblestimateitems`
--
ALTER TABLE `tblestimateitems`
  ADD CONSTRAINT `tblestimateitems_ibfk_1` FOREIGN KEY (`estimateid`) REFERENCES `tblestimates` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `tblestimates`
--
ALTER TABLE `tblestimates`
  ADD CONSTRAINT `tblestimates_ibfk_1` FOREIGN KEY (`clientid`) REFERENCES `tblclients` (`userid`) ON UPDATE CASCADE;

--
-- Constraints for table `tblinvoicepaymentrecords`
--
ALTER TABLE `tblinvoicepaymentrecords`
  ADD CONSTRAINT `tblinvoicepaymentrecords_ibfk_1` FOREIGN KEY (`invoiceid`) REFERENCES `tblinvoices` (`id`) ON UPDATE CASCADE;
COMMIT;