function intiFieldsValidation(Fields)
{
	$.each(Fields, function(key, field) {
		if(field.required)							
			$("label[for='"+field.id+"']").append("<span class='text-danger'> *</span>");
	
		//$("<span class='bg-danger' style='margin-left:2px'> This field is required</span>").insertAfter("#" + field.id);
	});
}
function fieldsValidation(Fields)
{
	valid=true;
	$.each(Fields, function(key, field) {
		$("#"+field.id).removeClass("errorInput");
		fieldVal=$("#"+field.id).val();
		if((field.required)&&(fieldVal==""))
		{
			errorFieldInput(field,"This field is required");
			valid=false;
			return false;
		}
		if(fieldVal!="")
		{
			
			if((my_isVariable(field.min))&&(fieldVal.length<field.min))
			{
				
				errorFieldInput(field,"This field must have at least "+field.min+ " characters");
				valid=false;
				return false;
			}
			if((my_isVariable(field.max))&&(fieldVal.length>field.max))
			{
				errorFieldInput(field,"Maximum number of characters is  "+field.max+ " characters");
				valid=false;
				return false;
			}
			if(my_isVariable(field.type))
			{
				if((field.type=="int")&&(!my_isInteger(fieldVal)))
				{
					errorFieldInput(field,"This field must be integer");
					valid=false;
					return false;
				}
				if((field.type=="email")&&(!my_isEmail(fieldVal)))
				{
					errorFieldInput(field,"This field must be a valid email");
					valid=false;
					return false;
				}
			}
		}
	});
	
	return valid;
}

function errorFieldInput(field,msg)
{
	type=getTypeElmenet(field.id);
	
	if(type=="SELECT")
	{
		
		$("#"+field.id).find(':selected').addClass("errorInput");
	}
	
	else
		$("#"+field.id).addClass("errorInput");
	alert_float('danger', "<b>"+field.title+": </b>"+ msg);
	$("#"+field.id).focus();
}
function my_isEmail(x)
{
	var filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
    return filter.test(x);
}
function my_isInteger(x) { return (typeof x === 'number') && (x % 1 === 0); }
function my_isVariable (variable) {
  return (typeof variable !== 'undefined');
}
function getTypeElmenet(elementId)
{
	return $("#"+elementId).get(0).tagName;
}