<?php
if($tag != ''){
    $pdf->SetFillColor(240,240,240);
    $pdf->SetDrawColor(245,245,245);
    $pdf->SetXY(0,0);
    $pdf->SetFont('freesans','B',15);
    $pdf->SetTextColor(0);
    $pdf->SetLineWidth(0.75);
    $pdf->StartTransform();
    $pdf->Rotate(-35,109,235);
    $pdf->Cell(100,1,strtoupper($tag),'TB',0,'C','1');
    $pdf->StopTransform();
    $pdf->SetFont('freesans','',10);
    $pdf->setX(10);
    $pdf->setY(10);
}
if(get_option('show_status_on_pdf_ei') == 1){
    // Top
    if ($status == 1) {
        $status = _l('purchase_status_new');
        $pdf->SetFillColor(119, 119, 119);
    } else if ($status == 2) {
        $status = _l('purchase_status_planning');
        $pdf->SetFillColor(3, 169, 244);
    } else if ($status == 3) {
        $status = _l('purchase_status_inprocess');
         $pdf->SetFillColor(252, 45, 66);
    } else if ($status == 4) {
        $status = _l('purchase_status_transit');
        $pdf->SetFillColor(252, 45, 66);
    }
    else if ($status == 5) {
        $status = _l('purchase_status_receiving');
        $pdf->SetFillColor(37, 155, 36);
    }

    $pdf->SetTextColor(255);
    $pdf->Cell(50, 10, strtoupper($status), 0, 1, 'C', '1');
    $pdf->SetTextColor(0);
}
$html = '<span style="font-weight:bold;font-size:20px;">Purchase Order</span><br />';
$html .= '<b style="color:#6a6c6f"># ' . $order_number . '</b>';
$pdf->writeHTMLCell(0, 0, 0, 20, $html, 0, 1, false, true, 'R', false);
$pdf->Ln(6);
$custom_pdf_logo_image_url = get_option('custom_pdf_logo_image_url');
$pdf->setJPEGQuality(100);
if($custom_pdf_logo_image_url == ''){
     if(get_option('company_logo'))
    $pdf->writeHTMLCell(35, 0, 10, 25, '<a href="'.site_url().'"><img src="'.site_url('uploads/company/'.get_option('company_logo')).'"></a>', 0, 1, false, true, 'L', false);
} else {
    $pdf->writeHTMLCell(35, 0, 10, 25, '<a href="'.site_url().'"><img src="'.$custom_pdf_logo_image_url.'"></a>', 0, 1, false, true, 'L', false);
}
// Get Y position for the separation
$y            = $pdf->getY();
$order_info = '<b>' . get_option('invoice_company_name') . '</b><br />';
$order_info .= nl2br(get_option('invoice_company_address')) . '<br/>';
$order_info .= get_option('invoice_company_city') . ', ';
$order_info .= get_option('invoice_company_state') . ', ';
$order_info .= get_option('invoice_company_postal_code') . '<br/> ';
$order_info .= get_country_name(get_option('invoice_company_country_code')) . '<br/> ';
if(get_option('invoice_company_phonenumber') != ''){
    $order_info .='<abbr title="Phone">P:</abbr>'. get_option('invoice_company_phonenumber'); 
  } 
// check for company custom fields
$custom_company_fields = get_company_custom_fields();
if(count($custom_company_fields) > 0){
    $order_info .= '<br />';
}
foreach($custom_company_fields as $field){
    $order_info .= $field['label'] . ':' . $field['value'] . '<br />';
}
$pdf->writeHTMLCell(91, '', '', $y, $order_info, 0, 0, false, true, 'J', true);

// Quote to
$client_details = '<b>' ._l('quote_to') . '</b><br />';
$client_details .= '<b>' .$order->supplier->supplier. '</b><br />';
$client_details .= nl2br($order->supplier->address) . '<br />' . $order->supplier->city . ', ' . $order->supplier->state .' , '.$order->supplier->zip.'<br />'.
get_country_name($order->supplier->country) .'<br />';

if (!empty($order->supplier->vat)) {
    $client_details .= _l('quote_vat') . ' ' . $order->supplier->vat . '<br />';
}

$inserted_customer_custom_field = false;
// check for quote custom fields which is checked show on pdf
$pdf_custom_fields = get_custom_fields('customers',array('show_on_pdf'=>1));
foreach($pdf_custom_fields as $field){
    $value = get_custom_field_value($order->supplierid,$field['id'],'customers');
    if($value == ''){continue;}
    $inserted_customer_custom_field = true;
    $client_details .= $field['name'] . ': ' . $value . '<br />';
}

if($inserted_customer_custom_field){
    $client_details .= '<br />';
}

$pdf->writeHTMLCell(99, '', '', '', $client_details, 0, 1, false, true, 'R', true);
// ship to to
if($order->include_shipping == 1 && $order->show_shipping_on_quote == 1){
    $pdf->Ln(5);
    $shipping_details = '<b>' ._l('ship_to') . '</b><br />';
    $shipping_details .= $order->shipping_street . '<br />' . $order->shipping_city . ', ' . $order->shipping_city .'<br />'.
    get_country_short_name($order->shipping_country) . ',' . $order->shipping_zip;
    $pdf->writeHTMLCell(191, '', '', '', $shipping_details, 0, 1, false, true, 'R', true);
    $pdf->Ln(5);
}
// Dates
$pdf->Cell(0, 0, 'PO Date' . ': ' . _d($order->podate), 0, 1, 'R', 0, '', 0);
if (!empty($order->expirydate)) {
    $pdf->Cell(0, 0, 'Expected Date: ' . _d($order->expecteddate), 0, 1, 'R', 0, '', 0);
}
if (!empty($order->reference_no)) {
    $pdf->Cell(0, 0, _l('reference_no') . ': ' . $order->reference_no, 0, 1, 'R', 0, '', 0);
}
if($order->sale_agent != 0){
    if(get_option('show_sale_agent_on_orders') == 1){
       $pdf->Cell(0, 0, _l('sale_agent_string') . ': ' .  get_staff_full_name($order->sale_agent), 0, 1, 'R', 0, '', 0);
   }
}
// check for quote custom fields which is checked show on pdf
$pdf_custom_fields = get_custom_fields('order',array('show_on_pdf'=>1));
foreach($pdf_custom_fields as $field){
    $value = get_custom_field_value($order->id,$field['id'],'order');
    if($value == ''){continue;}
    $pdf->Cell(0, 0, $field['name'] . ': ' .  $value, 0, 1, 'R', 0, '', 0);
}
// The Table
$pdf->Ln(5);
// Header
$tblhtml = '<table width="100%" bgcolor="#fff" cellspacing="0" cellpadding="5" border="0">
<tr height="30" bgcolor="#3A4656" style="color:#fff;text-align:center;">
	<th width="5%;">#</th>
	<th width="44%" align="left">'._l('order_table_item_heading').'</th>
	<th width="6%">'._l('order_table_quantity_heading').'</th>
	<th width="15%">'._l('order_table_rate_heading').'</th>
	<th width="10%">'._l('discount').'</th>
	<th width="10%">'._l('order_table_tax_heading').'</th>
	<th width="15%">'._l('order_table_amount_heading').'</th>
</tr>';
// Items
$taxes   = array();
$i       = 1;
$tblhtml .= '<tbody>';
 $CI =& get_instance();
foreach ($order->items as $item) {
    $tblhtml .= '<tr style="text-align:center;font-size:9px;">';
    $tblhtml .= '<td>' . $i . '</td>';
    $tblhtml .= '<td align="left">' . $item['description'] . '<br />'.$item['long_description'].'</td>';
    $tblhtml .= '<td>' . floatVal($item['qty']) . '</td>';
    $tblhtml .= '<td>' . _format_number($item['rate']) . '</td>';
      $disc = $CI->purchaseorders_model->get_discount($item['disc']);
    $disc = ($disc !== null ? $disc : 0);
    $tblhtml .= '<td>'.$disc.'%</td>';
    $taxrate = ($item['taxrate'] !== null ? $item['taxrate'] : 0);
    $tblhtml .= '<td>' . _format_number($taxrate) . '%</td>';
    $tblhtml .= '<td class="amount">' . _format_number(($item['qty'] * $item['rate'])) . '</td>';
    $tblhtml .= '</tr>';
    if ($item['taxid']) {
        if (!array_key_exists($item['taxid'], $taxes)) {
            if ($item['taxrate'] != null) {
                $calculated_tax        = (($item['qty'] * $item['rate']) / 100 * $item['taxrate']);
                $taxes[$item['taxid']] = $calculated_tax;
            }
        } else {
            $taxes[$item['taxid']] += $calculated_tax = (($item['qty'] * $item['rate']) / 100 * $item['taxrate']);
        }
    }
    $i++;
}
$tblhtml .= '</tbody>';
$tblhtml .= '</table>';
$pdf->writeHTML($tblhtml, true, false, false, false, '');

$pdf->Ln(8);
$tbltotal = '';
$tbltotal .= '<table cellpadding="6">';
$tbltotal .= '
<tr>
	<td align="right" width="80%">'._l('order_subtotal').'</td>
	<td align="right" width="20%">' . _format_number($order->subtotal) . '</td>
</tr>';
if($order->discount_total != 0){
    $tbltotal .= '
    <tr>
        <td align="right" width="80%">'.  _l('quote_discount') . '('. get_discount_percent($order->discount_percent) .'%)'.'</td>
        <td align="right" width="20%">-' . _format_number($order->discount_total) . '</td>
    </tr>';
}
foreach ($taxes as $taxid => $total) {
    $_tax = get_tax_by_id($taxid);
    if($order->discount_percent != 0 && $order->discount_type == 'before_tax'){
        $total_tax_calculated = ($total * get_discount_percent($order->discount_percent)) / 100;
        $total = ($total - $total_tax_calculated);
    }
    $tbltotal .= '<tr>
    <td align="right" width="80%">' . $_tax->name . '(' . _format_number($_tax->taxrate) . '%):' . '</td>
    <td align="right" width="20%">' . _format_number($total) . '</td>
</tr>';
}
if ($order->adjustment != '0.00') {
    $tbltotal .= '<tr>
    <td align="right" width="80%">'._l('order_adjustment').'</td>
    <td align="right" width="20%">' . _format_number($order->adjustment) . '</td>
</tr>';
}
$tbltotal .= '
<tr style="background-color:#f0f0f0;">
	<td align="right" width="80%">'._l('order_total').'</td>
	<td align="right" width="20%">' . format_money($order->total, $order->symbol) . '</td>
</tr>';

$tbltotal .= '</table>';

$pdf->writeHTML($tbltotal, true, false, false, false, '');

if (!empty($order->clientnote)) {
    $pdf->Ln(4);
    $pdf->MultiCell(190, 0, _l('order_note') . ' ' . clear_textarea_breaks($order->clientnote),0,'L');
}

if (!empty($order->terms)) {
    $pdf->Ln(4);
    $pdf->Cell(0, 0, _l('terms_and_conditions'), 0, 1, 'L', 0, '', 0);
    $pdf->Ln(2);
    $pdf->MultiCell(190, 0, clear_textarea_breaks($order->terms),0,'L');
}
