<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <?php include_once(APPPATH . 'views/admin/includes/alerts.php'); ?>
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-heading">
                        <?php echo $title; ?>
                    </div>

                    <div class="panel-body">
                        <a href="javascript:void(0)" class="btn btn-info pull-left mbot20 display-block addcategory">
                            <?php echo _l('sub_new_category'); ?></a>
                        <div class="clearfix"></div>
                        <div class="col-md-6">
                            <div class="panel-body" id="addcategoryform" style="display:none;">
                                <?php
                                $attributes = array('id' => 'category_form');
                                echo form_open($this->uri->uri_string(), $attributes);
                                ?>
                                <div class="form-group">
                                    <label for="category" class="control-label">
                                        Category</label>
                                    <select name="category" class="form-control selectpicker" id="category" data-live-search="true">
                                        <option value=""></option>
                                        <?php foreach (get_all_categories() as $cat) { ?>
                                            <option value="<?php echo $cat->category_id; ?>"><?php echo $cat->category_name; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
<?php echo render_input('categoryname', 'Sub Category Name'); ?>
                                <?php echo render_input('description', 'Description'); ?>
                                <div class="checkbox checkbox-primary">
                                    <input type="checkbox" value="1" name="cat_is_active" id="cat_is_active">                            
                                    <label>Is Active</label>
                                </div>
                                <input type="hidden"  name="cat_id" id="cat_id">
                                <button type="button" id="cformclose" class="btn btn-primary pull-right closebtn"><?php echo _l('close'); ?></button>
                                <button type="button"   class="btn btn-primary pull-right categorysubmitform closebtn"><?php echo _l('submit'); ?></button>
<?php echo form_close(); ?>
                            </div>
                            <div class="panel-body" id="addcategory" style="display:none;">
<?php
$attributes = array('id' => 'add_category_form');
echo form_open($this->uri->uri_string(), $attributes);
?>
                                <div class="form-group">
                                    <label for="category" class="control-label">
                                        Category</label>
                                    <select name="category" class="form-control selectpicker" id="category" data-live-search="true">
                                        <option value=""></option>
<?php foreach (get_all_categories() as $cat) { ?>
                                            <option value="<?php echo $cat->category_id; ?>"><?php echo $cat->category_name; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                                        <?php echo render_input('addcategory', 'Sub Category Name'); ?>
<?php echo render_input('adddescription', 'Description'); ?>
                                <div class="checkbox checkbox-primary">
                                    <input type="checkbox" value="1" name="addactive" id="addactive">                            
                                    <label>Is Active</label>
                                </div>                                
                                <button type="button" id="cformclose" class="btn btn-primary pull-right closebtn"><?php echo _l('close'); ?></button>
                                <button type="button"   class="btn btn-primary pull-right addcategory_details closebtn"><?php echo _l('submit'); ?></button>
<?php echo form_close(); ?>
                            </div>
                        </div>
                        <div class="clearfix"></div>
<?php
render_datatable(array(
    _l('category_name'),
    _l('sub_cat_name'),
    _l('sub_cat_description'),
    _l('sub_cat_item'),
    _l('sub_cat_isactive'),
    _l('options'),
        ), 'subcategories');
?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php
init_tail();
include_once(APPPATH . 'views/admin/subcategories/modals/add_subcategory.php');
include_once(APPPATH . 'views/admin/subcategories/modals/update_subcategory.php');
?>
<script>
    $(document).ready(function () {
        $('.addcategory').on('click', function (e) {
            e.preventDefault();
            $('#add_subcategory_modal').modal('show');
        });


        initDataTable('.table-subcategories', admin_url + 'subcategories', 'sub categories', [4], [4]);



    });

    $(document).on('click', '.edit-category', function () {

        var id = $(this).attr('data-id');
        $.ajax({
            type: "POST",
            url: admin_url + 'subcategories/get_category',
            data: {id: id},
            dataType: 'json',
            success: function (response) {
                $('#edit_subcategory_modal').modal('show');
                $('#edit_subcategory_form #category').selectpicker('deselectAll');
                $('#edit_subcategory_form #sales,#inventory,#cogs').selectpicker('deselectAll');
                $('#edit_subcategory_form #category').selectpicker('val', response.catid);
                $('#edit_subcategory_form #category').selectpicker('refresh');
                $('#edit_subcategory_form #sales').selectpicker('val', response.sales);
                $('#edit_subcategory_form #sales').selectpicker('refresh');
                $('#edit_subcategory_form #inventory').selectpicker('val', response.inventory);
                $('#edit_subcategory_form #inventory').selectpicker('refresh');
                $('#edit_subcategory_form #cogs').selectpicker('val', response.cogs);
                $('#edit_subcategory_form #cogs').selectpicker('refresh');
                $('#edit_subcategory_form #categoryname').val(response.subcategory_name);
                $('#edit_subcategory_form #description').val(response.description);
                $('#edit_subcategory_form #cat_id').val(response.subcategory_id);
                if (response.active == '1') {
                    $('#edit_subcategory_form input[name="cat_is_active"]').prop('checked', true);
                }
                else {
                    $('#edit_subcategory_form input[name="cat_is_active"]').prop('checked', false);
                }

                 if (response.show_in_cart == '1') {
                    $('#edit_subcategory_form input[name="show_in_cart"]').prop('checked', true);
                }
                else {
                    $('#edit_subcategory_form input[name="show_in_cart"]').prop('checked', false);
                }


            }
        });
    });



    $(document).on('click', '.ischeckbox', function () {
        var current = $(this);
        $.ajax({
            url: admin_url + "subcategories/changestatus",
            data: {id: $(this).data('rowid'), rowtype: $(this).data('rowtype')},
            dataType: 'json',
            type: 'post',
            success: function (response)
            {

            }
        });
    });
</script>
</body>
</html>
