<?php init_head(); ?>
<div id="wrapper">
	<div class="content">
		<div class="row">
			<?php include_once(APPPATH . 'views/admin/includes/alerts.php'); ?>
			<?php if(isset($member)){ ?>
			<div class="member">
				<?php echo form_hidden('isedit'); ?>
				<?php echo form_hidden('memberid',$member->staffid); ?>
			</div>
			<?php } ?>
			<?php echo form_open($this->uri->uri_string(),array('class'=>'staff-form')); ?>
			<div class="col-md-6">
				<div class="panel_s">
					<div class="panel-heading">
						<?php echo $title; ?>
					</div>
					<div class="panel-body">
						<!-- <?php if(isset($member)){ ?>
						<a href="<?php echo admin_url('staff/member'); ?>" class="btn btn-success pull-right mbot20 display-block"><?php echo _l('new_staff'); ?></a>
						<?php } ?> -->

						<div class="form-group">
                            <label class="control-lable">Salutation</label>
                            
                            <select class="form-control selectpicker" name="salutation" disabled="true">
                                <option value=""></option>
                                <?php 
                                    foreach ($salutation as $value) { 
                                ?>
                                    
                                    <option value="<?php echo $value->id; ?>" <?php if(isset($member)){ if($member->salutation == $value->id){ echo "selected"; }}?>><?php echo $value->description; ?></option>
                                <?php } ?>
                            </select>
                            
                        </div>

						<div class="clearfix"></div>
						<?php $value = (isset($member) ? $member->firstname : ''); ?>

						
                        <div class="form-group">
                            <label class="control-label">Firstname</label>
                            <input type="text" id="firstname" name="firstname" class="form-control"  value="<?php echo $value; ?>" disabled>
                        </div>
						

						<?php $value = (isset($member) ? $member->lastname : ''); ?>
						

						<div class="form-group">
                            <label class="control-label">Lastname</label>
                            <input type="text" id="lastname" name="lastname" class="form-control"  value="<?php echo $value; ?>" disabled>
                        </div>

						<div class="form-group">
                            <label for="country" class="control-label">Country</label>
                            <select name="country" class="form-control selectpicker" id="country" data-live-search="true" disabled>
                                <?php if (!isset($member)) { ?>
                                    <option value=""></option>
                                <?php } ?>
                                <?php
                                foreach (get_all_countries() as $country) {
                                    $selected = '';
                                    if (isset($member)) {
                                        if ($member->country == $country['country_id']) {
                                            $selected = 'selected';
                                        }
                                    } else {
                                        if (get_option('employee_default_country') == $country['country_id']) {
                                            $selected = 'selected';
                                        }
                                    }
                                    ?>
                                    <option value="<?php echo $country['country_id']; ?>" <?php echo $selected; ?>><?php echo $country['short_name']; ?></option>
                                <?php } ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="address" class="control-label">Address</label>
                            <textarea name="address" rows="2" cols="15" class="form-control selectpicker" id="address" data-live-search="true" disabled><?php echo (isset($member) ? $member->address : '') ?></textarea>
                        </div>

                        <?php $value = (isset($member) ? $member->city : ''); ?>
                        
                        <div class="form-group">
                            <label class="control-label">City</label>
                            <input type="text" id="city" name="city" class="form-control"  value="<?php echo $value; ?>" disabled>
                        </div>

                        <?php $value = (isset($member) ? $member->state : ''); ?>
                        <div class="form-group">
                            <label class="control-label">State</label>
                            <input type="text" id="state" name="state" class="form-control"  value="<?php echo $value; ?>" disabled>
                        </div>

                        <?php $value = (isset($member) ? $member->postal_code : ''); ?>
                        <div class="form-group">
                            <label class="control-label">Postal Code</label>
                            <input type="text" id="postal_code" name="postal_code" class="form-control"  value="<?php echo $value; ?>" disabled>
                        </div>

                        <div class="form-group">
                            <label class="control-label">Department</label>
                            <select name="department[]" class="form-control selectpicker" multiple="" disabled>
                                <option value=""></option>
                                <?php 
                                    $selected = "";
                                    foreach ($departments as $value) { 
                                       
                                ?>
                                    
                                    <option value="<?php echo $value['departmentid']; ?>" <?php if(isset($member)){ if(in_array($value['departmentid'], $department)){ echo "selected"; }} ?>><?php echo $value['name']; ?></option>
                                <?php } ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label class="control-label">Position</label>
                            <select name="position" class="form-control selectpicker" disabled>
                                <option value=""></option>
                               <?php 
                                    $selected = "";
                                    foreach ($postion as $value) { 
                                        
                                ?>
                                    
                                    <option value="<?php echo $value->id; ?>" <?php if(isset($member)){ if($value->id == $member->position){ echo "selected"; }} ?>><?php echo $value->description; ?></option>
                                <?php } ?>
                            </select>
                        </div>

                        <?php
                            $value = "";
                            if(isset($member)){
                                $value = $member->username;
                            }
                         ?>
                        <div class="form-group">
                            <label class="control-label">Username</label>
                            <input type="text" id="username" name="username" class="form-control"  value="<?php echo $value; ?>" disabled>
                        </div>



						<?php $value = (isset($member) ? $member->email : ''); ?>
						 <div class="form-group">
                            <label class="control-label">Email</label>
                            <input type="text" id="email" name="email" class="form-control"  value="<?php echo $value; ?>" disabled>
                        </div>
						

						<?php $value = (isset($member) ? $member->phonenumber : ''); ?>
						 <div class="form-group">
                            <label class="control-label">Phone number</label>
                            <input type="text" id="phonenumber" name="phonenumber" class="form-control"  value="<?php echo $value; ?>" readonly>
                        </div>

						<div class="form-group">
							<label for="facebook" class="control-label"><i class="fa fa-facebook"></i> <?php echo _l('staff_add_edit_facebook'); ?></label>
							<input type="text" class="form-control" name="facebook" value="<?php if(isset($member)){echo $member->facebook;} ?>">
						</div>
						<div class="form-group">
							<label for="linkedin" class="control-label"><i class="fa fa-linkedin"></i> <?php echo _l('staff_add_edit_linkedin'); ?></label>
							<input type="text" class="form-control" name="linkedin" value="<?php if(isset($member)){echo $member->linkedin;} ?>">
						</div>
						<div class="form-group">
							<label for="skype" class="control-label"><i class="fa fa-skype"></i> <?php echo _l('staff_add_edit_skype'); ?></label>
							<input type="text" class="form-control" name="skype" value="<?php if(isset($member)){echo $member->skype;} ?>">
						</div>
						<!-- <div class="form-group">
							<label for="departments"><?php echo _l('staff_add_edit_departments'); ?></label>
							<?php foreach($departments as $department){ ?>
							<div class="checkbox checkbox-primary">
								<?php
								$checked = '';
								if(isset($member)){
									foreach ($staff_departments as $staff_department) {
										if($staff_department['departmentid'] == $department['departmentid']){
											$checked = ' checked';
										}
									}
								}
								?>
								<input type="checkbox" name="departments[]" value="<?php echo $department['departmentid']; ?>"<?php echo $checked; ?>>
								<label><?php echo $department['name']; ?></label>
							</div>
							<?php } ?>
						</div> -->
						<?php $rel_id = (isset($member) ? $member->staffid : false); ?>
						<?php echo render_custom_fields('staff',$rel_id); ?>

						<div class="form-group">
                            <label class="control-label">Role</label>
                            <select name="position" class="form-control selectpicker" disabled>
                                <option value=""></option>
                               <?php 
                                    $selected = "";
                                    foreach ($roles as $role) { 
                                        
                                ?>
                                    
                                    <option value="<?php echo $role['roleid']; ?>" <?php if(isset($member)){ if($member->role == $role['roleid']){ echo "selected"; }} ?>><?php echo $role['name']; ?></option>
                                <?php } ?>
                            </select>
                        </div>


						

						<div class="form-group" id="staff_permissions">
							
							
							<?php if (is_admin()){ ?>
							<div class="row">

								<div class="col-md-12">
									<hr />
									<div class="checkbox checkbox-primary">
										<?php
										$isadmin = '';
										if(isset($member)) {
											if($member->staffid == get_staff_user_id() || is_admin($member->staffid)){
												$isadmin = ' checked';
											}
										}
										?>
										<input type="checkbox" name="administrator" <?php echo $isadmin; ?>>
										<label><?php echo _l('staff_add_edit_administrator'); ?></label>
									</div>
								</div>
							</div>
							<?php } ?>
						</div>
	<div class="clearfix form-group"></div>
						<label for="password" class="control-label"><?php echo _l('staff_add_edit_password'); ?></label>
						<div class="input-group">
							<input type="text" class="form-control password" name="password">
							<span class="input-group-addon">
								<a href="#" class="generate_password" onclick="generatePassword(this);return false;"><i class="fa fa-refresh"></i></a>
							</span>
						</div>
						<?php if(isset($member) && $member->last_password_change != NULL){ ?>
						<p class="text-muted"><?php echo _l('staff_add_edit_password_note'); ?></p>
						<?php echo _l('staff_add_edit_password_last_changed'); ?>: <?php echo time_ago($member->last_password_change); ?>
						<?php } ?>
						<button type="submit" class="btn btn-primary pull-right mtop20"><?php echo _l('submit'); ?></button>

					</div>
				</div>
			</div>
			<div class="col-md-6">
				<div class="panel_s">
					<div class="panel-heading">
						<?php echo _l('advanced_options'); ?>
					</div>
					<div class="panel-body">
						<div class="form-group">
							<label for="default_language" class="control-label"><?php echo _l('localization_default_language'); ?></label>
							<select name="default_language" id="default_language" class="form-control selectpicker">
								<option value=""><?php echo _l('system_default_string'); ?></option>
								<?php foreach(list_folders(APPPATH .'language') as $language){
									$selected = '';
									if(isset($member)){
										if($member->default_language == $language){
											$selected = 'selected';
										}
									}
									?>
									<option value="<?php echo $language; ?>" <?php echo $selected; ?>><?php echo ucfirst($language); ?></option>
									<?php } ?>
								</select>
							</div>

						</div>
					</div>
				</div>
				<?php echo form_close(); ?>
				<?php if(isset($member)){ ?>
				<div class="col-md-6">
					<div class="panel_s">
						<div class="panel-heading">
							<?php echo _l('staff_add_edit_notes'); ?>
							<a href="#" class="btn btn-success btn-icon pull-right" onclick="slideToggle('.usernote'); return false;"><i class="fa fa-plus"></i></a>
						</div>
						<div class="panel-body">
							<div class="row usernote hide">
								<div class="col-md-12">
									<?php echo form_open(admin_url('misc/add_user_note/'.$member->staffid . '/1')); ?>
									<?php echo render_textarea('description','staff_add_edit_note_description','',array('rows'=>5)); ?>
									<button class="btn btn-primary pull-right"><?php echo _l('submit'); ?></button>
									<?php echo form_close(); ?>
								</div>
							</div>
							<?php if(count($user_notes) > 0){ ?>
							<div class="table-responsive">
								<table class="table">
									<thead>
										<tr>
											<th><?php echo _l('staff_notes_table_description_heading'); ?></th>
											<th><?php echo _l('staff_notes_table_addedfrom_heading'); ?></th>
											<th><?php echo _l('staff_notes_table_dateadded_heading'); ?></th>
											<th><?php echo _l('options'); ?></th>
										</tr>
									</thead>
									<tbody>
										<?php foreach($user_notes as $note){ ?>
										<tr>
											<td><?php echo $note['description']; ?></td>
											<td><?php echo $note['firstname'] . ' ' . $note['lastname']; ?></td>
											<td><?php echo _dt($note['dateadded']); ?></td>
											<td><a href="<?php echo admin_url('misc/remove_user_note/'.$note['usernoteid'] . '/' .$member->staffid .'/1'); ?>" class="btn btn-danger btn-icon"><i class="fa fa-remove"></i></a></td>
										</tr>
										<?php } ?>
									</tbody>
								</table>
							</div>
							<?php } else { ?>
							<p class="no-margin"><?php echo _l('staff_no_user_notes_found'); ?></p>
							<?php } ?>
						</div>
					</div>
				</div>
				<?php } ?>
			</div>
		</div>
		<?php init_tail(); ?>
		<script>
			init_roles_permissions();
			_validate_form($('.staff-form'),{
				firstname:'required',
				lastname:'required',
				username:'required',
				password: {
					required: {
						depends: function(element){
							return ($('input[name="isedit"]').length == 0) ? true : false
						}
					}
				},
				email: {
					required:true,
					email:true,
					remote:{
						url: site_url + "admin/misc/staff_email_exists",
						type:'post',
						data: {
							email:function(){
								return $('input[name="email"]').val();
							},
							memberid:function(){
								return $('input[name="memberid"]').val();
							}
						}

					}
				}
			});
		</script>
	</body>
	</html>
