<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <?php include_once(APPPATH . 'views/admin/includes/alerts.php'); ?>
            <div class="col-md-12" id="small-table"><h5 class="customer-heading-profile bold" style="padding-left:5px;font-size:18px"> 
 <i class="fa fa-user" style="padding:5px"></i><?php echo $title; ?></h5>   
                <?php echo form_hidden('custom_view'); ?>
                <div class="panel_s" style="display:none">
                    <div class="panel-body">
                        <a href="<?php echo admin_url('leads/lead'); ?>" class="btn new-lead mright5 btn-info pull-left display-block">
                            <?php echo _l('new_lead'); ?>
                        </a>
                        <?php if (is_admin()) { ?>
                            <a href="<?php echo admin_url('leads/import'); ?>" class="btn btn-info pull-left display-block">
                                <?php echo _l('import_leads'); ?>
                            </a>
                        <?php } ?>
                        <div class="row">
                            <div class="col-md-5">
                                <a href="#" class="btn btn-default" onclick="slideToggle('.leads-overview'); return false;"><i class="fa fa-bar-chart"></i></a>
                                <a href="#" class="btn btn-default mleft5 toggle-custom-kan-ban-tab"><i class="fa fa-th-list"></i></a>
                            </div>
                            <div class="col-md-4 col-xs-12 pull-right leads-search">
                                <?php echo render_input('search[]', '', '', 'search', array('data-name' => 'search', 'onkeyup' => 'leads_canban(this.value);', 'placeholder' => _l('leads_search')), array(), 'no-margin') ?>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                        <div class="row hide leads-overview">
                            <hr />
                            <div class="col-md-12">
                                <h3 class="text-success no-margin"><?php echo _l('leads_summary'); ?></h3>
                            </div>
                            <?php
                            $numStatuses = count($statuses);
                            foreach ($statuses as $status) {
                                ?>
                                <div class="col-md-2 border-right">
                                    <h3 class="bold"><?php echo total_rows('tblleads', array('status' => $status['id'])); ?></h3>
                                    <span class="<?php if ($status['isdefault'] == 1) {
                                echo 'text-success';
                            } else {
                                echo 'text-info';
                            } ?> bold"><?php echo $status['name']; ?></span>
                                </div>
                                <?php } ?>
                                <?php $total_leads = total_rows('tblleads'); ?>
                            <div class="col-md-2">
<?php
$total_lost = total_rows('tblleads', array('lost' => 1));
$percent_lost = ($total_leads > 0 ? number_format(($total_lost * 100) / $total_leads, 2) : 0);
?>
                                <h3 class="bold"><?php echo $percent_lost; ?>%</h3>
                                <span class="text-danger bold"><?php echo _l('lost_leads'); ?></span>
                            </div>
                            <div class="col-md-2">
<?php
$total_junk = total_rows('tblleads', array('junk' => 1));
$percent_junk = ($total_leads > 0 ? number_format(($total_junk * 100) / $total_leads, 2) : 0);
?>
                                <h3 class="bold"><?php echo $percent_junk; ?>%</h3>
                                <span class="text-danger bold"><?php echo _l('junk_leads'); ?></span>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="panel_s mtop5">
                    <div class="panel-body fadeIn">
                   
                            <div class="leftmenu" style="position: absolute;">
                                <a href="<?php echo admin_url('leads/lead'); ?>" class="btn new-lead mright10 btn-info pull-left display-block">
<?php echo _l('new_lead'); ?>
                                </a>
                 <select id="searchorder" class="selectpicker" data-width="350px" >
                                    <option data-type="all" value="">All</option>
                                    <option data-type="status" value="lost">Lost</option>
                                    <option data-type="status" value="junk">Junk</option>
                                    <option data-type="status" value="not_assigned">Not Assigned</option>
                                    <option data-type="type" value="2">New</option>
                                    <option data-type="type" value="1">Client</option>
                                </select>
                            </div>
                            <div class="clearfix"></div>


                            <?php
                            $table_data = array(
                                _l('leads_dt_name'),
                                 'Date',
                                 'Country',
                                 'Description',
                                _l('leads_dt_email'),
                                _l('leads_dt_phonenumber'),
                                _l('leads_dt_assigned'),
                                _l('leads_dt_status'));
//                        _l('leads_dt_last_contact'));
                            $custom_fields = get_custom_fields('leads', array('show_on_table' => 1));
                            foreach ($custom_fields as $field) {
                                array_push($table_data, $field['name']);
                            }
                            array_push($table_data, _l('options'));
                            render_datatable($table_data, 'leads');
                            ?>
                
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<div class="modal fade kan-ban-lead-modal" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">

            <div class="modal-body">
            </div>
        </div>
    </div>
</div>

<div class="modal fade modal-chart" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">

            <div class="modal-body">
                <canvas class="chart" id="leads-report-by-statuses"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="modal animated fadeIn" id="convert_lead_to_client_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
<?php echo form_open('admin/leads/convert_to_client', array('id' => 'lead_to_client_form')); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close convert-client-close-modal"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">
                <?php echo _l('lead_convert_to_client'); ?>
                </h4>
            </div>
            <div class="modal-body">
                <input type="hidden" id="leadid" name="leadid"/>
                <input type="hidden" id="phonenumber" name="phonenumber"/>
                <input type="hidden" id="country" name="country"/>
    <?php echo render_input('firstname', 'lead_convert_to_client_firstname', ''); ?>
    <?php echo render_input('lastname', 'lead_convert_to_client_lastname', ''); ?>
    <?php echo render_input('email', 'lead_convert_to_email', ''); ?>

<?php echo form_hidden('original_lead_email', $lead->email); ?>
                <div class="client_password_set_wrapper">
                    <label for="password" class="control-label"><?php echo _l('client_password'); ?></label>
                    <div class="input-group">
                        <input type="text" class="form-control password" id="password" name="password">
                        <span class="input-group-addon">
                            <a href="#" class="generate_password" onclick="generatePassword(this);return false;"><i class="fa fa-refresh"></i></a>
                        </span>
                    </div>
                </div>
                <div class="checkbox checkbox-primary">
                    <input type="checkbox" name="send_set_password_email">
                    <label>
<?php echo _l('client_send_set_password_email'); ?>
                    </label>
                </div>
                <div class="checkbox checkbox-primary">
                    <input type="checkbox" name="donotsendwelcomeemail">
                    <label><?php echo _l('client_do_not_send_welcome_email'); ?></label>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default convert-client-close-modal"><?php echo _l('close'); ?></button>
                <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
            </div>
        </div>
<?php echo form_close(); ?>
    </div>
</div>

<script src="<?php echo site_url('assets/js/leads.js'); ?>"></script>
<script>
 $('#searchorder').change(function(){
          var id = $(this).val();
          var type = $('#searchorder option:selected').data('type');
          if(type=='all'){
             dt_custom_view('','.table-leads'); return false;
         }else{
            dt_custom_view(id,'.table-leads'); return false;
         }
     
           
       });
</script>
</body>
</html>
