<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <?php include_once(APPPATH . 'views/admin/includes/alerts.php'); ?>
            <div class="col-md-12">
                <h2>Holiday</h2>
                <div class="panel_s">
                    <div class="panel-body tableNoMTop">
    					<div class="absoluteBtns">
                            <a href="#" class="btn btn-info pull-left addform" data-toggle="modal" data-target="#holiday_modal"><?php echo _l('add_holiday'); ?></a>
                        </div>
                        <div class="clearfix"></div>
                        <input type="hidden" value="<?php echo get_option('tables_pagination_limit'); ?>" id="paging">
                        <div class="table-resposive">
                            <table id="example" class="table table-striped table-bordered" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Occasion</th>
                                        <th>Note</th>
                                        <th><?php echo _l('options'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($holidays as $holiday)
                                    {
                                    ?>
                                    <tr>
                                        <td><?php echo date('d/m/Y',strtotime($holiday->date)); ?></td>
                                        <td><?php echo $holiday->occasion; ?></td>
                                        <td><?php echo $holiday->note; ?></td>
                                        <td>

                                            <a href="javascript:void(0)" class="btn btn-default btn-icon" data-toggle="modal" data-target="#holiday_modal" data-id="<?php echo $holiday->id; ?>"><i class="fa fa-pencil-square-o"></i></a>

                                            <a onClick="return deleteconf();" href="<?php echo admin_url('holidays/delete/'.$holiday->id) ?>" class="btn  delete-items btn-icon"><i class="fa fa-remove"></i></a>
                                        </td>

                                        

                                    </tr>
                                    <?php
                                        }
                                         
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal animated fadeIn" id="holiday_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button group="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">
                    <span class="edit-title"><?php echo _l('edit_holiday'); ?></span>
                    <span class="add-title"><?php echo _l('add_holiday'); ?></span>
                </h4>
            </div>
            <?php echo form_open('admin/holidays/holiday'); ?>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">

                        <?php $value = ''; ?>

                        <?php echo render_date_input('date','Date',$value); ?>

                        <?php echo render_input('occasion', 'Occasion'); ?>

                        <div class="form-group">
                            <label class="control-label">Note</label>
                            <textarea name="note" rows="2" cols="15" class="form-control selectpicker" id="note" data-live-search="true"></textarea>
                        </div>
                        
                        <input type="hidden" name="id" id="id">
                        
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" data-dismiss="modal">Exit</button>
                <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
                <button type="button" class="btn btn-primary addsaveandnew">Save & New</button>
            <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.13/css/dataTables.bootstrap.min.css">
<script type="text/javascript" src="https://cdn.datatables.net/1.10.15/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.15/js/dataTables.bootstrap.min.js"></script>

<script>
   
    _validate_form($('form'), {
        occasion: 'required'
    }, manage_holiday);
    // initDataTable('.table-customer-groups', window.location.href, 'groups', [2], [2]);
    function manage_holiday(form) {

        var data = $(form).serialize();

        var url = form.action;
        $.post(url, data).success(function (response) {
            response = $.parseJSON(response);
            if (response.success == true) {

                // $('.table-customer-groups').DataTable().ajax.reload();
                location.reload();
                alert_float('success', response.message);
            }
            // $('#ledger,#payment_term,#account_req').selectpicker('deselectAll');
            $('#holiday_modal').modal('hide');
            // $('input[name="class_is_active"]').prop('checked', false);
        });

        return false;
    }
    $('#example').DataTable({
        "bLengthChange": false,
        "language": {
            "search": "Find"
        },
        "pageLength": parseInt($('#paging').val()),
    });

    $('.addform').click(function () {
        
        $('#name').val('');
        $('#holiday_modal input[name="id"]').val('');
        $('#holiday_modal .edit-title').addClass('hide');
        $('#holiday_modal .add-title').removeClass('hide');
    });

    $('#holiday_modal').on('show.bs.modal', function (e) {
        var invoker = $(e.relatedTarget);
        var group_id = $(invoker).data('id');
        var data = {id: group_id};
        if (group_id) {
            $('#holiday_modal .add-title').removeClass('hide');
            $('#holiday_modal .edit-title').addClass('hide');
            var url = '<?php echo base_url('admin/holidays/getholiday') ?>';
            $.post(url, data, function (response) {
                $('#occasion').val(response.occasion);
                $('#note').val(response.note);

                // var d = response.date;
                // var day = d.getDate();
                // var month = d.getMonth() + 1;
                // var year = d.getFullYear();
                // if (day < 10) {
                //     day = "0" + day;
                // }
                // if (month < 10) {
                //     month = "0" + month;
                // }
                // var date = day + "/" + month + "/" + year;
                // alert(date);
                $('#date').val(response.date);
                

            }, 'json');

           // $('#holiday_modal input').val('');
            // is from the edit button
            if (typeof (group_id) !== 'undefined') {
                // console.log(group_id);
                $('#holiday_modal input[name="id"]').val(group_id);
                $('#holiday_modal .add-title').addClass('hide');
                $('#holiday_modal .edit-title').removeClass('hide');
                $('#holiday_modal input[name="name"]').val($(invoker).parents('tr').find('td').eq(0).text());
            }
        }
    });

    $(document).ready(function(){

        $('.addsaveandnew').on('click', function (e) {
            if($("form").valid() == true)
            {
                $.ajax({
                    type: "POST",
                    url: admin_url + 'holidays/holiday',
                    // data: {data: $('#add_category_form').serializeArray()},
                    data: {
                        date: $('#date').val(),
                        occasion: $('#occasion').val(),
                        note: $('#note').val(),
                        id: $('#id').val(),
                    },
                    // dataType: 'json',
                    success: function (response) {
                        $('#date').val('');
                        $('#occasion').val('');
                        $('#note').val('');
                        $('#id').val('');
                        $('#holiday_modal').modal('show');  
                    }
                });
            }
        });

      
    });
</script>
</body>
</html>
