<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Warehouse_transfer_model extends CRM_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_list($value='')
    {
        $this->db->select('tblwarehousetransfer.*,tblwarehousetransfer_item.oursku,tblwarehousetransfer_item.qty,tblwarehousetransfer_item.uom');
        $this->db->from('tblwarehousetransfer');
        $this->db->join('tblwarehousetransfer_item','tblwarehousetransfer_item.warehousetransfer_id = tblwarehousetransfer.id');		
		$this->db->group_by('tblwarehousetransfer.id');

        $this->db->order_by('tblwarehousetransfer.date','DESC');
        return $this->db->get()->result(); 
    }

    public function get_warehouse()
    {
        return $this->db->get('tblwarehouse')->result();
    }

    public function get_location($ware_id)
    {
        return $this->db->where('ware_id',$ware_id)->order_by('location_id','ASC')->get('tbllocations')->result(); 
    }

    public function unsel_ware($ware_id)
    {
        return $this->db->where('ware_id !=',$ware_id)->get('tblwarehouse')->result();
    }

    public function get_item($location_id,$warehouse_id)
    {
        $this->db->select('tblwarehousestock.*,tblunitsofmeasure.name,tblunitsofmeasure.id as uomid');
        $this->db->from('tblwarehousestock');
        $this->db->join('tblinvoiceitemslist','tblinvoiceitemslist.sku = tblwarehousestock.suppliersku');
        $this->db->join('tblunitsofmeasure','tblunitsofmeasure.id = tblinvoiceitemslist.unitofmeasure');
        // $this->db->join('tblstaff','tblstaff.staffid = tbladminwarehousereminders.staff');
        $this->db->where('tblwarehousestock.location_id',$location_id);
        $this->db->where('tblwarehousestock.warehouse_id',$warehouse_id);
        $this->db->order_by('tblwarehousestock.id','ASC');
        return $this->db->get()->result(); 
    }

    public function transfer_warehouse($data)
    {
        // echo "<pre>";
        // print_r($this->input->post());
        // die;
        $var = $data['date'];
        $date = str_replace('/', '-', $var);

        $this->db->insert('tblwarehousetransfer', array(
                    'transfer_id' => $data['number'],
                    'date' => date('Y-m-d', strtotime($date)),
                    'from_warehouse' => $data['from_warehouse'],
                    'from_location' => $data['from_location'],
                    'to_warehouse' => $data['to_warehouse'],
                    'to_location' => $data['to_location'],
                
                ));
        $warehousetransfer_id = $this->db->insert_id();

        foreach ($data['warehouse_transfer_id'] as $key => $wh_id) 
        {
            // print_r($data['qty'][$key]);

            if($data['qty'][$key] == "")
            {
                $data['qty'][$key] = 0;
            }
            // echo $data['qty'][$key];

            $this->db->select('tblwarehousestock.*');
            $this->db->from('tblwarehousestock');
            $this->db->where('tblwarehousestock.suppliersku', $data['suppliersku'][$key]);
            $this->db->where('tblwarehousestock.warehouse_id', $data['to_warehouse']);
            $this->db->where('tblwarehousestock.location_id', $data['to_location']);
            $warehouse_stock = $this->db->get()->row();


            if($warehouse_stock)
            {
                $to_warehouse_qty = $warehouse_stock->qty + $data['qty'][$key];
                
                $this->db->where('tblwarehousestock.id', $warehouse_stock->id);
                // $this->db->set('qty', 'qty+'.$data['qty'][$key], FALSE);
                $this->db->set('qty', $to_warehouse_qty, FALSE);
                $this->db->update('tblwarehousestock');

                $this->db->select('tblwarehousestock.*');
                $this->db->from('tblwarehousestock');
                $this->db->where('tblwarehousestock.id',$wh_id);
                $warehousefrom = $this->db->get()->row();

                $from_warehouse_qty = $warehousefrom->qty - $data['qty'][$key];
                $this->db->where('tblwarehousestock.id', $wh_id);
                // $this->db->set('qty', 'qty-'.$data['qty'][$key], FALSE);
                $this->db->set('qty', $from_warehouse_qty, FALSE);
                $this->db->update('tblwarehousestock');

            }
            else
            {
                $this->db->insert('tblwarehousestock', array(
                    'suppliersku' => $data['suppliersku'][$key],
                    'oursku' => $data['oursku'][$key],
                    'description' => $data['description'][$key],
                    'qty' => $data['qty'][$key],
                    'warehouse_id' => $data['to_warehouse'],
                    'location_id' => $data['to_location'],
                    'date' => date('Y-m-d', strtotime($date)),
                    // 'grnid' => $insert_id,
                    
                ));
            }

            
            if($data['qty'][$key] != 0)
            {
                $this->db->insert('tblwarehousetransfer_item', array(
                        'warehousetransfer_id' => $warehousetransfer_id,
                        'suppliersku' => $data['suppliersku'][$key],
                        'oursku' => $data['oursku'][$key],
                        'description' => $data['description'][$key],
                        'qty' => $data['qty'][$key],
                        'uom' => $data['uom'][$key],
                    ));
            }


        }
         // Update next internal transfer number in settings
            $this->db->where('name', 'next_warehouse_transfer');
            $this->db->set('value', 'value+1', FALSE);
            $this->db->update('tbloptions');
        return true;

         

        
        
    }

    public function get_warehousetransfer($id)
    {
        $this->db->select('tblwarehousetransfer.*');
        $this->db->from('tblwarehousetransfer');
        $this->db->where('tblwarehousetransfer.id',$id);
        return $this->db->get()->row(); 
    }

    public function get_warehousetransfer_item($id)
    {
        $this->db->select('tblwarehousetransfer_item.*');
        $this->db->from('tblwarehousetransfer_item');
        $this->db->where('tblwarehousetransfer_item.warehousetransfer_id',$id);
        return $this->db->get()->result(); 
    }
}