<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Warehouse_model extends CRM_Model {

    function __construct() {
        parent::__construct();
    }

    /**
     * Get invoice item by ID
     * @param  mixed $id
     * @return mixed - array if not passed id, object if id passed
     */
    public function get($id = false, $active = '')
    {
        //$this->db->join('tblcountries','tblcountries.country_id = tblclients.country', 'left');

        if (is_int($active)) {
            $this->db->where('active', $active);
        }

        if (is_numeric($id)) {
            $this->db->where('ware_id', $id);
            $client = $this->db->get('tblwarehouse')->row();

            return $client;
        }

        //$this->db->order_by('datecreated', 'desc');
        return $this->db->get('tblwarehouse')->result_array();
    }

 public function getcontact($id){
     return $this->db->where('contact_id', $id)->get('tblwarehousecontacts')->row();  
}
    
public function addcontact(){
    $data=array('salutation' => $this->input->post('salutation'),
        'firstname' => $this->input->post('firstname'),
        'lastname'  => $this->input->post('lastname'),
        'country'  => $this->input->post('country'),
        'address'  => $this->input->post('address'),
        'city'     => $this->input->post('city'),
        'state'    => $this->input->post('state'),
        'zip'      => $this->input->post('zip'),
        'phoneno'  => $this->input->post('phoneno'),
        'mobileno' => $this->input->post('mobileno'),
        'fax'      => $this->input->post('fax'),
        'email'    => $this->input->post('email'),
        'skypeid'  => $this->input->post('skypeid'),
        'position' => $this->input->post('position'),
        'status'   => $this->input->post('status'),
        'department_id'   => $this->input->post('department'),
        'ware_id'   => $this->input->post('ware_id'));
    $res=$this->db->insert('tblwarehousecontacts', $data);  
    return $this->db->insert_id();
    
}

public function updateContacts($contactid)
{
     $data=array('salutation' => $this->input->post('salutation'),
        'firstname' => $this->input->post('firstname'),
        'lastname'  => $this->input->post('lastname'),
        'country'  => $this->input->post('country'),
        'address'  => $this->input->post('address'),
        'city'     => $this->input->post('city'),
        'state'    => $this->input->post('state'),
        'zip'      => $this->input->post('zip'),
        'phoneno'  => $this->input->post('phoneno'),
        'mobileno' => $this->input->post('mobileno'),
        'fax'      => $this->input->post('fax'),
        'email'    => $this->input->post('email'),
        'skypeid'  => $this->input->post('skypeid'),
        'position' => $this->input->post('position'),
        'status'   => $this->input->post('status'),
        'department_id'   => $this->input->post('department'),
        'ware_id'   => $this->input->post('ware_id'));
        $this->db->where('contact_id',$this->input->post('contactid'));
        $res=$this->db->update('tblwarehousecontacts',$data);
        return $res;
}

public function get_where_record($tbl,$id)
{
    
  return $this->db->where('contact_id', $id)->get($tbl)->row();  
}

public function get_client($id){
      return $this->db->where('ware_id', $id)->get('tblwarehouse')->row(); 
}

public function get_departments(){
   return $this->db->where('is_active','1')->order_by('sort_order','ASC')->get('tbldepartments')->result();  
}

    /**
     * Add new invoice item
     * @param array $data Invoice item data
     * @return boolean
     */
    public function add($data) {
        unset($data['action']);
         
         
        $this->db->insert('tblwarehouse', $data);
        $insert_id = $this->db->insert_id();
        
        if ($insert_id) {
            if(!$data['locations']){
                $data['locations']=0;
                $location=array(
                    'location_name'=>'Regular',
                    'stock_type'=>'Regular',
                    'ware_id'=>$insert_id,
                    'active'=>1,
                );
                $this->db->insert('tbllocations',$location);
           }else{
            $location = array('Regular','Receiving','Faulty','Return Merchandise Authorization','Return To Vendor');
             foreach ($location as $value) {
               $locationdata=array(
              'location_name'=>$value,
              'stock_type'=>$value,
              'ware_id'=>$insert_id,
                   'active'=>1,
                 );
             $this->db->insert('tbllocations',$locationdata);  
           }
          }
          
            logActivity('New Warehouse Added [ID:' . $insert_id . ', ' . $data['warehouse_name'] . ']');
            return $insert_id;
        }
        return false;
    }

    /**
     * Delete invoice item
     * @param  mixed $id
     * @return boolean
     */
    public function delete($id) {
        $this->db->where('ware_id', $id);
        $this->db->delete('tblwarehouse');

        if ($this->db->affected_rows() > 0) {
            logActivity('Warehouse Deleted [ID: ' . $id . ']');
            return true;
        }

        return false;
    }
    
     public function deletecontact($id) {
        $this->db->where('contact_id', $id);
        $this->db->delete('tblwarehousecontacts');

        if ($this->db->affected_rows() > 0) {
            logActivity('Warehouse Deleted [ID: ' . $id . ']');
            return true;
        }

        return false;
    }
    
    public function deleteitems($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('tblinvoiceitemslist');

        if ($this->db->affected_rows() > 0) {
            logActivity('Items Deleted [ID: ' . $id . ']');
            return true;
        }

        return false;
    }

        public function get_countries() {
        return $this->db->get('tblcountries')->result();
    }
    
   

    public function get_where_tbl($tbl, $col) {
        return $this->db->where($col, 1)->get($tbl)->result();
    }
    public function get_locations(){
         return $this->db->where('active','1')->get('tbllocations')->result();
    }

    public function get_where_single_tbl($tbl, $col, $val) {
        return $this->db->where($col, $val)->get($tbl)->row();
    }
    
    public function get_where_single_tbl_result($tbl, $col, $val) {
        return $this->db->where($col, $val)->get($tbl)->result();
    }

    public function get_receiving_warehouse($ware_id)
    {
      return $this->db->where('ware_id', $ware_id)->where('default_location', 1)->get('tbllocations')->row();
    }

    public function get_available_warehouse($ware_id)
    {
      return $this->db->where('ware_id', $ware_id)->where('default_location', 2)->get('tbllocations')->row();
    }

    public function get_customer_rma_warehouse($ware_id)
    {
      return $this->db->where('ware_id', $ware_id)->where('default_location', 3)->get('tbllocations')->row();
    }

    public function get_supplier_rtv_warehouse($ware_id)
    {
      return $this->db->where('ware_id', $ware_id)->where('default_location', 4)->get('tbllocations')->row();
    }

    public function get_scrapt_warehouse($ware_id)
    {
      return $this->db->where('ware_id', $ware_id)->where('default_location', 5)->get('tbllocations')->row();
    }

    public function update($data, $id) {
       
         unset($data['action']);
         unset($data['isedit']);
           $loctn = $this->db->where('ware_id',$id)->get('tblwarehouse')->row()->locations;
           if($loctn != $data['locations']){
                $this->db->where('ware_id',$id);
                $this->db->delete('tbllocations');
                if(!$data['locations']){
                     $data['locations']=0;
                     $location=array(
                         'location_name'=>'Regular',
                         'stock_type'=>'Regular',
                         'ware_id'=>$id,
                         'active'=>1,
                     );
                     $this->db->insert('tbllocations',$location);
                }else{
                 $location = array('Regular','Receiving','Faulty','Return Merchandise Authorization','Return To Vendor');
                  foreach ($location as $value) {
                    $locationdata=array(
                   'location_name'=>$value,
                   'stock_type'=>$value,
                   'ware_id'=>$id,
                   'active'=>1,
                      );
                  $this->db->insert('tbllocations',$locationdata);  
                }
               }
           }


        $receiving = array('default_location' => 1);
        $this->db->where('location_id', $data['receiving'])->update('tbllocations', $receiving);

        $available = array('default_location' => 2);
        $this->db->where('location_id', $data['available'])->update('tbllocations', $available);

        $customer_rma = array('default_location' => 3);
        $this->db->where('location_id', $data['customer_rma'])->update('tbllocations', $customer_rma);

        $supplier_rtv = array('default_location' => 4);
        $this->db->where('location_id', $data['supplier_rtv'])->update('tbllocations', $supplier_rtv);

        $scrapt = array('default_location' => 5);
        $this->db->where('location_id', $data['scrapt'])->update('tbllocations', $scrapt);

        unset($data['receiving']);
        unset($data['available']);
        unset($data['customer_rma']);
        unset($data['supplier_rtv']);
        unset($data['scrapt']);


         
        $this->db->where('ware_id', $id)->update('tblwarehouse', $data);
        return true;

    }
    
    public function get_contact_warehouse($id){
        return $this->db->where('ware_id',$id)->get('tblwarehousecontacts')->result();
    }

    public function add_reminder($data,$id){

        if(isset($data['notify_by_email'])){
            $data['notify_by_email'] = 1;
        } else {
             $data['notify_by_email'] = 0;
        }

        $data['date'] = to_sql_date($data['date']);
        $data['description'] = nl2br($data['description']);
        $data['creator'] = get_staff_user_id();
        $this->db->insert('tbladminwarehousereminders',$data);

        $insert_id = $this->db->insert_id();
        if($insert_id){
            logActivity('New Warehouse Reminder Added [Warehouse_id: ' . $data['ware_id'] . ' Description: ' . $data['description'] . ']');
            return true;
        }

        return false;
    }
    
    public function get_reminders($id = ''){

        $this->db->join('tblstaff','tblstaff.staffid = tbladminwarehousereminders.staff');

        if (is_numeric($id)) {
            $this->db->where('tbladminwarehousereminders.id', $id);
            return $this->db->get('tbladminwarehousereminders')->row();
        }

        $this->db->order_by('date', 'desc');
        return $this->db->get('tbladminwarehousereminders')->result_array();
    }
    
    public function delete_reminder($id){
        $reminder = $this->get_reminders($id);
           if($reminder->creator == get_staff_user_id()){
                $this->db->where('id',$id);
                $this->db->delete('tbladminwarehousereminders');
                if($this->db->affected_rows() > 0){
                    return true;
                }
                return false;
           }

       return false;
    }
    
}
