<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Settings_model extends CRM_Model
{
    function __construct()
    {
        parent::__construct();
    }

    /**
     * Update all settings
     * @param  array $data all settings
     * @return integer
     */
    public function update($data)
    {
       
        if($data['show_in_cart'] == "on")
        {
            $data['show_in_cart'] = 1;
        }
        else
        {
            $data['show_in_cart'] = 0;
        }
        
        $nextnumber = $this->db->where("name", 'next_customer')->get('tbloptions')->row();
        $nextreceipt = $this->db->where("name", 'next_receipt')->get('tbloptions')->row();

        $affectedRows = 0;
      
        $data = do_action('before_settings_updated', $data);
        foreach($data as $key =>  $value){
            if(!is_array($value)){

                $this->db->where('name', $key);
                $this->db->update('tbloptions', array(
                    'value' => $value
                ));
            }
        }

        foreach ($data['settings'] as $name => $val) 
        {

            if($name == 'next_customer')
            {                
                if($nextnumber->value > $val)
                {
                    
                    return -1;
                }
                
            }

            if($name == 'next_receipt')
            {                
                if($nextreceipt->value > $val)
                {
                    
                    return -2;
                }
                
            }

           // Check if the option exists
            $this->db->where('name',$name);
            $exists = $this->db->count_all_results('tbloptions');
            if($exists == 0){
                continue;
            }
            if ($name == 'email_signature') {
                $val = nl2br($val);
            }

            $this->db->where('name', $name);
            $this->db->update('tbloptions', array(
                'value' => $val
            ));

            if($this->db->affected_rows() > 0){
                $affectedRows++;
            }
        }

        
        if ($affectedRows > 0) {
            logActivity('Settings Updated []');
        }
        return $affectedRows;
        
    }

    public function add_new_company_pdf_field($data){
        $field = 'custom_company_field_' . trim($data['field']);
        $field =  preg_replace('/\s+/', '_', $field);
        if(add_option($field,$data['value'])){
            return true;
        }
        return false;
    }

    public function getLedger() {
        return $this->db->where('type', 'Ledger')->order_by('name', 'ASC')->get('tblledgergroups')->result();
    }

    public function getOptionByName($name) {
        return $this->db->where("name", $name)->get('tbloptions')->row_array();
    }

    public function getOptions() {
        $options = $this->db->get('tbloptions')->result_array();
        $data = array();
        foreach ($options as $key => $option) {
            $data[$option['name']] = $option['value'];
        }
        return $data;
    }

    function get_prev_groups2($id=0) {
       
        //$this->db->where('type', 'Ledger');
        $this->db->where('parent', $id);
        $this->db->order_by('name', 'ASC');
        $tabl= $this->db->get('tblledgergroups')->result();
        $subgoups=array();
        foreach($tabl as $ta)
        {           
            
            $ta->subgroups= $this->get_prev_groups2($ta->id);
            $ta->exists=false;
            foreach($ta->subgroups as $gr )         
            // if(($gr->type!="Group")||($gr->exists))
            // {
            //     $ta->exists=true;
            //     break;
                
            // }
            // if(($ta->type!="Group")||($ta->exists))
            // {
                $ta->exists=true;
                $subgoups[]=$ta;
                
            // }
            
            
        }
        
        return $subgoups;
    }

    public function empty_shopping_cart($value='')
    {
        $this->db->select('tblcategories.*');
        $this->db->from('tblcategories');
        $categories = $this->db->get()->result();

        foreach ($categories as $key => $value) 
        {
            $category_date = array('show_in_cart' => 0);
            $this->db->where('category_id', $value->category_id);
            $this->db->update('tblcategories', $category_date);

            $CI = &get_instance();
                
            $db2 = $CI->load->database('proverbs_solomon', TRUE);

            $db2->select('cart_category_translations.*');
            $db2->from('cart_category_translations');
            $db2->where('name',$value->category_name);
            $cart_category_translations = $db2->get()->row();

            // print_r($cart_category_translations);
            // die;

            $db2->select('cart_categories.*');
            $db2->from('cart_categories');
            $db2->where('id',$cart_category_translations->category_id);
            $cart_categories = $db2->get()->row();

            $db2->where('id', $cart_categories->id);
            $db2->delete('cart_categories');
            // print_r($db2->last_query());
            // die;

            $db2->where('parent_id', $cart_categories->id);
            $db2->delete('cart_categories');

            $db2->where('id', $cart_category_translations->id);
            $db2->delete('cart_category_translations');
        }


        $this->db->select('tblsubcategories.*');
        $this->db->from('tblsubcategories');
        $subcategories = $this->db->get()->result();

        foreach ($subcategories as $key => $value) 
        {
            $subcategory_date = array('show_in_cart' => 0);
            $this->db->where('subcategory_id', $value->subcategory_id);
            $this->db->update('tblsubcategories', $subcategory_date);

            $CI = &get_instance();
                
            $db2 = $CI->load->database('proverbs_solomon', TRUE);

            $db2->select('cart_category_translations.*');
            $db2->from('cart_category_translations');
            $db2->where('name',$value->subcategory_name);
            $cart_category_translations = $db2->get()->row();

            $db2->select('cart_categories.*');
            $db2->from('cart_categories');
            $db2->where('id',$cart_category_translations->category_id);
            $cart_categories = $db2->get()->row();

            $db2->where('cart_categories.id', $cart_categories->id);
            $db2->delete('cart_categories');

            $db2->where('parent_id', $cart_categories->id);
            $db2->delete('cart_categories');

            $db2->where('id', $cart_category_translations->id);
            $db2->delete('cart_category_translations');
        }

        $this->db->select('tblinvoiceitemslist.*');
        $this->db->from('tblinvoiceitemslist');
        $invoiceitemslist = $this->db->get()->result();

        foreach ($invoiceitemslist as $key => $value) 
        {

            $CI = &get_instance();
                
            $db2 = $CI->load->database('proverbs_solomon', TRUE);

            $invoiceitemslist_date = array('show_in_eview' => 0);
            $this->db->where('id', $value->id);
            $this->db->update('tblinvoiceitemslist', $invoiceitemslist_date);

            $this->db->select('tblmanufacturers.*');
            $this->db->from('tblmanufacturers');
            $this->db->where('tblmanufacturers.mfid',$value->manufacturer);
            $manufacturers_details = $this->db->get()->row();

            $db2->select('cart_manufacturer_translations.*');
            $db2->from('cart_manufacturer_translations');
            $db2->where('name',$manufacturers_details->name);
            $cart_manufacturer_translations = $db2->get()->row();

            $db2->select('cart_manufacturers.*');
            $db2->from('cart_manufacturers');
            $db2->where('id',$cart_manufacturer_translations->manufacturer_id);
            $cart_manufacturers = $db2->get()->row();

            $db2->where('cart_manufacturer_translations.id', $cart_manufacturer_translations->id);
            $db2->delete('cart_manufacturer_translations');


            $db2->where('cart_manufacturers.id', $cart_manufacturers->id);
            $db2->delete('cart_manufacturers');

            // $db2->where('cart_manufacturer_translations.id', $cart_manufacturer_translations->id);
            // $db2->delete('cart_manufacturer_translations');

            $db2->select('cart_products.*');
            $db2->where('sku', $value->sku);
            $cart_products = $db2->get('cart_products')->row();

            $db2->select('cart_product_translations.*');
            $db2->where('product_id', $cart_products->id);
            $cart_product_translations = $db2->get('cart_product_translations')->row();

           
            $this->load->library('ftp');

            $ftp_config['hostname'] = "skyway.redplanethost.com"; 
            $ftp_config['hostname'] = "ftp.proverbs.ekomplete.com"; 
            $ftp_config['username'] = "jay@proverbs.ekomplete.com";
            $ftp_config['password'] = "dtMo;rB@VITU";
            $ftp_config['debug']    = TRUE;

            $this->ftp->connect($ftp_config);

            if($cart_products->main_image != "")
            {
                $remote_file = '/public_html/images/modules/shoppingcart/products/'.$cart_products->main_image;

                $remote_thumbs_file = '/public_html/images/modules/shoppingcart/products/thumbs/'.$cart_products->main_image_thumb;

                $this->ftp->delete_file($remote_file);
                $this->ftp->delete_file($remote_thumbs_file);
            }


            if($cart_products->image1 != "")
            {
                $remote_file = '/public_html/images/modules/shoppingcart/products/'.$cart_products->image1;

                $remote_thumbs_file = '/public_html/images/modules/shoppingcart/products/thumbs/'.$cart_products->image1_thumb;

                $this->ftp->delete_file($remote_file);
                $this->ftp->delete_file($remote_thumbs_file);
            }

            if($cart_products->image2 != "")
            {
                $remote_file = '/public_html/images/modules/shoppingcart/products/'.$cart_products->image2;

                $remote_thumbs_file = '/public_html/images/modules/shoppingcart/products/thumbs/'.$cart_products->image2_thumb;

                $this->ftp->delete_file($remote_file);
                $this->ftp->delete_file($remote_thumbs_file);
            }

            if($cart_products->image3 != "")
            {
                $remote_file = '/public_html/images/modules/shoppingcart/products/'.$cart_products->image3;

                $remote_thumbs_file = '/public_html/images/modules/shoppingcart/products/thumbs/'.$cart_products->image3_thumb;

                $this->ftp->delete_file($remote_file);
                $this->ftp->delete_file($remote_thumbs_file);
            }

            if($cart_products->image4 != "")
            {
                $remote_file = '/public_html/images/modules/shoppingcart/products/'.$cart_products->image4;

                $remote_thumbs_file = '/public_html/images/modules/shoppingcart/products/thumbs/'.$cart_products->image4_thumb;

                $this->ftp->delete_file($remote_file);
                $this->ftp->delete_file($remote_thumbs_file);
            }


            if($cart_products->image5 != "")
            {
                $remote_file = '/public_html/images/modules/shoppingcart/products/'.$cart_products->image5;

                $remote_thumbs_file = '/public_html/images/modules/shoppingcart/products/thumbs/'.$cart_products->image5_thumb;

                $this->ftp->delete_file($remote_file);
                $this->ftp->delete_file($remote_thumbs_file);
            }

            $db2->where('cart_products.id', $cart_products->id);
            $db2->delete('cart_products');


            $db2->where('cart_product_translations.id', $cart_product_translations->id);
            $db2->delete('cart_product_translations');

        }

        return true;
        // echo "<pre>";
        // $db2->select('cart_category_translations.*');
        // $db2->from('cart_category_translations');    
        // $cat = $db2->get()->result();

        // $db2->select('cart_products.*');
        // $db2->from('cart_products');    
        // $product = $db2->get()->result();

        // print_r($product);
        // print_r($cat);
        // die;
       
    }

    public function update_categories($value='')
    {
        $this->db->select('tblcategories.*');
        $this->db->from('tblcategories');
        $categories = $this->db->get()->result();
        // print_r($categories);
        // die;

        foreach ($categories as $key => $value) 
        {
            $category_date = array('show_in_cart' => 1);
            $this->db->where('category_id', $value->category_id);
            $this->db->update('tblcategories', $category_date);
        
            
            $CI = &get_instance();
                
            $db2 = $CI->load->database('proverbs_solomon', TRUE);

            $db2->select('cart_category_translations.*');
            $db2->from('cart_category_translations');
            $db2->where('name',$value->category_name);
            $cart_category_translations = $db2->get()->row();


            if($cart_category_translations == "")
            {
                $db2->select_max('sort_order');
                $cart_categories = $db2->get('cart_categories')->row();  
                $sort_order = $cart_categories->sort_order + 1;

                $insert_cart_category = array(
                                'parent_id' => 0,
                                'icon' => 'default.png',
                                'icon_thumb' => 'default_thumb.png',
                                'products_count_total' => 0,
                                'products_count_active' => 0,
                                'sort_order' => $sort_order,
                            );
                $db2->insert('cart_categories', $insert_cart_category);
                $insert_cart_category_id = $db2->insert_id();

                $insert_cart_category_translations = array(
                                'category_id' => $insert_cart_category_id,
                                'solomon_cat_id' => $value->category_id,
                                'language_code' => 'en',
                                'name' => $value->category_name,
                                'description' => $value->description,
                            );

                $db2->insert('cart_category_translations', $insert_cart_category_translations);
                $insert_cart_category_translations_id = $db2->insert_id();
            }
            else
            {
                $update_cart_category_translations = array(
                            // 'category_id' => $value->id,
                            // 'language_code' => 'en',
                            'name' => $value->category_name,
                            'description' => $value->description,
                        );
                $db2->where('name', $value->category_name);
                $db2->update('cart_category_translations',$update_cart_category_translations);
            }
        }

       
        $this->db->select('tblsubcategories.*');
        $this->db->from('tblsubcategories');
        $subcategories = $this->db->get()->result();



        foreach ($subcategories as $key => $value) 
        {
            $subcategory_date = array('show_in_cart' => 1);
            $this->db->where('subcategory_id', $value->subcategory_id);
            $this->db->update('tblsubcategories', $category_date);
        
            
            $CI = &get_instance();
                
            $db2 = $CI->load->database('proverbs_solomon', TRUE);

            $db2->select('cart_category_translations.*');
            $db2->from('cart_category_translations');
            $db2->where('name',$value->subcategory_name);
            $cart_category_translations = $db2->get()->row();

            if($cart_category_translations == "")
            {

                $this->db->select('tblcategories.*');
                $this->db->from('tblcategories');
                $this->db->where('tblcategories.category_id',$value->catid);
                $category_details = $this->db->get()->row();

                // print_r($category_details);
                // die;

                $db2->select('cart_category_translations.*');
                $db2->from('cart_category_translations');
                $db2->where('name',$category_details->category_name);
                $cart_category_translations_datails = $db2->get()->row();

                // print_r($cart_category_translations_datails);
                // die;


                $db2->select_max('sort_order');
                $cart_categories = $db2->get('cart_categories')->row();  
                $sort_order = $cart_categories->sort_order + 1;

                $insert_cart_category = array(
                                'parent_id' => $cart_category_translations_datails->id,
                                'icon' => 'default.png',
                                'icon_thumb' => 'default_thumb.png',
                                'products_count_total' => 0,
                                'products_count_active' => 0,
                                'sort_order' => $sort_order,
                            );
                $db2->insert('cart_categories', $insert_cart_category);
                $insert_cart_category_id = $db2->insert_id();



                $insert_cart_category_translations = array(
                                'category_id' => $insert_cart_category_id,
                                'solomon_cat_id' => $value->subcategory_id,
                                'language_code' => 'en',
                                'name' => $value->subcategory_name,
                                'description' => $value->description,
                            );

                $db2->insert('cart_category_translations', $insert_cart_category_translations);
                $insert_cart_category_translations_id = $db2->insert_id();
            }
            else
            {
                $update_cart_category_translations = array(
                            // 'category_id' => $value->id,
                            // 'language_code' => 'en',
                            'name' => $value->subcategory_name,
                            'description' => $value->description,
                        );
                $db2->where('name', $value->subcategory_name);
                $db2->update('cart_category_translations',$update_cart_category_translations);
            }
        }
        return true;

        // echo "<pre>";
        // $db2->select('cart_category_translations.*');
        // $db2->from('cart_category_translations');    
        // $cat = $db2->get()->result();
        // print_r($cat);
        // die;

        // echo "succes";
    }

    public function update_products($value='')
    {
        $this->db->select('tblinvoiceitemslist.*');
        $this->db->from('tblinvoiceitemslist');
        $invoiceitemslist = $this->db->get()->result();
        // echo "<pre>";
        // print_r($invoiceitemslist);
        // die;

        foreach ($invoiceitemslist as $key => $value) 
        {

            $CI = &get_instance();
                
            $db2 = $CI->load->database('proverbs_solomon', TRUE);


            $invoiceitemslist_date = array('show_in_eview' => 1);
            $this->db->where('id', $value->id);
            $this->db->update('tblinvoiceitemslist', $invoiceitemslist_date);

            $this->db->select('tblinvoiceitems_eview.*');
            $this->db->from('tblinvoiceitems_eview');
            $this->db->where('tblinvoiceitems_eview.invoiceitems_id',$value->id);
            $eview_details = $this->db->get()->row();

            $eview_id = "";
            if($eview_details == "")
            {
                $insert_eview = array(
                                'invoiceitems_id' => $value->id,
                                'details' => '',
                                'is_featured' => 1,
                            );
                $this->db->insert('tblinvoiceitems_eview', $insert_eview);
                $eview_id = $this->db->insert_id();

                if ($value->image != "") {
                    $this->load->helper('polaris_upload');
                    handle_mainimage_eview_upload($eview_id,$value->image);
                }
            }
            else
            {

                $eview_id = $eview_details->id;
            }

            $this->db->select('tblmanufacturers.*');
            $this->db->from('tblmanufacturers');
            $this->db->where('tblmanufacturers.mfid',$value->manufacturer);
            $manufacturers_details = $this->db->get()->row();

            $db2->select('cart_manufacturer_translations.*');
            $db2->from('cart_manufacturer_translations');
            $db2->where('name',$manufacturers_details->name);
            $cart_manufacturer_translations = $db2->get()->row();

            $insert_cart_manufacturer_id = "";
            if($cart_manufacturer_translations == "")
            {
                $insert_cart_manufacturers = array(
                                            'logo_file' =>'default.png',
                                            'logo_file_thumb' =>'default.png',
                            );
                $db2->insert('cart_manufacturers', $insert_cart_manufacturers);
                $insert_cart_manufacturer_id = $db2->insert_id();

                

                $insert_cart_manufacturer_translations = array(
                                'manufacturer_id' => $insert_cart_manufacturer_id,
                                'language_code' => 'en',
                                'name' => $manufacturers_details->name,
                                // 'description' => $manufacturers_details->description,
                                'description' => "",
                            );

                $db2->insert('cart_manufacturer_translations', $insert_cart_manufacturer_translations);
                $update_cart_manufacturer_translations_id = $db2->insert_id();
            }
            else
            {
                $update_cart_manufacturer_translations = array(
                            // 'category_id' => $value->id,
                            // 'language_code' => 'en',
                            'name' => $manufacturers_details->name,
                            'description' => "",
                        );
                $db2->where('name', $manufacturers_details->name);
                $db2->update('cart_manufacturer_translations',$update_cart_manufacturer_translations);

                $insert_cart_manufacturer_id = $cart_manufacturer_translations->id;
            }

            $this->db->select('tblcategories.*');
            $this->db->from('tblcategories');
            $this->db->where('tblcategories.category_id',$value->category);
            $categorydetails = $this->db->get()->row();

            $this->db->select('tblsubcategories.*');
            $this->db->from('tblsubcategories');
            $this->db->where('tblsubcategories.subcategory_id',$value->subcategory);
            $category_details = $this->db->get()->row();

            // print_r($category_details);
            // die;

            $db2->select('cart_category_translations.*');
            $db2->from('cart_category_translations');
            $db2->where('name',$category_details->subcategory_name);
            $cart_category_translations = $db2->get()->row();

            $db2->select('cart_categories.*');
            $db2->from('cart_categories');
            $db2->where('id',$cart_category_translations->category_id);
            $cart_category = $db2->get()->row();


            $this->db->select('tblinvoiceitems_eview.*');
            $this->db->from('tblinvoiceitems_eview');
            $this->db->where('tblinvoiceitems_eview.id',$eview_id);
            $eview_details = $this->db->get()->row();

            $db2->select('cart_products.*');
            $db2->where('sku', $value->sku);
            $item_product = $db2->get('cart_products')->row();

            $image_item_id = "";
            if($item_product == "")
            {
                
                $db2->select_max('sort_order');
                $product_order = $db2->get('cart_products')->row();  
                $sort_order = $product_order->sort_order + 1;

                $insert_product = array(
                                'item_id' => $value->id,
                                // 'category_id' => $cart_category_translations->id,
                                'category_id' => $cart_category->id,
                                'manufacturer_id' => $insert_cart_manufacturer_id,
                                'sku' => $value->sku,
                                'price' => $value->salesprice,
                                // 'list_price' => $data['costprice'],
                                'list_price' => $value->suggested_price,
                                'is_featured' => $eview_details->is_featured,
                                'is_taxable' => 0,
                                'is_active' => 1,
                                'created_at' => date('Y-m-d'),
                                'sort_order' => $sort_order,
                            );
                $db2->insert('cart_products', $insert_product);
                $insert_product_id = $db2->insert_id();

                $image_item_id = $insert_product_id;

                $insert_product_translation = array(
                                    'product_id' => $insert_product_id,
                                    'language_code' => 'en',
                                    'name' => $value->description,
                                    'description' => $eview_details->details,
                                );

                $db2->insert('cart_product_translations', $insert_product_translation);

                // $db2->select('cart_category_translations.*');
                // $db2->from('cart_category_translations');
                // $db2->where('name',$categorydetails->category_name);
                // $cartcategorytranslations = $db2->get()->row();

                $db2->select('cart_categories.*');
                $db2->from('cart_categories');
                $db2->where('cart_categories.id',$cart_category_translations->category_id);
                $category_product = $db2->get()->row();

                // $db2->select('cart_categories.*');
                // $db2->from('cart_categories');
                // $db2->where('cart_categories.id',$cartcategorytranslations->category_id);
                // $category_product = $db2->get()->row();



                $products_count_total = $category_product->products_count_total + 1;
                $products_count_active = $category_product->products_count_active + 1;

                $update_cart_category = array(
                                            'products_count_total' => $products_count_total,
                                            'products_count_active' => $products_count_active,
                                        );
                $db2->where('id', $cart_category_translations->category_id);
                $db2->update('cart_categories', $update_cart_category);

            }
            else
            {
                $update_product = array(
                                    'item_id' => $value->id,
                                    // 'category_id' => $cart_category_translations->id,
                                    'category_id' => $cart_category->id,
                                    'manufacturer_id' => $insert_cart_manufacturer_id,
                                    'sku' => $value->sku,
                                    'price' => $value->salesprice,
                                    // 'list_price' => $data['costprice'],
                                    'list_price' => $value->suggested_price,
                                    'is_featured' => $eview_details->is_featured,
                                    'is_taxable' => 0,
                                    'is_active' => 1,
                                    'created_at' => date('Y-m-d'),
                                    // 'sort_order' => $sort_order,
                                );
                $db2->where('sku', $value->sku);
                $db2->update('cart_products', $update_product);
                // $insert_product_id = $db2->insert_id();

                $db2->select('cart_products.*');
                $db2->from('cart_products');
                $db2->where('sku', $value->sku);
                $cart_products_update_id = $db2->get()->row();

                $image_item_id = $cart_products_update_id->id;

                $update_product_translation = array(
                                    'product_id' => $cart_products_update_id->id,
                                    'language_code' => 'en',
                                    'name' => $value->description,
                                    'description' => $eview_details->details,
                                );
                $db2->where('product_id', $cart_products_update_id->id);
                $db2->update('cart_product_translations', $update_product_translation);
            }

            if ($value->image != "") {
                $this->load->helper('polaris_upload');
                // handle_main_image_upload($data['eview_id']);
                handle_product_main_image_upload($image_item_id,$value->image);
            }
            // echo "<pre>";
            // print_r($image_item_id);
            // // die;
            if ($eview_details->image1 != "") {
                $this->load->helper('polaris_upload');
                handle_product_image1_eview_upload($image_item_id,$eview_details->image1);
            }

            if ($eview_details->image2 != "") {
                $this->load->helper('polaris_upload');
                handle_product_image2_eview_upload($image_item_id,$eview_details->image2);
            }

            if ($eview_details->image3 != "") {
                $this->load->helper('polaris_upload');
                handle_product_image3_eview_upload($image_item_id,$eview_details->image3);
            }

            if ($eview_details->image4 != "") {
                $this->load->helper('polaris_upload');
                handle_product_image4_eview_upload($image_item_id,$eview_details->image4);
            }

            if ($eview_details->image5 != "") {
                $this->load->helper('polaris_upload');
                handle_product_image5_eview_upload($image_item_id,$eview_details->image5);
            }


        }

       // die;
        return true;

        // echo "<pre>";
        // $db2->select('cart_products.*');
        // $db2->from('cart_products');    
        // $cat = $db2->get()->result();
        // print_r($cat);
        // die;

        // echo "succes";
    }
}
