<?php

ob_start();
defined('BASEPATH') OR exit('No direct script access allowed');

class Purchaseorders_model extends CRM_Model {

    function __construct() {
        parent::__construct();
    }

    /**
     * Get estimate by id
     * @param  mixed $id
     * @return array
     */

    public function get_grn($id)
    {
        $this->db->select('tblgrns.number,tblgrns.grnid');
        $this->db->from('tblgrns');
        $this->db->join('tblpurchaseorders', 'tblpurchaseorders.id = tblgrns.po_id', 'left');
        $this->db->where('tblpurchaseorders.status',5);
        $this->db->where('tblgrns.po_id',$id);
        return $item = $this->db->get()->row();
    }

    public function get_request($id)
    {
        $this->db->select('tblrfqsqoutes.number,tblrfqsqoutes.id');
        $this->db->from('tblrfqsqoutes');
        $this->db->join('tblpurchaseorders', 'tblpurchaseorders.rfq_id = tblrfqsqoutes.id', 'left');
        // $this->db->where('tblpurchaseorders.status',5);
        $this->db->where('tblpurchaseorders.id',$id);
        return $item = $this->db->get()->row();
    }

    public function get($id = '') {
        $this->db->select('*,tblcurrencies.id as currencyid, tblpurchaseorders.id as id, tblcurrencies.name as currency_name');
        $this->db->from('tblpurchaseorders');
        $this->db->join('tblcurrencies', 'tblcurrencies.id = tblpurchaseorders.currency', 'left');

        if (is_numeric($id)) {
            $this->db->where('tblpurchaseorders.id', $id);
            $purchaseorder = $this->db->get()->row();

            if ($purchaseorder) {
                $this->load->model('suppliers_model');
                $purchaseorder->items = $this->get_purchaseorder_items($id);
                $purchaseorder->supplier = $this->suppliers_model->get($purchaseorder->supplierid);
//                if ($purchaseorder->supplier->company == '') {
//                    $purchaseorder->supplier->company = $purchaseorder->supplier->firstname . ' ' . $purchaseorder->supplier->lastname;
//                }
            }
            return $purchaseorder;
        }

        return $this->db->get()->result_array();
    }
	public function get_po_by_status($status = '4') {
        // echo $status;
        // die;
        $this->db->select('*,tblcurrencies.id as currencyid, tblpurchaseorders.id as id, tblcurrencies.name as currency_name,tblsuppliers.supplier as supplier');
        $this->db->from('tblpurchaseorders');
        $this->db->join('tblcurrencies', 'tblcurrencies.id = tblpurchaseorders.currency', 'left');
		$this->db->join('tblsuppliers', 'tblsuppliers.userid = tblpurchaseorders.supplierid', 'left');
        
           $this->db->where('tblpurchaseorders.status', $status);
          

           

        return $this->db->get()->result_array();
    }
    public function get_items($id) {
        return $this->get_purchaseorder_items($id);
    }

    /**
     * Convert estimate to invoice
     * @param  mixed $id estimate id
     * @return mixed     New invoice ID
     */
    public function convert_to_invoice($id, $client = false) {
        // Recurring invoice date is okey lets convert it to new invoice
        $_order = $this->get($id);

        $new_invoice_data = array();
        $new_invoice_data['clientid'] = $_order->clientid;
        $new_invoice_data['_number'] = get_option('next_invoice_number');
        $new_invoice_data['date'] = _d(date('Y-m-d'));
        $new_invoice_data['duedate'] = _d(date('Y-m-d'));

        if ($_order->expirydate < date('Y-m-d')) {
            $new_invoice_data['duedate'] = _d($_order->expirydate);
        }

        $new_invoice_data['currency'] = $_order->currency;
        $new_invoice_data['subtotal'] = $_order->subtotal;
        $new_invoice_data['total'] = $_order->total;
        $new_invoice_data['adjustment'] = $_order->adjustment;
        $new_invoice_data['discount_percent'] = $_order->discount_percent;
        $new_invoice_data['discount_total'] = $_order->discount_total;
        $new_invoice_data['discount_type'] = $_order->discount_type;
        $new_invoice_data['sale_agent'] = $_order->sale_agent;

        $new_invoice_data['terms'] = get_option('predefined_terms_invoice');
        $new_invoice_data['clientnote'] = get_option('predefined_clientnote_invoice');

        // Set to unpaid status automatically
        $new_invoice_data['status'] = 1;
        $new_invoice_data['clientnote'] = '';
        $new_invoice_data['adminnote'] = 'Converted from order #' . format_order_number($_order->number);
        $this->load->model('payment_modes_model');

        $modes = $this->payment_modes_model->get();
        $temp_modes = array();

        foreach ($modes as $mode) {
            $temp_modes[] = $mode['id'];
        }

        $new_invoice_data['allowed_payment_modes'] = $temp_modes;
        $new_invoice_data['newitems'] = array();

        $key = 1;
        foreach ($_order->items as $item) {
            $new_invoice_data['newitems'][$key]['sku'] = $item['sku'];
            $new_invoice_data['newitems'][$key]['description'] = $item['description'];
//            $new_invoice_data['newitems'][$key]['long_description'] = $item['long_description'];
            $new_invoice_data['newitems'][$key]['qty'] = $item['qty'];
            $new_invoice_data['newitems'][$key]['itemorder_id'] = $item['itemorder_id'];
            $new_invoice_data['newitems'][$key]['taxid'] = $item['taxid'];
            $new_invoice_data['newitems'][$key]['disc'] = $item['disc'];
            $new_invoice_data['newitems'][$key]['rate'] = $item['rate'];
            $new_invoice_data['newitems'][$key]['order'] = $item['item_order'];
            $key++;
        }

        $this->load->model('invoices_model');
      

        $id = $this->invoices_model->add($new_invoice_data);

        if ($id) {
            // Update estimate with the new invoice data and set to status accepted
            $this->db->where('id', $_order->id);
            $this->db->update('tblpurchaseorders', array(
                'invoiced_date' => date('Y-m-d H:i:s'),
                'invoiceid' => $id,
                'status' => 5
            ));
            if ($client == false) {
                $this->log_purchaseorder_activity($_order->id, 'converted this order to invoice.<br /><a href="' . admin_url('invoices/list_invoices/' . $id) . '">' . format_invoice_number($new_invoice_data['_number']) . '</a>');
            }
        }

        return $id;
    }

    public function get_orders_total($data) {

        $statuses = array(
            1,2,3,4,5
        );
        $this->load->model('currencies_model');

        if ((is_using_multiple_currencies('tblpurchaseorders') && !isset($data['currency'])) || !isset($data['currency'])) {
            $currencyid = $this->currencies_model->get_base_currency()->id;
        } else if (isset($data['currency'])) {
            $currencyid = $data['currency'];
        }

        $symbol = $this->currencies_model->get_currency_symbol($currencyid);
        $sql = 'SELECT';

        foreach ($statuses as $order_status) {
            $sql .= '(SELECT SUM(total) FROM tblpurchaseorders WHERE status=' . $order_status;
            $sql .= ' AND currency =' . $currencyid;
            $sql .= ') as "' . $order_status . '",';
        }

        $sql = substr($sql, 0, -1);
        $result = $this->db->query($sql)->result_array();
        $_result = array();
        $i = 0;
        foreach ($result as $key => $val) {
            foreach ($val as $total) {
                $_result[$i]['total'] = $total;
                $_result[$i]['symbol'] = $symbol;
                $i++;
            }
        }

        return $_result;
    }

    /**
     * Get all estimate items
     * @param  mixed $id orderid
     * @return array
     */
    public function get_purchaseorder_items($id) {
        $this->db->select('tblpurchaseorderitems.id,orderid,qty,rate,taxrate,disc,itemorder_id,tbltaxes.id as taxid,tbltaxes.name as taxname,description as description,long_description,item_order,sku,oursku');
        $this->db->from('tblpurchaseorderitems');
        $this->db->join('tbltaxes', 'tbltaxes.id = tblpurchaseorderitems.taxid', 'left');
        $this->db->where('tblpurchaseorderitems.orderid', $id);
        $this->db->order_by('item_order', 'asc');
        return $this->db->get()->result_array();
    }
	 
	 public function get_items_sku_qty($id) {
        $this->db->select('*');
        $this->db->from('tblpurchaseorderitems');        
        $this->db->where('orderid', $id);       
        return $this->db->get()->result_array();
    }

    public function get_paymentterms($id)
    {
        $this->db->select('*');
        $this->db->from('tblsuppliers');        
        $this->db->where('userid', $id);       
        return $this->db->get()->row();
    }

    /**
     * Insert new estimate to database
     * @param array $data invoiec data
     * @return mixed - false if not insert, estimate ID if succes
     */
    public function add($data) {

        // echo "<pre>";
        // print_r($data);
        // die;
        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);
        unset($data['creditlimit']);

       
        // $data['number'] = $data['_number'];
        $data['number'] = get_option('next_purchaseorder_number');
		if( $data['rfq_id'])
		{
			$this->db->where('id', $data['rfq_id']);
            $this->db->set('status', '4', FALSE);
            $this->db->update('tblrfqsqoutes');
		}
		
        $unsetters = array(
            '_number',
            'currency_symbol',
            'price',
            'taxname',
            'sku',
			'oursku',
            'description',
            'itemrecorid',
            'disc',
            'taxid',
            'rate',
            'quantity',
			// "rfq_id"
        );

        foreach ($unsetters as $unseter) {
            if (isset($data[$unseter])) {
                unset($data[$unseter]);
            }
        }

        if (isset($data['custom_fields'])) {
            $custom_fields = $data['custom_fields'];
            unset($data['custom_fields']);
        }

        $data['podate'] = to_sql_date($data['podate']);
        if (!empty($data['expecteddate'])) {
            $data['expecteddate'] = to_sql_date($data['expecteddate']);
        } else {
            unset($data['expecteddate']);
        }

        $data['terms'] = nl2br($data['terms']);
        $data['datecreated'] = date('Y-m-d H:i:s');
        $data['year'] = get_option('order_year');
        $data['addedfrom'] = get_staff_user_id();

        $items = array();
        if (isset($data['newitems'])) {
            $items = $data['newitems'];
            unset($data['newitems']);
        }
            

        $_data = do_action('before_order_added', array(
            'data' => $data,
            'items' => $items
        ));

        $data = $_data['data'];
        $items = $_data['items'];

        if($data['status'] ==''){
            $data['status']=1;
        }
        $data['hash'] = md5(rand() . microtime());
        // Check if the key exists
        $this->db->where('hash', $data['hash']);
        $exists = $this->db->get('tblpurchaseorders')->row();


        $data['vatpaid'] = str_replace(",", "",$data['vatpaid']);
        // echo "<pre>";
        // print_r($data);
        // die;

        $this->db->insert('tblpurchaseorders', $data);

        $insert_id = $this->db->insert_id();

        if ($insert_id) {

            if (isset($custom_fields)) {
                handle_custom_fields_post($insert_id, $custom_fields);
            }

            // Update next estimate number in settings
            $this->db->where('name', 'next_purchaseorder_number');
            $this->db->set('value', 'value+1', FALSE);
            $this->db->update('tbloptions');
        
            if (count($items) > 0) {
                foreach ($items as $key => $item) {
					
					
                    $this->db->insert('tblpurchaseorderitems', array(
                        'sku' => $item['sku'],
						'oursku' => $item['oursku'],
                        'description' => $item['description'],
                        'disc'=>$item['disc'],
                        'qty' => $item['qty'],
                        'itemorder_id'=>$item['itemorder_id'],
                        'rate' => $item['rate'],
                        'taxid' => $item['taxid'],
                        'orderid' => $insert_id,
                        'item_order' => $item['order'],
                    ));
					if( $data['status']==3)
					{
						$this->db->where('sku', $item['sku']);
						$this->db->set('onorder', 'onorder+'.$item['qty'], FALSE);
						$this->db->update('tblinvoiceitemslist');
					}
					if( $data['status']==4)
					{
						$this->db->where('sku', $item['sku']);
						$this->db->set('intransit', 'intransit+'.$item['qty'], FALSE);
						$this->db->update('tblinvoiceitemslist');
					}
                  	if( $data['status']==5)
					{
						$this->db->where('sku', $item['sku']);
						$this->db->set('receiving', 'receiving+'.$item["qty"], FALSE);
						$this->db->update('tblinvoiceitemslist');
					}
                }
            }

            $this->log_purchaseorder_activity($insert_id, 'created the Purchase order');
            do_action('after_order_added', $insert_id);
            return $insert_id;
        }

        return false;
    }

    public function get_order_item($id) {
        $this->db->where('id', $id);
        return $this->db->get('tblorderitems')->row();
    }

   
    public function get_term($id){
       $this->db->select('payment_term');
       $this->db->where('userid', $id);
       return $this->db->get('tblclients')->row()->payment_term; 
    }
    public function get_sales_agent($id){
       $this->db->select('account_req');
       $this->db->where('userid', $id);
       return $this->db->get('tblclients')->row()->account_req; 
    }

    /**
     * Update estimate data
     * @param  array $data estimate data
     * @param  mixed $id   orderid
     * @return boolean
     */
    public function update($data, $id) {
        // echo "<pre>";
        // print_r($data);
        // die;

        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);
        unset($data['creditlimit']);

        $affectedRows = 0;
        $prefix = get_option('purchaseorder_prefix');

        $data['number'] = substr($data['number'], strlen($prefix));
        $data['number'] = trim($data['number']);

        if (get_option('purchaseorder_number_format') == 2) {
            $_temp_number = explode('/', $data['number']);
            $data['number'] = $_temp_number[1];
        }

        $original_order = $this->get($id);
        $original_status = $original_order->status;
        $original_number = $original_order->number;
		
        unset($data['currency_symbol']);
        unset($data['price']);
        unset($data['taxname']);
        unset($data['taxid']);
        unset($data['isedit']);
        unset($data['sku']);
		unset($data['oursku']);
        unset($data['description']);
        unset($data['itemrecorid']);
        unset($data['disc']);
        unset($data['tax']);
        unset($data['rate']);
        unset($data['quantity']);
		unset($data['rfq_id']);
		

        $items = array();
        if (isset($data['items'])) {
            $items = $data['items'];
            unset($data['items']);
        }

        $newitems = array();
        if (isset($data['newitems'])) {
            $newitems = $data['newitems'];
            unset($data['newitems']);
        }

        if ($data['adjustment'] == 'NaN') {
            $data['adjustment'] = 0;
        }

        $data['terms'] = nl2br($data['terms']);
        $data['podate'] = to_sql_date($data['podate']);
        $data['expecteddate'] = to_sql_date($data['expecteddate']);


        if (isset($data['custom_fields'])) {
            $custom_fields = $data['custom_fields'];
            if (handle_custom_fields_post($id, $custom_fields)) {
                $affectedRows++;
            }

            unset($data['custom_fields']);
        }


        $action_data = array(
            'data' => $data,
            'newitems' => $newitems,
            'items' => $items,
            'id' => $id,
            'removed_items' => array()
        );

        if (isset($data['removed_items'])) {
            $action_data['removed_items'] = $data['removed_items'];
        }

        $_data = do_action('before_order_updated', $action_data);
        $data['removed_items'] = $_data['removed_items'];
        $newitems = $_data['newitems'];
        $items = $_data['items'];
        $data = $_data['data'];

        // Delete items checked to be removed from database
        if (isset($data['removed_items'])) {
            foreach ($data['removed_items'] as $remove_item_id) {
                foreach ($data['removed_items'] as $remove_item_id) {
                    $original_item = $this->get_order_item($remove_item_id);
                    $this->db->where('orderid', $id);
                    $this->db->where('id', $remove_item_id);
                    $this->db->delete('tblpurchaseorderitems');
                    if ($this->db->affected_rows() > 0) {
                        $this->log_purchaseorder_activity($id, 'removed item <b>' . $original_item->description . '</b>');
                        $affectedRows++;
                    }
                }
            }
            unset($data['removed_items']);
        }
         if($data['status'] ==''){
            $data['status']=1;
        }
        $this->db->where('id', $id);
        $this->db->update('tblpurchaseorders', $data);

        if ($this->db->affected_rows() > 0) {
            // Check for status change
            if ($original_status != $data['status']) {
                $this->log_purchaseorder_activity($original_order->id, 'Purchase Order Status Updated: From: ' . format_purchaseorder_status($original_status) . ' To: ' . format_purchaseorder_status($data['status']));
            }

            if ($original_number != $data['number']) {
                $this->log_purchaseorder_activity($original_order->id, 'Purchase Order Number Changed: From: ' . format_purchaseorder_number($original_number) . ' To: ' . format_purchaseorder_number($data['number']));
            }

            $affectedRows++;
        }
        $this->load->model('taxes_model');
        if (count($items) > 0) {
            // echo "<pre>";
            // print_r($items);
            // die;
            
            foreach ($items as $key => $item) {
               
                $order_item_id = $item['itemid'];

                $original_item = $this->get_order_item($order_item_id);

                $this->db->where('id', $order_item_id);
                $this->db->update('tblpurchaseorderitems', array(
                    'item_order' => $item['order'],
                ));
             

                

                if ($this->db->affected_rows() > 0) {
                    $affectedRows++;
                }
                // Check for invoice item short description change
                $this->db->where('id', $order_item_id);
                $this->db->update('tblpurchaseorderitems', array(
                    'description' => $item['description'],
                ));


                if ($this->db->affected_rows() > 0) {
                    $this->log_purchaseorder_activity($id, 'updated item short description from ' . $original_item->description . ' to ' . $item['description']);
                    $affectedRows++;
                }

                // Check for item long description change
                $this->db->where('id', $order_item_id);
                $this->db->update('tblpurchaseorderitems', array(
                    'sku' => nl2br($item['sku']),
                ));
                $this->db->where('id', $order_item_id);
                $this->db->update('tblpurchaseorderitems', array(
                    'disc'=>$item['disc'],
                ));

                if ($this->db->affected_rows() > 0) {
                    $this->log_purchaseorder_activity($id, 'updated item sku from ' . $original_item->sku . ' to ' . $item['sku']);
                    $affectedRows++;
                }
                // Check for tax id change
                $original_tax = $this->taxes_model->get($original_item->taxid);

                $this->db->where('id', $order_item_id);
                $this->db->update('tblpurchaseorderitems', array(
                    'taxid' => $item['taxid'],
                ));

                if ($this->db->affected_rows() > 0) {
                    $tax_now = $this->taxes_model->get($item['taxid']);
                    if ($original_tax) {
                        if ($tax_now) {
                            $this->log_purchaseorder_activity($id, 'updated tax (' . $original_tax->name . ') from ' . $original_tax->taxrate . '% to (' . $tax_now->name . ') ' . $tax_now->taxrate . '%');
                        } else {
                            $this->log_purchaseorder_activity($id, 'removed tax (' . $original_tax->name . ') ' . $original_tax->taxrate . '%');
                        }
                    } else {
                        $this->log_purchaseorder_activity($id, 'added tax (' . $tax_now->name . ') ' . $tax_now->taxrate . '%');
                    }
                    $affectedRows++;
                }

                // Check for item rate change
                $this->db->where('id', $order_item_id);
                $this->db->update('tblpurchaseorderitems', array(
                    'rate' => $item['rate'],
                ));
                if ($this->db->affected_rows() > 0) {
                    $this->log_purchaseorder_activity($id, 'updated item rate from ' . $original_item->rate . ' to ' . $item['rate']);
                    $affectedRows++;
                }
                // CHeck for invoice quantity change
                $this->db->where('id', $order_item_id);
                $this->db->update('tblpurchaseorderitems', array(
                    'qty' => $item['qty']
                ));

                if ($this->db->affected_rows() > 0) {
                    $this->log_purchaseorder_activity($id, 'updated quantity on item <b>' . $item['description'] . '</b> from ' . $original_item->qty . ' to ' . $item['qty']);
                    $affectedRows++;
                }
            }
        }

        if (count($newitems) > 0) {
            // echo "<pre>";
            // print_r($newitems);
            // die;
            $this->db->where('orderid', $id);
            $this->db->delete('tblpurchaseorderitems');
            foreach ($newitems as $key => $item) {

               

                // if($item['order'] != $id)
                // {
                    $this->db->insert('tblpurchaseorderitems', array(
                        'sku' => $item['sku'],
    					'oursku' => $item['oursku'],
                        'description' => $item['description'],
                        'disc'=>$item['disc'],
                        'qty' => $item['qty'],
                        'itemorder_id'=>$item['itemorder_id'],
                        'rate' => $item['rate'],
                        'taxid' => $item['taxid'],
                        'orderid' => $id,
                        'item_order' => $item['order'],
                    ));
                

                    $new_item_added = $this->db->insert_id();
                    if ($new_item_added) {
                        $this->log_purchaseorder_activity($id, 'added new item <b>' . $item['description'] . '</b>');
                        $affectedRows++;
                    }
                // }
                // else
                // {
                //     $this->db->where('id', $item['itemid']);
                //     $this->db->update('tblpurchaseorderitems', array(
                //         'sku' => $item['sku'],
                //         'oursku' => $item['oursku'],
                //         'description' => $item['description'],
                //         'disc'=>$item['disc'],
                //         'qty' => $item['qty'],
                //         'itemorder_id'=>$item['itemorder_id'],
                //         'rate' => $item['rate'],
                //         'taxid' => $item['taxid'],
                //         'orderid' => $id,
                //         'item_order' => $item['order'],          
                //     ));
                // }

            }
        }

        if ($affectedRows > 0) {
            do_action('after_order_updated', $id);
            return true;
        }

        return false;
    }

    public function client_order_action($action, $id) {
        $this->db->where('id', $id);
        $this->db->update('tblpurchaseorders', array(
            'status' => $action
        ));

        if ($this->db->affected_rows() > 0) {
            $this->load->model('staff_model');
            $staff = $this->staff_model->get('', 1);
            $estimate = $this->get($id);
            $invoiceid = false;
            $invoiced = false;
            if ($action == 4) {
//                if (get_option('order_auto_convert_to_invoice_on_client_accept') == 1) {
//                    $invoiceid = $this->convert_to_invoice($id, true);
//                    $this->load->model('invoices_model');
//                    if ($invoiceid) {
//                        $invoiced = true;
//                        $invoice = $this->invoices_model->get($invoiceid);
//                        $this->log_purchaseorder_activity($id, 'Client accepted this estimate. Estimate is converted to invoice with number <a href="' . admin_url('invoices/list_invoices/' . $invoiceid) . '">' . format_invoice_number($invoice->number) . '</a>', false, true);
//                    }
//
//                } else {
//                    $this->log_purchaseorder_activity($id, 'Client accepted this estimate.', false, true);
//                }
                $this->log_purchaseorder_activity($id, 'Client accepted this estimate.', false, true);

                // add notifications for all users which have permissions manageSales
                foreach ($staff as $member) {
                    if (has_permission('manageSales', $member['staffid'])) {
                        add_notification(array(
                            'fromcompany' => true,
                            'touserid' => $member['staffid'],
                            'description' => 'Congratiolations! Client accepted estimate with number ' . format_order_number($order->number),
                            'link' => 'orders/list_orders/' . $id
                        ));
                    }
                }

                return array(
                    'invoiced' => $invoiced,
                    'invoiceid' => $invoiceid
                );
            } else if ($action == 3) {
                // add notifications for all users which have permissions manageSales
                foreach ($staff as $member) {
                    if (has_permission('manageSales', $member['staffod'])) {
                        add_notification(array(
                            'fromcompany' => true,
                            'touserid' => $member['staffid'],
                            'description' => 'Client declined estimate with number ' . format_order_number($order->number),
                            'link' => 'orders/list_orders/' . $id
                        ));
                    }
                }
                $this->log_purchaseorder_activity($id, 'Client declined this estimate.', false, true);
                return true;
            }
        }

        return false;
    }

    /**
     * Delete estimate items and all connections
     * @param  mixed $id orderid
     * @return boolean
     */
    public function delete($id) {

//        if (get_option('delete_only_on_last_estimate') == 1) {
//            if (!is_last_estimate($id)) {
//                return false;
//            }
//        }

        do_action('before_order_deleted', $id);
        $this->db->where('id', $id);
        $this->db->delete('tblpurchaseorders');

        if ($this->db->affected_rows() > 0) {
//            if (get_option('order_number_decrement_on_delete') == 1) {
//                $current_next_order_number = get_option('next_order_number');
//                if ($current_next_order_number > 1) {
//                    // Decrement next estimate number to
//                    $this->db->where('name', 'next_order_number');
//                    $this->db->set('value', 'value-1', FALSE);
//                    $this->db->update('tbloptions');
//                }
//            }
            $this->db->where('orderid', $id);
            $this->db->delete('tblorderitems');

            $this->db->where('orderid', $id);
            $this->db->delete('tblpurchaseorderactivity');

            // Delete the custom field values
            $this->db->where('relid', $id);
            $this->db->where('fieldto', 'invoice');
            $this->db->delete('tblcustomfieldsvalues');

            return true;
        }
        return false;
    }

    /**
     * Set estimate to sent when email is successfuly sended to client
     * @param mixed $id orderid
     */
    public function set_order_sent($id) {
        $this->db->where('id', $id);
        $this->db->update('tblpurchaseorders', array(
            'sent' => 1,
            'datesend' => date('Y-m-d H:i:s')
        ));

        $description = 'sent order to client';
        $this->log_purchaseorder_activity($id, $description);

        // Update estimate status to sent
        $this->db->where('id', $id);
        $this->db->update('tblpurchaseorders', array(
            'status' => 2
        ));
    }

    /**
     * Sent estimate to client
     * @param  mixed  $id        orderid
     * @param  string  $template  email template to sent
     * @param  boolean $attachpdf attach estimate pdf or not
     * @return boolean
     */
    public function sent_order_to_client($id, $template = '', $attachpdf = true) {

        $this->load->model('emails_model');
        $order = $this->get($id);
        if ($template == '') {
            if ($order->sent == 0) {
                $template = 'order-send-to-client';
            } else {
                $template = 'order-already-send';
            }
        }

        $order_number = format_purchaseorder_number($order->number);
        $pdf = purchaseorder_pdf($order);

        if ($attachpdf) {
            $attach = $pdf->Output($order_number . '.pdf', 'S');
            $this->emails_model->add_attachment($attach, $order_number . '.pdf', 'application/pdf');
        }

        $send = $this->emails_model->send_email_template($template, $order->supplier->email, $order->supplirid, false, false, false, $id);
        if ($send) {
            $this->set_order_sent($id);
            return true;
        }

        return false;
    }

    /**
     * All estimate activity
     * @param  mixed $id orderid
     * @return array
     */
    public function get_order_activity($id) {
        $this->db->where('orderid', $id);
        $this->db->order_by('date', 'asc');
        return $this->db->get('tblpurchaseorderactivity')->result_array();
    }

    /**
     * Log estimate activity to database
     * @param  mixed $id   orderid
     * @param  string $description activity description
     */
    public function log_purchaseorder_activity($id, $description = '', $cron = false, $client = false) {
        $staffid = get_staff_user_id();

        if ($cron == true) {
            $staffid = 'Cron Job';
        } else if ($client == true) {
            $staffid = NULL;
        }

        $this->db->insert('tblpurchaseorderactivity', array(
            'description' => $description,
            'date' => date('Y-m-d H:i:s'),
            'orderid' => $id,
            'staffid' => $staffid
        ));
    }

    function get_prev($id) {
        return $this->db->query("select id,supplierid from tblpurchaseorders where id = (select max(id) from tblpurchaseorders where id < $id)")->row();
    }

    function get_next($id) {
        return $this->db->query("select id,supplierid from tblpurchaseorders where id = (select min(id) from tblpurchaseorders where id > $id)")->row();
    }

    function change_order_status($status, $id) {
		$this->db->select('status');
       $this->db->where('id', $id);
       $old_status= $this->db->get('tblpurchaseorders')->row()->status;
	   
        $this->db->where('id', $id);
        $this->db->update('tblpurchaseorders', array('status' => $status));
		
		if( $status>=3)
		{
			
			$items=$this->get_items_sku_qty($id);
			foreach($items as $item)
			{
				if($old_status==3)
				{
					$this->db->where('sku', $item['sku']);
					$this->db->set('onorder', 'onorder - '.$item["qty"], FALSE);
					$this->db->update('tblinvoiceitemslist');
				}
				
				if($old_status==4)
				{
					$this->db->where('sku', $item['sku']);
					$this->db->set('intransit', 'intransit - '.$item["qty"], FALSE);
					$this->db->update('tblinvoiceitemslist');
				}
				
				if( $status==3)
				{
					$this->db->where('sku', $item['sku']);
					$this->db->set('onorder', 'onorder+'.$item["qty"], FALSE);
					$this->db->update('tblinvoiceitemslist');
				}
				if( $status==4)
				{
					$this->db->where('sku', $item['sku']);
					$this->db->set('intransit', 'intransit+'.$item["qty"], FALSE);
					$this->db->update('tblinvoiceitemslist');
				}
				if( $status==5)
				{
					$this->db->where('sku', $item['sku']);
					$this->db->set('receiving', 'receiving+'.$item["qty"], FALSE);
					$this->db->update('tblinvoiceitemslist');
				}
			}
		}
		return 1;
    }
    public function update_credit($amount,$id){
       $this->db->query("UPDATE tblclients SET credit_limit = credit_limit + $amount WHERE userid =".$id);
    }

    public function getinvoices($id) {
       return   $this->db->select_sum('total')->where('status !=','2')->where('clientid',$id)->get('tblinvoices')->row();
    }
    public function getorders($id) {
       return   $this->db->select_sum('total')->where('clientid',$id)->get('tblpurchaseorders')->row();
    }
    public function getcredit($id) {
       return   $this->db->where('userid',$id)->get('tblclients')->row();
    }
   public function get_contacts($id){
       return $this->db->where('userid',$id)->get('tblsuppliercontacts')->result();
    }
   public function get_where_contacts($id){
      
       return $this->db->where('userid',$id)->get('tblsuppliercontacts')->result();
    }
     public function get_discount($id){
         return   $this->db->where('id',$id)->get('tbldiscounts')->row()->discountrate;  
    }
    

}
