<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Misc_model extends CRM_Model {

    public $notifications_limit = 15;

    function __construct() {
        parent::__construct();
    }

    public function get_taxes_dropdown_template($name, $taxid,$disc_name, $disc,$itemid) {
     
        $this->load->model('taxes_model');
        $taxes = $this->taxes_model->get();
        $this->load->model('discount_model');
        $discounts = $this->discount_model->get_discounts($itemid);
        $select = '<select class="selectpicker display-block tax" data-width="100%" name="' . $name . '">';
        $_no_tax_selected = '';
        if (!$taxid) {
            $_no_tax_selected = 'selected';
        }
        $select .= '<option value="0" ' . $_no_tax_selected . ' data-taxrate="0">' . _l('no_tax') . '</option>';
        foreach ($taxes as $tax) {
            $selected = '';
            if ($taxid == $tax['id']) {
                $selected = 'selected';
            }
            $select .= '<option value="' . $tax['id'] . '" ' . $selected . ' data-taxrate="' . $tax['taxrate'] . '" data-taxname="' . $tax['name'] . '" data-subtext="' . $tax['name'] . '">' . $tax['taxrate'] . '%</option>';
        }
        $select .= '</select>';
        
         $select1 = '<select class="selectpicker display-block disc" data-width="100%" name="' . $disc_name . '">';
         $_no_dic_selected = '';
                if (!$disc) {
                    $_no_dic_selected = 'selected';
                }
                $select1 .= '<option value="0" ' . $_no_dic_selected . ' data-text="0">0%</option>';
                foreach ($discounts as $discount) {
                    $selecteddic = '';
                    if ($disc == $discount->id) {
                        $selecteddic = 'selected';
                    }
                    $select1 .= '<option value="' . $discount->id . '" ' . $selecteddic . '  data-text="' . $discount->discountrate . '" >' . $discount->discountrate . '%</option>';
                }
           $select1 .= '</select>';
         
           return json_encode(array('tax' => $select, 'disc' => $select1));
   
    }
    public function get_uofm_dropdown_template($name, $uofmid,$itemid) {
     
        $this->load->model('units_model');
        $uofm = $this->units_model->get_units();

        $select = '<select class="selectpicker display-block tax" data-width="100%" name="' . $name . '">';
        $_no_tax_selected = '';
        if (!$uofmid) {
            $_no_tax_selected = 'selected';
        }
        $select .= '<option value="0" ' . $_no_tax_selected . ' ></option>';
        foreach ($uofm as $val) {
            $selected = '';
            if ($uofmid == $val['id']) {
                $selected = 'selected';
            }
            $select .= '<option value="' . $val['id'] . '" ' . $selected . ' >' . $val['name'] . '</option>';
        }
        $select .= '</select>';
        
       
         
           return json_encode(array('uofm' => $select));
   
    }

    public function get_ledger_dropdown_template($name, $ledgerid , $type_name , $amount_type_value) {
        $this->load->model('vouchers_model');
        $ledgers = $this->vouchers_model->get_ledgers();

        $select = '<select get_ledger_dropdown_template class="selectpicker display-block ledger" data-width="100%" name="' . $name . '">';
        $_no_ledger_selected = '';
        if (!$ledgerid) {
            $_no_ledger_selected = 'selected';
        }
//        $select .= '<option value="" ' . $_no_ledger_selected . ' ></option>';
        foreach ($ledgers as $ledr) {
            $selected = '';
            if ($ledgerid == $ledr->id) {
                $selected = 'selected';
            }
            $select .= '<option value="' . $ledr->id . '" ' . $selected . ' >' . $ledr->name . '</option>';
        }
        $select .= '</select>';
 
	
	   $select1 = '<select get_ledger_dropdown_template class="selectpicker display-block amount_type" data-width="100%" name="' .  $type_name . '">';
        $_no_ledger_selected = '';
        if (!$ledgerid) {
            $_no_ledger_selected = 'selected';
        }
//        $select1 .= '<option value="" ' . $_no_ledger_selected . ' ></option>';
		$ledgers = array();
		$ledgers[0]['id'] = 0  ; $ledgers[0]['name'] = "Debit"  ; 
		$ledgers[1]['id'] = 1  ; $ledgers[1]['name'] = "Credit"  ; 
        foreach ($ledgers as $ledr) {
            $selected = '';
            if ($ledr['id'] == $amount_type_value) {
                $selected = 'selected';
            }
            $select1 .= '<option value="' . $ledr['id'] . '" ' . $selected . ' >' . $ledr['name'] . '</option>';
        }
        $select1 .= '</select>';
         
           return json_encode(array('ledger' => $select, 'amount_type' => $select1));

    }

    public function get_modules($name, $moduleid, $access_name, $accessid) {

        $selected = 'selected';
        $select = '<select get_module_dropdown_template class="selectpicker display-block module" data-width="100%" name="' . $name . '">';

        $select .= '<option value="1" ' . ($moduleid == 1 ? $selected : "") . ' >Module 1</option>';
        $select .= '<option value="2" ' . ($moduleid == 2 ? $selected : "") . ' >Module 2</option>';
        $select .= '<option value="3" ' . ($moduleid == 3 ? $selected : "" ) . ' >Module 3</option>';
        $select .= '<option value="4" ' . ($moduleid == 4 ? $selected : "" ) . ' >Module 4</option>';
        $select .= '<option value="5" ' . ($moduleid == 5 ? $selected : "" ) . ' >Module 5</option>';
        $select .= '</select>';

        $select1 = '<select get_access_dropdown_template class="selectpicker display-block access" data-width="100%" name="' . $access_name . '">';

        $select1 .= '<option value="1" ' . ($accessid == 1 ? $selected : "") . ' >All</option>';
        $select1 .= '<option value="2" ' . ($accessid == 2 ? $selected : "") . ' >None</option>';

        $select1 .= '</select>';
        return json_encode(array('module' => $select, 'access' => $select1));
    }

    public function getbfore_modules($name, $moduleid) {
        $selected = 'selected';

        $select = '<select get_module_dropdown_template class="selectpicker display-block module" data-width="100%" name="' . $name . '">';

        $select .= '<option value="1" ' . ($moduleid == 1 ? $selected : "") . ' >Module 1</option>';
        $select .= '<option value="2" ' . ($moduleid == 2 ? $selected : "") . ' >Module 2</option>';
        $select .= '<option value="3" ' . ($moduleid == 3 ? $selected : "" ) . ' >Module 3</option>';
        $select .= '<option value="4" ' . ($moduleid == 4 ? $selected : "" ) . ' >Module 4</option>';
        $select .= '<option value="5" ' . ($moduleid == 5 ? $selected : "" ) . ' >Module 5</option>';
        $select .= '</select>';
        return $select;
    }

    public function getbfore_access($name, $accessid) {

        $selected = 'selected';
        $select = '<select get_access_dropdown_template class="selectpicker display-block access" data-width="100%" name="' . $name . '">';

        $select .= '<option value="1" ' . ($accessid == 1 ? $selected : "") . ' >All</option>';
        $select .= '<option value="2" ' . ($accessid == 2 ? $selected : "") . ' >None</option>';

        $select .= '</select>';
        return $select;
    }

    /**
     * Add reminder
     * @since  Version 1.0.2
     * @param mixed $data All $_POST data for the reminder
     * @param mixed $id   relid id
     * @return boolean
     */
    public function add_reminder($data, $id) {

        if (isset($data['notify_by_email'])) {
            $data['notify_by_email'] = 1;
        } else {
            $data['notify_by_email'] = 0;
        }

        $data['date'] = to_sql_date($data['date']);
        $data['description'] = nl2br($data['description']);
        $data['creator'] = get_staff_user_id();
        $this->db->insert('tblreminders', $data);

        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            logActivity('New Reminder Added [' . ucfirst($data['rel_type']) . 'ID: ' . $data['rel_id'] . ' Description: ' . $data['description'] . ']');
            return true;
        }

        return false;
    }

    /**
     * Get all reminders or 1 reminder if id is passed
     * @since Version 1.0.2
     * @param  mixed $id reminder id OPTIONAL
     * @return array or object
     */
    public function get_reminders($id = '') {

        $this->db->join('tblstaff', 'tblstaff.staffid = tblreminders.staff');

        if (is_numeric($id)) {
            $this->db->where('tblreminders.id', $id);
            return $this->db->get('tblreminders')->row();
        }

        $this->db->order_by('date', 'desc');
        return $this->db->get('tblreminders')->result_array();
    }

    /**
     * Remove client reminder from database
     * @since Version 1.0.2
     * @param  mixed $id reminder id
     * @return boolean
     */
    public function delete_reminder($id) {
        $reminder = $this->get_reminders($id);
        if ($reminder->creator == get_staff_user_id() || is_admin()) {
            $this->db->where('id', $id);
            $this->db->delete('tblreminders');
            if ($this->db->affected_rows() > 0) {
                logActivity('Reminder Deleted [' . ucfirst($reminder->rel_type) . 'ID: ' . $reminder->id . ' Description: ' . $reminder->description . ']');
                return true;
            }
            return false;
        }

        return false;
    }

    public function get_google_calendar_ids() {

        $is_admin = is_admin();
        $this->load->model('departments_model');
        $departments = $this->departments_model->get();
        $staff_departments = $this->departments_model->get_staff_departments(false, true);
        $ids = array();
        // Check departments google calendar ids
        foreach ($departments as $department) {
            if ($department['calendar_id'] == '') {
                continue;
            }
            if ($is_admin) {
                $ids[] = $department['calendar_id'];
            } else {
                if (in_array($department['departmentid'], $staff_departments)) {
                    $ids[] = $department['calendar_id'];
                }
            }
        }
        // Ok now check if main calendar is setup
        $main_id_calendar = get_option('google_calendar_main_calendar');
        if ($main_id_calendar != '') {
            $ids[] = $main_id_calendar;
        }

        return $ids;
    }

    /**
     * Get current user notifications
     * @param  boolean $read include and readed notifications
     * @return array
     */
    public function get_user_notifications($read = 1) {
        $total = 10;
        $total_unread = total_rows('tblnotifications', array(
            'isread' => $read,
            'touserid' => get_staff_user_id()
        ));
        if (is_numeric($read)) {
            $this->db->where('isread', $read);
        }
        if ($total_unread > $total) {
            $_diff = $total_unread - $total;
            $total = $_diff + $total;
        }

        $this->db->where('touserid', get_staff_user_id());
        $this->db->limit($total);
        $this->db->order_by('date', 'desc');
        return $this->db->get('tblnotifications')->result_array();
    }

    /**
     * Get current user all notifications
     * @param  mixed $page page number / ajax request
     * @return array
     */
    public function get_all_user_notifications($page) {

        $offset = ($page * $this->notifications_limit);
        $this->db->limit($this->notifications_limit, $offset);
        $this->db->where('touserid', get_staff_user_id());
        $this->db->order_by('date', 'desc');
        $notifications = $this->db->get('tblnotifications')->result_array();
        $i = 0;
        foreach ($notifications as $notification) {
            if ($notification['fromcompany'] == NULL) {
                $notifications[$i]['profile_image'] = '<a href="' . admin_url('staff/profile/' . $notification['fromuserid']) . '">' . staff_profile_image($notification['fromuserid'], array(
                            'staff-profile-image-small',
                            'img-circle',
                            'pull-left'
                        )) . '</a>';
            } else {
                $notifications[$i]['profile_image'] = '';
            }
            $notifications[$i]['date'] = time_ago($notification['date']);
            $i++;
        }

        return $notifications;
    }

    /**
     * Set notification read when user open notification dropdown
     * @return boolean
     */
    public function set_notifications_read() {
        $this->db->where('touserid', get_staff_user_id());
        $this->db->update('tblnotifications', array(
            'isread' => 1
        ));
        if ($this->db->affected_rows() > 0) {
            return true;
        }

        return false;
    }

    /**
     * Dismiss announcement
     * @param  array  $data  announcement data
     * @param  boolean $staff is staff or client
     * @return boolean
     */
    public function dismiss_announcement($data, $staff = true) {
        if ($staff == false) {
            $userid = get_client_user_id();
        } else {
            $userid = get_staff_user_id();
        }
        $data['userid'] = $userid;
        $data['staff'] = $staff;

        $this->db->insert('tbldismissedannouncements', $data);
        return true;
    }

    /**
     * Add user note (used for staff and clients)
     * @param array $data   note data
     * @param mixed $userid staff/client id
     * @param boolean $staff  is staff or client
     */
    public function add_user_note($data, $userid, $staff) {
        $data['dateadded'] = date('Y-m-d H:i:s');
        $data['addedfrom'] = get_staff_user_id();
        $data['staff'] = $staff;
        $data['description'] = nl2br($data['description']);
        $data['userid'] = $userid;

        $this->db->insert('tbluseradminnotes', $data);
        $insert_id = $this->db->insert_id();

        if ($insert_id) {
            logActivity('User Note Added [UserID: ' . $userid . ' Staff: ' . $staff . ']');
        }

        return $insert_id;
    }

    public function add_employee_note($data, $empid, $staff) {
        $data['dateadded'] = date('Y-m-d H:i:s');
        $data['addedfrom'] = get_staff_user_id();
        $data['staff'] = $staff;
        $data['description'] = nl2br($data['description']);
        $data['empid'] = $empid;

        $this->db->insert('tblemployeeadminnotes', $data);
        $insert_id = $this->db->insert_id();

        if ($insert_id) {
            logActivity('Employee Note Added [Empid: ' . $empid . ' Staff: ' . $staff . ']');
        }

        return $insert_id;
    }
    
    public function add_item_note($data, $userid, $staff) {
        $data['dateadded'] = date('Y-m-d H:i:s');
        $data['addedfrom'] = get_staff_user_id();
        $data['staff'] = $staff;
        $data['description'] = nl2br($data['description']);
        $data['itemid'] = $userid;

        $this->db->insert('tblinvoiceitmnotes', $data);
        $insert_id = $this->db->insert_id();

        if ($insert_id) {
            logActivity('Item Note Added [Item ID: ' . $userid . ' Staff: ' . $staff . ']');
        }

        return $insert_id;
    }

    public function add_supplier_note($data, $userid, $staff) {
        $data['dateadded'] = date('Y-m-d H:i:s');
        $data['addedfrom'] = get_staff_user_id();
        $data['staff'] = $staff;
        $data['description'] = nl2br($data['description']);
        $data['userid'] = $userid;

        $this->db->insert('tblsupplieradminnotes', $data);
        $insert_id = $this->db->insert_id();

        if ($insert_id) {
            logActivity('Suppliere Note Added [UserID: ' . $userid . ' Staff: ' . $staff . ']');
        }

        return $insert_id;
    }

    /**
     * Get all user notes / Staff or client
     * @param  mixed  $userid staff/client idate(format)
     * @param  boolean $staff  is staff or client
     * @return array
     */
    public function get_user_notes($userid, $staff = true) {
        $this->db->select('tbluseradminnotes.dateadded,description,usernoteid,tblstaff.firstname,tblstaff.lastname,addedfrom');
        $this->db->from('tbluseradminnotes');
        $this->db->join('tblstaff', 'tbluseradminnotes.addedfrom = tblstaff.staffid', 'left');
        $this->db->where('staff', $staff);
        $this->db->where('tbluseradminnotes.userid', $userid);
        $this->db->order_by('tbluseradminnotes.dateadded', 'ASC');
        return $this->db->get()->result_array();
    }

    public function get_employee_notes($empid, $staff = true) {
        $this->db->select('tblemployeeadminnotes.dateadded,description,empnoteid,tblstaff.firstname,tblstaff.lastname,addedfrom');
        $this->db->from('tblemployeeadminnotes');
        $this->db->join('tblstaff', 'tblemployeeadminnotes.addedfrom = tblstaff.staffid', 'left');
        $this->db->where('staff', $staff);
        $this->db->where('tblemployeeadminnotes.empid', $empid);
        $this->db->order_by('tblemployeeadminnotes.dateadded', 'ASC');
        return $this->db->get()->result_array();
    }

    /**
     * Perform search on top header
     * @since  Version 1.0.1
     * @param  string $q search
     * @return array    search results
     */
    public function perform_search($q) {

        $result = array();
        $limit = get_option('limit_top_search_bar_results_to');
        // Clients
        $this->db->select()
                ->join('tblcountries', 'tblcountries.country_id = tblclients.country')
                ->from('tblclients')
                ->like('firstname', $q)
                ->or_like('lastname', $q)
                ->or_like('email', $q)
                ->or_like("CONCAT(firstname, ' ', lastname)", $q)
                ->or_like('company', $q)
                ->or_like('vat', $q)
                ->or_like('phonenumber', $q)
                ->or_like('city', $q)
                ->or_like('zip', $q)
                ->or_like('state', $q)
                ->or_like('address', $q)
                ->or_like('tblcountries.short_name', $q)
                ->or_like('tblcountries.long_name', $q)
                ->or_like('tblcountries.numcode', $q)
                ->or_like('tblcountries.calling_code', $q)
                ->limit($limit);

        $result['clients'] = $this->db->get()->result_array();

        // Staff
        $this->db->select()
                ->from('tblstaff')
                ->like('firstname', $q)
                ->or_like('lastname', $q)
                ->or_like("CONCAT(firstname, ' ', lastname)", $q, FALSE)
                ->or_like('facebook', $q)
                ->or_like('linkedin', $q)
                ->or_like('phonenumber', $q)
                ->or_like('email', $q)
                ->or_like('skype', $q)
                ->limit($limit);

        $result['staff'] = $this->db->get()->result_array();

        // Tickets
        $this->db->select()
                ->join('tbldepartments', 'tbldepartments.departmentid = tbltickets.department')
                ->from('tbltickets')
                ->like('ticketid', $q)
                ->or_like('subject', $q)
                ->or_like('message', $q)
                ->or_like('tbldepartments.name', $q)
                ->limit($limit);

        $result['tickets'] = $this->db->get()->result_array();

        // Surveys
        $this->db->select()
                ->from('tblsurveys')
                ->like('subject', $q)
                ->or_like('slug', $q)
                ->or_like('description', $q)
                ->or_like('viewdescription', $q)
                ->limit($limit);

        $result['surveys'] = $this->db->get()->result_array();

        // Knowledge base articles
        $this->db->select()
                ->from('tblknowledgebase')
                ->like('subject', $q)
                ->or_like('description', $q)
                ->or_like('slug', $q)
                ->limit($limit);

        $result['knowledge_base_articles'] = $this->db->get()->result_array();

        // Leads
        $this->db->select()
                ->from('tblleads')
                ->like('name', $q)
                ->or_like('email', $q)
                ->or_like('phonenumber', $q)
                ->or_like('notes', $q)
                ->limit($limit);

        $result['leads'] = $this->db->get()->result_array();

        // Staff tasks
        $this->db->select()
                ->from('tblstafftasks')
                ->like('name', $q)
                ->or_like('priority', $q)
                ->or_like('description', $q)
                ->limit($limit);

        $result['tasks'] = $this->db->get()->result_array();

        // Contracts
        $this->db->select()
                ->from('tblcontracts')
                ->like('description', $q)
                ->or_like('subject', $q)
                ->limit($limit);

        $result['contracts'] = $this->db->get()->result_array();

        // Invoice payment records
        $this->db->select('*,tblinvoicepaymentrecords.id as paymentid')
                ->from('tblinvoicepaymentrecords')
                ->join('tblinvoicepaymentsmodes', 'tblinvoicepaymentrecords.paymentmode = tblinvoicepaymentsmodes.id', 'LEFT')
                ->like('tblinvoicepaymentrecords.id', $q)
                ->or_like('paymentmode', $q)
                ->or_like('tblinvoicepaymentsmodes.name', $q)
                ->or_like('invoiceid', $q)
                ->limit($limit);

        $result['invoice_payment_records'] = $this->db->get()->result_array();

        // Invoices
        $this->db->select('*,tblinvoices.id as invoiceid')
                ->from('tblinvoices')
                ->join('tblclients', 'tblclients.userid = tblinvoices.clientid')
                ->join('tblcurrencies', 'tblcurrencies.id = tblinvoices.currency')
                ->like('number', $q)
                ->or_like('year', $q)
                ->or_like("CONCAT(firstname, ' ', lastname)", $q, FALSE)
                ->or_like('company', $q)
                ->or_like('clientnote', $q)
                ->or_like('email', $q)
                ->or_like('vat', $q)
                ->or_like('phonenumber', $q)
                ->or_like('city', $q)
                ->or_like('zip', $q)
                ->or_like('state', $q)
                ->or_like('address', $q)
                ->or_like('adminnote', $q)
                ->or_like('tblinvoices.id', $q)
                ->or_like('token', $q)
                ->limit($limit);

        $result['invoices'] = $this->db->get()->result_array();

        // Expenses
        $this->db->select('*,tblexpenses.amount as amount,tblexpensescategories.name as category_name,tblinvoicepaymentsmodes.name as payment_mode_name,tbltaxes.name as tax_name, tblexpenses.id as expenseid')
                ->from('tblexpenses')
                ->join('tblclients', 'tblclients.userid = tblexpenses.clientid', 'left')
                ->join('tblinvoicepaymentsmodes', 'tblinvoicepaymentsmodes.id = tblexpenses.paymentmode', 'left')
                ->join('tbltaxes', 'tbltaxes.id = tblexpenses.tax', 'left')
                ->join('tblexpensescategories', 'tblexpensescategories.id = tblexpenses.category')
                ->or_like("CONCAT(firstname, ' ', lastname)", $q, FALSE)
                ->or_like('company', $q)
                ->or_like('paymentmode', $q)
                ->or_like('tblinvoicepaymentsmodes.name', $q)
                ->or_like('email', $q)
                ->or_like('vat', $q)
                ->or_like('phonenumber', $q)
                ->or_like('city', $q)
                ->or_like('zip', $q)
                ->or_like('state', $q)
                ->or_like('address', $q)
                ->or_like('tblexpensescategories.name', $q)
                ->or_like('tblexpenses.note', $q)
                ->limit($limit);

        $result['expenses'] = $this->db->get()->result_array();

        // Goals
        $this->db->select()
                ->from('tblgoals')
                ->like('description', $q)
                ->or_like('subject', $q)
                ->limit($limit);

        $result['goals'] = $this->db->get()->result_array();

        // Custom fields
        $this->db->select()
                ->from('tblcustomfieldsvalues')
                ->like('value', $q)
                ->limit($limit);

        $result['custom_fields'] = $this->db->get()->result_array();

        // Invoice items
        $this->db->select()
                ->from('tblinvoiceitems')
                ->like('description', $q)
                ->or_like('long_description', $q)
                ->limit($limit);

        $result['invoice_items'] = $this->db->get()->result_array();

        return $result;
    }

    public function get_supplier_notes($userid, $staff = true) {
        $this->db->select('tblsupplieradminnotes.dateadded,description,usernoteid,tblstaff.firstname,tblstaff.lastname,addedfrom');
        $this->db->from('tblsupplieradminnotes');
        $this->db->join('tblstaff', 'tblsupplieradminnotes.addedfrom = tblstaff.staffid', 'left');
        $this->db->where('staff', $staff);
        $this->db->where('tblsupplieradminnotes.userid', $userid);
        $this->db->order_by('tblsupplieradminnotes.dateadded', 'ASC');
        return $this->db->get()->result_array();
    }
    public function get_items_notes($itemid, $staff = true) {
        $this->db->select('tblinvoiceitmnotes.dateadded,description,usernoteid,tblstaff.firstname,tblstaff.lastname,addedfrom');
        $this->db->from('tblinvoiceitmnotes');
        $this->db->join('tblstaff', 'tblinvoiceitmnotes.addedfrom = tblstaff.staffid', 'left');
        $this->db->where('staff', $staff);
        $this->db->where('tblinvoiceitmnotes.itemid', $itemid);
        $this->db->order_by('tblinvoiceitmnotes.dateadded', 'ASC');
        return $this->db->get()->result_array();
    }

    public function get_manufacturer_notes($userid, $staff = true) {
        $this->db->select('tblmanufacturersnotes.dateadded,description,usernoteid,tblstaff.firstname,tblstaff.lastname,addedfrom');
        $this->db->from('tblmanufacturersnotes');
        $this->db->join('tblstaff', 'tblmanufacturersnotes.addedfrom = tblstaff.staffid', 'left');
        $this->db->where('staff', $staff);
        $this->db->where('tblmanufacturersnotes.userid', $userid);
        $this->db->order_by('tblmanufacturersnotes.dateadded', 'ASC');
        return $this->db->get()->result_array();
    }

    public function delete_user_note($noteid) {
        $this->db->where('usernoteid', $noteid);
        $this->db->delete('tbluseradminnotes');
        if ($this->db->affected_rows() > 0) {
            logActivity('User Note Deleted [NoteID: ' . $noteid . ']');
            return true;
        }

        return false;
    }

    public function delete_employee_note($noteid) {
        $this->db->where('empnoteid', $noteid);
        $this->db->delete('tblemployeeadminnotes');
        if ($this->db->affected_rows() > 0) {
            logActivity('Employee Note Deleted [NoteID: ' . $noteid . ']');
            return true;
        }

        return false;
    }

    public function delete_item_note($noteid) {
        $this->db->where('usernoteid', $noteid);
        $this->db->delete('tblinvoiceitmnotes');
        if ($this->db->affected_rows() > 0) {
            logActivity('Item Note Deleted [NoteID: ' . $noteid . ']');
            return true;
        }

        return false;
    }

    public function delete_supplier_note($noteid) {
        $this->db->where('usernoteid', $noteid);
        $this->db->delete('tblsupplieradminnotes');
        if ($this->db->affected_rows() > 0) {
            logActivity('Supplier Note Deleted [NoteID: ' . $noteid . ']');
            return true;
        }

        return false;
    }

    public function add_manufacturer_note($data, $userid, $staff) {
        $data['dateadded'] = date('Y-m-d H:i:s');
        $data['addedfrom'] = get_staff_user_id();
        $data['staff'] = $staff;
        $data['description'] = nl2br($data['description']);
        $data['userid'] = $userid;

        $this->db->insert('tblmanufacturersnotes', $data);
        $insert_id = $this->db->insert_id();

        if ($insert_id) {
            logActivity('Manufacturer Note Added [UserID: ' . $userid . ' Staff: ' . $staff . ']');
        }
    }

    public function delete_manufacturer_note($noteid) {
        $this->db->where('usernoteid', $noteid);
        $this->db->delete('tblmanufacturersnotes');
        if ($this->db->affected_rows() > 0) {
            logActivity('Manufacturer Note Deleted [NoteID: ' . $noteid . ']');
            return true;
        }

        return false;
    }

}
