<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Manufacturers_model extends CRM_Model
{
    function __construct()
    {
        parent::__construct();
    }

    public function get($id = false, $active = '')
    {
         $this->db->join('tblcountries','tblcountries.country_id = tblmanufacturers.country', 'left');
        if (is_int($active)) {
            $this->db->where('active', $active);
        }

        if (is_numeric($id)) {
            $this->db->where('mfid', $id);
            $client = $this->db->get('tblmanufacturers')->row();

            return $client;
        }

        $this->db->order_by('datecreated', 'desc');
        return $this->db->get('tblmanufacturers')->result_array();
    }
    public function add($data)
    {
        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);

         $data = do_action('before_manufacture_added', $data);
         $this->db->insert('tblmanufacturers', $data);
         $userid = $this->db->insert_id();
         return $userid;
    }
    public function update($data,$id){

        unset($data['action']);
        unset($data['isedit']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);
        unset($data['userid']);
        
         $this->db->where('mfid', $id);
        $res = $this->db->update('tblmanufacturers', $data);
        if($res)
            return true;
        else 
           return false;
    }
    public function get_country($id){
   return $this->db->where('country_id',$id)->get('tblcountries')->row();  
}
    public function change_manufacturer_status($id, $status)
    {
        $this->db->where('mfid', $id);
        $this->db->update('tblmanufacturers', array(
            'active' => $status
        ));

        if ($this->db->affected_rows() > 0) {
            logActivity('Manufacturer Status Changed [ManufacturerID: ' . $id . ' Status(Active/Inactive): ' . $status . ']');
            return true;
        }

        return false;
    }
    public function delete($id)
    {

        do_action('before_manufacture_deleted', $id);

        $this->db->where('mfid', $id);
        $res =$this->db->delete('tblmanufacturers');
        if($res)
            return true;
         else 
            return false;
    }
}
