<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Holidays_model extends CRM_Model
{
    function __construct()
    {
        parent::__construct();
    }

    public function get_list()
    {
    	$this->db->select('*');
    	$this->db->from('tblholidays');
        $holiday = $this->db->get()->result();
       	return $holiday;	
    }

    public function add($data)
    {
        $var = $data['date'];
        $date = str_replace('/', '-', $var);

        $insert_data = array(
                            'occasion' => $data['occasion'],
                            'note' => $data['note'],
        					'date' => date('Y-m-d', strtotime($date)),
        					);
   
        $this->db->insert('tblholidays', $insert_data);
        $holiday_id = $this->db->insert_id();

        if ($this->db->affected_rows() > 0) {
            return true;
        }


    	return false; 
    }

    public function getholiday(){
    	return $this->db->where('id', $this->input->post('id'))->get('tblholidays')->row();  
	}

	public function edit($data)
	{
        $var = $data['date'];
        $date = str_replace('/', '-', $var);
        
		$update_data = array(
        					'occasion' => $data['occasion'],
                            'note' => $data['note'],
                            'date' => date('Y-m-d', strtotime($date)),
                            );
		$this->db->where('id', $data['id']);
        $this->db->update('tblholidays', $update_data);

        if ($this->db->affected_rows() > 0) {
            return true;
        }
        return false;
	}

	public function delete($id)
    {

        $affectedRows = 0;
        
        $this->db->where('id', $id);
        $this->db->delete('tblholidays');
        
        if ($this->db->affected_rows() > 0) {
            
            return true;
        }
        return false;
    }
}