<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Grn_model extends CRM_Model {

    function __construct() {
        parent::__construct();
    }

    /**
     * Get invoice by id
     * @param  mixed $id
     * @return array
     */
    public function get_poid($id)
    {
        $this->db->select('tblpurchaseorders.id, tblpurchaseorders.number,tblpurchaseorders.total as pur_total');
        $this->db->from('tblgrns');
        $this->db->join('tblpurchaseorders', "tblpurchaseorders.id = tblgrns.po_id");
        $this->db->where('tblgrns.grnid', $id);
		
		
        return $this->db->get()->row();
    }

    public function get_rfqid($id)
    {
        $this->db->select('tblrfqsqoutes.id, tblrfqsqoutes.number');
        $this->db->from('tblgrns');
        $this->db->join('tblpurchaseorders', "tblpurchaseorders.id = tblgrns.po_id");
        $this->db->join('tblrfqsqoutes', "tblrfqsqoutes.id = tblpurchaseorders.rfq_id");
        $this->db->where('tblgrns.grnid', $id);
        return $this->db->get()->row();
        
    }


    public function get($id = '')
    {
        $this->db->select('tblgrns.*, tblwarehouse.warehouse_name, tblpurchaseorders.number AS po_number');
        $this->db->from('tblgrns');

        if (is_numeric($id)) {
            $this->db->where('tblgrns.grnid', $id);
            $this->db->join('tblwarehouse', "tblwarehouse.ware_id = tblgrns.warehouse");
            $this->db->join('tblpurchaseorders', "tblpurchaseorders.id = tblgrns.po_id");

            $grn = $this->db->get()->row();
            echo $grn->supplierid;
            // if ($grn) {
       			$this->load->model('suppliers_model');
                $grn->supplier = $this->suppliers_model->get($grn->supplierid);
                $grn->items = $this->get_grn_items($id);
            // } 

            // echo "<pre>";
            // print_r($grn);
            // die;

            return $grn;
        }
        return $this->db->get()->result_array();
    }


    public function get_grn($id)
    {
        $this->db->select('tblgrns.*, tblwarehouse.warehouse_name');
        $this->db->from('tblgrns');
        $this->db->where('tblgrns.grnid', $id);
        $this->db->join('tblwarehouse', "tblwarehouse.ware_id = tblgrns.warehouse");
        
        $grn = $this->db->get()->row();
            
        if ($grn) {
            $this->load->model('suppliers_model');
            $grn->supplier = $this->suppliers_model->get($grn->supplierid);
            $grn->items = $this->get_grn_items($id);
        } 

        return $grn;
       
    }


    public function get_items($id) {
        return $this->get_invoice_items($id);
    }

    public function get_uofm() {
        return $this->db->order_by('name', 'ASC')->get('tblunitsofmeasure')->result();
    }

    /**
     * Get all invoice items
     * @param  mixed $id invoiceid
     * @return array
     */
    public function get_grn_items($id)
    {
        $this->db->select('tblgrnitems.*');
        $this->db->from('tblgrnitems');
        $this->db->where('tblgrnitems.grnid', $id);
        $this->db->order_by('tblgrnitems.item_order', 'asc');
        return $this->db->get()->result_array();
  
    }   

    public function get_invoice_item($id) {
		$this->db->select('*');
        $this->db->where('id', $id);
        return $this->db->get('tblgrnitems')->row();
    }

    public function getbalance($id) {
        $this->db->select_sum('amount');
        $this->db->where('invoiceid', $id);
        return $this->db->get('tblinvoicepaymentrecords')->row();
    }

    /**
     * Get this invoice generated recuring invoices
     * @since  Version 1.0.1
     * @param  mixed $id main invoice id
     * @return array
     */
    public function get_invoice_recuring_invoices($id) {
        $this->db->where('is_recurring_from', $id);
        $invoices = $this->db->get('tblinvoices')->result_array();
        $recuring_invoices = array();
        foreach ($invoices as $invoice) {
            $recuring_invoices[] = $this->get($invoice['id']);
        }
        return $recuring_invoices;
    }

    /**
     * Get invoice total from all statuses
     * @since  Version 1.0.2
     * @param  mixed $data $_POST data
     * @return array
     */
    public function get_invoices_total($data) {

        $statuses = array(
            1,
            2,
            3,
            4
        );
        $this->load->model('currencies_model');

        if ((is_using_multiple_currencies() && !isset($data['currency'])) || !isset($data['currency'])) {
            $currencyid = $this->currencies_model->get_base_currency()->id;
        } else if (isset($data['currency'])) {
            $currencyid = $data['currency'];
        }


        $symbol = $this->currencies_model->get_currency_symbol($currencyid);
        $sql = 'SELECT';
        foreach ($statuses as $invoice_status) {
            $sql .= '(SELECT SUM(total) FROM tblinvoices WHERE status=' . $invoice_status;
            $sql .= ' AND currency =' . $currencyid;
            $sql .= ') as "' . $invoice_status . '",';
        }

        $sql = substr($sql, 0, -1);
        $result = $this->db->query($sql)->result_array();
        $_result = array();
        $i = 0;
        foreach ($result as $key => $val) {
            foreach ($val as $total) {
                $_result[$i]['total'] = $total;
                $_result[$i]['symbol'] = $symbol;
                $i++;
            }
        }

        return $_result;
    }

    /**
     * Insert new invoice to database
     * @param array $data invoiec data
     * @return mixed - false if not insert, invoice ID if succes
     */
    function get_ledgerdetails($id) {
        $this->db->select('ldg.*');
        $this->db->from('tblledgergroups as ldg');
        $this->db->join('tblinvoiceitemslist as inl', 'inl.ledger = ldg.id');
        $this->db->where('inl.id', $id);
        return $ldgres = $this->db->get()->row();
    }

    function get_taxrate($id) {

        $this->db->where('id', $id);
        return $this->db->get('tbltaxes')->row();
    }

    public function get_warehouse()
    {
        return $this->db->get('tblwarehouse')->result();
    }

    public function add($data, $cron = false, $expense = false) {

        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);
		unset($data['received']);
		unset($data['ordered']);
		unset($data['discounts']);
		unset($data['salesprice']);
		unset($data['taxrate']);
        // $data['number'] = $data['_number'];
        $data['number'] = get_option('next_grn_number');

        $unsetters = array(
            '_number',
            'currency_symbol',
            'price',
            'suppliersku',
            'itemorder_id',
            'itemrecorid',
            'oursku',
            'description',
            'disc',
            'rate',
            'quantity',
			// 'po_id',
			'discounts'
        );

        $this->db->select('tblpurchaseorders.id,tblpurchaseorders.rfq_id,tblrfqsqoutes.warehouse');
        $this->db->from('tblpurchaseorders');
        $this->db->join('tblrfqsqoutes', 'tblrfqsqoutes.id = tblpurchaseorders.rfq_id');
        $this->db->where('tblpurchaseorders.id', $data["po_id"]);
        $warehouse_id = $this->db->get()->row();
       

		$po_id=$data["po_id"];
        foreach ($unsetters as $unseter) {
            if (isset($data[$unseter])) {
                unset($data[$unseter]);
            }
        }


        $data['hash'] = md5(rand() . microtime());
        // Check if the key exists
        $this->db->where('hash', $data['hash']);
        $exists = $this->db->get('tblgrns')->row();

        if ($exists) {
            $data['hash'] = md5(rand() . microtime());
        }

        $data['note'] = nl2br($data['note']);
        $data['date'] = to_sql_date($data['date']);
        $data['datecreated'] = date('Y-m-d H:i:s');

        $items = array();
		
        if (isset($data['newitems'])) {
            $items = $data['newitems'];
            unset($data['newitems']);
        }
        $supplierid = $data['supplierid'];
        $voucherdate = $data['date'];

        $invoicenumber = format_grn_number($data['number']);

        $_data = do_action('before_grn_added', array(
            'data' => $data,
            'items' => $items
        ));

        $data = $_data['data'];
        $items = $_data['items'];
		
		
		
		
		foreach ($items as $key => $item)
			if($item['received']<$item["ordered"])				
				$data["note"].="Item SKU ".$item["oursku"].":  Ordered ".$item["ordered"]." but received just ".$item['received']."\r\n";
					
				
		
		
		
        $this->db->insert('tblgrns', $data);
        $insert_id = $this->db->insert_id();


        if ($insert_id) {
			if($po_id)
			{
				$this->db->select('qty,sku,oursku');
				$this->db->from('tblpurchaseorderitems');
				$this->db->where('orderid', $po_id);
				$this->db->order_by('item_order', 'asc');
				$original_items= $this->db->get()->result_array();
				$str="";
				
				 foreach ($items as $key => $item) {
					
					foreach($original_items as $origine)
					{
						
						
						if($origine["oursku"]==$item['oursku'])
						{
							
							if($item['received']<$origine["qty"])
							{
								$str.="Item SKU ".$item["oursku"].":  Ordered <b>".$item["ordered"]."</b> but received just <b>".$item['received']."</b>"."\r\n";
								
							}
						}
						
					}
                }
				
				if($str)
				{
					$this->db->where('id', $po_id);
            		$this->db->set('adminnote', $str, true);
            		$this->db->update('tblpurchaseorders');
				}
				else
				{
					$this->db->where('id', $po_id);
            		$this->db->set('status', 5, FALSE);
            		$this->db->update('tblpurchaseorders');
				}
			}
			
			
            // crerate voucher id 
            $this->db->select_max('voucher');
            $this->db->where('vchtype', '1');
            $voucher = $this->db->get('tblvoucher')->row()->voucher;

            if ($voucher) {
                $voucher = ++$voucher;
            } else {
                $voucher = 'GRN0001';
            }

            // calculate total 


            $total = '';
            foreach ($items as $key => $item) {
				
				
				
                $total = ($total + ($item['qty'] * $item['rate']));
            }
            // echo $total;
            // die;

           // create voucer 
            $this->db->insert('tblvoucher', array(
                'voucher' => $voucher,
                'vchtype' => '1',
                'invoiceid' => $insert_id,
                'docdate' => $voucherdate,
                'trxdate' => $voucherdate,
                'created_by' => get_staff_user_id(),
                'currency' => '3',
            ));
            $voucherid = $this->db->insert_id();

            $voucehrdata = array('vchid' => $voucherid);
            $this->db->where('grnid', $insert_id);
            $this->db->update('tblgrns', $voucehrdata);
            
            $this->load->model('settings_model');
            $default_options = $this->settings_model->getOptions();

            // $default_options['GR_ledger'];
            // $default_options['inventory_ledger'];

            $this->db->insert('tblvoucherlines', array(
                'ledger' => $default_options['GR_ledger'],
                'vchid' => $voucherid,
                'amount' => $total,
                'amount_type' => 1,
                'description' => 'Goods received not yet invoiced',
                'refrence' => '',
                'invoiceid' => $insert_id,
                'item_order' => '0',
            ));


            $this->db->insert('tblvoucherlines', array(
                'ledger' => $default_options['inventory_ledger'],
                'vchid' => $voucherid,
                'amount' => $total,
                'amount_type' => 0,
                'description' => 'Inventory',
                'refrence' => '',
                'invoiceid' => $insert_id,
                'item_order' => '0',
            ));

            // $this->db->insert_id();
            // if (trim($data['cicharge'])) {
            //     $this->db->insert('tblvoucherlines', array(
            //         'ledger' => 25,
            //         'vchid' => $voucherid,
            //         'amount' => $data['cicharge'],
            //         'description' => 'Automatic GRN journal',
            //         'refrence' => '',
            //         'invoiceid' => $insert_id,
            //         'item_order' => '1',
            //     ));
            //     $this->db->insert_id();
            // }


            // $array = $this->db->query("SELECT supplier,userid from tblsuppliers where userid=" . $data['supplierid'])->row();
            // $this->db->where('name', ucfirst($array->supplier));
            // $this->db->where('type', 'Ledger');
            // $this->db->where('parent', 19);
            // $res = $this->db->get('tblledgergroups')->row();
            // if (!$res) {
            //     $this->load->model('ledgers_model');
            //     $ledgerdata = array(
            //         'name' => ucfirst($array->supplier),
            //         'description' => $array->supplier,
            //         'type' => 'Ledger',
            //         'parent' => 19,
            //         'accountid' => $array->userid,
            //     );
            //     $ledgerid = $this->ledgers_model->add($ledgerdata);
            //     $this->createpath();
            //     $this->db->insert('tblvoucherlines', array(
            //         'ledger' => $ledgerid,
            //         'vchid' => $voucherid,
            //         'amount' => ($data['cicharge'] + $data['total']),
            //         'description' => 'Automatic GRN journal',
            //         'refrence' => '',
            //         'invoiceid' => $insert_id,
            //         'item_order' => '2',
            //     ));
            // } else {

            //     $this->db->insert('tblvoucherlines', array(
            //         'ledger' => $res->id,
            //         'vchid' => $voucherid,
            //         'amount' => ($data['cicharge'] + $data['total']),
            //         'description' => 'Automatic GRN journal',
            //         'refrence' => '',
            //         'invoiceid' => $insert_id,
            //         'item_order' => '2',
            //     ));
            // }



            // /////////////

            $this->db->where('name', 'next_grn_number');
            $this->db->set('value', 'value+1', FALSE);
            $this->db->update('tbloptions');


            // $this->db->select('tbllocations.location_id');
            // $this->db->from('tbllocations');
            // $this->db->where('tbllocations.ware_id', $warehouse_id->warehouse);
            // $this->db->where('tbllocations.default_location', 1);
            // $location_id = $this->db->get()->row();

            $this->db->select('tbllocations.location_id');
            $this->db->from('tbllocations');
            $this->db->where('tbllocations.ware_id', $data['warehouse']);
            $this->db->where('tbllocations.default_location', 1);
            $location_id = $this->db->get()->row();

            // echo "<pre>";
            // print_r($items);
            // die;

            if (count($items) > 0) {
                $i = 1;

                foreach ($items as $key => $item) {

                    $this->db->insert('tblgrnitems', array(
                        'grnid' => $insert_id,
                        'qty' => $item['received'],
                        'suppliersku' => $item['suppliersku'],
                        'oursku' => $item['oursku'],
                        'description' => $item['description'],
                        'item_order' => $item['order'],
                        'itemorder_id' => $item['itemorder_id'],
                        'itemid' => $item['itemorder_id'],
                        'ordered' => $item['ordered'],
                        'received' => $item['received'],
                    ));



                    // $this->db->select('tblinvoiceitemslist.*');
                    // $this->db->from('tblinvoiceitemslist');
                    // $this->db->where('tblinvoiceitemslist.sku', $item['suppliersku']);
                    // $invoiceitemslist = $this->db->get()->row();

                    $this->db->select('tblwarehousestock.*');
                    $this->db->from('tblwarehousestock');
                    $this->db->where('tblwarehousestock.suppliersku', $item['suppliersku']);
                    $this->db->where('tblwarehousestock.warehouse_id', $warehouse_id->warehouse);
                    $this->db->where('tblwarehousestock.location_id', $location_id->location_id);
                    $warehouse_stock = $this->db->get()->row();

                    if($warehouse_stock)
                    {
                        $this->db->where('id', $warehouse_stock->id);
                        $this->db->set('qty', 'qty+'.$item['received'], FALSE);
                        $this->db->update('tblwarehousestock');
                    }
                    else
                    {
                        $this->db->insert('tblwarehousestock', array(
                            'suppliersku' => $item['suppliersku'],
                            'oursku' => $item['oursku'],
                            'description' => $item['description'],
                            'qty' => $item['received'],
                            // 'warehouse_id' => $warehouse_id->warehouse,
                            'warehouse_id' => $data['warehouse'],
                            'location_id' => $location_id->location_id,
                            // 'grnid' => $insert_id,
                            
                        ));
                    }

                    

                }
            }

            do_action('after_grn_added', $insert_id);
            return $insert_id;
        }

        return false;
    }

    public function createpath() {

        $array = $this->db->query("SELECT * from tblledgergroups")->result_array();
        $array2 = array();
        foreach ($array as $key => $value) {
            $array2[$value['id']] = $value;
        }
        foreach ($array2 as $key => $a) {

            if ($a['parent'] == 0) {
                $data['path'] = $a['name'];
                $this->db->where('id', $a['id']);
                $this->db->update('tblledgergroups', $data);
            } else {
                $b = $a;
                $_a = array($b['name']);
                while ($b['parent'] != 0) {
                    $b = $array2[$b['parent']];
                    $_a[] = $b['name'];
                }


                $data['path'] = implode('/', array_reverse($_a));
                $this->db->where('id', $a['id']);
                $this->db->update('tblledgergroups', $data);
            }
        }
    }

    public function get_term($id) {
        $this->db->select('payment_term');
        $this->db->where('userid', $id);
        return $this->db->get('tblclients')->row();
    }

    public function get_sales_agent($id) {
        $this->db->select('account_req');
        $this->db->where('userid', $id);
        return $this->db->get('tblclients')->row()->account_req;
    }

    public function due_days($id) {
        $this->db->select('dueDays');
        $this->db->where('id', $id);
        return $this->db->get('tblinvoicepaymentsmodes')->row();
    }

    /**
     * Update invoice data
     * @param  array $data invoice data
     * @param  mixed $id   invoiceid
     * @return boolean
     */
    public function update($data, $id) {
        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);
        unset($data['creditlimit']);
        unset($data['itemrecorid']);
        $affectedRows = 0;
        $prefix = get_option('invoice_prefix');

        $data['number'] = substr($data['number'], strlen($prefix));
        $data['number'] = trim($data['number']);

        if (get_option('invoice_number_format') == 2) {
            $_temp_number = explode('/', $data['number']);
            $data['number'] = $_temp_number[1];
        }


        $original_invoice = $this->get($id);
        $original_number = $original_invoice->number;
        $invoicenumber = format_grn_number($original_number);
		
			
        unset($data['currency_symbol']);
        unset($data['price']);
        unset($data['taxname']);
		unset($data['discounts']);
		
        unset($data['taxid']);
        unset($data['isedit']);
        unset($data['sku']);
        unset($data['description']);
        unset($data['long_description']);
        unset($data['disc']);
        unset($data['tax']);
        unset($data['rate']);
        unset($data['quantity']);
	 	unset($data['po_id']);
		unset($data['received']);
		unset($data['ordered']);
		unset($data['oursku']);
		unset($data['suppliersku']);
		unset($data['discounts']);
		unset($data['salesprice']);
		unset($data['taxrate']);
        $items = array();
        if (isset($data['items'])) {
            $items = $data['items'];
            unset($data['items']);
        }

        $newitems = array();
        if (isset($data['newitems'])) {
            $newitems = $data['newitems'];
            unset($data['newitems']);
        }
       


       

        $data['date'] = to_sql_date($data['date']);
        

       

        $action_data = array(
            'data' => $data,
            'newitems' => $newitems,
            'items' => $items,
            'id' => $id,
            'removed_items' => array()
        );
        if (isset($data['removed_items'])) {
            $action_data['removed_items'] = $data['removed_items'];
        }

        $_data = $action_data;
        $data['removed_items'] = $_data['removed_items'];
        $newitems = $_data['newitems'];
        $items = $_data['items'];
        $data = $_data['data'];
		
		foreach ($items as $key => $item)
			if($item['received']<$item["ordered"])				
				$data["note"].="\r\nItem SKU ".$item["oursku"].":  Ordered <b>".$item["ordered"]."</b> but received just <b>".$item['received']."</b>";
        // Delete items checked to be removed from database
        if (isset($data['removed_items'])) {
            foreach ($data['removed_items'] as $remove_item_id) {
                $original_item = $this->get_invoice_item($remove_item_id);
               
                $this->db->where('id', $remove_item_id);
                $this->db->delete('tblgrnitems');
                if ($this->db->affected_rows() > 0) {
                    $this->log_grn_activity($id, 'removed item <b>' . $original_item->description . '</b>');
                    $affectedRows++;
                }
            }
            unset($data['removed_items']);
        }

        $this->db->where('grnid', $id);
        $this->db->update('tblgrns', $data);


        if ($this->db->affected_rows() > 0) {
            
            $affectedRows++;

            if ($original_number != $data['number']) {
                $this->log_grn_activity($original_invoice->id, 'GRN Number Changed: From: ' . format_grn_number($original_number) . ' To: ' . format_grn_number($data['number']));
            }
        }

        $this->load->model('taxes_model');
        if (count($items) > 0) {
            foreach ($items as $key => $item) {
                $invoice_item_id = $item['itemid'];

                $original_item = $this->get_invoice_item($invoice_item_id);

               
                // Check for invoice item short description change
                $this->db->where('id', $invoice_item_id);
                $this->db->update('tblgrnitems', array(
                    'description' => $item['description'],
                ));

                if ($this->db->affected_rows() > 0) {
                    $this->log_grn_activity($id, 'updated item short description from ' . $original_item->description . ' to ' . $item['description']);
                    $affectedRows++;
                }

                // Check for item sku change
                $this->db->where('id', $invoice_item_id);
                $this->db->update('tblgrnitems', array(
                    'oursku' => $item['oursku']
                ));
                

                if ($this->db->affected_rows() > 0) {
                    $this->log_grn_activity($id, 'updated item oursku from ' . $original_item->oursku . ' to ' . $item['oursku']);
                    $affectedRows++;
                }
                  // Check for item sku change
                $this->db->where('id', $invoice_item_id);
                $this->db->update('tblgrnitems', array(
                    'suppliersku' => $item['suppliersku']
                ));
                

                if ($this->db->affected_rows() > 0) {
                    $this->log_grn_activity($id, 'updated item suppliersku from ' . $original_item->suppliersku . ' to ' . $item['suppliersku']);
                    $affectedRows++;
                }

                    
				
				 $this->db->where('id', $invoice_item_id);
                $this->db->update('tblgrnitems', array(
                    'received' => $item['received']
                ));

                if ($this->db->affected_rows() > 0) {
                    $this->log_grn_activity($id, 'updated number received on item <b>' . $item['description'] . '</b> from ' . $original_item->received . ' to ' . $item['received']);
                    $affectedRows++;
                }
				
				$this->db->where('id', $invoice_item_id);
                $this->db->update('tblgrnitems', array(
                    'ordered' => $item['ordered']
                ));

                if ($this->db->affected_rows() > 0) {
                    $this->log_grn_activity($id, 'updated number received on item <b>' . $item['description'] . '</b> from ' . $original_item->ordered . ' to ' . $item['ordered']);
                    $affectedRows++;
                }
            }
        }
        if (count($newitems) > 0) {
            foreach ($newitems as $key => $item) {
                $this->db->insert('tblgrnitems', array(
                     'suppliersku' => $item['suppliersku'],
                        'oursku' => $item['oursku'],
                        'description' => $item['description'],
                        'received' => $item['received'],
						'ordered' => $item['ordered'],
                        'itemorder_id' => $item['itemorder_id'],
                        'grnid' => $insert_id,
                        'item_order' => $item['order'],
                        'itemid' => $item['itemorder_id'],
                ));
                $new_item_added = $this->db->insert_id();
                if ($new_item_added) {
                    $this->log_grn_activity($id, 'added new item <b>' . $item['description'] . '</b>');
                    $affectedRows++;
                }
            }
        }
        

        
        

        if ($affectedRows > 0) {
            $this->log_grn_activity($id, '<b>GRN updated</b>');
            return true;
        }

        return false;
    }

    public function get_attachments($invoiceid, $id = '') {

        // If is passed id get return only 1 attachment
        if (is_numeric($id)) {
            $this->db->where('id', $id);
        } else {
            $this->db->where('invoiceid', $invoiceid);
        }

        $result = $this->db->get('tblinvoiceattachments');
        if (is_numeric($id)) {
            return $result->row();
        } else {
            return $result->result_array();
        }
    }

    /**
     *  Delete invoice attachment
     * @since  Version 1.0.4
     * @param   mixed $id  attachmentid
     * @return  boolean
     */
    public function delete_attachment($id) {
        $attachment = $this->get_attachments('', $id);
        if ($attachment) {
            if (unlink(INVOICE_ATTACHMENTS_FOLDER . $attachment->invoiceid . '/' . $attachment->file_name)) {
                $this->db->where('id', $id);
                $this->db->delete('tblinvoiceattachments');
                $other_attachments = list_files(INVOICE_ATTACHMENTS_FOLDER . $attachment->invoiceid);
                if (count($other_attachments) == 0) {
                    // delete the dir if no other attachments found
                    delete_dir(INVOICE_ATTACHMENTS_FOLDER . $attachment->invoiceid);
                }
            }

            return true;
        }
        return false;
    }

    /**
     * Delete invoice items and all connections
     * @param  mixed $id invoiceid
     * @return boolean
     */
    public function delete($id) {

        if (get_option('delete_only_on_last_invoice') == 1) {
            if (!is_last_invoice($id)) {
                return false;
            }
        }

        do_action('before_invoice_deleted', $id);
        $this->db->where('id', $id);
        $this->db->delete('tblinvoices');

        if ($this->db->affected_rows() > 0) {
            // Check if is invoice from expense
            $this->db->where('invoiceid', $id);
            $is_expense_invoice = $this->db->get('tblexpenses')->row();
            if ($is_expense_invoice) {
                $this->db->where('id', $is_expense_invoice->id);
                $this->db->update('tblexpenses', array('invoiceid' => NULL));
            }
            if (get_option('invoice_number_decrement_on_delete') == 1) {
                $current_next_invoice_number = get_option('next_invoice_number');
                if ($current_next_invoice_number > 1) {
                    // Decrement next invoice number to
                    $this->db->where('name', 'next_invoice_number');
                    $this->db->set('value', 'value-1', FALSE);
                    $this->db->update('tbloptions');
                }
            }
            $this->db->where('invoiceid', $id);
            $this->db->delete('tblinvoiceitems');

            $this->db->where('invoiceid', $id);
            $this->db->delete('tblinvoicepaymentrecords');

            $this->db->where('invoiceid', $id);
            $this->db->delete('tblgrnsactivity');

            // Delete the custom field values
            $this->db->where('relid', $id);
            $this->db->where('fieldto', 'invoice');
            $this->db->delete('tblcustomfieldsvalues');

            return true;
        }
        return false;
    }

    /**
     * Set invoice to sent when email is successfuly sended to client
     * @param mixed $id invoiceid
     * @param  mixed $cron is request coming from cron
     * @param  mixed $manually is staff manualy marking this invoice as sent
     * @return  boolean
     */
    public function set_invoice_sent($id, $cron = false, $manually = false) {
        $this->db->where('id', $id);
        $this->db->update('tblinvoices', array(
            'sent' => 1,
            'datesend' => date('Y-m-d H:i:s')
        ));

        $marked = false;
        if ($this->db->affected_rows() > 0) {
            $marked = true;
        }
        if ($cron == true) {
            $description = 'Invoice sent to client by CRON';
        } else {
            if ($manually == false) {
                $description = get_staff_full_name() . ' sent invoice to client';
            } else {
                $description = get_staff_full_name() . ' marked invoice as sent';
            }
        }
        $this->log_grn_activity($id, $description, $cron);

        return $marked;
    }

    /**
     * Sent overdue notice to client for this invoice
     * @since  Since Version 1.0.1
     * @param  mxied  $id   invoiceid
     * @param  boolean $cron is request from cron
     * @return boolean
     */
    public function send_invoice_overdue_notice($id, $cron = false) {

        $this->load->model('emails_model');
        $invoice = $this->get($id);

        $invoice_number = format_invoice_number($invoice->number);
        $pdf = invoice_pdf($invoice);
        $attach = $pdf->Output($invoice_number . '.pdf', 'S');
        $this->emails_model->add_attachment($attach, $invoice_number . '.pdf', 'application/pdf');
        $send = $this->emails_model->send_email_template('invoice-overdue-notice', $invoice->client->email, $invoice->clientid, $id);

        if ($send) {
            if ($cron == true) {
                $_from = '[CRON]';
            } else {
                $_from = get_staff_full_name();
            }
            $this->db->where('id', $id);
            $this->db->update('tblinvoices', array(
                'last_overdue_reminder' => date('Y-m-d')
            ));

            $this->log_grn_activity($id, _l('user_sent_overdue_reminder', $_from), $cron);
            return true;
        }

        return false;
    }

    /**
     * Sent invoice to client
     * @param  mixed  $id        invoiceid
     * @param  string  $template  email template to sent
     * @param  boolean $attachpdf attach invoice pdf or not
     * @param  boolean $cron      is request coming from cron
     * @return boolean
     */
    public function sent_invoice_to_client($id, $template = '', $attachpdf = true, $cron = false) {

        $this->load->model('emails_model');
        $invoice = $this->get($id);
        if ($template == '') {
            if ($invoice->sent == 0) {
                $template = 'invoice-send-to-client';
            } else {
                $template = 'invoice-already-send';
            }
        }

        $invoice_number = format_invoice_number($invoice->number);
        $pdf = invoice_pdf($invoice);

        if ($attachpdf) {
            $attach = $pdf->Output($invoice_number . '.pdf', 'S');
            $this->emails_model->add_attachment($attach, $invoice_number . '.pdf', 'application/pdf');
        }

        $send = $this->emails_model->send_email_template($template, $invoice->client->email, $invoice->clientid, $id);
        if ($send) {
            $this->set_invoice_sent($id, $cron);
            return true;
        }

        return false;
    }

    /**
     * All invoice activity
     * @param  mixed $id invoiceid
     * @return array
     */
    public function get_grn_activity($id) {
        // $this->db->where('grnid', $id);
        // $this->db->order_by('date', 'asc');
        // return $this->db->get('tblgrnsactivity')->result_array();
        $this->db->where('grnid', $id);
        // $this->db->order_by('date', 'asc');
        return $this->db->get('tblgrnitems')->result_array();
    }

    /**
     * Log invoice activity to database
     * @param  mixed $id   invoiceid
     * @param  string $description activity description
     */
    public function log_grn_activity($id, $description = '', $cron = false, $client = false) {
        $staffid = get_staff_user_id();

        if ($cron == true) {
            $staffid = 'Cron Job';
        } else if ($client == true) {
            $staffid = NULL;
        }

        $this->db->insert('tblgrnsactivity', array(
            'description' => $description,
            'date' => date('Y-m-d H:i:s'),
            'grnid' => $id,
            'staffid' => $staffid
        ));
    }

    function get_prev($id) {
        return $this->db->query("select id,clientid from tblinvoices where id = (select max(id) from tblinvoices where id < $id)")->row();
    }

    function get_next($id) {
        return $this->db->query("select id,clientid from tblinvoices where id = (select min(id) from tblinvoices where id > $id)")->row();
    }

    function change_invoice_status($status, $id) {
        $this->db->where('id', $id);
        return $this->db->update('tblinvoices', array('status' => $status));
    }

    public function update_credit($amount, $id) {
        $amount = str_replace(',', '', $amount);
        $this->db->query("UPDATE tblclients SET credit_limit = credit_limit + $amount WHERE userid =" . $id);
    }

    public function getinvoices($id) {
        return $this->db->select_sum('total')->where('status !=', '2')->where('clientid', $id)->get('tblinvoices')->row();
    }

    public function getorders($id) {
        return $this->db->select_sum('total')->where('clientid', $id)->get('tblorders')->row();
    }

    public function getcredit($id) {
        return $this->db->where('userid', $id)->get('tblclients')->row();
    }

    public function get_discount($id) {
        return $this->db->where('id', $id)->get('tbldiscounts')->row()->discountrate;
    }

    public function get_where_record($tbl, $id) {

        return $this->db->where('grnid', $id)->get($tbl)->row();
    }
	public function getbills_po($id)
    {
        $this->db->select('*');
        $this->db->from('tblbills');
        $this->db->where('po_id', $id);
        return $this->db->get()->row();
    }
}
