<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Employee_model extends CRM_Model
{
    function __construct()
    {
        parent::__construct();
    }

    public function get_list($value='')
    {	
    	$this->db->select('tblemployee.*,tblcountries.short_name,tblposition.description');
        $this->db->join('tblcountries','tblcountries.country_id = tblemployee.country', 'left');
        $this->db->join('tblposition','tblposition.id = tblemployee.position', 'left');
        // $this->db->join('tblemp_department','tblemp_department.empid = tblemployee.empid', 'left');
    	// $this->db->join('tbldepartments','tbldepartments.departmentid = tblemp_department.department', 'left');
        // $this->db->join('tblemp_department','tblemp_department.empid = tblemployee.empid', 'left');
    	$this->db->from('tblemployee');
        // $this->db->group_by('tblemployee.empid');
        $employee = $this->db->get()->result();
       	return $employee;	
    }

    public function get_departmentlist($value='')
    {
        $this->db->select('tbldepartments.name as department,tblemp_department.empid');
        $this->db->from('tblemp_department');
        // $this->db->join('tblemployee','tblemployee.empid = tblemp_department.empid', 'left');
        $this->db->join('tbldepartments','tbldepartments.departmentid = tblemp_department.department', 'left');
        // $this->db->join('tblemp_department','tblemp_department.empid = tblemployee.empid', 'left');
        // $this->db->group_by('tblemployee.empid');
        $department = $this->db->get()->result();
       
        return $department;   
    }

    public function get_last_employee(){
 		return $this->db->order_by('empid','DESC')->get('tblemployee')->row();
	}

	public function get_departments(){
		return $this->db->where('is_active','1')->order_by('sort_order','ASC')->get('tbldepartments')->result();  
	}

	public function get_role(){
		return $this->db->order_by('roleid','ASC')->get('tblroles')->result();  
	}

	public function get_salutation(){
		return $this->db->where('is_active','1')->order_by('id','ASC')->get('tblsalutation')->result();  
	}

    public function get_race()
    {
        
    }

	public function get_postion(){
		return $this->db->where('is_active','1')->order_by('id','ASC')->get('tblposition')->result();  
	}

	public function add($data)
    {
        // echo "<pre>";
        // print_r($data);
        // die;

        $var = $data['starting_date'];
        $starting_date = str_replace('/', '-', $var);

        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);

       // First check for all cases if the email exists.
       /* $this->db->where('email', $data['email']);
        $email = $this->db->get('tblemployee')->row();
        if ($email) {
            die('Email already exists');
        }

        $this->db->where('email', $data['email']);
        $email = $this->db->get('tblstaff')->row();
        if ($email) {
            die('Staff Email already exists');
        }

        if($data['country'] == ''){
            $data['country'] = 0;
        }*/

        $this->load->helper('phpass');
        $hasher              = new PasswordHash(PHPASS_HASH_STRENGTH, PHPASS_HASH_PORTABLE);
        $data['password']    = $hasher->HashPassword($data['password']);
        $data['datecreated'] = date('Y-m-d H:i:s');

        // $data = do_action('before_client_added', $data);

        $insert_staffdata = array(
                            'salutation' => $data['salutation'],
                            'email' => $data['email'],
                            'firstname' => $data['firstname'],
                            'lastname' => $data['lastname'],
                            'country' => $data['country'],
                            'address' => $data['address'],
                            'city' => $data['city'],
                            'state' => $data['state'],
                            'postal_code' => $data['postal_code'],
                            'position' => $data['position'],
                            'username' => $data['username'],
                            'phonenumber' => $data['phone'],
                           // 'password' => $data['password'],
                            'role' => $data['role'],
                            'default_language' => 'english',
                            'active' => '0',
                            'admin' => '0',
                            );

        $this->db->insert('tblstaff', $insert_staffdata);
        $staffid = $this->db->insert_id();

        if (isset($data['department'])) {
            foreach ($data['department'] as $department) {
                $this->db->insert('tblstaffdepartments', array(
                    'staffid' => $staffid,
                    'departmentid' => $department
                ));
            }
        }



        //$data['account_number'] =  $this->get_postion('next_employee');
		$acc = $this->get_last_employee();
        if($acc){
          $res = explode('-',$acc->account_number);
        }else{
           $res = array();
        }
        if ($acc->account_number) {
            if(get_option('next_employee') >  $res[1] - 1) {
        
                $ac = get_option('employee_prefix') . get_option('employee_separator') . get_option('next_employee');
                $data['account_number'] = $ac;
            }else{
             $data['account_number'] = ++$acc->account_number;
            }
        } else {
            $ac = get_option('employee_prefix') . get_option('employee_separator') . get_option('employee_startnumber');
            $data['account_number'] = $ac;
        }
		
        $insert_data = array(
        					'salutation' => $data['salutation'],
        					'firstname' => $data['firstname'],
        					'lastname' => $data['lastname'],
        					'account_number' => $data['account_number'],
        					'starting_date' => date('Y-m-d', strtotime($starting_date)),
        					'country' => $data['country'],
        					'address' => $data['address'],
        					'city' => $data['city'],
        					'state' => $data['state'],
        					'postal_code' => $data['postal_code'],
        					'email' => $data['email'],
        					'phone' => $data['phone'],
        					'mobile' => $data['mobile'],
        					'position' => $data['position'],
        					'username' => $data['username'],
        					//'password' => $data['password'],
        					'role' => $data['role'],
                            'account_status' => $data['account_status'],
        					'staffid' => $staffid,
        					);
   
        $this->db->insert('tblemployee', $insert_data);
        $empid = $this->db->insert_id();

        foreach ($data['department'] as $key => $value) 
        {
            $insert_department = array(
                            'empid' => $empid,
                            'department' => $value,
                            
                            );
   
            $this->db->insert('tblemp_department', $insert_department);
            $empdepartment = $this->db->insert_id();
        }

        if($empid)
        {
            $this->db->where('name', 'next_employee');
            $this->db->set('value', 'value+1', FALSE);
            $this->db->update('tbloptions');
        }
        


        return $empid;
    }

    public function getdepartments($id="")
    {
        $this->db->select('tblemp_department.department');
        $this->db->from('tblemp_department');
		if($id)
        $this->db->where('empid',$id);
        $department = $this->db->get()->result_array();
        return $department;   
        // return $this->db->where('empid',$id)->get('tblemp_department')->result(); 
    }

    public function get_banks(){
        return $this->db->order_by('bank', 'ASC')->get('tblbanks')->result();  
    }

    public function get_institutions(){
        return $this->db->order_by('id', 'ASC')->get('tblinstitutions')->result();  
    }

    public function get_grades(){
        return $this->db->order_by('id', 'ASC')->get('tblgrades')->result();  
    }

    public function get($id)
    {
    	$this->db->select('tblemployee.*');
    	$this->db->from('tblemployee');
    	$this->db->where('empid', $id);
        $employee = $this->db->get()->row();
       	return $employee;
    }

    public function get_prev($id){
	   return $this->db->query("select empid from tblemployee where empid = (select max(empid) from tblemployee where empid < $id)")->row();
	}

	public function get_next($id){
  		return  $this->db->query("select empid from tblemployee where empid = (select min(empid) from tblemployee where empid > $id)")->row();
	}

	public function add_reminder($data,$id){

        if(isset($data['notify_by_email'])){
            $data['notify_by_email'] = 1;
        } else {
             $data['notify_by_email'] = 0;
        }

        $data['date'] = to_sql_date($data['date']);
        $data['description'] = nl2br($data['description']);
        $data['creator'] = get_staff_user_id();
        $this->db->insert('tbladminemployeereminders',$data);

        $insert_id = $this->db->insert_id();
        if($insert_id){
            logActivity('New Employee Reminder Added [EmpID: ' . $data['empid'] . ' Description: ' . $data['description'] . ']');
            return true;
        }

        return false;
    }

    public function delete_reminder($id)
    {
    	$this->db->where('id', $id);
        $this->db->delete('tbladminemployeereminders');
        return true;
    }

    public function get_all_employee_attachments($id="")
    {

        $attachments = array();
        $attachments['employee'] = array();
       if($id)
        $this->db->where('empid',$id);
        $employee_main_attachments = $this->db->get('tblemployeeattachments')->result_array();
        $attachments['employee'] = $employee_main_attachments;

        return $attachments;
    }

    public function delete_attachment($id){
        $this->db->where('id',$id);
        $attachment = $this->db->get('tblemployeeattachments')->row();
        if($attachment){
            if(unlink(EMPLOYEE_ATTACHMENTS_FOLDER . $attachment->empid . '/' . $attachment->file_name)){
                $this->db->where('id',$id);
                $this->db->delete('tblemployeeattachments');

                return true;
            }

              // Check if no attachments left, so we can delete the folder also
            $other_attachments = list_files(EMPLOYEE_ATTACHMENTS_FOLDER . $attachment->empid);
            if(count($other_attachments) == 0){
                delete_dir(EMPLOYEE_ATTACHMENTS_FOLDER . $attachment->empid);
            }
        }

        return false;
    }


    public function update($data, $id,$employee_request = false)
    {
        // echo "<pre>";
        // print_r($data);
        // die;
        $var = $data['starting_date'];
        $starting_date = str_replace('/', '-', $var);
        // $data['starting_date'] = date('Y-m-d', strtotime($starting_date));

        $var1 = $data['dob'];
        $dob = str_replace('/', '-', $var1);
        // $data['dob'] = date('Y-m-d', strtotime($dob));

        unset($data['action']);
        unset($data['isedit']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);
      
      
        


        $affectedRows = 0;
       


        if($data['country'] == ''){
            $data['country'] = 0;
        }

        $update_data = array(
                            'salutation' => $data['salutation'],
                            'firstname' => $data['firstname'],
                            'lastname' => $data['lastname'],
                            'account_number' => $data['account_number'],
                            'starting_date' => date('Y-m-d', strtotime($starting_date)),
                            'country' => $data['country'],
                            'address' => $data['address'],
                            'city' => $data['city'],
                            'state' => $data['state'],
                            'postal_code' => $data['postal_code'],
                            'email' => $data['email'],
                            'phone' => $data['phone'],
                            'mobile' => $data['mobile'],
                            'position' => $data['position'],
                            'username' => $data['username'],
                            // 'password' => $data['password'],
                            'role' => $data['role'],
                            'account_status' => $data['account_status'],
                            'national_id' => $data['national_id'],
                            'dob' => date('Y-m-d', strtotime($dob)),
                            'gender' => $data['gender'],
                            'marital_status' => $data['marital_status'],
                            'blood_type' => $data['blood_type'],
                            'race' => $data['race'],
                            'nationality' => $data['nationality'],
                            'dependents' => $data['dependents'],
                            'bank' => $data['bank'],
                            'branch' => $data['branch'],
                            'accountno' => $data['accountno'],
                            'medicalinfo' => $data['medicalinfo'],

                            );

        if (empty($data['password'])) {
            unset($data['password']);
        } else {
            $this->load->helper('phpass');
            $hasher                       = new PasswordHash(PHPASS_HASH_STRENGTH, PHPASS_HASH_PORTABLE);
            $data['password']             = $hasher->HashPassword($data['password']);
            $data['last_password_change'] = date('Y-m-d H:i:s');
            $update_data['password'] = $data['password'];
        }

        // echo "<pre>";
        // print_r($update_data);
        // die;

        $this->db->where('empid', $id);
        $this->db->update('tblemployee', $update_data);

        $this->db->where('empid', $id);
        $this->db->delete('tblemp_department');


        foreach ($data['department'] as $key => $value) 
        {
            $insert_department = array(
                            'empid' => $id,
                            'department' => $value,
                            
                            );
   
            $this->db->insert('tblemp_department', $insert_department);
            $empdepartment = $this->db->insert_id();
        }


        $this->db->select('tblemployee.*');
        $this->db->from('tblemployee');
        $this->db->where('empid', $id);
        $employee = $this->db->get()->row();
        

        $update_staff_data = array(
                            'salutation' => $data['salutation'],
                            'email' => $data['email'],
                            'firstname' => $data['firstname'],
                            'lastname' => $data['lastname'],
                            'country' => $data['country'],
                            'address' => $data['address'],
                            'city' => $data['city'],
                            'state' => $data['state'],
                            'postal_code' => $data['postal_code'],
                            'position' => $data['position'],
                            'username' => $data['username'],
                            'phonenumber' => $data['phone'],
                            'password' => $data['password'],
                            'role' => $data['role'],
							
                            // 'default_language' => 'english',
                            // 'active' => '0',
                            // 'admin' => '0',
                            );

        if (empty($data['password'])) {
            unset($data['password']);
        } else {
            $this->load->helper('phpass');
            $hasher                       = new PasswordHash(PHPASS_HASH_STRENGTH, PHPASS_HASH_PORTABLE);
            $data['password']             = $hasher->HashPassword($data['password']);
            $data['last_password_change'] = date('Y-m-d H:i:s');
            $update_staff_data['password'] = $data['password'];
        }

        // echo "<pre>";
        // print_r($update_data);
        // die;

        $this->db->where('staffid', $employee->staffid);
        $this->db->update('tblstaff', $update_staff_data);

        $this->db->where('staffid', $employee->staffid);
        $this->db->delete('tblstaffdepartments');

        if (isset($data['department'])) {
            foreach ($data['department'] as $department) {
                $this->db->insert('tblstaffdepartments', array(
                    'staffid' => $employee->staffid,
                    'departmentid' => $department
                ));
            }
        }


        if ($this->db->affected_rows() > 0) {
            $affectedRows++;
            // do_action('after_client_updated', $id);
            $_update_client_log = $data['firstname'] . ' ' . $data['lastname'];
            $_is_staff          = NULL;

            if (is_staff_logged_in()) {
                $_update_client_log .= ' From Staff: ' . get_staff_user_id();
                $_is_staff = get_staff_user_id();
            }

            return true;
        }


    return false;
}


    public function delete($id)
    {

        $affectedRows = 0;
        // do_action('before_client_deleted', $id);

        $this->db->select('tblemployee.*');
        $this->db->from('tblemployee');
        $this->db->where('empid', $id);
        $employee = $this->db->get()->row();


        $this->db->where('staffid', $employee->staffid);
        $this->db->delete('tblstaffdepartments');


        $this->db->where('staffid', $employee->staffid);
        $this->db->delete('tblstaff');



        $this->db->where('empid', $id);
        $this->db->delete('tblemp_department');

        $this->db->where('empid', $id);
        $this->db->delete('tblemployee');

        if ($this->db->affected_rows() > 0) {
            $affectedRows++;

            // Delete client admin notes
            $this->db->where('empid', $id);
            $this->db->where('staff', 0);
            $this->db->delete('tblemployeeadminnotes');

            if ($this->db->affected_rows() > 0) {
                $affectedRows++;
            }

        }



        if ($affectedRows > 0) {
            // do_action('after_client_deleted');
            logActivity('Employee Deleted [' . $id . ']');
            return true;
        }
        return false;
    }

    public function get_education($id="")
    {
        $this->db->select('tbleducation.*,tblcountries.short_name,tblinstitutions.name as institutions_name,tblgrades.name as grades_name');
        $this->db->from('tbleducation');
        $this->db->join('tblcountries','tblcountries.country_id = tbleducation.country', 'left');
        $this->db->join('tblinstitutions','tblinstitutions.id = tbleducation.institutions', 'left');
        $this->db->join('tblgrades','tblgrades.id = tbleducation.grades', 'left');
		 if($id)
        $this->db->where('empid', $id);
        $education = $this->db->get()->result();
        return $education;
       
    }

    public function get_contact($id="")
    {
        $this->db->select('tblcontact.*,tblcountries.short_name,tblsalutation.description');
        $this->db->from('tblcontact');
        $this->db->join('tblcountries','tblcountries.country_id = tblcontact.country', 'left');
        $this->db->join('tblsalutation','tblsalutation.id = tblcontact.salutation', 'left');
		 if($id)
        $this->db->where('empid', $id);
        $contact = $this->db->get()->result();
        return $contact;
       
    }

    public function get_document($id)
    {
        $this->db->select('tbldocuments.*');
        $this->db->from('tbldocuments');
        // $this->db->join('tblcountries','tblcountries.country_id = tbleducation.country', 'left');
        // $this->db->join('tblinstitutions','tblinstitutions.id = tbleducation.institutions', 'left');
        // $this->db->join('tblgrades','tblgrades.id = tbleducation.grades', 'left');
        $this->db->where('empid', $id);
        $education = $this->db->get()->result();
        return $education;
       
    }

    public function add_education($data)
    {
        $var = $data['start_date'];
        $start_date = str_replace('/', '-', $var);

        $var1 = $data['finish_date'];
        $finish_date = str_replace('/', '-', $var1);

        $insert_data = array(
                            'empid' => $data['empid'],
                            'certificate' => $data['certificate'],
                            'institutions' => $data['institutions'],
                            'country' => $data['country'],
                            'address' => $data['address'],
                            'city' => $data['city'],
                            'state' => $data['state'],
                            'postal_code' => $data['postal_code'],
                            'instition_type' => $data['instition_type'],
                            'tuition_method' => $data['tuition_method'],
                            'start_date' => date('Y-m-d', strtotime($start_date)),
                            'finish_date' => date('Y-m-d', strtotime($finish_date)),
                            'completion' => $data['completion'],
                            'grades' => $data['grades'],
                            );
   
        $this->db->insert('tbleducation', $insert_data);
        $education_id = $this->db->insert_id();

        if ($this->db->affected_rows() > 0) {
            return true;
        }


        return false;
    }

    public function geteducation(){
        return $this->db->where('id', $this->input->post('id'))->get('tbleducation')->row();  
    }

    public function edit_education($data)
    {
        $var = $data['start_date'];
        $start_date = str_replace('/', '-', $var);

        $var1 = $data['finish_date'];
        $finish_date = str_replace('/', '-', $var1);
        
        $update_data = array(
                            'empid' => $data['empid'],
                            'certificate' => $data['certificate'],
                            'institutions' => $data['institutions'],
                            'country' => $data['country'],
                            'address' => $data['address'],
                            'city' => $data['city'],
                            'state' => $data['state'],
                            'postal_code' => $data['postal_code'],
                            'instition_type' => $data['instition_type'],
                            'tuition_method' => $data['tuition_method'],
                            'start_date' => date('Y-m-d', strtotime($start_date)),
                            'finish_date' => date('Y-m-d', strtotime($finish_date)),
                            'completion' => $data['completion'],
                            'grades' => $data['grades'],
                            );
        $this->db->where('id', $data['id']);
        $this->db->update('tbleducation', $update_data);

        if ($this->db->affected_rows() > 0) {
            return true;
        }
        return false;
    }

    public function delete_education($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('tbleducation');
        
        if ($this->db->affected_rows() > 0) {
            
            return true;
        }
        return false;
    }

    public function add_document($data)
    {
        $var = $data['date_issued'];
        $date_issued = str_replace('/', '-', $var);

        $var1 = $data['expiration'];
        $expiration = str_replace('/', '-', $var1);

        $var2 = $data['reminder'];
        $reminder = str_replace('/', '-', $var2);

        $insert_data = array(
                            'empid' => $data['empid'],
                            'name' => $data['name'],
                            'document_type' => $data['document_type'],
                            'serial_number' => $data['serial_number'],
                            'date_issued' => date('Y-m-d', strtotime($date_issued)),
                            'expiration' => date('Y-m-d', strtotime($expiration)),
                            'reminder' => date('Y-m-d', strtotime($reminder)),
                            'note' => $data['note'],
                            );
   
        $this->db->insert('tbldocuments', $insert_data);
        $document_id = $this->db->insert_id();

        if ($this->db->affected_rows() > 0) {
            return true;
        }


        return false;
    }

    public function getdocument(){
        return $this->db->where('id', $this->input->post('id'))->get('tbldocuments')->row();  
    }

    public function edit_document($data)
    {
        $var = $data['date_issued'];
        $date_issued = str_replace('/', '-', $var);

        $var1 = $data['expiration'];
        $expiration = str_replace('/', '-', $var1);

        $var2 = $data['reminder'];
        $reminder = str_replace('/', '-', $var2);
        
        $update_data = array(
                            'empid' => $data['empid'],
                            'name' => $data['name'],
                            'document_type' => $data['document_type'],
                            'serial_number' => $data['serial_number'],
                            'date_issued' => date('Y-m-d', strtotime($date_issued)),
                            'expiration' => date('Y-m-d', strtotime($expiration)),
                            'reminder' => date('Y-m-d', strtotime($reminder)),
                            'note' => $data['note'],
                            );
                            
        $this->db->where('id', $data['id']);
        $this->db->update('tbldocuments', $update_data);

        if ($this->db->affected_rows() > 0) {
            return true;
        }
        return false;
    }

    public function delete_document($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('tbldocuments');
        
        if ($this->db->affected_rows() > 0) {
            
            return true;
        }
        return false;
    }

    public function add_contact($data)
    {
        

        $insert_data = array(
                            'empid' => $data['empid'],
                            'salutation' => $data['salutation'],
                            'firstname' => $data['firstname'],
                            'lastname' => $data['lastname'],
                            'country' => $data['country'],
                            'address' => $data['address'],
                            'city' => $data['city'],
                            'state' => $data['state'],
                            'postal_code' => $data['postal_code'],
                            'relationship' => $data['relationship'],
                            'priority' => $data['priority'],
                            'phone_home' => $data['phone_home'],
                            'phone_work' => $data['phone_work'],
                            'mobile' => $data['mobile'],
                            'email' => $data['email'],
                            );
   
        $this->db->insert('tblcontact', $insert_data);
        $contact_id = $this->db->insert_id();

        if ($this->db->affected_rows() > 0) {
            return true;
        }

        return false;
    }

    public function getcontact(){
        return $this->db->where('id', $this->input->post('id'))->get('tblcontact')->row();  
    }

    public function edit_contact($data)
    {
      
        
        $update_data = array(
                            'empid' => $data['empid'],
                            'salutation' => $data['salutation'],
                            'firstname' => $data['firstname'],
                            'lastname' => $data['lastname'],
                            'country' => $data['country'],
                            'address' => $data['address'],
                            'city' => $data['city'],
                            'state' => $data['state'],
                            'postal_code' => $data['postal_code'],
                            'relationship' => $data['relationship'],
                            'priority' => $data['priority'],
                            'phone_home' => $data['phone_home'],
                            'phone_work' => $data['phone_work'],
                            'mobile' => $data['mobile'],
                            'email' => $data['email'],
                            );
                            
        $this->db->where('id', $data['id']);
        $this->db->update('tblcontact', $update_data);

        if ($this->db->affected_rows() > 0) {
            return true;
        }
        return false;
    }

    public function delete_contact($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('tblcontact');
        
        if ($this->db->affected_rows() > 0) {
            
            return true;
        }
        return false;
    }





}