<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Clients_model extends CRM_Model
{
    function __construct()
    {
        parent::__construct();
    }

     /**
     * With this function staff can login as client in the clients area
     * @param  mixed $id client id
     */
    //  public function get_ledgers(){
    //     return $this->db->where('type', 'Ledger')->order_by('name','ASC')->get('tblledgergroups')->result();
    // }
    /**
     * Add new tax
     * @param $id data
     * @return array
     */
    public function get_warehouse_item($id,$suppliersku)
    {
        $this->db->select('tblclients.warehouse,tblwarehousestock.*');
        $this->db->from('tblclients');
        $this->db->join('tbllocations', 'tbllocations.ware_id = tblclients.warehouse');
        $this->db->join('tblwarehousestock', 'tblwarehousestock.location_id = tbllocations.location_id');
        $this->db->where('tblclients.userid', $id);
        $this->db->where('tbllocations.default_location', 2);
        $this->db->where('tblwarehousestock.suppliersku', $suppliersku);
		
        return $item = $this->db->get()->row();
        // echo "<pre>";
        // print_r($item);
        // die;
    }

		public function get_search_value($search)
    {
		
        $this->db->select('vehicles.users_id as users_id,vehicles.engines_id,vehicles.registration_number,vehicles.vin,engines.vehiclemodelyear,engines.type,vehiclemodelyear.make,vehiclemodelyear.model,vehiclemodelyear.year,sanetz_users.*');

        $this->db->from('vehicles');

		$this->db->join('engines', 'engines.id = vehicles.engines_id', 'left');

		$this->db->join('vehiclemodelyear', 'vehiclemodelyear.id = engines.vehiclemodelyear', 'left');

        $this->db->join('sanetz_users','sanetz_users.id = vehicles.users_id', 'left');
		
		$this->db->where("CONCAT(vehiclemodelyear.make, ' ', vehiclemodelyear.model) LIKE '%".$search."%'", NULL, FALSE);
		$this->db->or_like("vehiclemodelyear.year ",$search);
		$this->db->or_like("sanetz_users.last_name ",$search);
		$this->db->or_like("sanetz_users.first_name ",$search);
		$this->db->or_like("sanetz_users.phone_mobile ",$search);
		$this->db->or_like("sanetz_users.phone_work ",$search);
		$this->db->or_like("sanetz_users.phone_home ",$search);
		$this->db->or_like("CONCAT(sanetz_users.first_name, ' ', sanetz_users.last_name)",$search);
		$this->db->or_like("vehicles.registration_number ",$search);
		$this->db->or_like("vehicles.vin ",$search);
		$this->db->or_like("engines.type ",$search);
		$this->db->group_by('vehicles.id');
		$this->db->order_by('vehicles.users_id', 'ASC'); 
		//$this->db->or_like("vehiclemodelyear.year ",$search);
		//$this->db->or_like("engines.engine_code ",$search);

       //$this->db->limit(100);

        if ($id) {
            $this->db->where('engines.id', $id);
            $client = $this->db->get('engines')->row();
        //echo $this->db->last_query();

            return $client;
        }
		
		
      	/*$this->db->order_by('vehiclemodelyear.make asc, vehiclemodelyear.model asc,vehiclemodelyear.year asc,
 FIELD(fuel, "Petrol", "diesel", "hybrid") asc,engines.type asc,engines.kw asc');*/
        
         $result = $this->db->get()->result_array();
		//echo $this->db->last_query();
		return $result;
		
    }
    public function get_warehouse()
    {
        return $this->db->get('tblwarehouse')->result();
    }
	
	public function get_vehicles_data($clientid)
    {

        $this->db->select('vehicles.*');

        $this->db->from('vehicles');


		$this->db->where('vehicles.users_id',$clientid);

 		$vehicles_data = $this->db->get()->result();

        return $vehicles_data;
    }

    public function get_vehicles($id = false, $active = '',$vehicleid)
    {

        if (is_numeric($id)) {
            $this->db->where('id', $id);
            $vehicle = $this->db->get('vehicles')->row();
            echo($vehicle);

            return $vehicle;
        }

        return $this->db->get('vehicles')->result_array();
    }

	public function countrow($userid){
	$this->db->select('vehicles.users_id');

        $this->db->from('vehicles');


		$this->db->where('vehicles.users_id',$userid);

 		$vehicles = $this->db->get()->num_rows();

        return $vehicles;

	}

    public function get_ledgers_object($id = false, $active = '')
    {
        if (is_int($active)) {
            $this->db->where('active', $active);
        }

        if (is_numeric($id)) {
            $this->db->where('id', $id);
            $client = $this->db->get('tblledgergroups')->row();
            echo($client);

            return $client;
        }


        return $this->db->get('tblledgergroups')->result();
    }


	public function findCustomerByPhone($from_number)
    {
       
        if ($from_number) {
           
        	$this->db->where('phone_mobile', $from_number);
        	$this->db->or_where('phone_home', $from_number);
        	$this->db->or_where('phone_work', $from_number);

        }

        return $this->db->get('sanetz_users')->row();
    }

public function findEventByPhone($event_date)
    {
       
        if ($event_date) {
           
        	$this->db->where('event_date', $event_date);

        }

        return $this->db->get('events')->row();
    }
public function findEventByNumber($from_number)
    {
       
        if ($from_number) {
           
        	$this->db->where('from_number', $from_number);
        	$this->db->where('ignore_list', '1');

        }

        return $this->db->get('events')->row();
    }	
    public function getLedger() {
        return $this->db->where('type', 'Ledger')->order_by('name', 'ASC')->get('tblledgergroups')->result();
    }

    function get_prev_groups2($id=0) {
       
        //$this->db->where('type', 'Ledger');
        $this->db->where('parent', $id);
        $this->db->order_by('name', 'ASC');
        $tabl= $this->db->get('tblledgergroups')->result();
        $subgoups=array();
        foreach($tabl as $ta)
        {           
            
            $ta->subgroups= $this->get_prev_groups2($ta->id);
            $ta->exists=false;
            foreach($ta->subgroups as $gr )         
            // if(($gr->type!="Group")||($gr->exists))
            // {
            //     $ta->exists=true;
            //     break;
                
            // }
            // if(($ta->type!="Group")||($ta->exists))
            // {
                $ta->exists=true;
                $subgoups[]=$ta;
                
            // }
            
            
        }
        
        return $subgoups;
    }
	public function get_vehiclejc($vehicleid)

    {
		//echo $vehicleid;
        $this->db->select('jobcards.*');

        $this->db->from('jobcards');


		$this->db->where('jobcards.vehicles_id',$vehicleid);
		$this->db->order_by('appointment_date', 'desc');

 		$jobcard = $this->db->get()->result();
        if ($jobcard) {
		//$jobcard->items = $this->get_jobcard_items($id);
        return $jobcard;

    }
	
	}
	
	public function get_jobcard_payments($jobcardid)

    {
        $this->db->select('payments.*');

        $this->db->from('payments');

		$this->db->where('payments.jobcards_id',$jobcardid);
		
 		$payments = $this->db->get()->result();
		//echo $this->db->last_query();
		//print_r($payments);
		
        if ($payments) {
        return $payments;
    }
	
	}
	
	public function get_jobcard_status()

    {

        $this->db->select('jobcards.*');

        $this->db->from('jobcards');

		$this->db->where('jobcards.jc_status','100');

 		$jobcard_status = $this->db->get()->result();
		return $jobcard_status;

	}
	
	 public function get_jobcard_items($id)

    {

        $this->db->select('jobcard_items.id,qty,estimate_cost,jobcard_items.description,jobcard_items.private_notes,service,product,products.name,product_services.name as service_name');

        $this->db->from('jobcard_items');

        $this->db->join('products', 'products.id = jobcard_items.product', 'left');

        $this->db->join('product_services', 'product_services.id = jobcard_items.service', 'left');

        $this->db->where('jobcard_items.jobcards_id', $id);

        return $this->db->get()->result();

  

    }

	 public function get_where_single_tbl($tbl, $col, $val) {
			return $this->db->where($col, $val)->get($tbl)->row();
		}
    function get_prev_ledgers(){
        return $this->get_prev_groups(0);
        $this->db->order_by('name', 'ASC');
        return $this->db->get('tblledgergroups')->result();   
    }

    function get_prev_groups($id=0) {
     //  $this->db->where('type', 'Group');
        $this->db->where('parent', $id);
        $this->db->order_by('name', 'ASC');
        $tabl= $this->db->get('tblledgergroups')->result();
        $subgoups=array();
        foreach($tabl as $ta)
        {           
            
            $ta->subgroups= $this->get_prev_groups($ta->id);
            $subgoups[]=$ta;
            
        }
        
        return $subgoups;
    }

    public function login_as_client($id)
    {
        $this->load->model('clients_model');
        $client = $this->clients_model->get($id);

        $user_data = array(
            'client_user_id' => $client->userid,
            'client_logged_in' => true,
            'logged_in_as_client' => true,
        );

        $this->session->set_userdata($user_data);
        redirect(site_url());
    }

    /**
     * @param  mixed $id client id (optional)
     * @param  integer $active (optional) get all active or inactive
     * @return mixed
     * Get client object based on passed clientid if not passed clientid return array of all clients
     */
    public function get($id = false, $active = '')
    {

        if ($id) {
            //$this->db->where('active', '1');
            $this->db->where('id', $id);
            $client = $this->db->get('sanetz_users')->row();
        //echo $this->db->last_query();

            return $client;
        }

        $this->db->order_by('date_entered', 'desc');
        return $this->db->get('sanetz_users')->result_array();
    }
   
   		public function getcustomers()
    {
		
        $this->db->select("sanetz_users.* ");

        if ($id) {
            $this->db->where('sanetz_users.id', $id);
            $client = $this->db->get('engines')->row();
        //echo $this->db->last_query();

            return $client;
        }
        return $this->db->get('sanetz_users')->result_array();
    }
   
 public function changestatus(){
          
            $row = $this->db->where('id',$this->input->post('id'))->get('tblcustomersgroups')->row();
           if($row->class_is_active == '0'){
                $data =array('class_is_active'=>1);
                $this->db->where('id', $this->input->post('id'));
                $this->db->update('tblcustomersgroups', $data);
           }
           if($row->class_is_active == '1'){
                $data =array('class_is_active'=>0);
                $this->db->where('id', $this->input->post('id'));
                $this->db->update('tblcustomersgroups', $data);
           }
      }
    
    
    
   /*get last client account number*/

public function get_last_user(){
 return $this->db->order_by('userid','DESC')->get('tblclients')->row();
}

    /**
     * @param array $_POST data
     * @return integer Insert ID
     * Add new client to database
     */
    public function add($data)
    {
      unset($data['action']);
      unset($data['save']);
      unset($data['cancel']);
      unset($data['snew']);
      unset($data['slist']);
	
       // First check for all cases if the email exists.
        $this->db->where('email', $data['email']);
        $email = $this->db->get('sanetz_users')->row();
        // if ($email) {
        //     die('Email already exists');
        // }
        $this->db->select('UUID() AS id');
        $idrow = $this->db->get('sanetz_users')->row();
		$data['id']= $idrow->id;
		$phone_list_old = explode( ',' , $data['phone_ignore_list_old']);
		foreach($phone_list_old as $ignore_list_data){
		$this->db->select('events.*');

        $this->db->from('events');

        $this->db->where('from_number',$ignore_list_data);
		
		$found_number_old = $this->db->get()->row();
		if($found_number_old){
		$this->db->where('from_number',$found_number_old->from_number); 
		$this->db->set('ignore_list','1');
		
        $res=$this->db->update('events');
		
		
			}
			
		}
		$phone_list = explode( ',' , $data['phone_ignore_list']);
		foreach($phone_list as $list_data){
		$this->db->select('events.*');

        $this->db->from('events');

        $this->db->where('from_number',$list_data);
		
		$found_number = $this->db->get()->row();
			
		if($found_number){
		$this->db->where('from_number',$found_number->from_number); 
		$this->db->set('status','99');
		$this->db->set('ignore_list','0');
        $res=$this->db->update('events');
		//echo $this->db->last_query();
			}
			
		}
		//$this->db->set('phone_ignore_list',$phone_list_old);
        $this->db->insert('sanetz_users', $data);
        //echo $this->db->last_query();
		//exit;
        $userid = $this->db->insert_id();
        return $userid;
    }
	
	public function add_payment($data)
    {
      unset($data['action']);

        //$idrow = $this->db->get('payments')->row();
		//$data['id']= $idrow->id;
		//print_r($data);

        $this->db->insert('payments', $data);
        $paymentid = $this->db->insert_id();
        return $paymentid;
    }
	public function add_payment_jobcard_status($totalamount,$jobcards_id,$jobcard_number)
    {
      unset($totalamount['action']);

        $data['amount']= $totalamount ;
        $data['jobcards_id']= $jobcards_id ;
        $data['jobcard_number']= $jobcard_number ;
		$date = '2018-1-1';		
		$data['date_entered']= $date ;

	    $this->db->insert('payments',$data);
        $paymentid = $this->db->insert_id();
        return $paymentid;
    }
	
	public function update_payment($data, $id) {
       
         unset($data['action']);
         unset($data['isedit']);
        $payments = $this->db->where('id',$id)->get('payments')->row();
		
        $this->db->where('id', $id)->update('payments', $data);
		//echo $this->db->last_query();
        return true;

    }

    public function createpath(){
    
        $array = $this->db->query("SELECT * from tblledgergroups")->result_array();
        $array2 = array();
        foreach ($array as $key => $value) {
            $array2[$value['id']] = $value;
        }
        foreach ($array2 as $key => $a) {

            if ($a['parent'] == 0) {
                $data['path']= $a['name'];
                 $this->db->where('id', $a['id']);
                 $this->db->update('tblledgergroups', $data);
                 } else {
                $b = $a;
                $_a = array($b['name']);
                while ($b['parent'] != 0) {
                    $b = $array2[$b['parent']];
                    $_a[] = $b['name'];
                }
                
               
                $data['path']= implode('/', array_reverse($_a));
                 $this->db->where('id', $a['id']);
                 $this->db->update('tblledgergroupss', $data);
            }
        }
    }

    public function createpath2($parent, $ledger_id, $accountname) {
		//echo "parent=".$parent."</br>";
        //$clientid 	= $this->db->where('userid', $parent)->get('tblclients')->row()->ledger;
		//echo "client=".$clientid;exit;
        $ledgerPath = $this->db->where('id', $parent)->get('tblledgergroups')->row()->path;
		//echo "ledgerPath=".$ledgerPath;
        //$array2 = array($ledgerid, ucfirst($accountname));
		//echo "array2";
		//print_r($array2);echo "</br>";
        //$slash = implode('/', $array2);
		//echo "slash".$slash;exit;
        //exit;
		$data['path']	= $ledgerPath."/".$accountname;
		$data['parent']	= $parent;
        $this->db->where('id', $ledger_id);
        $this->db->update('tblledgergroups', $data);
    }
    
	function add_ledger_AR($userid,$data)
	{
		
		if($data['groups_in']==1)
		{
			$this->db->select_max('accountid');
			$this->db->where('accountid', $userid);
			$accountid = $this->db->get('tblledgergroups')->row()->accountid;	
			$this->load->model('ledgers_model');
			$ledgerdata=array(
			  'name'=>ucfirst($data['accountname']),
			  'description'=>$data['accountname'],
			  'type'=>'Ledger',
			  'parent'=>14,//129
			  'accountid'=>$userid,
			);
			
			if($accountid){
				$this->db->where('accountid',$userid);
				$this->db->update('tblledgergroups',$ledgerdata);
			}
			else
			{
			  
			  $ledgerid = $this->ledgers_model->add($ledgerdata);
              return $ledgerid;
			}
	   
		  /* if($ledgerid){
				$this->db->where('userid', $userid);
				$this->db->update('tblclients', array('ledger'=>$ledgerid));
				$this->createpath();
		   } */ 
		}
	}
    /**
     * @param  array $_POST data
     * @param  integer ID
     * @return boolean
     * Update client informations
     */
    public function update($data, $id,$client_request = false)
    {
      unset($data['action']);
      unset($data['isedit']);
      unset($data['save']);
      unset($data['cancel']);
      unset($data['snew']);
      unset($data['slist']);
   

        $_data = do_action('before_client_updated', array(
            'userid' => $id,
            'data' => $data
            ));
		
        $data = $_data['data'];
		//print_r($data);
		$phone_list_old = explode( ',' , $data['phone_ignore_list_old']);
		//print_r($phone_list_old);
		//exit;
		foreach($phone_list_old as $ignore_list_data){
			//echo 'abc';
			//exit;
		$this->db->select('events.*');

        $this->db->from('events');

        $this->db->where('from_number',$ignore_list_data);
		
		$found_number_old = $this->db->get()->row();
		if($found_number_old){
		$this->db->where('from_number',$found_number_old->from_number); 
		$this->db->set('ignore_list','1');
        $res=$this->db->update('events');
		//echo $this->db->last_query();
		//exit;
		
		
			}
			
		}
		$phone_list = explode( ',' , $data['phone_ignore_list']);
		foreach($phone_list as $list_data){
		$this->db->select('events.*');

        $this->db->from('events');

        $this->db->where('from_number',$list_data);
		
		$found_number = $this->db->get()->row();
		//print_r($found_number);
		//exit;	
		if($found_number){
		
		$this->db->where('from_number',$found_number->from_number); 
		$this->db->set('status','99');
		$this->db->set('ignore_list','1');
        $res=$this->db->update('events');
		//echo $this->db->last_query();
		//exit;
			}
			
		}
		//print_r($found_number);
		//exit;
        $this->db->where('id', $id);
        $this->db->update('sanetz_users', $data);

        if ($this->db->affected_rows() > 0) {
            $affectedRows++;
            do_action('after_client_updated', $id);
            $_update_client_log = $data['firstname'] . ' ' . $data['lastname'];
            $_is_staff          = NULL;

            if (is_staff_logged_in()) {
                $_update_client_log .= ' From Staff: ' . get_staff_user_id();
                $_is_staff = get_staff_user_id();
            }
        }




    if($affectedRows > 0 && !isset($set_password_email_sent)){
        logActivity('Client Info Updated [' . $_update_client_log . ']', $_is_staff);
        return true;
    } else if($affectedRows > 0 && isset($set_password_email_sent)){
        return array('set_password_email_sent_and_profile_updated'=>true);
    } else if($affectedRows == 0 && isset($set_password_email_sent)){
        return array('set_password_email_sent'=>true);
    }

    return false;
}

    /**
     * @param  integer ID
     * @return boolean
     * Delete client, also deleting rows from, dismissed client announcements, ticket replies, tickets, autologin, user notes
     */
    public function delete($id) {
        $this->db->where('id', $id);
        $this->db->delete('sanetz_users');

        if ($this->db->affected_rows() > 0) {
            logActivity('sanetz_users Deleted [ID: ' . $id . ']');
            return true;
        }

        return false;
    }

    /**
     * Get customer default currency
     * @param  mixed $id customer id
     * @return mixed
     */
    public function get_customer_default_currency($id){
        $this->db->where('userid',$id);
        return $this->db->get('tblclients')->row()->default_currency;
    }
    /**
     *  Get customer billing details
     * @param   mixed $id   customer id
     * @return  array
     */
    public function get_customer_billing_and_shipping_details($id){
        $this->db->select('billing_street,billing_city,billing_state,billing_zip,billing_country,shipping_street,shipping_city,shipping_state,shipping_zip,shipping_country');
        $this->db->from('tblclients');
        $this->db->where('userid',$id);
        return $this->db->get()->result_array();
    }
    /**
     *  Get customer attachment
     * @param   mixed $id   customer id
     * @return  array
     */
    public function get_all_customer_attachments($id){

        $attachments = array();
        $attachments['invoices'] = array();
        $attachments['contracts'] = array();
        $attachments['leads'] = array();
        $attachments['tickets'] = array();
        $attachments['tasks'] = array();
        $attachments['customer'] = array();
        // Invoices
        $this->db->select('clientid,id');
        $this->db->where('clientid',$id);
        $this->db->from('tblinvoices');
        $invoices = $this->db->get()->result_array();
        foreach($invoices as $invoice){
            $this->db->where('invoiceid',$invoice['id']);
            $_attachments = $this->db->get('tblinvoiceattachments')->result_array();
            if(count($_attachments) > 0){
                foreach($_attachments as $_att){
                    array_push($attachments['invoices'],$_att);
                }
            }
        }

        $this->db->select('client,id');
        $this->db->where('client',$id);
        $this->db->from('tblcontracts');
        $contracts = $this->db->get()->result_array();
        foreach($contracts as $contract){
            $this->db->where('contractid',$contract['id']);
            $_attachments = $this->db->get('tblcontractattachments')->result_array();
            if(count($_attachments) > 0){
                foreach($_attachments as $_att){
                    array_push($attachments['contracts'],$_att);
                }
            }
        }

        $customer = $this->get($id);
        if($customer->leadid != NULL){
          $this->db->where('leadid',$customer->leadid);
          $_attachments =$this->db->get('tblleadattachments')->result_array();
          if(count($_attachments) > 0){
            foreach($_attachments as $_att){
                array_push($attachments['leads'],$_att);
            }
        }
    }

    $this->db->select('ticketid,userid');
    $this->db->where('userid',$id);
    $this->db->from('tbltickets');
    $tickets = $this->db->get()->result_array();

    foreach($tickets as $ticket){
        $this->db->where('ticketid',$ticket['ticketid']);
        $_attachments = $this->db->get('tblticketattachments')->result_array();
        if(count($_attachments) > 0){
           foreach($_attachments as $_att){
            array_push($attachments['tickets'],$_att);
        }
    }
}


$this->db->select('rel_id,id');
$this->db->where('rel_id',$id);
$this->db->where('rel_type','customer');
$this->db->from('tblstafftasks');
$tasks = $this->db->get()->result_array();

foreach($tasks as $task){
    $this->db->where('taskid',$task['id']);
    $_attachments = $this->db->get('tblstafftasksattachments')->result_array();
    if(count($_attachments) > 0){
       foreach($_attachments as $_att){
          array_push($attachments['tasks'],$_att);
      }
  }
}


$this->db->where('clientid',$id);
$client_main_attachments = $this->db->get('tblclientattachments')->result_array();
$attachments['client'] = $client_main_attachments;

return $attachments;
}
public function get_country($id){
   return $this->db->where('country_id',$id)->get('tblcountries')->row();  
}
public function get_pai_balance($id){
   $result = $this->db->select_sum('amount')->where('invoiceid',$id)->get('tblinvoicepaymentrecords')->row();
   if($result){
       return $result->amount;
   }else{
       return 0;
   }
}
public function get_balance($id){
    $result = $this->db->where('clientid',$id)->get('tblinvoices')->result();
     $total=$paidamount=0;
    if(!empty($result)){
       
        foreach ($result as $value) {
            $paidamount +=$this->get_pai_balance($value->id);
            $total +=$value->total;
        }
         return $total-$paidamount;
       
    }else{
        return $total;
    }
  
}
public function delete_attachment($id){
    $this->db->where('id',$id);
    $attachment = $this->db->get('tblclientattachments')->row();
    if($attachment){
        if(unlink(CLIENT_ATTACHMENTS_FOLDER . $attachment->clientid . '/' . $attachment->file_name)){
            $this->db->where('id',$id);
            $this->db->delete('tblclientattachments');

            return true;
        }

          // Check if no attachments left, so we can delete the folder also
        $other_attachments = list_files(CLIENT_ATTACHMENTS_FOLDER . $attachment->clientid);
        if(count($other_attachments) == 0){
            delete_dir(CLIENT_ATTACHMENTS_FOLDER . $attachment->clientid);
        }
    }

    return false;
}

    /**
     * @param  integer ID
     * @param  integer Status ID
     * @return boolean
     * Update client status Active/Inactive
     */
    public function change_client_status($id, $status)
    {
        $this->db->where('userid', $id);
        $this->db->update('tblclients', array(
            'active' => $status
            ));

        if ($this->db->affected_rows() > 0) {
            logActivity('Client Status Changed [ClientID: ' . $id . ' Status(Active/Inactive): ' . $status . ']');
            return true;
        }

        return false;
    }
    /**
     * @param  mixed $_POST data
     * @return mixed
     * Change client password, used from client area
     */
    public function change_client_password($data)
    {
        // Get current password
        $this->db->where('userid', get_client_user_id());
        $client = $this->db->get('tblclients')->row();

        $this->load->helper('phpass');
        $hasher = new PasswordHash(PHPASS_HASH_STRENGTH, PHPASS_HASH_PORTABLE);
        if (!$hasher->CheckPassword($data['oldpassword'], $client->password)) {
            logActivity('Client Password Not Match [ClientID: ' . get_client_user_id() . ']');
            return array(
                'old_password_not_match' => true
                );
        }

        $update_data['password']             = $hasher->HashPassword($data['password']);
        $update_data['last_password_change'] = date('Y-m-d H:i:s');
        $this->db->where('userid', get_client_user_id());
        $this->db->update('tblclients', $update_data);

        if ($this->db->affected_rows() > 0) {
            logActivity('Client Password Changed [ClientID: ' . get_client_user_id() . ']');
            return true;
        }

        return false;
    }

    public function get_client($id){
      return $this->db->where('userid', $id)->get('tblclients')->row(); 
}

public function get_departments(){
   return $this->db->where('is_active','1')->order_by('sort_order','ASC')->get('tbldepartments')->result();  
}
    
 function getDataByOrder($table, $where ) {
        $this->db->order_by('sort_order', 'asc');
        return $this->db->get_where($table, $where)->result_array();
 }

    public function get_customer_groups($id){

        $this->db->where('customer_id',$id);
        return $this->db->get('tblcustomergroups_in')->result_array();
    }

    public function get_groups($id = ''){
         $this->db->where('class_is_active','1');
        if(is_numeric($id)){
            $this->db->where('id',$id);
            return $this->db->get('tblcustomersgroups')->row();
        }

        return $this->db->get('tblcustomersgroups')->result_array();
    }

    public function delete_group($id){

        if(is_reference_in_table('groupid','tblcustomergroups_in',$id)){
            return array('referenced'=>true);
        }

        $this->db->where('id',$id);
        $this->db->delete('tblcustomersgroups');

        if($this->db->affected_rows() > 0){
            logActivity('Customer Group Delete [ID:'.$id.']');
            return true;
        }

        return false;

    }

    public function add_group($data){
        if($this->input->post('class_is_active')){
              $active = $this->input->post('class_is_active');
         }else{
              $active = 0;  
         }
         $data['class_is_active'] = $active;
        $this->db->insert('tblcustomersgroups',$data);
        $insert_id = $this->db->insert_id();

        if($insert_id){
            logActivity('New Customer Group Created [ID:'.$insert_id.', Name:'.$data['name'].']');
            return true;
        }

        return false;
    }

    public function edit_group($data){
        $this->db->where('id',$data['id']);
   
          if($this->input->post('class_is_active')){
              $active = $this->input->post('class_is_active');
         }else{
              $active = 0;  
         }
         $data['creditlimit']=str_replace(",","",$data['creditlimit']);
         $array=array(
             'name' => $data['name'],
             'discription' => $data['discription'],
             'ledger' => $data['ledger'],
             'payment_term' => $data['payment_term'],
             'account_req' => $data['account_req'],
             'default_currency' => $data['default_currency'],
             'default_language' => $data['default_language'],
             'creditlimit' => $data['creditlimit'],          
             'class_is_active' => $active,
         );
     
         
        $this->db->update('tblcustomersgroups',$array);
        if($this->db->affected_rows() > 0){
            logActivity('Customer Group Updated [ID:'.$data['id'].']');
            return true;
        }
        return false;
    }
    public function DeleteContacts($id)
{
        $this->db->where('id', $id);
        $res=$this->db->delete('tblclientcontacts');
        return $res;
}
public function addcontact(){
    $data=array('salutation' => $this->input->post('salutation'),
        'firstname' => $this->input->post('firstname'),
        'lastname'  => $this->input->post('lastname'),
        'country'  => $this->input->post('country'),
        'address'  => $this->input->post('address'),
        'city'     => $this->input->post('city'),
        'state'    => $this->input->post('state'),
        'zip'      => $this->input->post('zip'),
        'phoneno'  => $this->input->post('phoneno'),
        'mobileno' => $this->input->post('mobileno'),
        'fax'      => $this->input->post('fax'),
        'email'    => $this->input->post('email'),
        'skypeid'  => $this->input->post('skypeid'),
        'position' => $this->input->post('position'),
        'status'   => $this->input->post('status'),
        'department_id' => $this->input->post('department'),
        'userid'   => $this->input->post('client_id'));
        $res=$this->db->insert('tblclientcontacts', $data);
 
    return $this->db->insert_id();
    
}
   /**
     * Add client personal reminder
     * @since  Version 1.0.2
     * @param mixed $data All $_POST data for the reminder
     * @param mixed $id   client id
     * @return boolean
     */
    public function add_reminder($data,$id){

        if(isset($data['notify_by_email'])){
            $data['notify_by_email'] = 1;
        } else {
             $data['notify_by_email'] = 0;
        }

        $data['date'] = to_sql_date($data['date']);
        $data['description'] = nl2br($data['description']);
        $data['creator'] = get_staff_user_id();
        $this->db->insert('tbladminclientreminders',$data);

        $insert_id = $this->db->insert_id();
        if($insert_id){
            logActivity('New Client Reminder Added [ClientID: ' . $data['clientid'] . ' Description: ' . $data['description'] . ']');
            return true;
        }

        return false;
    }
public function getRecords($tbl)
{
  return $this->db->get($tbl)->result_array();  
}
public function get_where_record($tbl,$id)
{
    
  return $this->db->where('id', $id)->get($tbl)->row();  
}
public function getclass(){
     return $this->db->where('id', $this->input->post('id'))->get('tblcustomersgroups')->row();  
}
public function getcontact($id){
     return $this->db->where('id', $id)->get('tblclientcontacts')->row();  
}
public function updateContacts($contactid)
{
     $data=array('salutation' => $this->input->post('salutation'),
        'firstname' => $this->input->post('firstname'),
        'lastname'  => $this->input->post('lastname'),
        'country'  => $this->input->post('country'),
        'address'  => $this->input->post('address'),
        'city'     => $this->input->post('city'),
        'state'    => $this->input->post('state'),
        'zip'      => $this->input->post('zip'),
        'phoneno'  => $this->input->post('phoneno'),
        'mobileno' => $this->input->post('mobileno'),
        'fax'      => $this->input->post('fax'),
        'email'    => $this->input->post('email'),
        'skypeid'  => $this->input->post('skypeid'),
        'position' => $this->input->post('position'),
        'status'   => $this->input->post('status'),
        'department_id'   => $this->input->post('department'),
        'userid'   => $this->input->post('client_id'));
        $this->db->where('id', $this->input->post('contactid'));
        $res=$this->db->update('tblclientcontacts',$data);
//        echo $this->db->last_query();
        return $res;
}
function get_prev($id){
   return $this->db->query("select id from `sanetz_users` where id = (select max(id) from `sanetz_users` where id < $id)")->row();
}
function get_next($id){
  return  $this->db->query("select id from `sanetz_users` where id = (select min(id) from `sanetz_users` where id > $id)")->row();
}
function filldata($id){
   return $this->db->where('id', $id)->get('tblcustomersgroups')->row();    
}
function get_current_period(){
    return $this->db->order_by('id','ASC')->limit(1)->get('tblperiod')->row();  
}
}
