<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Banks_model extends CRM_Model
{
    function __construct()
    {
        parent::__construct();
    }

    /**
     * @param  mixed $id client id (optional)
     * @param  integer $active (optional) get all active or inactive
     * @return mixed
     * Get client object based on passed clientid if not passed clientid return array of all clients
     */
    public function get($id = false, $active = '')
    {


//        $this->db->join('tblcountries','tblcountries.country_id = tblbanks.country', 'left');

        if (is_int($active)) {
            $this->db->where('active', $active);
        }

        if (is_numeric($id)) {
            $this->db->where('bankid', $id);
            $client = $this->db->get('tblbanks')->row();

            return $client;
        }

        $this->db->order_by('datecreated', 'desc');
        return $this->db->get('tblbanks')->result_array();
    }

   /*get last client account number*/

public function get_last_user(){
 return $this->db->order_by('bankid','DESC')->get('tblclients')->row();
}

public function get_country($id){
   return $this->db->where('country_id',$id)->get('tblcountries')->row();  
}
public function get_pai_balance($id){
   $result = $this->db->select_sum('amount')->where('invoiceid',$id)->get('tblinvoicepaymentrecords')->row();
   if($result){
       return $result->amount;
   }else{
       return 0;
   }
}
public function get_balance($id){
    $result = $this->db->where('clientid',$id)->get('tblinvoices')->result();

    if(!empty($result)){
        $total=$paidamount=0;
        foreach ($result as $value) {
            $paidamount +=$this->get_pai_balance($value->id);
            $total +=$value->total;
        }
        
        return $total-$paidamount;
    }
}

public function get_contact($id){
 return $this->db->where('bankid',$id)->get('tblclientcontacts')->result();
}

 function getSingleRecord($table, $where) {
        return $this->db->get_where($table, $where)->row();
    }
    
 function getDataByOrder($table, $where ) {
        $this->db->order_by('sort_order', 'asc');
        return $this->db->get_where($table, $where)->result_array();
 }

public function addcontact($customerid){
    $data=array('salutation' => $this->input->post('salutation'),
        'firstname' => $this->input->post('firstname'),
        'lastname'  => $this->input->post('lastname'),
        'country'  => $this->input->post('country'),
        'address'  => $this->input->post('address'),
        'city'     => $this->input->post('city'),
        'state'    => $this->input->post('state'),
        'zip'      => $this->input->post('zip'),
        'phoneno'  => $this->input->post('phoneno'),
        'mobileno' => $this->input->post('mobileno'),
        'fax'      => $this->input->post('fax'),
        'email'    => $this->input->post('email'),
        'skypeid'  => $this->input->post('skypeid'),
        'position' => $this->input->post('position'),
        'status'   => $this->input->post('status'),
        'bankid'   => $customerid);
    $res=$this->db->insert('tblsuppliercontacts', $data);  
    return $this->db->insert_id();
    
}

public function getRecords($tbl)
{
  return $this->db->get($tbl)->result_array();  
}
public function get_where_record($tbl,$id)
{
    
  return $this->db->where('id', $id)->get($tbl)->row();  
}

public function DeleteContacts($id)
{
        $this->db->where('id', $id);
        $res=$this->db->delete('tblsuppliercontacts');
        return $res;
}
public function get_client($id){
      return $this->db->where('bankid', $id)->get('tblbanks')->row(); 
}

public function updateContacts($contactid)
{
     $data=array('salutation' => $this->input->post('salutation'),
        'firstname' => $this->input->post('firstname'),
        'lastname'  => $this->input->post('lastname'),
        'country'  => $this->input->post('country'),
        'address'  => $this->input->post('address'),
        'city'     => $this->input->post('city'),
        'state'    => $this->input->post('state'),
        'zip'      => $this->input->post('zip'),
        'phoneno'  => $this->input->post('phoneno'),
        'mobileno' => $this->input->post('mobileno'),
        'fax'      => $this->input->post('fax'),
        'email'    => $this->input->post('email'),
        'skypeid'  => $this->input->post('skypeid'),
        'position' => $this->input->post('position'),
        'status'   => $this->input->post('status'),
        );
        $this->db->where('id', $contactid);
        $res=$this->db->update('tblsuppliercontacts',$data);
        return $res;
}



    /**
     * @param array $_POST data
     * @return integer Insert ID
     * Add new client to database
     */
    public function add($data)
    {
        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);


        $data['datecreated'] = date('Y-m-d H:i:s');
        $data = do_action('before_client_added', $data);
        $this->db->insert('tblbanks', $data);
        $bankid = $this->db->insert_id();
        return $bankid;
    }

    /**
     * @param  array $_POST data
     * @param  integer ID
     * @return boolean
     * Update client informations
     */
    public function update($data, $id)
    {
        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);
        $this->db->where('bankid', $id);
        $this->db->update('tblbanks', $data);

        return true;
    }

    /**
     * @param  integer ID
     * @return boolean
     * Delete client, also deleting rows from, dismissed client announcements, ticket replies, tickets, autologin, user notes
     */
    public function delete($id)
    {

        do_action('before_client_deleted', $id);

        $this->db->where('bankid', $id);
        $this->db->delete('tblbanks');
         return true;
    }


    /**
     * @param  integer ID
     * @param  integer Status ID
     * @return boolean
     * Update client status Active/Inactive
     */
    public function change_bank_status($id, $status)
    {
        $this->db->where('bankid', $id);
        $this->db->update('tblbanks', array(
            'active' => $status
        ));

        if ($this->db->affected_rows() > 0) {
            logActivity('Bank Status Changed [ClientID: ' . $id . ' Status(Active/Inactive): ' . $status . ']');
            return true;
        }

        return false;
    }
    
function get_prev($id){
   return $this->db->query("select bankid from tblbanks where bankid = (select max(bankid) from tblbanks where bankid < $id)")->row();
}
function get_next($id){
  return  $this->db->query("select bankid from tblbanks where bankid = (select min(bankid) from tblbanks where bankid > $id)")->row();
}
}
