<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class BankingAccountTransfer_model extends CRM_Model {

    function __construct() {
        parent::__construct();
    }

    /**
     * Get invoice item by ID
     * @param  mixed $id
     * @return mixed - array if not passed id, object if id passed
     */
    public function get($id = false, $active = '')
    {
        //$this->db->join('tblcountries','tblcountries.country_id = tblclients.country', 'left');

        if (is_int($active)) {
            $this->db->where('active', $active);
        }

        if (is_numeric($id)) {
            $this->db->where('ware_id', $id);
            $client = $this->db->get('tblwarehouse')->row();

            return $client;
        }

        //$this->db->order_by('datecreated', 'desc');
        return $this->db->get('tblwarehouse')->result_array();
    }



public function get_where_record($tbl,$id)
{
    
  return $this->db->where('contact_id', $id)->get($tbl)->row();  
}

public function get_client($id){
      return $this->db->where('ware_id', $id)->get('tblwarehouse')->row(); 
}
public function branches_by_bank($id){
      return $this->db->where('bankid', $id)->get('tblbankbranches')->result(); 
}
public function get_ledgers(){
      return $this->db->order_by('name', 'ASC')->where('type', 'Ledger')->get('tblledgergroups')->result(); 
}
public function get_banks(){
     return $this->db->order_by('bank', 'ASC')->get('tblbanks')->result();  
}
public function get_departments(){
   return $this->db->where('is_active','1')->order_by('sort_order','ASC')->get('tbldepartments')->result();  
}
   public function get_branches() {
        return $this->db->where('bankid', $this->input->post('id'))->get('tblbankbranches')->result();
    }
   public function get_accounts() {
	   	$this->db->where('branch', $this->input->post('id'));
	   	$this->db->where('id !=',$this->input->post('selectedaccount'));
        return $this->db->get('tblbanksaccount')->result();
		
    //    return $this->db->where('branch', $this->input->post('id'),'id',$this->input->post('selectedaccount'))->get('tblbanksaccount')->result();
		
    }
   public function get_accounts_details() {
        return $this->db->where('id', $this->input->post('id'))->get('tblbanksaccount')->row();
    }
  public function add($data){
            $d = DateTime::createFromFormat(get_current_date_format(), $data['date']);
             $data['date']  = $d->format('Y-m-d');
             
             
          $result=array(
              'date' =>$data['date'],
              'fromBank' =>$data['fromBank'],
              'fromBranch' =>$data['fromBranch'],
              'fromAccount' =>$data['fromAccount'],
              'fromBalance' =>str_replace(',','',$data['fromBalance']),
              'fromCurrency' =>$data['fromCurrency'],
              'amountToTransfer' =>str_replace(',','',$data['amountToTransfer']),
              'fromBAT' =>$data['fromBAT'],
              'toBank' =>$data['toBank'],
              'toBranch' =>$data['toBranch'],
              'toAccount' =>str_replace(',','',$data['toAccount']),
              'toBalance' =>str_replace(',','',$data['toBalance']),
              'toCurrency' =>$data['toCurrency'],
              'toBAT' =>str_replace(',','',$data['toBAT']),
              'note' =>$data['note']
              
         );
         
        $res =$this->db->insert('tblbanckaccounttransfer', $result);
        $transfer_id = $this->db->insert_id(); 
        if($res){
            $transferamount = str_replace(',','',$data['amountToTransfer']);
         
            $this->db->query("UPDATE tblbanksaccount SET balance = balance - $transferamount , available = available - $transferamount  WHERE id =".$data['fromAccount']); 
        
            $balanc = str_replace(',','',$data['amountToTransfer']); 
            
            $this->db->query("UPDATE tblbanksaccount SET balance = balance + $balanc , available = available + $balanc  WHERE id =".$data['toAccount']); 
			
	
        $amountToTransfer = str_replace(',','',$data['amountToTransfer']);
			
		$this->db->select('ledger');
        $this->db->where('id', $data['fromAccount']);
        $lederforbank = $this->db->get('tblbanksaccount')->row()->ledger;

		$this->db->select_max('voucher');
        $this->db->where('vchtype', '10');
        $voucher = $this->db->get('tblvoucher')->row()->voucher;

        if($voucher){
            $voucher = ++$voucher;
        }else{
         $voucher ='TRN0001';
        }
  //echo "<pre>";
       //  print_r($dat);
        $this->db->insert('tblvoucher',array(
                 
                        'voucher'=>$voucher,
                        'vchtype'=>'10',
                        'invoiceid'=>$transfer_id ,
                        'docdate'=>date('Y-m-d'),
                        'trxdate'=>$data['date'],
                        'created_by'=> get_staff_user_id(),
                        'currency'=>'3',
                   
                        ));
        $voucherid = $this->db->insert_id();
	
		$this->db->select('id');

        $this->db->where('id', $lederforbank);
        $ledernameforbank = $this->db->get('tblledgergroups')->row()->id;	
		
		
							$this->db->insert('tblvoucherlines',array(
                            'ledger'=>$ledernameforbank, 
                            'vchid'=>$voucherid,
                            // 'amount'=>$data['total'],
                            'amount'=>$amountToTransfer,
                            'description'=> 'Bank Transfer',
                            'refrence'=>'',
                            'invoiceid'=>$transfer_id,
                            'poid'=>'',
                            'item_order'=>'0',
                            'amount_type'=>1 // 0 debit ; 1 credit
                            ));	
							
			
	$this->db->select('ledger');
        $this->db->where('id', $data['toAccount']);
        $lederforbank = $this->db->get('tblbanksaccount')->row()->ledger;

		$this->db->select_max('voucher');
        $this->db->where('vchtype', '10');
        $voucher = $this->db->get('tblvoucher')->row()->voucher;

        if($voucher){
            $voucher = ++$voucher;
        }else{
         $voucher ='TRN0001';
        }
  //echo "<pre>";
       //  print_r($dat);
        $this->db->insert('tblvoucher',array(
                 
                        'voucher'=>$voucher,
                        'vchtype'=>'10',
                        'invoiceid'=>$transfer_id ,
                        'docdate'=>date('Y-m-d'),
                        'trxdate'=>$data['date'],
                        'created_by'=> get_staff_user_id(),
                        'currency'=>'3',
                   
                        ));
        $voucherid = $this->db->insert_id();
	
		$this->db->select('id');

        $this->db->where('id', $lederforbank);
        $ledernameforbank = $this->db->get('tblledgergroups')->row()->id;	
		
		
							$this->db->insert('tblvoucherlines',array(
                            'ledger'=>$ledernameforbank, 
                            'vchid'=>$voucherid,
                            // 'amount'=>$data['total'],
                            'amount'=>$amountToTransfer,
                            'description'=> 'Bank Transfer',
                            'refrence'=>'',
                            'invoiceid'=>$transfer_id,
                            'poid'=>'',
                            'item_order'=>'0',
                            'amount_type'=>0 // 0 debit ; 1 credit
                            ));	
							
			
			
			
			
			
			
             return $res;
			 
			 
			 
			 
			 
			 
			 
			 
			 
			 
			 
			 
			 
        }
       
  }
  public function getBankName($bankid){
       return $this->db->where('bankid',$bankid)->get('tblbanks')->row()->bank;   
  }
  public function getBranchName($branchid){
       return $this->db->where('bankbranchid',$branchid)->get('tblbankbranches')->row()->branchname;   
  }
  public function getBankAccount($accountid){
       return $this->db->where('id',$accountid)->get('tblbanksaccount')->row()->account_number;   
  }
  public function getCurrency($currency){
       return $this->db->where('id',$currency)->get('tblcurrencies')->row()->name;   
  }
  public function getCurrencySymbol($currency){
       return $this->db->where('id',$currency)->get('tblcurrencies')->row()->symbol;   
  }
  public function delete($id){
    $this->db->where('id', $id);
    $res=$this->db->delete('tblbanckaccounttransfer');
  
    return $res;
  }
  public function getdetails($id){
        return $this->db->where('id',$id)->get('tblbanckaccounttransfer')->row();    
  }
 
    
}
