<?php
/**
 * Newsfeed post attachments
 * @param  mixed $postid Post ID to add attachments
 * @return array  - Result values
 */
function handle_newsfeed_post_attachments($postid)
{
    $path = NEWSFEED_FOLDER . $postid . '/';
    $CI =& get_instance();
    if (isset($_FILES['file']['name'])) {
        $uploaded_files = false;
        // Get the temp file path
        $tmpFilePath    = $_FILES['file']['tmp_name'];
        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {

            $type        = $_FILES["file"]["type"];
            // Setup our new file path
            $filename    = unique_filename($path, $_FILES["file"]["name"]);
            $newFilePath = $path . $filename;

            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }

            // Upload the file into the temp dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                $file_uploaded = true;
                $CI->db->insert('tblpostattachments', array(
                    'filename' => $filename,
                    'postid' => $postid,
                    'filetype' => $type,
                    'datecreated' => date('Y-m-d H:i:s')
                ));
            }
        }

        if ($file_uploaded == true) {
            echo json_encode(array(
                'success' => true,
                'postid' => $postid
            ));
        } else {
            echo json_encode(array(
                'success' => false,
                'postid' => $postid
            ));
        }
    }
}
/**
 * Handle contract attachments if any
 * @param  mixed $contractid
 * @return boolean
 */
function handle_contract_attachment($contractid)
{
    if (isset($_FILES['file']['name']) && $_FILES['file']['name'] != '') {
        $path        = CONTRACTS_UPLOADS_FOLDER . $contractid . '/';
        // Get the temp file path
        $tmpFilePath = $_FILES['file']['tmp_name'];
        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Setup our new file path
            $filename    = unique_filename($path, $_FILES["file"]["name"]);
            $newFilePath = $path . $filename;
            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }
            // Upload the file into the company uploads dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                $CI =& get_instance();
                $CI->db->insert('tblcontractattachments', array(
                    'contractid' => $contractid,
                    'file_name' => $filename,
                    'filetype' => $_FILES["file"]["type"],
                    'dateadded' => date('Y-m-d H:i:s')
                ));

                return true;
            }
        }
    }

    return false;
}

/**
 * Handle lead attachments if any
 * @param  mixed $leadid
 * @return boolean
 */
function handle_lead_attachments($leadid)
{

    $CI =& get_instance();
    if (isset($_FILES['file']['name']) && $_FILES['file']['name'] != '') {
        $path        = LEAD_ATTACHMENTS_FOLDER . $leadid . '/';
        // Get the temp file path
        $tmpFilePath = $_FILES['file']['tmp_name'];
        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Setup our new file path
            $filename    = unique_filename($path, $_FILES["file"]["name"]);
            $newFilePath = $path . $filename;
            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }
            // Upload the file into the company uploads dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                $CI =& get_instance();
                $CI->db->insert('tblleadattachments', array(
                    'leadid' => $leadid,
                    'file_name' => $filename,
                    'filetype' => $_FILES["file"]["type"],
                    'addedfrom' => get_staff_user_id(),
                    'dateadded' => date('Y-m-d H:i:s')
                ));

                $CI->load->model('leads_model');
                $CI->leads_model->log_lead_activity($leadid, 'Added attachment');
                return true;
            }
        }
    }

    return false;
}

/**
 * Check for task attachment
 * @since Version 1.0.1
 * @param  mixed $taskid
 * @return mixed           false if no attachment || array uploaded attachments
 */
function handle_tasks_attachments($taskid)
{

    $path           = TASKS_ATTACHMENTS_FOLDER . $taskid . '/';
    $uploaded_files = array();
    if (isset($_FILES['file']['name']) && $_FILES['file']['name'] != '') {
        // Get the temp file path
        $tmpFilePath = $_FILES['file']['tmp_name'];

        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Setup our new file path
            $filename    = unique_filename($path, $_FILES["file"]["name"]);
            $newFilePath = $path . $filename;

            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }

            // Upload the file into the temp dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                array_push($uploaded_files, array(
                    'filename' => $filename,
                    'filetype' => $_FILES["file"]["type"]
                ));
            }
        }

    }

    if (count($uploaded_files) > 0) {
        return $uploaded_files;
    }

    return false;
}


/**
 * Invoice attachments
 * @since  Version 1.0.4
 * @param  mixed $invoiceid invoice ID to add attachments
 * @return array  - Result values
 */
function handle_invoice_attachments($invoiceid)
{
    $path = INVOICE_ATTACHMENTS_FOLDER . $invoiceid . '/';
    $CI =& get_instance();
    if (isset($_FILES['file']['name'])) {
        $uploaded_files = false;
        // Get the temp file path
        $tmpFilePath    = $_FILES['file']['tmp_name'];
        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Getting file extension
            $type        = $_FILES["file"]["type"];
            // Setup our new file path
            $filename    = unique_filename($path, $_FILES["file"]["name"]);
            $newFilePath = $path . $filename;

            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }

            // Upload the file into the temp dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                $file_uploaded = true;
                $CI->db->insert('tblinvoiceattachments', array(
                    'file_name' => $filename,
                    'invoiceid' => $invoiceid,
                    'filetype' => $type,
                    'datecreated' => date('Y-m-d H:i:s')
                ));

                $insert_id = $CI->db->insert_id();
                $CI->load->model('invoices_model');
                $CI->invoices_model->log_invoice_activity($invoiceid, 'Added attachment');
            }
        }

        if ($file_uploaded == true) {
            echo json_encode(array(
                'success' => true,
                'invoiceid' => $invoiceid,
                'attachment_id' => $insert_id,
                'filetype' => $type,
                'file_name' => $filename
            ));
        } else {
            echo json_encode(array(
                'success' => false,
                'invoiceid' => $invoiceid,
                'file_name' => $filename
            ));
        }
    }
}


/**
 * Client attachments
 * @since  Version 1.0.4
 * @param  mixed $clientid Client ID to add attachments
 * @return array  - Result values
 */
function handle_client_attachments_upload($clientid)
{

    $path = CLIENT_ATTACHMENTS_FOLDER . $clientid . '/';
    $CI =& get_instance();
    if (isset($_FILES['file']['name'])) {
        // Get the temp file path
        $tmpFilePath = $_FILES['file']['tmp_name'];
        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Getting file extension
            $type        = $_FILES["file"]["type"];
            // Setup our new file path
            $filename    = unique_filename($path, $_FILES['file']['name']);
            $newFilePath = $path . $filename;

            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }
            // Upload the file into the temp dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                $CI->db->insert('tblclientattachments', array(
                    'file_name' => $filename,
                    'clientid' => $clientid,
                    'filetype' => $type,
                    'datecreated' => date('Y-m-d H:i:s')
                ));

            }
        }
    }
}

function handle_employee_attachments_upload($empid)
{

    $path = EMPLOYEE_ATTACHMENTS_FOLDER . $empid . '/';
    $CI =& get_instance();
    if (isset($_FILES['file']['name'])) {
        // Get the temp file path
        $tmpFilePath = $_FILES['file']['tmp_name'];
        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Getting file extension
            $type        = $_FILES["file"]["type"];
            // Setup our new file path
            $filename    = unique_filename($path, $_FILES['file']['name']);
            $newFilePath = $path . $filename;

            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }
            // Upload the file into the temp dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                $CI->db->insert('tblemployeeattachments', array(
                    'file_name' => $filename,
                    'empid' => $empid,
                    'filetype' => $type,
                    'datecreated' => date('Y-m-d H:i:s')
                ));

            }
        }
    }
}

function handle_branch_attachments_upload($clientid)
{

    $path = BRANCH_ATTACHMENTS_FOLDER . $clientid . '/';
    $CI =& get_instance();
    if (isset($_FILES['file']['name'])) {
        // Get the temp file path
        $tmpFilePath = $_FILES['file']['tmp_name'];
        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Getting file extension
            $type        = $_FILES["file"]["type"];
            // Setup our new file path
            $filename    = unique_filename($path, $_FILES['file']['name']);
            $newFilePath = $path . $filename;

            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }
            // Upload the file into the temp dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                $CI->db->insert('tblbankbrancheattachments', array(
                    'file_name' => $filename,
                    'clientid' => $clientid,
                    'filetype' => $type,
                    'datecreated' => date('Y-m-d H:i:s')
                ));

            }
        }
    }
}

function handle_expense_attachments($id)
{
    $path = EXPENSE_ATTACHMENTS_FOLDER . $id . '/';
    $CI =& get_instance();
    if (isset($_FILES['file']['name'])) {

        // Get the temp file path
        $tmpFilePath = $_FILES['file']['tmp_name'];
        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Setup our new file path
            $filename    = $_FILES["file"]["name"];
            $newFilePath = $path . $filename;
            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }
            // Upload the file into the temp dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                $CI->db->where('id', $id);
                $CI->db->update('tblexpenses', array(
                    'attachment' => $filename,
                    'filetype' => $_FILES["file"]["type"]
                ));
            }
        }
    }
}

/**
 * Check for ticket attachment after inserting ticket to database
 * @param  mixed $ticketid
 * @return mixed           false if no attachment || array uploaded attachments
 */
function handle_ticket_attachments($ticketid)
{
    $path           = TICKET_ATTACHMENTS_FOLDER . $ticketid . '/';
    $uploaded_files = array();

    for ($i = 0; $i < count($_FILES['attachments']['name']); $i++) {
        if ($i <= get_option('maximum_allowed_ticket_attachments')) {
            // Get the temp file path
            $tmpFilePath = $_FILES['attachments']['tmp_name'][$i];

            // Make sure we have a filepath
            if (!empty($tmpFilePath) && $tmpFilePath != '') {
                // Getting file extension
                $path_parts         = pathinfo($_FILES["attachments"]["name"][$i]);
                $extension          = $path_parts['extension'];
                $allowed_extensions = explode('|', get_option('ticket_attachments_file_extensions'));
                // Check for all cases if this extension is allowed
                if (!in_array($extension, $allowed_extensions)) {
                    continue;
                }
                // Setup our new file path
                $filename    = unique_filename($path, $_FILES["attachments"]["name"][$i]);
                $newFilePath = $path . $filename;

                if (!file_exists($path)) {
                    mkdir($path);
                    fopen($path . 'index.html', 'w');
                }

                // Upload the file into the temp dir
                if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                    array_push($uploaded_files, array(
                        'file_name' => $filename,
                        'filetype' => $_FILES["attachments"]["type"][$i]
                    ));
                }
            }
        }
    }

    if (count($uploaded_files) > 0) {
        return $uploaded_files;
    }
    return false;
}

function handle_item_upload($id,$eview_id = "")
{
    if (isset($_FILES['image']['name']) && $_FILES['image']['name'] != '') {
        $path        = INVOICE_ATTACHMENTS_FOLDER;
        $path1        = EVIEW_FOLDER;
		 $CI =& get_instance();
		$CI->db->select('image');
		$CI->db->where('empid', $id);
		$sup = $CI->db->get('tblemployee')->row();
		if($sup->image)
		{
		if(file_exists($path.$sup->image))
			unlink($path.$sup->image);
		if(file_exists($path.$sup->image))
			unlink($path1.$sup->image);
		}
        // Get the temp file path
        $tmpFilePath = $_FILES['image']['tmp_name'];

        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Getting file extension
            $path_parts  = pathinfo($_FILES["image"]["name"]);
            $extension   = $path_parts['extension'];

            $allowed_extensions = array('jpg','jpeg','png');

            if(!in_array($extension, $allowed_extensions)) {
                set_alert('warning','Image extension not allowed.');
                return false;
            }

            // Setup our new file path
            $filename    = uniqid().".".$extension;
			
            $newFilePath = $path . $filename;
            $newFilePath1 = $path1 . $filename;
            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }
            // Upload the file into the company uploads dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {

                copy($newFilePath, $newFilePath1);

              
                $CI->db->where('id', $id);
                $CI->db->update('tblinvoiceitemslist', array(
                    'image' => $filename
                ));

                if($eview_id == "")
                {
                    $eviw_main_image = array(

                                    'invoiceitems_id' => $id,
                                    'main_image' => $filename,
                                    );

                    $CI->db->insert('tblinvoiceitems_eview', $eviw_main_image);
                    return $CI->db->insert_id();
                
                    
                }
                else
                {
                    $CI->db->where('id', $eview_id);
                    $CI->db->update('tblinvoiceitems_eview', array(
                        'main_image' => $filename
                    ));
                }
                
                

                return true;
            }
        }
    }
    
    return false;
}
function handle_emplyee_upload($id)
{
    if (isset($_FILES['image']['name']) && $_FILES['image']['name'] != '') {
		 $CI =& get_instance();
		$CI->db->select('image');
		$CI->db->where('empid', $id);
		$sup = $CI->db->get('tblemployee')->row();
		if($sup->image)
		if(file_exists(FCPATH."uploads/employee/".$id."/".$sup->image))
			unlink(FCPATH."uploads/employee/".$id."/".$sup->image);
			
        $path        = FCPATH."uploads/employee/".$id."/";
       
        // Get the temp file path
        $tmpFilePath = $_FILES['image']['tmp_name'];

        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Getting file extension
            $path_parts  = pathinfo($_FILES["image"]["name"]);
            $extension   = $path_parts['extension'];

            $allowed_extensions = array('jpg','jpeg','png');

            if(!in_array($extension, $allowed_extensions)) {
                set_alert('warning','Image extension not allowed.');
                return false;
            }

            // Setup our new file path
            $filename    = uniqid().".".$extension;
			
            $newFilePath = $path . $filename;
         
            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }
			
            // Upload the file into the company uploads dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {

               

               
                $CI->db->where('empid', $id);
                $CI->db->update('tblemployee', array(
                    'image' => $filename
                ));
                

                return true;
            }
        }
    }
    
    return false;
}
function handle_makeimg_upload($id)
{
	
	
    if (isset($_FILES['image_make']['name']) && $_FILES['image_make']['name'] != '') {
		
		 $CI =& get_instance();
		$CI->db->select('image_make');
		$CI->db->where('id', $id);
		$sup = $CI->db->get('vehiclemodelyear')->row();
		if($sup->image)
		if(file_exists(FCPATH."uploads/make_img/".$sup->image_make))
			unlink(FCPATH."uploads/make_img/".$sup->image_make);
			
        $path        = FCPATH."uploads/make_img/";
       
        // Get the temp file path
        $tmpFilePath = $_FILES['image_make']['tmp_name'];

        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Getting file extension
            $path_parts  = pathinfo($_FILES["image_make"]["name"]);
            $extension   = $path_parts['extension'];

            $allowed_extensions = array('jpg','jpeg','png');

            if(!in_array($extension, $allowed_extensions)) {
                set_alert('warning','Image extension not allowed.');
                return false;
            }

            // Setup our new file path
            $filename    = uniqid().".".$extension;
			
            $newFilePath = $path . $filename;
         
           
			
            // Upload the file into the company uploads dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {

               

               
                $CI->db->where('id', $id);
                $CI->db->update('vehiclemodelyear', array(
                    'image_make' => $filename
                ));
				//echo $this->db->last_query();
				//exit;
                

                return true;
            }
        }
    }
    
    return false;
}
function handle_modelimg_upload($id)
{
	echo $_FILES['image_model']['name'];
    if (isset($_FILES['image_model']['name']) && $_FILES['image_model']['name'] != '') {
		 $CI =& get_instance();
		$CI->db->select('image_model');
		$CI->db->where('id', $id);
		$sup = $CI->db->get('vehiclemodelyear')->row();
		if($sup->image)
		if(file_exists(FCPATH."uploads/model_img/".$sup->image_make))
			unlink(FCPATH."uploads/model_img/".$sup->image_make);
			
        $path        = FCPATH."uploads/model_img/";
       
        // Get the temp file path
        $tmpFilePath = $_FILES['image_model']['tmp_name'];

        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Getting file extension
            $path_parts  = pathinfo($_FILES["image_model"]["name"]);
            $extension   = $path_parts['extension'];

            $allowed_extensions = array('jpg','jpeg','png');

            if(!in_array($extension, $allowed_extensions)) {
                set_alert('warning','Image extension not allowed.');
                return false;
            }

            // Setup our new file path
            $filename    = uniqid().".".$extension;
			
            $newFilePath = $path . $filename;
         
           
			
            // Upload the file into the company uploads dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {

               
               
                $CI->db->where('id', $id);
                $CI->db->update('vehiclemodelyear', array(
                    'image_model' => $filename
                ));
                

                return true;
            }
        }
    }
    
    return false;
}
function handle_supplier_upload($id)
{
	
    if (isset($_FILES['image']['name']) && $_FILES['image']['name'] != '') {
		 $CI =& get_instance();
		$CI->db->select('image');
		$CI->db->where('userid', $id);
		$sup = $CI->db->get('tblsuppliers')->row();
		if($sup->image)
		if(file_exists(FCPATH."uploads/suppliers/".$sup->image))
			unlink(FCPATH."uploads/suppliers/".$sup->image);
		
        $path        = FCPATH."uploads/suppliers/";
      
        // Get the temp file path
        $tmpFilePath = $_FILES['image']['tmp_name'];

        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Getting file extension
            $path_parts  = pathinfo($_FILES["image"]["name"]);
            $extension   = $path_parts['extension'];

            $allowed_extensions = array('jpg','jpeg','png');

            if(!in_array($extension, $allowed_extensions)) {
                set_alert('warning','Image extension not allowed.');
                return false;
            }

            // Setup our new file path
            $filename    = uniqid().".".$extension;
			
            $newFilePath = $path . $filename;
         
            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }
			 
            // Upload the file into the company uploads dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {

             

                $CI =& get_instance();
                $CI->db->where('userid', $id);
                $CI->db->update('tblsuppliers', array(
                    'image' => $filename
                ));
                

                return true;
            }
        }
    }
    
    return false;
}
/**
 * Check for company logo upload
 * @param  mixed $ticketid
 * @return boolean
 */



function handle_eviewitem_upload($id)
{
    if (isset($_FILES['image']['name']) && $_FILES['image']['name'] != '') {
        $path        = EVIEW_FOLDER;
        // Get the temp file path
        $tmpFilePath = $_FILES['image']['tmp_name'];

        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Getting file extension
            $path_parts  = pathinfo($_FILES["image"]["name"]);
            $extension   = $path_parts['extension'];

            $allowed_extensions = array('jpg','jpeg','png');

            if(!in_array($extension, $allowed_extensions)) {
                set_alert('warning','Image extension not allowed.');
                return false;
            }

            // Setup our new file path
            $filename    = $_FILES["image"]["name"];
            $newFilePath = $path . $filename;
            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }
            
            echo $tmpFilePath;
            die;
            // Upload the file into the company uploads dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                $CI =& get_instance();
                // $CI->db->where('id', $id);
                // $CI->db->update('tblinvoiceitemslist', array(
                //     'image' => $filename
                // ));
                echo $newFilePath;
                $eviw_main_image = array(

                                    'invoiceitems_id' => $id,
                                    'main_image' => $filename,
                                    );

                $CI->db->insert('tblinvoiceitems_eview', $eviw_main_image);
                die;
                return true;
            }
        }
    }
    
    return false;
}

function handle_main_image_upload($id,$product_id = "")
{
    if (isset($_FILES['main_image']['name']) && $_FILES['main_image']['name'] != '') {
        $path        = EVIEW_FOLDER;
        // Get the temp file path
        $tmpFilePath = $_FILES['main_image']['tmp_name'];

        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Getting file extension
            $path_parts  = pathinfo($_FILES["main_image"]["name"]);
            $extension   = $path_parts['extension'];

            $product_filename = $path_parts['filename'];

            $allowed_extensions = array('jpg','jpeg','png');

            if(!in_array($extension, $allowed_extensions)) {
                set_alert('warning','Image extension not allowed.');
                return false;
            }

            // Setup our new file path
            $filename    = $_FILES["main_image"]["name"];
            $newFilePath = $path . $filename;
            // echo $newFilePath;
            // die;
            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }

            // $another_path = 'proverbs.ekomplete.com/images/modules/shoppingcart/products/thumbs/'.$filename;
            // $product_file = $newFilePath;

            // $another_path_product = '/home/proverbs/public_html/images/modules/shoppingcart/products/'.$filename;

            // $product_thumbfile = $another_path_product;

            // rename($newFilePath, $another_path_product);
            
            // if(file_exists($product_thumbfile))
            // {
            //     $another_path = '/home/proverbs/public_html/images/modules/shoppingcart/products/thumbs/'.$product_filename.'_thumb.'.$extension;
            //     copy($product_thumbfile, $another_path);

            // }
            // copy($another_path_product, 'thumbs/'.$filename);
            // move_uploaded_file($tmpFilePath,$another_path);

            // Upload the file into the company uploads dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                $CI =& get_instance();
                $CI->db->where('id', $id);
                $CI->db->update('tblinvoiceitems_eview', array(
                    'main_image' => $filename
                ));


                // $db2 = $CI->load->database('proverbs_solomon', TRUE);
                // $db2->where('id', $product_id);
                // $db2->update('cart_products', array(
                //     'main_image' => $filename,
                // ));

                // $db2->where('id', $product_id);
                // $db2->update('cart_products', array(
                //     'main_image_thumb' => $product_filename.'_thumb.'.$extension,
                // ));

                return true;
            }
        }
    }
    
    return false;
}

function handle_main_image_eview_upload($id,$product_id = "")
{
    if (isset($_FILES['main_image']['name']) && $_FILES['main_image']['name'] != '') {
        $path        = EVIEW_FOLDER;
        // Get the temp file path
        $tmpFilePath = $_FILES['main_image']['tmp_name'];

        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Getting file extension
            $path_parts  = pathinfo($_FILES["main_image"]["name"]);
            $extension   = $path_parts['extension'];

            $product_filename = $path_parts['filename'];

            $allowed_extensions = array('jpg','jpeg','png');

            if(!in_array($extension, $allowed_extensions)) {
                set_alert('warning','Image extension not allowed.');
                return false;
            }

            // Setup our new file path
            $filename    = $_FILES["main_image"]["name"];
            $newFilePath = $path . $filename;
            // echo $newFilePath;
            // die;
            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }

            // $another_path = 'proverbs.ekomplete.com/images/modules/shoppingcart/products/thumbs/'.$filename;
            // $product_file = $newFilePath;

            // $another_path_product = '/home/proverbs/public_html/images/modules/shoppingcart/products/'.$filename;

            // $product_thumbfile = $another_path_product;

            // rename($newFilePath, $another_path_product);
            
            // if(file_exists($product_thumbfile))
            // {
            //     $another_path = '/home/proverbs/public_html/images/modules/shoppingcart/products/thumbs/'.$product_filename.'_thumb.'.$extension;
            //     copy($product_thumbfile, $another_path);

            // }
            // copy($another_path_product, 'thumbs/'.$filename);
            // move_uploaded_file($tmpFilePath,$another_path);

            // Upload the file into the company uploads dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                $CI =& get_instance();
                $CI->db->where('id', $id);
                $CI->db->update('tblinvoiceitems_eview', array(
                    'main_image' => $filename
                ));


                // $db2 = $CI->load->database('proverbs_solomon', TRUE);
                // $db2->where('id', $product_id);
                // $db2->update('cart_products', array(
                //     'main_image' => $filename,
                // ));

                // $db2->where('id', $product_id);
                // $db2->update('cart_products', array(
                //     'main_image_thumb' => $product_filename.'_thumb.'.$extension,
                // ));

                return true;
            }
        }
    }
    
    return false;
}

function handle_mainimage_eview_upload($eview_id,$image)
{
    if ($image != "") 
    {
        $path = EVIEW_FOLDER;
        $local_file = INVOICE_ATTACHMENTS_FOLDER.$image;
        
            $path_parts  = pathinfo($image);
            $extension   = $path_parts['extension'];

            $product_filename = $path_parts['filename'];

            $allowed_extensions = array('jpg','jpeg','png');

            if(!in_array($extension, $allowed_extensions)) {
                set_alert('warning','Image extension not allowed.');
                return false;
            }

            // Setup our new file path
            $filename    = $image;
            $newFilePath = $path . $filename;
            // echo $newFilePath;
            // die;
            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }
           
            // Upload the file into the company uploads dir
            $remote_file = $newFilePath;
            copy($local_file, $remote_file);
            
            $CI =& get_instance();
            $CI->db->where('id', $eview_id);
            $CI->db->update('tblinvoiceitems_eview', array(
                'main_image' => $image
            ));

                return true;
            
       
    }
    
    return false;
}


function handle_product_main_image_upload($product_id,$image)
{
    // echo $product_id;
    // die;
    // echo $product_id;
    // die;
    // if (isset($_FILES['main_image']['name']) && $_FILES['main_image']['name'] != '') {
    if ($image != "") {
        
        // $filename    = $_FILES["main_image"]["name"];
        $filename    = $image;
        $CI =& get_instance();
        $CI->load->library('ftp');
        // echo $filename;
        // die;

        $local_file = EVIEW_FOLDER.$filename;
        // echo $local_file; 
        // die;
        // $local_file = site_url('uploads/eview').'/'.$filename;
      
        // /* FTP Account */
        // $ftp_host = "ftp.proverbs.ekomplete.com"; /* host */
        // $ftp_user_name = "jay@proverbs.ekomplete.com"; /* username */
        // $ftp_user_pass = "dtMo;rB@VITU"; /* password */

        $ftp_config['hostname'] = "skyway.redplanethost.com"; 
        $ftp_config['hostname'] = "ftp.proverbs.ekomplete.com"; 
        $ftp_config['username'] = "jay@proverbs.ekomplete.com";
        $ftp_config['password'] = "dtMo;rB@VITU";
        $ftp_config['debug']    = TRUE;

        $CI->ftp->connect($ftp_config);


        // $remote_file = '/home/proverbs/public_html/'.$filename;
        $remote_file = '/public_html/images/modules/shoppingcart/products/'.$filename;


        $path_parts  = pathinfo($filename);
        $extension   = $path_parts['extension'];

        $product_filename = $path_parts['filename'];
        // echo $product_filename;
        // die;


        $remote_thumbs_file = '/public_html/images/modules/shoppingcart/products/thumbs/'.$product_filename.'_thumb.'.$extension;
        // echo $remote_file;
        // die;

        $CI->ftp->upload($local_file,$remote_file);
        $CI->ftp->upload($local_file,$remote_thumbs_file);

        // $CI =& get_instance();
        
        $db2 = $CI->load->database('proverbs_solomon', TRUE);
        $db2->where('id', $product_id);
        $db2->update('cart_products', array(
            'main_image' => $filename,
        ));

        $db2->where('id', $product_id);
        $db2->update('cart_products', array(
            'main_image_thumb' => $product_filename.'_thumb.'.$extension,
        ));

        $CI->ftp->close();

        // $connect_it = ftp_connect( $ftp_host );

        // if (ftp_login($connect_it, $ftp_user_name, $ftp_user_pass)) {
        //     echo "Connected as $ftp_user_name@$ftp_host\n";

        // } else {
        //     echo "Couldn't connect as $ftp_user_name\n";
        // }
        // // die;

        // // $login_result = ftp_login( $connect_it, $ftp_user_name, $ftp_user_pass );

        // if ( ftp_put( $connect_it, $remote_file, $local_file, FTP_ASCII ) ) {

        //     // $CI =& get_instance();
        
        //     // $db2 = $CI->load->database('proverbs_solomon', TRUE);
        //     // $db2->where('id', $product_id);
        //     // $db2->update('cart_products', array(
        //     //     'main_image' => $filename,
        //     // ));

        //     // $db2->where('id', $product_id);
        //     // $db2->update('cart_products', array(
        //     //     'main_image_thumb' => $product_filename.'_thumb.'.$extension,
        //     // ));

        //     // return true;
        //     echo "WOOT! Successfully transfer $local_file\n";
        // }
        // else {
        //     echo "Doh! There was a problem\n";
        // }
 
        //     die;

        return true;
            
    }
    
    return false;
}

function handle_image1_upload($id,$product_id = "")
{
    if (isset($_FILES['image1']['name']) && $_FILES['image1']['name'] != '') {
        $path        = EVIEW_FOLDER;
        // Get the temp file path
        $tmpFilePath = $_FILES['image1']['tmp_name'];

        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Getting file extension
            $path_parts  = pathinfo($_FILES["image1"]["name"]);
            $extension   = $path_parts['extension'];

            $product_filename = $path_parts['filename'];

            $allowed_extensions = array('jpg','jpeg','png');

            if(!in_array($extension, $allowed_extensions)) {
                set_alert('warning','Image extension not allowed.');
                return false;
            }

            // Setup our new file path
            $filename    = $_FILES["image1"]["name"];
            $newFilePath = $path . $filename;
            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }

            
            // Upload the file into the company uploads dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                $CI =& get_instance();
                $CI->db->where('id', $id);
                $CI->db->update('tblinvoiceitems_eview', array(
                    'image1' => $filename
                ));

                // $db2 = $CI->load->database('proverbs_solomon', TRUE);
                // $db2->where('id', $product_id);
                // $db2->update('cart_products', array(
                //     'image1' => $filename,
                // ));

                // $db2->where('id', $product_id);
                // $db2->update('cart_products', array(
                //     'image1_thumb' => $product_filename.'_thumb.'.$extension,
                // ));

                return true;
            }
        }
    }
    
    return false;
}

function handle_product_image1_eview_upload($product_id,$image)
{
   
    if ($image != "") 
    {
        
        $filename    = $image;
        // echo $image;
        // die;
        $CI =& get_instance();
        $CI->load->library('ftp');
        
        $local_file = EVIEW_FOLDER.$filename;

        $ftp_config['hostname'] = "skyway.redplanethost.com"; 
        $ftp_config['hostname'] = "ftp.proverbs.ekomplete.com"; 
        $ftp_config['username'] = "jay@proverbs.ekomplete.com";
        $ftp_config['password'] = "dtMo;rB@VITU";
        $ftp_config['debug']    = TRUE;

        $CI->ftp->connect($ftp_config);

        $remote_file = '/public_html/images/modules/shoppingcart/products/'.$filename;


        $path_parts  = pathinfo($filename);
        $extension   = $path_parts['extension'];

        $product_filename = $path_parts['filename'];
        
        $remote_thumbs_file = '/public_html/images/modules/shoppingcart/products/thumbs/'.$product_filename.'_thumb.'.$extension;
        // echo $remote_file;
        // die;

        $CI->ftp->upload($local_file,$remote_file);
        $CI->ftp->upload($local_file,$remote_thumbs_file);

        // $CI =& get_instance();
        
        $db2 = $CI->load->database('proverbs_solomon', TRUE);
        $db2->where('id', $product_id);
        $db2->update('cart_products', array(
            'image1' => $filename,
        ));

        $db2->where('id', $product_id);
        $db2->update('cart_products', array(
            'image1_thumb' => $product_filename.'_thumb.'.$extension,
        ));

        $CI->ftp->close();
        return true;
            
    }
    
    return false;
}

function handle_product_image1_upload($product_id = "")
{
    if (isset($_FILES['image1']['name']) && $_FILES['image1']['name'] != '') {
        
        $filename    = $_FILES["image1"]["name"];
        $CI =& get_instance();
        $CI->load->library('ftp');

        $local_file = EVIEW_FOLDER.$filename;
        // $local_file = site_url('uploads/eview').'/'.$filename;
      

        $ftp_config['hostname'] = "skyway.redplanethost.com"; 
        $ftp_config['hostname'] = "ftp.proverbs.ekomplete.com"; 
        $ftp_config['username'] = "jay@proverbs.ekomplete.com";
        $ftp_config['password'] = "dtMo;rB@VITU";
        $ftp_config['debug']    = TRUE;

        $CI->ftp->connect($ftp_config);


        // $remote_file = '/home/proverbs/public_html/'.$filename;
        $remote_file = '/public_html/images/modules/shoppingcart/products/'.$filename;


        $path_parts  = pathinfo($_FILES["image1"]["name"]);
        $extension   = $path_parts['extension'];

        $product_filename = $path_parts['filename'];


        $remote_thumbs_file = '/public_html/images/modules/shoppingcart/products/thumbs/'.$product_filename.'_thumb.'.$extension;
        // echo $remote_file;
        // die;

        $CI->ftp->upload($local_file,$remote_file);
        $CI->ftp->upload($local_file,$remote_thumbs_file);

        // $CI =& get_instance();
        
        $db2 = $CI->load->database('proverbs_solomon', TRUE);
        $db2->where('id', $product_id);
        $db2->update('cart_products', array(
            'image1' => $filename,
        ));

        $db2->where('id', $product_id);
        $db2->update('cart_products', array(
            'image1_thumb' => $product_filename.'_thumb.'.$extension,
        ));

        $CI->ftp->close();       

        return true;
            
    }
    
    return false;
}

function handle_image2_upload($id,$product_id = "")
{
    if (isset($_FILES['image2']['name']) && $_FILES['image2']['name'] != '') {
        $path        = EVIEW_FOLDER;
        // Get the temp file path
        $tmpFilePath = $_FILES['image2']['tmp_name'];

        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Getting file extension
            $path_parts  = pathinfo($_FILES["image2"]["name"]);
            $extension   = $path_parts['extension'];

            $product_filename = $path_parts['filename'];

            $allowed_extensions = array('jpg','jpeg','png');

            if(!in_array($extension, $allowed_extensions)) {
                set_alert('warning','Image extension not allowed.');
                return false;
            }

            // Setup our new file path
            $filename    = $_FILES["image2"]["name"];
            $newFilePath = $path . $filename;
            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }

            // $product_file = $newFilePath;

            // $another_path_product2 = '/home/proverbs/public_html/images/modules/shoppingcart/products/'.$filename;

            // $product_thumbfile2 = $another_path_product2;

            // rename($newFilePath, $another_path_product2);
            
            // if(file_exists($product_thumbfile2))
            // {
            //     $another_path2 = '/home/proverbs/public_html/images/modules/shoppingcart/products/thumbs/'.$product_filename.'_thumb.'.$extension;
            //     copy($product_thumbfile2, $another_path2);

            // }

            // Upload the file into the company uploads dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                $CI =& get_instance();
                $CI->db->where('id', $id);
                $CI->db->update('tblinvoiceitems_eview', array(
                    'image2' => $filename
                ));

                // $db2 = $CI->load->database('proverbs_solomon', TRUE);
                // $db2->where('id', $product_id);
                // $db2->update('cart_products', array(
                //     'image2' => $filename,
                // ));

                // $db2->where('id', $product_id);
                // $db2->update('cart_products', array(
                //     'image2_thumb' => $product_filename.'_thumb.'.$extension,
                // ));

                return true;
            }
        }
    }
    
    return false;
}


function handle_product_image2_upload($product_id = "")
{
    if (isset($_FILES['image2']['name']) && $_FILES['image2']['name'] != '') {
        
        $filename    = $_FILES["image2"]["name"];
        $CI =& get_instance();
        $CI->load->library('ftp');

        $local_file = EVIEW_FOLDER.$filename;
        // $local_file = site_url('uploads/eview').'/'.$filename;
      

        $ftp_config['hostname'] = "skyway.redplanethost.com"; 
        $ftp_config['hostname'] = "ftp.proverbs.ekomplete.com"; 
        $ftp_config['username'] = "jay@proverbs.ekomplete.com";
        $ftp_config['password'] = "dtMo;rB@VITU";
        $ftp_config['debug']    = TRUE;

        $CI->ftp->connect($ftp_config);


        // $remote_file = '/home/proverbs/public_html/'.$filename;
        $remote_file = '/public_html/images/modules/shoppingcart/products/'.$filename;


        $path_parts  = pathinfo($_FILES["image2"]["name"]);
        $extension   = $path_parts['extension'];

        $product_filename = $path_parts['filename'];


        $remote_thumbs_file = '/public_html/images/modules/shoppingcart/products/thumbs/'.$product_filename.'_thumb.'.$extension;
        // echo $remote_file;
        // die;

        $CI->ftp->upload($local_file,$remote_file);
        $CI->ftp->upload($local_file,$remote_thumbs_file);

        // $CI =& get_instance();
        
        $db2 = $CI->load->database('proverbs_solomon', TRUE);
        $db2->where('id', $product_id);
        $db2->update('cart_products', array(
            'image2' => $filename,
        ));

        $db2->where('id', $product_id);
        $db2->update('cart_products', array(
            'image2_thumb' => $product_filename.'_thumb.'.$extension,
        ));

        $CI->ftp->close();       

        return true;
            
    }
    
    return false;
}

function handle_product_image2_eview_upload($product_id,$image)
{
   
    if ($image != "") 
    {
        
        $filename    = $image;
        $CI =& get_instance();
        $CI->load->library('ftp');
        
        $local_file = EVIEW_FOLDER.$filename;

        $ftp_config['hostname'] = "skyway.redplanethost.com"; 
        $ftp_config['hostname'] = "ftp.proverbs.ekomplete.com"; 
        $ftp_config['username'] = "jay@proverbs.ekomplete.com";
        $ftp_config['password'] = "dtMo;rB@VITU";
        $ftp_config['debug']    = TRUE;

        $CI->ftp->connect($ftp_config);

        $remote_file = '/public_html/images/modules/shoppingcart/products/'.$filename;


        $path_parts  = pathinfo($filename);
        $extension   = $path_parts['extension'];

        $product_filename = $path_parts['filename'];
        
        $remote_thumbs_file = '/public_html/images/modules/shoppingcart/products/thumbs/'.$product_filename.'_thumb.'.$extension;
        // echo $remote_file;
        // die;

        $CI->ftp->upload($local_file,$remote_file);
        $CI->ftp->upload($local_file,$remote_thumbs_file);

        // $CI =& get_instance();
        
        $db2 = $CI->load->database('proverbs_solomon', TRUE);
        $db2->where('id', $product_id);
        $db2->update('cart_products', array(
            'image2' => $filename,
        ));

        $db2->where('id', $product_id);
        $db2->update('cart_products', array(
            'image2_thumb' => $product_filename.'_thumb.'.$extension,
        ));

        $CI->ftp->close();
        return true;
            
    }
    
    return false;
}

function handle_image3_upload($id,$product_id = "")
{
    if (isset($_FILES['image3']['name']) && $_FILES['image3']['name'] != '') {
        $path        = EVIEW_FOLDER;
        // Get the temp file path
        $tmpFilePath = $_FILES['image3']['tmp_name'];

        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Getting file extension
            $path_parts  = pathinfo($_FILES["image3"]["name"]);
            $extension   = $path_parts['extension'];

            $product_filename = $path_parts['filename'];

            $allowed_extensions = array('jpg','jpeg','png');

            if(!in_array($extension, $allowed_extensions)) {
                set_alert('warning','Image extension not allowed.');
                return false;
            }

            // Setup our new file path
            $filename    = $_FILES["image3"]["name"];
            $newFilePath = $path . $filename;
            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }

            // $product_file1 = $newFilePath;

            // $another_path_product3 = '/home/proverbs/public_html/images/modules/shoppingcart/products/'.$filename;

            // $product_thumbfile3 = $another_path_product3;

            // rename($newFilePath, $another_path_product3);
            
            // if(file_exists($product_thumbfile3))
            // {
            //     $another_path3 = '/home/proverbs/public_html/images/modules/shoppingcart/products/thumbs/'.$product_filename.'_thumb.'.$extension;
            //     copy($product_thumbfile3, $another_path3);

            // }

            // Upload the file into the company uploads dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                $CI =& get_instance();
                $CI->db->where('id', $id);
                $CI->db->update('tblinvoiceitems_eview', array(
                    'image3' => $filename
                ));

                // $db2 = $CI->load->database('proverbs_solomon', TRUE);
                // $db2->where('id', $product_id);
                // $db2->update('cart_products', array(
                //     'image3' => $filename,
                // ));

                // $db2->where('id', $product_id);
                // $db2->update('cart_products', array(
                //     'image3_thumb' => $product_filename.'_thumb.'.$extension,
                // ));

                return true;
            }
        }
    }
    
    return false;
}


function handle_product_image3_upload($product_id = "")
{
    if (isset($_FILES['image3']['name']) && $_FILES['image3']['name'] != '') {
        
        $filename    = $_FILES["image3"]["name"];
        $CI =& get_instance();
        $CI->load->library('ftp');

        $local_file = EVIEW_FOLDER.$filename;
        // $local_file = site_url('uploads/eview').'/'.$filename;
      

        $ftp_config['hostname'] = "skyway.redplanethost.com"; 
        $ftp_config['hostname'] = "ftp.proverbs.ekomplete.com"; 
        $ftp_config['username'] = "jay@proverbs.ekomplete.com";
        $ftp_config['password'] = "dtMo;rB@VITU";
        $ftp_config['debug']    = TRUE;

        $CI->ftp->connect($ftp_config);


        // $remote_file = '/home/proverbs/public_html/'.$filename;
        $remote_file = '/public_html/images/modules/shoppingcart/products/'.$filename;


        $path_parts  = pathinfo($_FILES["image3"]["name"]);
        $extension   = $path_parts['extension'];

        $product_filename = $path_parts['filename'];


        $remote_thumbs_file = '/public_html/images/modules/shoppingcart/products/thumbs/'.$product_filename.'_thumb.'.$extension;
        // echo $remote_file;
        // die;

        $CI->ftp->upload($local_file,$remote_file);
        $CI->ftp->upload($local_file,$remote_thumbs_file);

        // $CI =& get_instance();
        
        $db2 = $CI->load->database('proverbs_solomon', TRUE);
        $db2->where('id', $product_id);
        $db2->update('cart_products', array(
            'image3' => $filename,
        ));

        $db2->where('id', $product_id);
        $db2->update('cart_products', array(
            'image3_thumb' => $product_filename.'_thumb.'.$extension,
        ));

        $CI->ftp->close();       

        return true;
            
    }
    
    return false;
}

function handle_product_image3_eview_upload($product_id,$image)
{
   
    if ($image != "") 
    {
        
        $filename    = $image;
        $CI =& get_instance();
        $CI->load->library('ftp');
        
        $local_file = EVIEW_FOLDER.$filename;

        $ftp_config['hostname'] = "skyway.redplanethost.com"; 
        $ftp_config['hostname'] = "ftp.proverbs.ekomplete.com"; 
        $ftp_config['username'] = "jay@proverbs.ekomplete.com";
        $ftp_config['password'] = "dtMo;rB@VITU";
        $ftp_config['debug']    = TRUE;

        $CI->ftp->connect($ftp_config);

        $remote_file = '/public_html/images/modules/shoppingcart/products/'.$filename;


        $path_parts  = pathinfo($filename);
        $extension   = $path_parts['extension'];

        $product_filename = $path_parts['filename'];
        
        $remote_thumbs_file = '/public_html/images/modules/shoppingcart/products/thumbs/'.$product_filename.'_thumb.'.$extension;
        // echo $remote_file;
        // die;

        $CI->ftp->upload($local_file,$remote_file);
        $CI->ftp->upload($local_file,$remote_thumbs_file);

        // $CI =& get_instance();
        
        $db2 = $CI->load->database('proverbs_solomon', TRUE);
        $db2->where('id', $product_id);
        $db2->update('cart_products', array(
            'image3' => $filename,
        ));

        $db2->where('id', $product_id);
        $db2->update('cart_products', array(
            'image3_thumb' => $product_filename.'_thumb.'.$extension,
        ));

        $CI->ftp->close();
        return true;
            
    }
    
    return false;
}

function handle_image4_upload($id,$product_id = "")
{
    if (isset($_FILES['image4']['name']) && $_FILES['image4']['name'] != '') {
        $path        = EVIEW_FOLDER;
        // Get the temp file path
        $tmpFilePath = $_FILES['image4']['tmp_name'];

        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Getting file extension
            $path_parts  = pathinfo($_FILES["image4"]["name"]);
            $extension   = $path_parts['extension'];

            $product_filename = $path_parts['filename'];

            $allowed_extensions = array('jpg','jpeg','png');

            if(!in_array($extension, $allowed_extensions)) {
                set_alert('warning','Image extension not allowed.');
                return false;
            }

            // Setup our new file path
            $filename    = $_FILES["image4"]["name"];
            $newFilePath = $path . $filename;
            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }

            // $product_file = $newFilePath;

            // $another_path_product4 = '/home/proverbs/public_html/images/modules/shoppingcart/products/'.$filename;

            // $product_thumbfile4 = $another_path_product4;

            // rename($newFilePath, $another_path_product4);
            
            // if(file_exists($product_thumbfile4))
            // {
            //     $another_path4 = '/home/proverbs/public_html/images/modules/shoppingcart/products/thumbs/'.$product_filename.'_thumb.'.$extension;
            //     copy($product_thumbfile4, $another_path4);

            // }


            // Upload the file into the company uploads dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                $CI =& get_instance();
                $CI->db->where('id', $id);
                $CI->db->update('tblinvoiceitems_eview', array(
                    'image4' => $filename
                ));

                // $db2 = $CI->load->database('proverbs_solomon', TRUE);
                // $db2->where('id', $product_id);
                // $db2->update('cart_products', array(
                //     'image4' => $filename,
                // ));

                // $db2->where('id', $product_id);
                // $db2->update('cart_products', array(
                //     'image4_thumb' => $product_filename.'_thumb.'.$extension,
                // ));

                return true;
            }
        }
    }
    
    return false;
}

function handle_product_image4_upload($product_id = "")
{
    if (isset($_FILES['image4']['name']) && $_FILES['image4']['name'] != '') {
        
        $filename    = $_FILES["image4"]["name"];
        $CI =& get_instance();
        $CI->load->library('ftp');

        $local_file = EVIEW_FOLDER.$filename;
        // $local_file = site_url('uploads/eview').'/'.$filename;
      

        $ftp_config['hostname'] = "skyway.redplanethost.com"; 
        $ftp_config['hostname'] = "ftp.proverbs.ekomplete.com"; 
        $ftp_config['username'] = "jay@proverbs.ekomplete.com";
        $ftp_config['password'] = "dtMo;rB@VITU";
        $ftp_config['debug']    = TRUE;

        $CI->ftp->connect($ftp_config);


        // $remote_file = '/home/proverbs/public_html/'.$filename;
        $remote_file = '/public_html/images/modules/shoppingcart/products/'.$filename;


        $path_parts  = pathinfo($_FILES["image4"]["name"]);
        $extension   = $path_parts['extension'];

        $product_filename = $path_parts['filename'];


        $remote_thumbs_file = '/public_html/images/modules/shoppingcart/products/thumbs/'.$product_filename.'_thumb.'.$extension;
        // echo $remote_file;
        // die;

        $CI->ftp->upload($local_file,$remote_file);
        $CI->ftp->upload($local_file,$remote_thumbs_file);

        // $CI =& get_instance();
        
        $db2 = $CI->load->database('proverbs_solomon', TRUE);
        $db2->where('id', $product_id);
        $db2->update('cart_products', array(
            'image4' => $filename,
        ));

        $db2->where('id', $product_id);
        $db2->update('cart_products', array(
            'image4_thumb' => $product_filename.'_thumb.'.$extension,
        ));

        $CI->ftp->close();       

        return true;
            
    }
    
    return false;
}

function handle_product_image4_eview_upload($product_id,$image)
{
   
    if ($image != "") 
    {
        
        $filename    = $image;
        $CI =& get_instance();
        $CI->load->library('ftp');
        
        $local_file = EVIEW_FOLDER.$filename;

        $ftp_config['hostname'] = "skyway.redplanethost.com"; 
        $ftp_config['hostname'] = "ftp.proverbs.ekomplete.com"; 
        $ftp_config['username'] = "jay@proverbs.ekomplete.com";
        $ftp_config['password'] = "dtMo;rB@VITU";
        $ftp_config['debug']    = TRUE;

        $CI->ftp->connect($ftp_config);

        $remote_file = '/public_html/images/modules/shoppingcart/products/'.$filename;


        $path_parts  = pathinfo($filename);
        $extension   = $path_parts['extension'];

        $product_filename = $path_parts['filename'];
        
        $remote_thumbs_file = '/public_html/images/modules/shoppingcart/products/thumbs/'.$product_filename.'_thumb.'.$extension;
        // echo $remote_file;
        // die;

        $CI->ftp->upload($local_file,$remote_file);
        $CI->ftp->upload($local_file,$remote_thumbs_file);

        // $CI =& get_instance();
        
        $db2 = $CI->load->database('proverbs_solomon', TRUE);
        $db2->where('id', $product_id);
        $db2->update('cart_products', array(
            'image4' => $filename,
        ));

        $db2->where('id', $product_id);
        $db2->update('cart_products', array(
            'image4_thumb' => $product_filename.'_thumb.'.$extension,
        ));

        $CI->ftp->close();
        return true;
            
    }
    
    return false;
}

function handle_image5_upload($id,$product_id = "")
{
    if (isset($_FILES['image5']['name']) && $_FILES['image5']['name'] != '') {
        $path        = EVIEW_FOLDER;
        // Get the temp file path
        $tmpFilePath = $_FILES['image5']['tmp_name'];

        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Getting file extension
            $path_parts  = pathinfo($_FILES["image5"]["name"]);
            $extension   = $path_parts['extension'];

            $product_filename = $path_parts['filename'];

            $allowed_extensions = array('jpg','jpeg','png');

            if(!in_array($extension, $allowed_extensions)) {
                set_alert('warning','Image extension not allowed.');
                return false;
            }

            // Setup our new file path
            $filename    = $_FILES["image5"]["name"];
            $newFilePath = $path . $filename;
            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }

            // $product_file = $newFilePath;

            // $another_path_product5 = '/home/proverbs/public_html/images/modules/shoppingcart/products/'.$filename;

            // $product_thumbfile5 = $another_path_product5;

            // rename($newFilePath, $another_path_product5);
            
            // if(file_exists($product_thumbfile5))
            // {
            //     $another_path5 = '/home/proverbs/public_html/images/modules/shoppingcart/products/thumbs/'.$product_filename.'_thumb.'.$extension;
            //     copy($product_thumbfile5, $another_path5);

            // }

            // Upload the file into the company uploads dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                $CI =& get_instance();
                $CI->db->where('id', $id);
                $CI->db->update('tblinvoiceitems_eview', array(
                    'image5' => $filename
                ));

                // $db2 = $CI->load->database('proverbs_solomon', TRUE);
                // $db2->where('id', $product_id);
                // $db2->update('cart_products', array(
                //     'image5' => $filename,
                // ));

                // $db2->where('id', $product_id);
                // $db2->update('cart_products', array(
                //     'image5_thumb' => $product_filename.'_thumb.'.$extension,
                // ));

                return true;
            }
        }
    }
    
    return false;
}

function handle_product_image5_upload($product_id = "")
{
    if (isset($_FILES['image5']['name']) && $_FILES['image5']['name'] != '') {
        
        $filename    = $_FILES["image5"]["name"];
        $CI =& get_instance();
        $CI->load->library('ftp');

        $local_file = EVIEW_FOLDER.$filename;
        // $local_file = site_url('uploads/eview').'/'.$filename;
      

        $ftp_config['hostname'] = "skyway.redplanethost.com"; 
        $ftp_config['hostname'] = "ftp.proverbs.ekomplete.com"; 
        $ftp_config['username'] = "jay@proverbs.ekomplete.com";
        $ftp_config['password'] = "dtMo;rB@VITU";
        $ftp_config['debug']    = TRUE;

        $CI->ftp->connect($ftp_config);


        // $remote_file = '/home/proverbs/public_html/'.$filename;
        $remote_file = '/public_html/images/modules/shoppingcart/products/'.$filename;


        $path_parts  = pathinfo($_FILES["image5"]["name"]);
        $extension   = $path_parts['extension'];

        $product_filename = $path_parts['filename'];


        $remote_thumbs_file = '/public_html/images/modules/shoppingcart/products/thumbs/'.$product_filename.'_thumb.'.$extension;
        // echo $remote_file;
        // die;

        $CI->ftp->upload($local_file,$remote_file);
        $CI->ftp->upload($local_file,$remote_thumbs_file);

        // $CI =& get_instance();
        
        $db2 = $CI->load->database('proverbs_solomon', TRUE);
        $db2->where('id', $product_id);
        $db2->update('cart_products', array(
            'image5' => $filename,
        ));

        $db2->where('id', $product_id);
        $db2->update('cart_products', array(
            'image5_thumb' => $product_filename.'_thumb.'.$extension,
        ));

        $CI->ftp->close();       

        return true;
            
    }
    
    return false;
}

function handle_product_image5_eview_upload($product_id,$image)
{
   
    if ($image != "") 
    {
        
        $filename    = $image;
        $CI =& get_instance();
        $CI->load->library('ftp');
        
        $local_file = EVIEW_FOLDER.$filename;

        $ftp_config['hostname'] = "skyway.redplanethost.com"; 
        $ftp_config['hostname'] = "ftp.proverbs.ekomplete.com"; 
        $ftp_config['username'] = "jay@proverbs.ekomplete.com";
        $ftp_config['password'] = "dtMo;rB@VITU";
        $ftp_config['debug']    = TRUE;

        $CI->ftp->connect($ftp_config);

        $remote_file = '/public_html/images/modules/shoppingcart/products/'.$filename;


        $path_parts  = pathinfo($filename);
        $extension   = $path_parts['extension'];

        $product_filename = $path_parts['filename'];
        
        $remote_thumbs_file = '/public_html/images/modules/shoppingcart/products/thumbs/'.$product_filename.'_thumb.'.$extension;
        // echo $remote_file;
        // die;

        $CI->ftp->upload($local_file,$remote_file);
        $CI->ftp->upload($local_file,$remote_thumbs_file);

        // $CI =& get_instance();
        
        $db2 = $CI->load->database('proverbs_solomon', TRUE);
        $db2->where('id', $product_id);
        $db2->update('cart_products', array(
            'image5' => $filename,
        ));

        $db2->where('id', $product_id);
        $db2->update('cart_products', array(
            'image5_thumb' => $product_filename.'_thumb.'.$extension,
        ));

        $CI->ftp->close();
        return true;
            
    }
    
    return false;
}




function handle_company_logo_upload()
{
    if (isset($_FILES['company_logo']['name']) && $_FILES['company_logo']['name'] != '') {
        $path        = COMPANY_FILES_FOLDER . '/';
        // Get the temp file path
        $tmpFilePath = $_FILES['company_logo']['tmp_name'];

        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Getting file extension
            $path_parts = pathinfo($_FILES["company_logo"]["name"]);
            $extension  = $path_parts['extension'];

            $allowed_extensions = array(
                'jpg',
                'jpeg',
                'png'
            );

            if (!in_array($extension, $allowed_extensions)) {
                set_alert('warning', 'Image extension not allowed.');
                return false;
            }

            // Setup our new file path
            $filename    = 'logo' . '.' . $extension;
            $newFilePath = $path . $filename;
            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }

            // Upload the file into the company uploads dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                update_option('company_logo', $filename);
                return true;
            }
        }
    }
    return false;
}

function handle_favicon_upload()
{
    if (isset($_FILES['favicon']['name']) && $_FILES['favicon']['name'] != '') {
        $path        = COMPANY_FILES_FOLDER . '/';
        // Get the temp file path
        $tmpFilePath = $_FILES['favicon']['tmp_name'];

        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {
            // Getting file extension
            $path_parts  = pathinfo($_FILES["favicon"]["name"]);
            $extension   = $path_parts['extension'];
            // Setup our new file path
            $filename    = 'favicon' . '.' . $extension;
            $newFilePath = $path . $filename;
            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . 'index.html', 'w');
            }
            // Upload the file into the company uploads dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                update_option('favicon', $filename);
                return true;
            }
        }
    }
    return false;
}
/**
 * Check for staff profile image
 * @param  mixed $ticketid
 * @return boolean
 */
function handle_staff_profile_image_upload()
{
    if (isset($_FILES['profile_image']['name']) && $_FILES['profile_image']['name'] != '') {
        $path = STAFF_PROFILE_IMAGES_FOLDER . get_staff_user_id() . '/';

        // Get the temp file path
        $tmpFilePath = $_FILES['profile_image']['tmp_name'];

        // Make sure we have a filepath
        if (!empty($tmpFilePath) && $tmpFilePath != '') {

            // Getting file extension
            $path_parts         = pathinfo($_FILES["profile_image"]["name"]);
            $extension          = $path_parts['extension'];
            $allowed_extensions = array(
                'jpg',
                'jpeg',
                'png'
            );

            if (!in_array($extension, $allowed_extensions)) {
                set_alert('warning', 'Image extension not allowed.');
                return false;
            }
            // Setup our new file path
            $filename    = unique_filename($path, $_FILES["profile_image"]["name"]);
            $newFilePath = $path . '/' . $filename;
            if (!file_exists($path)) {
                mkdir($path);
                fopen($path . '/index.html', 'w');
            }

            // Upload the file into the company uploads dir
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                $CI =& get_instance();

                $config                   = array();
                $config['image_library']  = 'gd2';
                $config['source_image']   = $newFilePath;
                $config['new_image']      = 'thumb_' . $filename;
                $config['maintain_ratio'] = TRUE;
                $config['width']          = 160;
                $config['height']         = 160;

                $CI->load->library('image_lib', $config);
                $CI->image_lib->resize();
                $CI->image_lib->clear();

                $config['image_library']  = 'gd2';
                $config['source_image']   = $newFilePath;
                $config['new_image']      = 'small_' . $filename;
                $config['maintain_ratio'] = TRUE;
                $config['width']          = 32;
                $config['height']         = 32;

                $CI->image_lib->initialize($config);
                $CI->image_lib->resize();
                $CI->db->where('staffid', get_staff_user_id());
                $CI->db->update('tblstaff', array(
                    'profile_image' => $filename
                ));

                // Remove original image
                unlink($newFilePath);
                return true;
            }
        }
    }
    return false;
}
