<?php
// Since Version 1.0.1
/**
 * Check if company using invoice with different currencies
 * @return boolean
 */
function is_using_multiple_currencies($table = 'tblinvoices')
{
    $CI =& get_instance();

    $CI->load->model('currencies_model');
    $currencies = $CI->currencies_model->get();

    $total_currencies_used = 0;

    foreach ($currencies as $currency) {
        $CI->db->where('currency', $currency['id']);
        $total = $CI->db->count_all_results($table);
        if ($total > 0) {
            $total_currencies_used++;
        }
    }

    if ($total_currencies_used > 1) {
        return true;
    } else if ($total_currencies_used == 0) {
        return false;
    }

    return false;
}
/**
 * Check if client have invoices with multiple currencies
 * @return booelan
 */
function is_client_using_multiple_currencies($clientid = '',$table = 'tblinvoices')
{
    if ($clientid == '') {
        $clientid = get_client_user_id();
    }

    $CI =& get_instance();

    $CI->load->model('currencies_model');
    $currencies = $CI->currencies_model->get();

    $total_currencies_used = 0;
    foreach ($currencies as $currency) {
        $CI->db->where('currency', $currency['id']);
        $CI->db->where('clientid', $clientid);
        $total = $CI->db->count_all_results($table);
        if ($total > 0) {
            $total_currencies_used++;
        }
    }

    if ($total_currencies_used > 1) {
        return true;
    } else if ($total_currencies_used == 0) {
        return false;
    }
    return false;
}
/**
 * Get invoice total left for paying if not payments found the original total from the invoice will be returned
 * @since  Version 1.0.1
 * @param  mixed $id     invoice id
 * @param  mixed $invoice_total
 * @return mixed  total left
 */
function get_invoice_total_left_to_pay($id,$invoice_total){
    $CI = &get_instance();
    $CI->load->model('payments_model');
    $payments = $CI->payments_model->get_invoice_payments($id);

    foreach($payments as $payment){
        $invoice_total -= $payment['amount'];
    }

    return $invoice_total;
}
/**
 * Check invoice restrictions - hash, clientid
 * @since  Version 1.0.1
 * @param  mixed $id   invoice id
 * @param  string $hash invoice hash
 */
function check_invoice_restrictions($id, $hash)
{
    $CI =& get_instance();
    $CI->load->model('invoices_model');
    if (!$hash || !$id) {
        die('No invoice specified');
    }

    if (!is_client_logged_in()) {
        if (get_option('view_invoice_only_logged_in') == 1) {
            redirect(site_url('clients/login'));
        }
    }

    $invoice = $CI->invoices_model->get($id);
    if (!$invoice) {
        die('Invoice not found');
    }

    if ($invoice->hash != $hash) {
        die;
    }

    // Do one more check
    if (!is_staff_logged_in()) {
      if (get_option('view_invoice_only_logged_in') == 1) {
        if ($invoice->clientid != get_client_user_id()) {
            die;
        }
      }
    }

}
/**
 * Forat number with 2 decimals
 * @param  mixed $total
 * @return string
 */
function _format_number($total)
{

    if (!is_numeric($total)) {
        return false;
    }
    $decimal_separator  = get_option('decimal_separator');
    $thousand_separator = get_option('thousand_separator');
    return number_format($total, 2, $decimal_separator, $thousand_separator);
}

/**
 * Format money with 2 decimal based on symbol
 * @param  mixed $total
 * @param  string $symbol Money symbol
 * @return string
 */
function format_money($total, $symbol = '')
{
	if($total=='')
		$total=0;
	if (!is_numeric($total) && $total != 0) {
		
        return false;
     
    }

    $decimal_separator  = get_option('decimal_separator');
    $thousand_separator = get_option('thousand_separator');
    $currency_placement = get_option('currency_placement');

    if ($currency_placement === 'after') {
        $_formated = number_format($total, 2, $decimal_separator, $thousand_separator) . ' ' . $symbol;
    } else {
        if($total==''){
            $_formated = $symbol . '' . number_format(0, 2, $decimal_separator, $thousand_separator);
        }else{
            $pos = strpos($total, '-');
            if($pos === false){
              $_formated = $symbol . '' . number_format($total, 2, $decimal_separator, $thousand_separator);
            }else{
                $total = str_replace('-', '', $total);
               $_formated = '-'.$symbol . '' . number_format($total, 2, $decimal_separator, $thousand_separator);   
            }
        }
    }

    return $_formated;
}
/**
 * Format invoice status
 * @param  integer  $status
 * @param  string  $classes additional classes
 * @param  boolean $label   To include in html label or not
 * @return mixed
 */
function format_invoice_status($status, $classes = '', $label = true)
{
    if ($status == 1) {
        $status      = _l('invoice_status_unpaid');
        $label_class = 'danger';
    } else if ($status == 2) {
        $status      = _l('invoice_status_paid');
        $label_class = 'success';
    } else if ($status == 3) {
        $status      = _l('invoice_status_not_paid_completely');
        $label_class = 'warning';
    } else {
        // status 4
        $status      = _l('invoice_status_overdue');
        $label_class = 'warning';
    }

    if ($label == true) {
        return '<span class="label label-' . $label_class . ' ' . $classes . ' inline-block">' . $status . '</span>';
    } else {
        return $status;
    }
}
function format_bills_status($status, $classes = '', $label = true)
{
    if ($status == 1) {
        $status      = 'Current';
        $label_class = 'success';
    } else if ($status == 2) {
        $status      = 'Late';
        $label_class = 'warning';
    } else {
        // status 4
        $status      ='Overdue';
        $label_class = 'danger';
    }

    if ($label == true) {
        return '<span class="label label-' . $label_class . ' ' . $classes . ' inline-block">' . $status . '</span>';
    } else {
        return $status;
    }
}

/**
 * Format estimate status
 * @param  integer  $status
 * @param  string  $classes additional classes
 * @param  boolean $label   To include in html label or not
 * @return mixed
 */
function format_estimate_status($status, $classes = '', $label = true)
{
    if ($status == 1) {
        $status      = _l('estimate_status_draft');
        $label_class = 'default';
    } else if ($status == 2) {
        $status      = _l('estimate_status_sent');
        $label_class = 'info';
    } else if ($status == 3) {
        $status      = _l('estimate_status_declined');
        $label_class = 'danger';
    } else if ($status == 4) {
        $status      = _l('estimate_status_accepted');
        $label_class = 'success';
    } else {
        // status 5
        $status      = _l('estimate_status_expired');
        $label_class = 'warning';
    }

    if ($label == true) {
        return '<span class="label label-' . $label_class . ' ' . $classes . ' inline-block">' . $status . '</span>';
    } else {
        return $status;
    }
}


/**
 * Format order status
 * @param  integer  $status
 * @param  string  $classes additional classes
 * @param  boolean $label   To include in html label or not
 * @return mixed
 */
function format_order_status($status, $classes = '', $label = true)
{

    
    if ($status == 1) {
        $status      = _l('order_status_new');
        $label_class = 'default';
    } else if ($status == 2) {
        $status      = _l('order_status_planning');
        $label_class = 'info';
    } else if ($status == 3) {
        $status      = _l('order_status_inprocess');
        $label_class = 'info';
    } else if ($status == 4) {
        $status      = _l('order_status_completed');
        $label_class = 'info';
    }
     else if ($status == 5) {
        $status      = _l('order_status_fulfilled');
        $label_class = 'success';
    } else {
        // status 5
        $status      = _l('order_status_expired');
        $label_class = 'danger';
    }

    if ($label == true) {
        return '<span class="label label-' . $label_class . ' ' . $classes . ' inline-block">' . $status . '</span>';
    } else {
        return $status;
    }
}
function format_orderfulfillment_status($status, $classes = '', $label = true)
{

    
    if ($status == 1) {
        $status      = _l('orderfulfillment_status_pick');
        $label_class = 'default';
    } else if ($status == 2) {
        $status      = _l('orderfulfillment_status_picked');
        $label_class = 'info';
    } else if ($status == 3) {
        $status      = _l('orderfulfillment_status_ready');
        $label_class = 'info';
    } else if ($status == 4) {
        $status      = _l('orderfulfillment_status_released');
        $label_class = 'info';
    }
     

    if ($label == true) {
        return '<span class="label label-' . $label_class . ' ' . $classes . ' inline-block">' . $status . '</span>';
    } else {
        return $status;
    }
}

function format_purchaseorder_status($status, $classes = '', $label = true)
{

    
    if ($status == 1) {
        $status      = _l('purchase_status_new');
        $label_class = 'default';
    } else if ($status == 2) {
        $status      = _l('purchase_status_planning');
        $label_class = 'info';
    } else if ($status == 3) {
        $status      = _l('purchase_status_inprocess');
        $label_class = 'info';
    } else if ($status == 4) {
        $status      = _l('purchase_status_transit');
        $label_class = 'info';
    }
     else if ($status == 5) {
        $status      = _l('purchase_status_receiving');
        $label_class = 'success';
    }

    if ($label == true) {
        return '<span class="label label-' . $label_class . ' ' . $classes . ' inline-block">' . $status . '</span>';
    } else {
        return $status;
    }
}
function format_rfq_status($status, $classes = '', $label = true)
{											
    
    if ($status == 1) {
        $status      = 'New';
        $label_class = 'default';
    } else if ($status == 2) {
        $status      = 'Under Review';
        $label_class = 'info';
    } else if ($status == 3) {
        $status      = 'Approved';
        $label_class = 'info';
    } else if ($status == 4) {
        $status      = 'Processed';
        $label_class = 'success';
    }
     

    if ($label == true) {
        return '<span class="label label-' . $label_class . ' ' . $classes . ' inline-block">' . $status . '</span>';
    } else {
        return $status;
    }
}

/**
 * Update invoice status
 * @param  mixed $id invoice id
 * @return mixed invoice updates status / if no update return false
 */
function update_invoice_status($id, $cron = false)
{
    $CI =& get_instance();

    $CI->load->model('payments_model');
    $CI->load->model('invoices_model');
    $payments = $CI->payments_model->get_invoice_payments($id);

    $invoice         = $CI->invoices_model->get($id);
    $original_status = $invoice->status;
    $total_payments  = array();

    $status = 1;
    // Check if the first payments is equal to invoice total
    if (isset($payments[0])) {
        if ($payments[0]['amount'] == $invoice->total) {
            // Paid status
            $status = 2;
        } else {
            foreach ($payments as $payment) {
                array_push($total_payments, $payment['amount']);
            }

            $total = array_sum($total_payments);
            if ($total == $invoice->total) {
                // Paid status
                $status = 2;
            } else if ($total == 0) {
                // Unpaid status
                $status = 1;
            } else {
                if ($invoice->duedate != null) {
                    if (date('Y-m-d', strtotime($invoice->duedate)) < date('Y-m-d')) {
                        // Overdue status
                        $status = 4;

                    } else {
                        // Not paid completely status
                        $status = 3;
                    }
                } else {
                    // Not paid completely status
                    $status = 3;
                }
            }
        }
    } else {
        if ($invoice->duedate != null) {
            if (date('Y-m-d', strtotime($invoice->duedate)) < date('Y-m-d')) {
                // Overdue status
                $status = 4;
            }
        }
    }
    $CI->db->where('id', $id);
    $CI->db->update('tblinvoices', array(
        'status' => $status
    ));

    if ($CI->db->affected_rows() > 0) {

        $_from_cron = '';
        if ($cron == true) {
            $_from_cron = '[CRON]';
        }
        logActivity('Invoice Status Updated ' . $_from_cron . ' [Invoice Number: ' . format_invoice_number($invoice->number) . ', From: ' . format_invoice_status($original_status, '', false) . ' To: ' . format_invoice_status($status, '', false) . ']', NULL, $cron);
        $CI->invoices_model->log_invoice_activity($invoice->id, '' . $_from_cron . ' Invoice Status Updated: From: ' . format_invoice_status($original_status, '') . ' To: ' . format_invoice_status($status, '') . '', $cron);
        return $status;
    }

    return false;
}
function update_paybill_status($id, $cron = false)
{
    $CI =& get_instance();


    $CI->load->model('bills_model');
    $payments = $CI->bills_model->get_bill_payments($id);


    $bill         = $CI->bills_model->get($id);
    $original_status = $invoice->status;
    $total_payments  = array();

    $status = 1;
    // Check if the first payments is equal to invoice total
    if (isset($payments[0])) {
        if ($payments[0]['amount'] == $bill->total) {
            // Paid status
            $status = 4;
        } else {
            foreach ($payments as $payment) {
                array_push($total_payments, $payment['amount']);
            }

            $total = array_sum($total_payments);
            if ($total == $bill->total) {
                // Paid status
                $status = 4;
            } else if ($total == 0) {
                // Unpaid status
                $status = 1;
            } else {
                if ($bill->due_date != null) {
                    if (date('Y-m-d', strtotime($bill->due_date)) < date('Y-m-d')) {
                        // Overdue status
                        $status = 3;

                    }
                } else {
                    $status = 2;
                }
            }
        }
    } else {
        if ($bill->due_date  != null) {
            if (date('Y-m-d', strtotime($bill->due_date )) < date('Y-m-d')) {
                // Overdue status
                $status = 3;
            }
        }
    }
    $CI->db->where('billid', $id);
    $CI->db->update('tblbills', array(
        'status' => $status
    ));

//    if ($CI->db->affected_rows() > 0) {
//
//        $_from_cron = '';
//        if ($cron == true) {
//            $_from_cron = '[CRON]';
//        }
//        logActivity('Invoice Status Updated ' . $_from_cron . ' [Invoice Number: ' . format_invoice_number($invoice->number) . ', From: ' . format_invoice_status($original_status, '', false) . ' To: ' . format_invoice_status($status, '', false) . ']', NULL, $cron);
//        $CI->invoices_model->log_invoice_activity($invoice->id, '' . $_from_cron . ' Invoice Status Updated: From: ' . format_invoice_status($original_status, '') . ' To: ' . format_invoice_status($status, '') . '', $cron);
//        return $status;
//    }

    return false;
}

/**
 * Check if the give invoice id is last invoice
 * @param  mixed  $id invoice id
 * @return boolean
 */
function is_last_invoice($id)
{
    $year = get_option('invoice_year');
    $CI =& get_instance();
    $CI->db->select('id')->from('tblinvoices')->where('year', $year)->order_by('id', 'desc')->limit(1);
    $query = $CI->db->get();

    $last_invoice_id = $query->row()->id;
    if ($last_invoice_id == $id) {
        return true;
    }

    return false;
}
/**
 * Check if the give estimate id is last invoice
 * @since Version 1.0.2
 * @param  mixed  $id estimateid
 * @return boolean
 */
function is_last_estimate($id)
{

    $year = get_option('estimate_year');
    $CI =& get_instance();
    $CI->db->select('id')->from('tblestimates')->where('year', $year)->order_by('id', 'desc')->limit(1);
    $query = $CI->db->get();

    $last_estimate_id = $query->row()->id;
    if ($last_estimate_id == $id) {
        return true;
    }

    return false;
}
/**
 * Format invoice number based on description
 * @param  mixed $number
 * @return string
 */
function format_invoice_number($number)
{

    $format = get_option('invoice_number_format');
 
    if ($format == 1) {
        // Number based

        return get_option('invoice_prefix') .get_option('invoice_separator').$number;
    } else if ($format == 2) {
        return get_option('invoice_prefix') . get_option('invoice_year') . '/'.$number;
    }
    return $number;
}

function get_paidinvoice($id,$from_date,$to_date)
{
    // echo $id;
    // die;
    $CI =& get_instance();
    $CI->load->model('reports_model');
    $paidinvoice = $CI->reports_model->get_paidinvoice_print($id,$from_date,$to_date);
    // print_r($paidinvoice);
    // die;
    return $paidinvoice;
}

function format_payment_number($number)
{
     return get_option('payment_prefix') .get_option('invoice_separator'). str_pad($number, get_option('number_padding_invoice_and_estimate'), '0', STR_PAD_LEFT);
   
}
function format_paybill_number($number){
     return get_option('billpayment_prefix') . str_pad($number, get_option('number_padding_invoice_and_estimate'), '0', STR_PAD_LEFT);
}
function format_grn_number($number){
     return get_option('goodsreceived_prefix').get_option('goodsreceived_separator') . $number;
}
/**
 * Format estimate number based on description
 * @since  Version 1.0.2
 * @param  mixed $number
 * @return string
 */
function format_estimate_number($number)
{
   $format = get_option('estimate_number_format');
    if ($format == 1) {
        // Number based
        return get_option('estimate_prefix') .get_option('estimate_separator'). $number;
    } else if ($format == 2) {
        return get_option('estimate_prefix') . get_option('estimate_year') . '/' .$number;
    }
    return $number;
}

/**
 * Format estimate number based on description
 * @since  Version 1.0.2
 * @param  mixed $number
 * @return string
 */
function format_purchaseorder_number($number)
{
   $format = get_option('purchaseorder_number_format');
    if ($format == 1) {
        // Number based
        return get_option('purchaseorder_prefix') .get_option('purchaseorder_separator'). $number;
    } else if ($format == 2) {
        return get_option('purchaseorder_prefix') . get_option('purchaseorder_year') . '/' . $number;
    }
    return $number;
}
function format_rfqsquote_number($number)
{
   $format = get_option('purchaserequest_number_format');
    if ($format == 1) {
        // Number based
        return get_option('purchaserequest_prefix') .get_option('purchaserequest_separator'). $number;
    } else if ($format == 2) {
        return get_option('purchaserequest_prefix') .get_option('purchaserequest_separator'). get_option('rfqsqoute_year') . '/' . $number;
    }
    return $number;
}

/**
 * Format estimate number based on description
 * @since  Version 1.0.2
 * @param  mixed $number
 * @return string
 */
function format_order_number($number)
{
   $format = get_option('order_number_format');
    if ($format == 1) {
        // Number based
        return get_option('order_prefix') .get_option('order_separator') .  $number;
    } else if ($format == 2) {
        return get_option('order_prefix') . get_option('order_year') . '/' .$number;
    }
    return $number;
}
function format_orderfullfillment_number($number)
{
   $format = get_option('pickticket_number_format');
    if ($format == 1) {
        // Number based
        return get_option('pickticket_prefix') .get_option('pickticket_separator') .  $number;
    } else if ($format == 2) {
        return get_option('pickticket_prefix') . get_option('order_year') . '/' .$number;
    }
    return $number;
}

/**
 * Check if payment mode is allowed for specific invoice
 * @param  mixed  $id payment mode id
 * @param  mixed  $invoiceid invoice id
 * @return boolean
 */
function is_payment_mode_allowed_for_invoice($id, $invoiceid)
{
    $CI =& get_instance();

    $CI->db->where('id', $invoiceid);
    $allowed_modes = $CI->db->get('tblinvoices')->row()->allowed_payment_modes;

    if (!is_null($allowed_modes)) {
        $allowed_modes = unserialize($allowed_modes);
        if (count($allowed_modes) == 0) {
            return false;
        } else {
            foreach ($allowed_modes as $mode) {
                if ($mode == $id) {
                    return true;
                }
            }
        }
    } else {
        return false;
    }

    return false;
}
/**
 * Check if invoice mode exists in invoice
 * @since  Version 1.0.1
 * @param  array  $modes     all invoice modes
 * @param  mixed  $invoiceid invoice id
 * @param  boolean $offline   should check offline or online modes
 * @return boolean
 */
function found_invoice_mode($modes, $invoiceid, $offline = true)
{
    $CI =& get_instance();

    $CI->db->select('tblcurrencies.name as currency_name,allowed_payment_modes')->from('tblinvoices')->join('tblcurrencies', 'tblcurrencies.id = tblinvoices.currency', 'left')->where('tblinvoices.id', $invoiceid);
    $invoice = $CI->db->get()->row();

    if (!is_null($invoice->allowed_payment_modes)) {
        $invoice->allowed_payment_modes = unserialize($invoice->allowed_payment_modes);

        if (count($invoice->allowed_payment_modes) == 0) {
            return false;
        } else {
            foreach ($modes as $mode) {
                if ($offline == true) {
                    if (is_numeric($mode['id'])) {
                        foreach ($invoice->allowed_payment_modes as $allowed_mode) {
                            if ($allowed_mode == $mode['id']) {
                                return true;
                            }
                        }
                    }
                } else {
                    if (!is_numeric($mode['id']) && !empty($mode['id'])) {

                        foreach ($invoice->allowed_payment_modes as $allowed_mode) {
                            if ($allowed_mode == $mode['id']) {
                                // Check for currencies
                                $currencies = explode(',', get_option('paymentmethod_' . $mode['id'] . '_currencies'));
                                foreach ($currencies as $currency) {
                                    $currency = trim($currency);
                                    if (strtoupper($currency) == strtoupper($invoice->currency_name)) {
                                        return true;
                                    }
                                }

                                return false;
                            }
                        }
                    }
                }
            }
        }
    }
    return false;
}
/**
 * Prepare general invoice pdf
 * @param  object $invoice Invoice as object with all necessary fields
 * @return mixed object
 */
function invoice_pdf($invoice)
{
    $CI =& get_instance();
    $CI->load->library('pdf');
    $invoice_number = format_invoice_number($invoice->number);
    $pdf            = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
    $pdf->SetTitle($invoice_number);
    $CI->pdf->SetMargins(PDF_MARGIN_LEFT, 26, PDF_MARGIN_RIGHT);
    $CI->pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $CI->pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    $CI->pdf->SetAutoPageBreak(TRUE, 30);
    $pdf->SetAuthor(get_option('company'));
    $pdf->SetFont('freesans', '', 10);
    $pdf->AddPage();
    $status = $invoice->status;
    include(APPPATH . 'views/themes/' . active_clients_theme() . '/views/invoicepdf.php');
    return $pdf;
}
/**
 * Prepare general ledger pdf
 * @param  object $invoice Invoice as object with all necessary fields
 * @return mixed object
 */
function invoices_report_pdf($invoices,$from_date,$to_date)
{
    $CI =& get_instance();
    $CI->load->library('pdf');
    // $invoice_number = format_invoice_number($invoice->number);
    $pdf            = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
    $pdf->SetTitle('Invoices Report');
    $CI->pdf->SetMargins(PDF_MARGIN_LEFT, 26, PDF_MARGIN_RIGHT);
    $CI->pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $CI->pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    $CI->pdf->SetAutoPageBreak(TRUE, 30);
    $pdf->SetAuthor(get_option('company'));
    $pdf->SetFont('freesans', '', 10);
    $pdf->AddPage();
    // $status = $invoice->status;
    include(APPPATH . 'views/themes/' . active_clients_theme() . '/views/invoicereportpdf.php');
    return $pdf;
}

function balacesheet_pdf($balancesheet,$to)
{
    $CI =& get_instance();
    $CI->load->library('pdf');
    // $invoice_number = format_invoice_number($invoice->number);
    $pdf            = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
    $pdf->SetTitle('Invoices Report');
    $CI->pdf->SetMargins(PDF_MARGIN_LEFT, 26, PDF_MARGIN_RIGHT);
    $CI->pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $CI->pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    $CI->pdf->SetAutoPageBreak(TRUE, 30);
    $pdf->SetAuthor(get_option('company'));
    $pdf->SetFont('freesans', '', 10);
    $pdf->AddPage();
    // $status = $invoice->status;
    include(APPPATH . 'views/themes/' . active_clients_theme() . '/views/balacesheet_pdf.php');
    return $pdf;
}

function sale_items_report_pdf($sale_items,$from_date,$to_date)
{
    $CI =& get_instance();
    $CI->load->library('pdf');
    // $invoice_number = format_invoice_number($invoice->number);
    $pdf            = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
    $pdf->SetTitle('Sales By Item');
    $CI->pdf->SetMargins(PDF_MARGIN_LEFT, 26, PDF_MARGIN_RIGHT);
    $CI->pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $CI->pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    $CI->pdf->SetAutoPageBreak(TRUE, 30);
    $pdf->SetAuthor(get_option('company'));
    $pdf->SetFont('freesans', '', 10);
    $pdf->AddPage();
    // $status = $invoice->status;
    include(APPPATH . 'views/themes/' . active_clients_theme() . '/views/sale_item_reportpdf.php');
    return $pdf;
}




function ledger_pdf($id, $fromdate, $todate)
{
    $CI =& get_instance();
    $CI->load->library('pdf');

    $pdf            = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
    $pdf->SetTitle('Ledger Report');
    $CI->pdf->SetMargins(PDF_MARGIN_LEFT, 26, PDF_MARGIN_RIGHT);
    $CI->pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $CI->pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    $CI->pdf->SetAutoPageBreak(TRUE, 30);
    $pdf->SetAuthor(get_option('company'));
    $pdf->SetFont('freesans', '', 10);
    $pdf->AddPage();
    include(APPPATH . 'views/themes/' . active_clients_theme() . '/views/ledgerpdf.php');
    return $pdf;
}
/**
 * Prepare general statement
 * @param  object $invoice Invoice as object with all necessary fields
 * @return mixed object
 */
function statementdownload($clientid, $fromdate, $todate)
{

    $CI =& get_instance();
    $CI->load->library('pdf');
    
        $CI->load->model('currencies_model');
        $base_currency_symbol = $CI->currencies_model->get_base_currency()->symbol;
    
        //out standing invoice total
        $CI->load->model('reports_model');
         $CI->load->model('clients_model');
        $totaloutstanding = $CI->reports_model->getUnpaidInvoices($clientid,$fromdate);        
        $totaloutstanding = $totaloutstanding->total;
        
        //get all invoice between date
        $invoicesin = $CI->reports_model->betweenDateInvoice_DESC($clientid,$fromdate,$todate);

     
        $CI->load->model('clients_model');

        $clientdetails= $CI->clients_model->get($clientid);
        $fromdate_payment = $fromdate;
        $todate_payment = $todate;
      
        $title = _l('customers_accounts');
            
         $CI->use_navigation  = false;
         

    $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
    
    $pdf->SetTitle('Account Statement');
    $CI->pdf->SetMargins(PDF_MARGIN_LEFT, 26, PDF_MARGIN_RIGHT);
    $CI->pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $CI->pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    $CI->pdf->SetAutoPageBreak(TRUE, 30);
    $pdf->SetAuthor(get_option('company'));
    $pdf->SetFont('freesans', '', 10);
    $pdf->AddPage();
    include(APPPATH . 'views/themes/' . active_clients_theme() . '/views/statementpdf.php');
    return $pdf;
      
}

function transactiondownload($clientid)
{
    $CI =& get_instance();
    $CI->load->library('pdf');
    
        $CI->load->model('currencies_model');
        $base_currency_symbol = $CI->currencies_model->get_base_currency()->symbol;
    
        //out standing invoice total
        $CI->load->model('reports_model');
         $CI->load->model('clients_model');
        
        //get all invoice between date
        $invoicesin = $CI->reports_model->betweenDateInvoiceAll_DESC($clientid);

     
        $CI->load->model('clients_model');

        $clientdetails= $CI->clients_model->get($clientid);

      
        $title = _l('customers_accounts');
            
         $CI->use_navigation  = false;
         

    $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
    
    $pdf->SetTitle('Transaction History');
    $CI->pdf->SetMargins(PDF_MARGIN_LEFT, 26, PDF_MARGIN_RIGHT);
    $CI->pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $CI->pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    $CI->pdf->SetAutoPageBreak(TRUE, 30);
    $pdf->SetAuthor(get_option('company'));
    $pdf->SetFont('freesans', '', 10);
    $pdf->AddPage();
    include(APPPATH . 'views/themes/' . active_clients_theme() . '/views/transactionhistory.php');
    return $pdf;
      
}
/**
 * Generate payment pdf
 * @since  Version 1.0.1
 * @param  object $payment All payment data
 * @return mixed object
 */
function payment_pdf($payment)
{
    $CI =& get_instance();
    $CI->load->library('pdf');
    $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
    $pdf->SetTitle(_l('payment') . '#-' . $payment->id);
    $CI->pdf->SetMargins(PDF_MARGIN_LEFT, 26, PDF_MARGIN_RIGHT);
    $CI->pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $CI->pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    $CI->pdf->SetAutoPageBreak(TRUE, 30);
    $pdf->SetAuthor(get_option('company'));
    $pdf->SetFont('freesans', '', 10);
    $pdf->AddPage();
    include(APPPATH . 'views/themes/' . active_clients_theme() . '/views/paymentpdf.php');
    return $pdf;
}

/**
 * Prepare general estimate pdf
 * @since  Version 1.0.2
 * @param  object $estimate estimate as object with all necessary fields
 * @return mixed object
 */
function estimate_pdf($quote)
{
    
    $CI =& get_instance();
    $CI->load->library('pdf');
    $quote_number = format_estimate_number($quote->number);
    $pdf            = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
    $pdf->SetTitle($quote_number);
    $CI->pdf->SetMargins(PDF_MARGIN_LEFT, 26, PDF_MARGIN_RIGHT);
    $CI->pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $CI->pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    $CI->pdf->SetAutoPageBreak(TRUE, 30);
    $pdf->SetAuthor(get_option('company'));
    $pdf->SetFont('freesans', '', 10);
    $pdf->AddPage();
    $status = $quote->status;
    include(APPPATH . 'views/themes/' . active_clients_theme() . '/views/quotepdf.php');
    return $pdf;
}

function estimate_report_pdf($quotes,$from_date,$to_date)
{
    
    $CI =& get_instance();
    $CI->load->library('pdf');
    // $quote_number = format_estimate_number($quote->number);
    $pdf            = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
    $pdf->SetTitle('Quote Report');
    $CI->pdf->SetMargins(PDF_MARGIN_LEFT, 26, PDF_MARGIN_RIGHT);
    $CI->pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $CI->pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    $CI->pdf->SetAutoPageBreak(TRUE, 30);
    $pdf->SetAuthor(get_option('company'));
    $pdf->SetFont('freesans', '', 10);
    $pdf->AddPage();
    $status = $quote->status;
    include(APPPATH . 'views/themes/' . active_clients_theme() . '/views/quotereportpdf.php');
    return $pdf;
}

/**
 * Prepare general estimate pdf
 * @since  Version 1.0.2
 * @param  object $estimate estimate as object with all necessary fields
 * @return mixed object
 */
function order_pdf($order)
{
    $CI =& get_instance();
    $CI->load->library('pdf');
    $order_number = format_order_number($order->number);
    $pdf            = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
    $pdf->SetTitle($order_number);
    $CI->pdf->SetMargins(PDF_MARGIN_LEFT, 26, PDF_MARGIN_RIGHT);
    $CI->pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $CI->pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    $CI->pdf->SetAutoPageBreak(TRUE, 30);
    $pdf->SetAuthor(get_option('company'));
    $pdf->SetFont('freesans', '', 10);
    $pdf->AddPage();
    $status = $order->status;
    include(APPPATH . 'views/themes/' . active_clients_theme() . '/views/orderpdf.php');
    return $pdf;
}


function orderfullfillment_pdf($order,$original_order_number)
{
    $CI =& get_instance();
    $CI->load->library('pdf');
    $order_number = format_orderfullfillment_number($order->number);
	$orig_order_number = format_order_number($original_order_number);
    $pdf            = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
    $pdf->SetTitle($order_number);
    $CI->pdf->SetMargins(PDF_MARGIN_LEFT, 26, PDF_MARGIN_RIGHT);
    $CI->pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $CI->pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    $CI->pdf->SetAutoPageBreak(TRUE, 30);
    $pdf->SetAuthor(get_option('company'));
    $pdf->SetFont('freesans', '', 10);
    $pdf->AddPage();
    $status = $order->status;
    include(APPPATH . 'views/themes/' . active_clients_theme() . '/views/fullfillmentpdf.php');
    return $pdf;
}


function order_report_pdf($orders,$from_date,$to_date)
{
    $CI =& get_instance();
    $CI->load->library('pdf');
    // $order_number = format_order_number($order->number);
    $pdf            = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
    $pdf->SetTitle('Order Report');
    $CI->pdf->SetMargins(PDF_MARGIN_LEFT, 26, PDF_MARGIN_RIGHT);
    $CI->pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $CI->pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    $CI->pdf->SetAutoPageBreak(TRUE, 30);
    $pdf->SetAuthor(get_option('company'));
    $pdf->SetFont('freesans', '', 10);
    $pdf->AddPage();
    // $status = $order->status;
    include(APPPATH . 'views/themes/' . active_clients_theme() . '/views/order_reportpdf.php');
    return $pdf;
}

function purchaseorder_pdf($order)
{
    $CI =& get_instance();
    $CI->load->library('pdf');
    $order_number = format_purchaseorder_number($order->number);
    $pdf            = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
    $pdf->SetTitle($order_number);
    $CI->pdf->SetMargins(PDF_MARGIN_LEFT, 26, PDF_MARGIN_RIGHT);
    $CI->pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $CI->pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    $CI->pdf->SetAutoPageBreak(TRUE, 30);
    $pdf->SetAuthor(get_option('company'));
    $pdf->SetFont('freesans', '', 10);
    $pdf->AddPage();
    $status = $order->status;
    include(APPPATH . 'views/themes/' . active_clients_theme() . '/views/purchaseorderpdf.php');
    return $pdf;
}
function rqf_pdf($order)
{
    $CI =& get_instance();
    $CI->load->library('pdf');
    $order_number = format_rfqsquote_number($order->number);
    $pdf            = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
    $pdf->SetTitle($order_number);
    $CI->pdf->SetMargins(PDF_MARGIN_LEFT, 26, PDF_MARGIN_RIGHT);
    $CI->pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $CI->pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    $CI->pdf->SetAutoPageBreak(TRUE, 30);
    $pdf->SetAuthor(get_option('company'));
    $pdf->SetFont('freesans', '', 10);
    $pdf->AddPage();
    $status = $order->status;
    //include(APPPATH . 'views/admin/rfqs/views/rfqs_pdf_template.php');
	
	$status = $order->status;
	
    include(APPPATH . 'views/themes/' . active_clients_theme() . '/views/rfqs_pdf_template.php');
    return $pdf;
}
function format_proposal_status($status, $classes = '', $label = true)
{
    if ($status == 1) {
        $status      = _l('proposal_status_open');
        $label_class = 'default';
    } else if ($status == 2) {
        $status      = _l('proposal_status_declined');
        $label_class = 'danger';
    } else if ($status == 3) {
        $status      = _l('proposal_status_accepted');
        $label_class = 'success';
    } else if ($status == 4) {
        $status      = _l('proposal_status_sent');
        $label_class = 'info';
    } else {
       return $status;
    }

    if ($label == true) {
        return '<span class="label label-' . $label_class . ' ' . $classes . ' inline-block">' . $status . '</span>';
    } else {
        return $status;
    }
}


/**
 * Check quote restrictions - hash, clientid
 * @since  Version 1.0.1
 * @param  mixed $id   quote id
 * @param  string $hash quote hash
 */
function check_quote_restrictions($id, $hash)
{
    $CI =& get_instance();
    $CI->load->model('estimates_model');
    if (!$hash || !$id) {
        die('No quote specified');
    }

    if (!is_client_logged_in() && !is_staff_logged_in()) {
        if (get_option('view_quote_only_logged_in') == 1) {
            redirect(site_url('clients/login'));
        }
    }

    $quote = $CI->estimates_model->get($id);
    if (!$quote) {
        die('Quote not found');
    }

    if ($quote->hash != $hash) {
        die;
    }

    // Do one more check
    if (!is_staff_logged_in()) {
      if (get_option('view_quote_only_logged_in') == 1) {
        if ($quote->clientid != get_client_user_id()) {
            die;
        }
      }
    }

}

/**
 * Check order restrictions - hash, clientid
 * @since  Version 1.0.1
 * @param  mixed $id   quote id
 * @param  string $hash quote hash
 */
function check_order_restrictions($id, $hash)
{
    $CI =& get_instance();
    $CI->load->model('orders_model');
    if (!$hash || !$id) {
        die('No order specified');
    }

    if (!is_client_logged_in() && !is_staff_logged_in()) {
        if (get_option('view_quote_only_logged_in') == 1) {
            redirect(site_url('clients/login'));
        }
    }

    $order = $CI->orders_model->get($id);
    if (!$order) {
        die('Order not found');
    }

    if ($order->hash != $hash) {
        die;
    }

    // Do one more check
    if (!is_staff_logged_in()) {
      if (get_option('view_quote_only_logged_in') == 1) {
        if ($order->clientid != get_client_user_id()) {
            die;
        }
      }
    }

}
function check_purchaseorder_restrictions($id, $hash)
{
    $CI =& get_instance();
    $CI->load->model('purchaseorders_model');
    if (!$hash || !$id) {
        die('No order specified');
    }

    if (!is_client_logged_in() && !is_staff_logged_in()) {
        if (get_option('view_quote_only_logged_in') == 1) {
            redirect(site_url('clients/login'));
        }
    }

    $order = $CI->purchaseorders_model->get($id);
    if (!$order) {
        die('Order not found');
    }

    if ($order->hash != $hash) {
        die;
    }

    // Do one more check
    if (!is_staff_logged_in()) {
      if (get_option('view_quote_only_logged_in') == 1) {
        if ($order->supplirid != get_client_user_id()) {
            die;
        }
      }
    }

}

function check_proposal_restrictions($id, $hash)
{
    $CI =& get_instance();
    $CI->load->model('proposals_model');
    if (!$hash || !$id) {
        die('No proposal specified');
    }

    $proposal = $CI->proposals_model->get($id);
    if (!$proposal) {
        die('Proposal not found');
    }

    if ($proposal->hash != $hash) {
        die;
    }
}
function load_pdf_language($clientid){
    $CI = &get_instance();
    $lang = get_option('active_language');
    // When cron or email sending pdf document the pdfs need to be on the client language
    $language = get_client_default_language($clientid);
    if(DEFINED('CRON') || DEFINED('EMAIL_TEMPLATE_SEND')){
        if(!empty($language)){
            $lang = $language;
        }
    } else {
        if(get_option('output_client_pdfs_from_admin_area_in_client_language') == 1){
            if(!empty($language)){
                $lang = $language;
            }
        }
    }
    if(file_exists(APPPATH .'language/'.$lang)){
        $CI->lang->load($lang.'_lang',$lang);
    }
}
function proposal_pdf($proposal){

    $CI =& get_instance();

    if($proposal->rel_id != NULL && $proposal->rel_type == 'customer'){
        load_pdf_language($proposal->rel_id);
    }

    $CI->load->library('pdf');
    $pdf            = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

    $CI->pdf->SetMargins(PDF_MARGIN_LEFT, 26, PDF_MARGIN_RIGHT);
    $CI->pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $CI->pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    $CI->pdf->SetAutoPageBreak(TRUE, 30);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    $pdf->SetAuthor(get_option('company'));
    $pdf->SetFont('freesans', '', 10);
    $pdf->AddPage();

    $CI->load->model('currencies_model');

    $total = '';
    if($proposal->total != 0){
        $total = format_money($proposal->total,$CI->currencies_model->get($proposal->currency)->symbol);
        $total = _l('proposal_total') . ': ' .$total;
    }
    # Dont remove these lines - important for the PDF layout
    // Add <br /> tag and wrap over div element every image to prevent overlaping over text
    $proposal->content = preg_replace('/(<img[^>]+>(?:<\/img>)?)/i', '<br><br><div>$1</div><br><br>', $proposal->content);
    // Add cellpadding to all tables inside the html
    $proposal->content = preg_replace('/(<table\b[^><]*)>/i', '$1 cellpadding="4">', $proposal->content);
    // Remove white spaces cased by the html editor ex. <td>  item</td>
    $proposal->content = preg_replace('/[\t\n\r\0\x0B]/', '', $proposal->content);
    $proposal->content = preg_replace('/([\s])\1+/', ' ', $proposal->content);

    if(file_exists(APPPATH . 'views/themes/' . active_clients_theme() . '/views/my_proposalpdf.php')){
        include(APPPATH . 'views/themes/' . active_clients_theme() . '/views/my_proposalpdf.php');
    } else {
        include(APPPATH . 'views/themes/' . active_clients_theme() . '/views/proposalpdf.php');
    }

    return $pdf;
}
// for warehose formats
function format_internaltransfer_number($number)
{

    $format = get_option('internalransfer_number_format');
 
    if ($format == 1) {
        // Number based

        return get_option('internalransfer_prefix') .get_option('internalransfer_separator').$number;
    } else if ($format == 2) {
   return get_option('internalransfer_prefix').get_option('internalransfer_separator') . get_option('invoice_year') . '/'.$number;
    }
    return $number;
}
function format_warehousetransfer_number($number)
{

    $format = get_option('warehousetransfer_number_format');
 
    if ($format == 1) {
        // Number based

        return get_option('warehousetransfer_prefix') .get_option('warehousetransfer_separator').$number;
    } else if ($format == 2) {
   return get_option('warehousetransfer_prefix').get_option('warehousetransfer_separator') . get_option('invoice_year') . '/'.$number;
    }
    return $number;
}

function format_bintransfer_number($number)
{

    $format = get_option('bintransfer_number_format');
 
    if ($format == 1) {
        // Number based

        return get_option('bintransfer_prefix') .get_option('bintransfer_separator').$number;
    } else if ($format == 2) {
   return get_option('bintransfer_prefix').get_option('bintransfer_separator') . get_option('invoice_year') . '/'.$number;
    }
    return $number;
}
function format_lead_number($number)
{

    $format = get_option('lead_number_format');
 
    if ($format == 1) {
        // Number based

        return get_option('lead_prefix') .get_option('lead_separator').$number;
    } else if ($format == 2) {
   return get_option('lead_prefix').get_option('lead_separator') . get_option('invoice_year') . '/'.$number;
    }
    return $number;
}
