<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Institutions extends Admin_controller {

    function __construct() {
        parent::__construct();
        $this->load->model('positions_model');
    }

    public function index() 
    {    
      $data['institutions'] = $this->institutions_model->get_list();
      $data['title'] = "Positions";
      $this->load->view('admin/positions/manage', $data);
    }

    public function institutions() {
        if ($this->input->is_ajax_request()) {
            $data = $this->input->post();

            if ($data['id'] == '') {
                $success = $this->institutions_model->add($data);
                $message = '';
                if ($success == true) {
                    $message = _l('added_successfuly', "Position");
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            } else {
				
                $success = $this->institutions_model->edit($data);
                $message = '';
                if ($success == true) {
                    $message = _l('updated_successfuly', "Position");
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            }
        }
    }

    public function getinstitutions(){
		echo  json_encode($this->institutions_model->getinstitutions());
	}

	public function delete($id)
	{
		$response = $this->institutions_model->delete($id);
		
		if ($response == true) {
            set_alert('success', _l('deleted', "Position"));
        } else {
            set_alert('warning', _l('problem_deleting', "Position"));
        }

        redirect(admin_url('positions'));
	}
}