<?php

ob_start();
defined('BASEPATH') OR exit('No direct script access allowed');

class Vouchers extends Admin_controller {

    function __construct() {
        parent::__construct();
        $this->load->model('vouchers_model');
    }

    /* Get all estimates in case user go on index page */

    public function index1($id = false, $clientid = false) {

        $has_permission = has_permission('manageGroups');

        if (!$has_permission && !$this->input->is_ajax_request()) {
            access_denied('manageGroups');
        }

        if ($this->input->is_ajax_request()) {
            // From client profile
            if (is_numeric($clientid)) {
                if (!$has_permission) {
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'voucher',
                'docdate',
                'trxdate',
            );

            $sIndexColumn = "vchid";
            $sTable = 'tblvoucher';
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, array(), array(), array('vchid'));
            $output = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();

                for ($i = 0; $i < count($aColumns); $i++) {

                    $_data = $aRow[$aColumns[$i]];
                    if ($aColumns[$i] == 'docdate') {
                        $_data = _d($_data);
                    }
                    if ($aColumns[$i] == 'trxdate') {
                        $_data = _d($_data);
                    }
                    if ($aColumns[$i] == 'voucher') {
                        $_data = $_data = '<a href="' . admin_url('vouchers/voucher/' . $aRow['vchid']) . '">' . $_data . '</a>';
                    }

                    $row[] = $_data;
                }
                $options = icon_btn('admin/vouchers/voucher/' . $aRow['vchid'], 'pencil-square-o');
                $row[] = $options .= icon_btn('#', 'remove', ' beforedelete', array('data-toggle' => 'tooltip', 'title' => _l('voucher_delete_tooltip'), 'data-id' => $aRow['vchid']));

                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        $data['vchid'] = '';
        if (is_numeric($id)) {
            $data['vchid'] = $id;
        }

        $data['title'] = _l('lng_vouchers');
        $this->load->view('admin/vouchers/manage', $data);
    }

    public function index()
    {
        if($this->input->get('bill_id'))
        {
            $bill_id = $this->input->get('bill_id');
        }
        else
        {
            $bill_id = "";
        }
        $data['vouchers'] = $this->vouchers_model->get_voucher_list($bill_id);
        
        $data['title'] = _l('lng_vouchers');
        $this->load->view('admin/vouchers/manage', $data);
    }

    public function vouchertypes($id = false, $clientid = false){
          $has_permission = has_permission('manageGroups');

        if (!$has_permission && !$this->input->is_ajax_request()) {
            access_denied('manageGroups');
        }

        if ($this->input->is_ajax_request()) {
            // From client profile
            if (is_numeric($clientid)) {
                if (!$has_permission) {
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'name',
                'vtypecode',
                'description',
            );

            $sIndexColumn = "id";
            $sTable = 'tblvouchertypes';
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, array(), array(), array('id'));
            $output = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();

                for ($i = 0; $i < count($aColumns); $i++) {

                    $_data = $aRow[$aColumns[$i]];
                    
                    $row[] = $_data;
                }
                $options = icon_btn('admin/vouchers/vouchertype/' . $aRow['id'], 'pencil-square-o');
                $row[] = $options .= icon_btn('#', 'remove', ' beforedelete', array('data-toggle' => 'tooltip', 'title' => _l('voucher_delete_tooltip'), 'data-id' => $aRow['id']));

                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        $data['id'] = '';
        if (is_numeric($id)) {
            $data['id'] = $id;
        }

        $data['title'] = _l('form_vouchertypes');
        $this->load->view('admin/vouchers/managetype', $data);
    }
    /* Add new estimate or update existing */

    public function voucher($id = '') {


        if (!has_permission('manageGroups')) {
            access_denied('manageGroups');
        }
        $this->load->model('clients_model');
        if ($this->input->post()) 
	    {

		
    		$debit  = 0; 
    		$credit = 0;
    		$a = $this->input->post();
    		foreach ( $_REQUEST['newitems']  as $row )
    		{


    			if ( $row['amount_type'] == 0) {
     				$debit =$debit + str_replace(array(','), '', $row['amount']); 
    			}

    			if ( $row['amount_type'] == 1) {
     				$credit =$credit +str_replace(array(','), '', $row['amount']); 
    			}
    		}

    		if( $credit != $debit ) 
    		{             
    			 set_alert('warning',"Debit and Credit do not match",  _l('voucher')   );
                   		 if (trim($this->input->post('action')) == 'snew') {
                    		    redirect(admin_url('vouchers/voucher'));
                     	   exit;
                    }
                    if (trim($this->input->post('action')) == 'slist') {
                        redirect(admin_url('vouchers'));
                    }
    	    }


            if ($id == '') {

		        if( $credit == $debit ) 
                    $id = $this->vouchers_model->add($this->input->post());

                if ($id) {
                    $estimates = $this->vouchers_model->get($id);

                    set_alert('success', _l('added_successfuly', _l('voucher')));

                    if (trim($this->input->post('action')) == 'snew') {
                        redirect(admin_url('vouchers/voucher'));
                        exit;
                    }

                    if (trim($this->input->post('action')) == 'slist') {
                        redirect(admin_url('vouchers'));
                    }
                }
            } 
            else {

		        if( $credit == $debit ) 
                    $success = $this->vouchers_model->update($this->input->post(), $id);
                if ($success) {
                    set_alert('success', _l('updated_successfuly', _l('voucher')));
                }

                if (trim($this->input->post('action')) == 'snew') {
                    redirect(admin_url('vouchers/voucher'));
                    exit;
                }

                if (trim($this->input->post('action')) == 'slist') {
                    redirect(admin_url('vouchers'));
                }
            }
        }

        if ($id == '') {
            $title = _l('create_new_voucher');
        } else {
            $vouchers = $this->vouchers_model->get($id);

            $data['voucher'] = $vouchers;
            $data['edit'] = true;
            $title = _l('edit', _l('voucher_lowercase'));
        }

        $this->load->model('taxes_model');
        $data['taxes'] = $this->taxes_model->get();

        $this->load->model('currencies_model');
        $data['currencies'] = $this->currencies_model->get();

        $this->load->model('vouchers_model');
        $data['vchtypes'] = $this->vouchers_model->get_types();
        $data['ledgers'] = $this->vouchers_model->get_ledgers();

        $data['prev'] = $this->vouchers_model->get_prev_groups2();
        // echo "<pre>";
        // print_r($data['prev']);
        // die;

        // $data['ledgers'] = $this->clients_model->get_ledgers();


        $data['title'] = $title;
        $this->load->view('admin/vouchers/voucher', $data);
    }

    public function init_estimate_items_ajax($id) {
        echo json_encode($this->vouchers_model->get_estimate_items($id));
    }

    public function createcode() {
        echo $this->vouchers_model->createcode();
    }

    public function get_term() {
        echo json_encode($this->vouchers_model->get_term($this->input->post('id')));
    }

    /* Delete estimate */

    public function delete($id) {
        if (!has_permission('manageGroups')) {
            access_denied('manageGroups');
        }

        if (!$id) {
            redirect(admin_url('vouchers'));
        }

        $success = $this->vouchers_model->delete($id);

        if ($success) {
            set_alert('success', _l('deleted', _l('voucher_lowercase')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('voucher_lowercase')));
        }

        redirect(admin_url('vouchers'));
    }
    public function typedelete($id) {
        if (!has_permission('manageGroups')) {
            access_denied('manageGroups');
        }

        if (!$id) {
            redirect(admin_url('vouchers/vouchertypes'));
        }

        $success = $this->vouchers_model->typedelete($id);

        if ($success) {
            set_alert('success', _l('deleted', _l('smallvouchertypes')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('smallvouchertypes')));
        }

        redirect(admin_url('vouchers/vouchertypes'));
    }

    public function vouchertype($id = '') {
        if ($this->input->post() && !$this->input->is_ajax_request()) {
            if (!has_permission('manageGroups')) {
                access_denied('manageGroups');
            }

            if ($id == '') {
              
                $id = $this->vouchers_model->add_vouchertype($this->input->post());
                if ($id) {
                    set_alert('success', _l('added_successfuly', _l('form_vouchertype')));
                    if (trim($this->input->post('action')) == 'save') {
                        redirect(admin_url('vouchers/vouchertype/' . $id));
                        exit;
                    }
                    if (trim($this->input->post('action')) == 'snew') {
                        redirect(admin_url('vouchers/vouchertype'));
                        exit;
                    }
                    if (trim($this->input->post('action')) == 'slist') {
                        redirect(admin_url('vouchers/vouchertypes'));
                    }
                    if (trim($this->input->post('action')) == 'cancel') {
                        redirect(admin_url());
                        exit;
                    }
                }
            } else {
                $success = $this->vouchers_model->update_vouchertype($this->input->post(), $id);
                if ($success) {
                    set_alert('success', _l('updated_successfuly', _l('form_vouchertype')));
                }
                if (trim($this->input->post('action')) == 'save') {
                    redirect(admin_url('vouchers/vouchertype/' . $id));
                    exit;
                }
                if (trim($this->input->post('action')) == 'snew') {
                    redirect(admin_url('vouchers/vouchertype'));
                    exit;
                }

                if (trim($this->input->post('action')) == 'slist') {
                    redirect(admin_url('vouchers/vouchertypes'));
                }
                if (trim($this->input->post('action')) == 'cancel') {
                    redirect(admin_url());
                    exit;
                }
            }
        }

        if ($id == '') {
            $title = _l('add_new', _l('form_vouchertype'));
        } else {

            $vouchertype = $this->vouchers_model->get_voucher($id);
            $res = $this->vouchers_model->get_where_allowedvouchertype($id);
            $allowedvouchertype = array();
            foreach ($res as $value) {
                $allowedvouchertype[$value->ledgerorgroupid] =$value->ledgerorgroupid;
            }
            $data['allowedvouchertype']=  $allowedvouchertype;
            $data['vouchertype'] = $vouchertype;

            $data['prev'] = $this->vouchers_model->get_prev_type($id);
            $data['next'] = $this->vouchers_model->get_next_type($id);
            $title = $vouchertype->name;
        }
          $data['allledgrs'] = $this->vouchers_model->getall_ledgers();
        $data['title'] = $title;
        $this->load->view('admin/vouchers/vouchertype', $data);
    }

}
