<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Units extends Admin_controller {

	function __construct(){
		parent::__construct();
		$this->load->model('units_model');
              
	}

	/* List all clients */
	public function index()
	{

		if($this->input->is_ajax_request()){
			$aColumns = array('name', 'description','quantity', 'is_active','id');
			$sIndexColumn = "id";
			$sTable = 'tblunitsofmeasure';
           
			$result = data_tables_init($aColumns,$sIndexColumn,$sTable,array(),array(),array());
			$output = $result['output'];
			$rResult = $result['rResult'];

			foreach ( $rResult as $aRow )
			{
				$row = array();
				for ( $i=0 ; $i<count($aColumns) ; $i++ )
				{
					$_data = $aRow[ $aColumns[$i] ];
					   if ($aColumns[$i] == 'is_active') {
                                            if ($aRow['is_active'] == '0') {
                                                    $_data = '<input  class="ischeckbox" data-rowid="'.$aRow['id'].'" value="' . $aRow['is_active'] . '" type="checkbox"/>';
                                                } else {
                                                    $_data = '<input  class="ischeckbox" data-rowid="'.$aRow['id'].'" checked="checked" value="' . $aRow['is_active'] . '" type="checkbox"/>';
                                                }
                                            }
                                     	 if ($aColumns[$i] == 'id') {
                                             	$options = icon_btn('#','pencil-square-o','editunitrecord',array('data-id'=>$aRow['id']));
			                   $_data = $options .= icon_btn('admin/units/delete/'.$aRow['id'],'remove','',array('data-toggle'=>'tooltip','onClick' => 'return deleteconf();','title'=>_l('unit_delete_tooltip')));
                                           }

					$row[] = $_data;
				}

			
				$output['aaData'][] = $row;
			}

			echo json_encode( $output );
			die();
		}


		$data['title'] = _l('units_of_mesure');
		$this->load->view('admin/units/manage',$data);
	}
        	/* Delete Unit */
	public function delete($id){

		if(!has_permission('manageinventory')){
			access_denied('manageinventory');
		}

		if(!$id){
			redirect(admin_url('units'));
		}

		$response = $this->units_model->delete($id);

		if(is_array($response) && isset($response['referenced'])){
			set_alert('warning',_l('is_referenced',_l('unit_lowercase')));
		} else if($response == true){
			set_alert('success', _l('deleted',_l('units_of_mesure')));
		} else {
			set_alert('warning', _l('problem_deleting',_l('unit_lowercase')));
		}

		redirect(admin_url('units'));
	}
        /* Change client status / active / inactive */
	public function change_unit_status($id,$status){

		if(!has_permission('manageinventory')){
			access_denied('manageinventory');
		}

		if($this->input->is_ajax_request()){
			$this->units_model->change_unit_status($id,$status);
		}
	}
   /*Unit of measure*/
    public function addunit(){
		$this->units_model->addunit();
		redirect(admin_url('units'));
	}

	public function add_unit(){
		$id = $this->units_model->addunit();
		echo $id;
	}

	public function update_unit($value='')
	{
		$id = $this->units_model->editunit();
		echo $id;
	}
 
    public function getdataunit(){
    	echo $this->units_model->getdataunit();
	}
 
    public function updateunit(){
    	$this->units_model->editunit();
    	redirect(admin_url('units'));
	}

	public function changestatus(){
    	echo $this->units_model->changestatus();
	}
	
}
