<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Subgroups extends Admin_controller {

	function __construct(){
		parent::__construct();
                $this->load->model('subgroups_model');
	}

	/* List all clients */
	public function index()
	{

		if($this->input->is_ajax_request()){
			$aColumns = array('name','description','parent');
			$sIndexColumn = "id";
			$sTable = 'tblledgergroups';
                        
                       $where = array('WHERE type="Group"');
                       
			$result = data_tables_init($aColumns,$sIndexColumn,$sTable,array(), $where,array('id','status'));
			$output = $result['output'];
			$rResult = $result['rResult'];

			foreach ( $rResult as $aRow )
			{
				$row = array();
				$parent=0;
				for ( $i=0 ; $i<count($aColumns) ; $i++ )
				{
					$_data = $aRow[ $aColumns[$i] ];
                                          if($aColumns[$i] == 'parent'){
                                           $_data =  $this->subgroups_model->get_parent($aRow['parent']);
										   $parent=$aRow['parent'];
                                        }
					$row[] = $_data;
				}

				$options = icon_btn('admin/subgroups/subgroup/'.$aRow['id'],'pencil-square-o');
				if($parent!=0)
				{
                                if($aRow['status'] == 0){
				$row[]  = $options .= icon_btn('admin/subgroups/delete/'.$aRow['id'],'remove','',array('data-toggle'=>'tooltip','onClick' => 'return deleteconf();','title'=>_l('subgroup_delete_tooltip')));
                                }else{
                                    $row[]  = $options;
                                }
				}
				else
					$row[]  = "";
				$output['aaData'][] = $row;
			}

			echo json_encode( $output );
			die();
		}


		$data['title'] = _l('group');
		$this->load->view('admin/subgroups/manage',$data);
	}
        
    
	/* Edit client or add new client*/
	public function subgroup($id = ''){

		if($this->input->post() && !$this->input->is_ajax_request()){
			if(!has_permission('manageGroups')){
				access_denied('manageGroups');
			}

			if($id == ''){
				$id = $this->subgroups_model->add($this->input->post());
				if($id){
					set_alert('success', _l('added_successfuly',_l('subgroup')));
                                        if (trim($this->input->post('action')) == 'save') {
                                             redirect(admin_url('subgroups/subgroup/'.$id));
                                           exit;
                                       }
                                       if (trim($this->input->post('action')) == 'snew') {
                                           redirect(admin_url('subgroups/subgroup'));
                                           exit;
                                       }
                                      if (trim($this->input->post('action')) == 'sexit') {
                                            redirect(admin_url('subgroups'));

                                       }
                                       
					
				}
			} else {
				$success = $this->subgroups_model->update($this->input->post(),$id);
				if($success){
					set_alert('success', _l('updated_successfuly',_l('subgroup')));
				}
				     if (trim($this->input->post('action')) == 'save') {
                                             redirect(admin_url('subgroups/subgroup/'.$id));
                                           exit;
                                       }
                                       if (trim($this->input->post('action')) == 'snew') {
                                           redirect(admin_url('subgroups/subgroup'));
                                           exit;
                                       }
                                      if (trim($this->input->post('action')) == 'sexit') {
                                            redirect(admin_url('subgroups'));

                                       }
			}
		}

		if($id == ''){
			$title = _l('account_subgroup');
		} else {
	
			$subgroup = $this->subgroups_model->get($id);
             
			$data['subgroup'] = $subgroup;
                        $title = $subgroup->name;
            
		}
             $data['prevsubgroups'] = $this->subgroups_model->get_prev_groups2();
	
      		$data['title'] = $title;
		$this->load->view('admin/subgroups/subgroup',$data);
	}
        
  

 
	

	/* Delete client */
	public function delete($id){

		if(!has_permission('manageGroups')){
			access_denied('manageGroups');
		}

		if(!$id){
			redirect(admin_url('subgroups'));
		}

		$response = $this->subgroups_model->delete($id);

		if(is_array($response) && isset($response['referenced'])){
			set_alert('warning',_l('is_referenced',_l('subgroup_lowercase')));
		} else if($response == true){
			set_alert('success', _l('deleted',_l('subgroup')));
		} else {
			set_alert('warning', _l('problem_deleting',_l('subgroup_lowercase')));
		}

		redirect(admin_url('subgroups'));
	}

	/* Change client status / active / inactive */
	public function change_subgroup_status($id,$status){

		if(!has_permission('manageGroups')){
			access_denied('manageGroups');
		}

		if($this->input->is_ajax_request()){
			$this->subgroups_model->change_subgroup_status($id,$status);
		}
	}
	

}
