<?php ob_start();
defined('BASEPATH') OR exit('No direct script access allowed');

class Rfqs extends Admin_controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('rfqs_model');
    }

    /* Get all purchaseorders in case user go on index page */
    public function index($id = false, $clientid = false)
    {
      
         // $has_permission = has_permission('manageRfqs');
         $has_permission = has_permission('rfq');

         if(!$has_permission && !$this->input->is_ajax_request()){
            access_denied('rfq');
         }

         $_status = '';

         if($this->input->get('status')){
            $_status = $this->input->get('status');
         }

        if ($this->input->is_ajax_request()) {
			
            // From client profile
            if(is_numeric($clientid)){
                if(!$has_permission){
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'number',
				'datecreated', 
                'requisitiondate',                
               'requiredby',
			   'warehouse',
			   'status'
                 );
		
            

            $where                    = array();

           
 			$this->load->model('warehouse_model');
			$warehouses=$this->warehouse_model->get();
			
			$listWarhouses=array();
			foreach($warehouses as $w)
			{
				$listWarhouses[$w['ware_id']]=$w['warehouse_name'];
			}
            $sIndexColumn = "id";
            $sTable       = 'tblrfqsqoutes';
            $where  = array();
            // $where  = array('where status != 4');

            if (is_numeric($clientid)) {
                $where                    = array(
                    'AND supplierid=' . $clientid
                );
            }


            if ($this->input->post('status')) {
                array_push($where, 'AND status=' . $this->input->post('status'));
            }

            if($this->input->post('custom_view')){
                $custom_view = $this->input->post('custom_view');
                if($custom_view == 'not_sent'){
                     array_push($where,'AND sent=0');
                 }
            }
 
            $sIndexColumn = "id";
            $sTable       = 'tblrfqsqoutes';
            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, array(), $where, array(
                'tblrfqsqoutes.id',
                'invoiceid',
                'hash',
               
                             
                
                'status'
            ));
            $output       = $result['output'];
            $rResult      = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();

               $status=0;
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data                    = $aRow[$aColumns[$i]];

                    if ($aColumns[$i] == 'number') {
                        // If is from client area table
                    if (is_numeric($clientid)) {
                        $__data = '<a href="' . admin_url('rfqs/list_rfqs/' . $aRow['id']) . '">' . format_rfqsquote_number($_data) . '</a><br />';
                    } else {
                           $__data = '<a href="#" onclick="init_request_quotation(' . $aRow['id'] . '); return false;">' . format_rfqsquote_number($_data) . '</a><br />';
                    }
                    } else if ($aColumns[$i] == 'requisitiondate') {
                        $__data = _d($_data);
                    }
					 else if ($aColumns[$i] == 'datecreated') {
                        $__data = _d($_data);
                    }
					 else if ($aColumns[$i] == 'requiredby') {
                        $__data = _d($_data);
                    }
                    else if ($aColumns[$i] == 'status') {
						$status=$_data;
                        $__data = format_rfq_status($_data);
						
                    } else if ($aColumns[$i] == 'warehouse') {
						if(isset($listWarhouses[$_data]))
							$__data = $listWarhouses[$_data];
						else
                        $__data ="";
                    }
					
					
                    $row[] = $__data;
                }
                $options='';
				if($status<3)
                    if (has_permission('rfq_edit')) { 
				        $options .= icon_btn('admin/rfqs/rfq/' . $aRow['id'], 'edit', ' btn-edit-customer', array('data-toggle' => 'tooltip', 'title' =>'Edit Purchase Request'));
                    }
                $options .= icon_btn('#','print','printorder',array('data-toggle' => 'tooltip', 'title' =>'Print Purchase Request','data-id'=>$aRow['id'],'data-hash'=>$aRow['hash']));

                 $options .= icon_btn('admin/rfqs/pdf/' . $aRow['id'],'download','',array('data-toggle' => 'tooltip', 'title' =>'Download Purchase Request', 'download' =>'admin/rfqs/pdf/' . $aRow['id']));

                  $options .= icon_btn('#', 'eye','',array('data-toggle' => 'tooltip', 'title' =>"View Purchase Request", 'onclick'=>'init_request_quotation('.$aRow['id'].'); return false;'));
                  
                if($status<3)
                    if (has_permission('rfq_delete')) { 
                        $options .= icon_btn('admin/rfqs/delete/' . $aRow['id'], 'remove', ' btn-delete-customer', array('data-toggle' => 'tooltip', 'title' =>'Delete Purchase Request'));
                    }
         
                 $row[] =$options;
                 $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        $data['orderid'] = '';
        if (is_numeric($id)) {
            $data['orderid'] = $id;
        }
        

        $data['status'] = $_status;
        $data['bodyclass'] = 'small-table';
        $data['title']     = _l('rfqs_list');
        $this->load->view('admin/rfqs/manage', $data);
    }

    /* List all purchaseorders datatables */
    public function list_rfqs($id = false, $clientid = false)
    {
		
          $has_permission = has_permission('rfq');

         if(!$has_permission && !$this->input->is_ajax_request()){
            access_denied('rfq');
         }

         $_status = '';

         if($this->input->get('status')){
            $_status = $this->input->get('status');
         }

        if ($this->input->is_ajax_request()) {
            // From client profile
            if(is_numeric($clientid)){
                if(!$has_permission){
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                // 'number',
                // 'requisitiondate',
              
                // 'status'
                'number',
                'datecreated', 
                'requisitiondate',                
               'requiredby',
               'warehouse',
               'status'
            );

           $join = array();
            $where                    = array();

            if (is_numeric($clientid)) {
                $where                    = array(
                    'AND supplierid=' . $clientid
                );
            }

            $this->load->model('warehouse_model');
            $warehouses=$this->warehouse_model->get();
            
            $listWarhouses=array();
            foreach($warehouses as $w)
            {
                $listWarhouses[$w['ware_id']]=$w['warehouse_name'];
            }


            if ($this->input->post('status')) {
                array_push($where, 'AND status=' . $this->input->post('status'));
            }

            if($this->input->post('custom_view')){
                $custom_view = $this->input->post('custom_view');
                if($custom_view == 'not_sent'){
                     array_push($where,'AND sent=0');
                 }
            }
 
            $sIndexColumn = "id";
            $sTable       = 'tblrfqsqoutes';
            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array(
                'tblrfqsqoutes.id',
                'invoiceid',
                'hash',
               
                             
                
                'status'
            ));
            $output       = $result['output'];
            $rResult      = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();

                
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data                    = $aRow[$aColumns[$i]];

                    if ($aColumns[$i] == 'number') {
                        // If is from client area table
                        if (is_numeric($clientid)) 
                        {
                            $__data = '<a href="' . admin_url('rfqs/list_rfqs/' . $aRow['id']) . '">' . format_purchaseorder_number($_data) . '</a><br />';
                        }
                        else 
                        {
                               $__data = '<a href="#" onclick="init_request_quotation(' . $aRow['id'] . '); return false;">' . format_rfqsquote_number($_data) . '</a><br />';
                        }
                    }
                    else if ($aColumns[$i] == 'requisitiondate') 
                    {
                        $__data = _d($_data);
                    }
                    else if ($aColumns[$i] == 'datecreated') 
                    {
                        $__data = _d($_data);
                    }
                    else if ($aColumns[$i] == 'requiredby') 
                    {
                        $__data = _d($_data);
                    }
                    else if ($aColumns[$i] == 'warehouse') 
                    {
                        if(isset($listWarhouses[$_data]))
                            $__data = $listWarhouses[$_data];
                        else
                        $__data ="";
                    }
                    else if ($aColumns[$i] == 'status') 
                    {
                        $status=$_data;
                        $__data = format_rfq_status($_data);
                        
                    }
                    else if ($aColumns[$i] == 'supplierid') {
                        $__data = '<a href="' . admin_url('suppliers/supplier/' . $aRow['supplierid']) . '">' . $aRow['supplier'] . '</a><br />';
                    }else if ($aColumns[$i] == 'total') {
                        $__data = format_money($_data, $aRow['symbol']);
                    }else if ($aColumns[$i] == 'tblcurrencies.name') {
                         $__data = $aRow['tblcurrencies.name'];
                    } 
                    $row[] = $__data;
                }
                $options='';
				
				
				 $options .= icon_btn('admin/rfqs/rfq/' . $aRow['id'], 'edit', ' btn-edit-customer', array('data-toggle' => 'tooltip', 'title' =>'Edit Purchase Request'));
				 
                $options .= icon_btn('#','print','printorder',array('data-toggle' => 'tooltip', 'title' =>'Print Purchase Order','data-id'=>$aRow['id'],'data-hash'=>$aRow['hash']));
               $options .= icon_btn('admin/rfqs/pdf/' . $aRow['id'],'download','',array('data-toggle' => 'tooltip', 'title' =>'Download Purchase Order', 'download' =>'admin/rfqs/pdf/' . $aRow['id']));
                 $options .= icon_btn('#', 'eye','',array('data-toggle' => 'tooltip', 'title' =>"View Request Quotation", 'onclick'=>'init_request_quotation('.$aRow['id'].'); return false;'));
  
                 $options .= icon_btn('admin/rfqs/delete/' . $aRow['id'], 'remove', ' btn-delete-customer', array('data-toggle' => 'tooltip', 'title' =>'Delete Purchase Order'));
         
                 $row[] =$options;
                 $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        $data['orderid'] = '';
        if (is_numeric($id)) {
            $data['orderid'] = $id;
        }
        // echo $data['orderid'];
        // die;

        $data['status'] = $_status;
        $data['bodyclass'] = 'small-table';
        $data['title']     = _l('rfqs_list');
        $this->load->view('admin/rfqs/manage', $data);
    }
	 public function get_all_items_ajax() {
		 
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->rfqs_model->get_all_items_ajax());
        }
    }
	 public function get_all_our_items_ajax() {
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->rfqs_model->get_all_our_items_ajax());
        }
    }
	public function get_rfq_data_ajax($id)
    {
        if(!has_permission('rfq')){
            access_denied('rfq');
        }

        if (!$id) {
            die('No order found');
        }

        $order = $this->rfqs_model->get($id);
		$order->items = $this->rfqs_model->get_rfqs_items_unit($id);
		//order["items"]=$items;

        $data['po_id'] = $this->rfqs_model->get_poid($id);
        $data['grn_number'] = $this->rfqs_model->get_grn($id);
		
		
		$created_by=$this->staff_model->get($order->addedfrom);
		
		$order->createdby=$created_by->firstname." ".$created_by->lastname;
		$this->load->model('warehouse_model');
		$warehouses=$this->warehouse_model->get($order->warehouse);
        $order->warehouse=$warehouses->warehouse_name;
        $data['order']  = $order;
		$data['items']  = $items;
		
		$data['activity'] = $this->rfqs_model->get_rfq_activity($id);
        $this->load->view('admin/rfqs/rfqs_preview_template', $data);
    }
	function change_rfq_status($status,$id)
	{
		echo $this->rfqs_model->change_rfq_status($status,$id);
	}
    /* Add new order or update existing */
    public function rfq($id = '',$function="")
    {
		
         if(!has_permission('rfq')){
            access_denied('rfq');
         }
        $this->load->model('clients_model');
        if ($this->input->post()) {
            if (($id == '')||($function == 'copy')) {
                if(!has_permission('rfq_add')){
                    access_denied('rfq_add');
                }

                $id = $this->rfqs_model->add($this->input->post());
                if ($id) {
                    $purchaseorders = $this->rfqs_model->get($id);
                    if ($purchaseorders->number != $this->input->post('_number')) {
                        set_alert('warning', "PR number changed");
                    } else {
                       set_alert('success', _l('added_successfuly',_l('rfqsorder')));
                    }
                    
                    if (trim($this->input->post('action')) == 'save') {
                          //redirect(admin_url('rfqs/rfq/'.$this->input->post('supplierid').'/'. $id));
						  redirect(admin_url('rfqs/'));
                        exit;
                    }
                    if (trim($this->input->post('action')) == 'snew') {
                        redirect(admin_url('rfqs/rfq'));
                        exit;
                    }
                 
                    if (trim($this->input->post('action')) == 'slist') {
                         // redirect(admin_url('rfqs/' . $id));
                         redirect(admin_url('rfqs'));
                         
                    }
                    if (trim($this->input->post('action')) == 'cancel') {
                        redirect(admin_url());
                        exit;
                    }
//                    redirect(admin_url('purchaseorders/list_purchaseorders/' . $id));
                }
            } else {

                if(!has_permission('rfq_edit')){
                    access_denied('rfq_edit');
                }
                $success = $this->rfqs_model->update($this->input->post(), $id);
                if ($success) {
                   set_alert('success', _l('updated_successfuly',_l('rfqsorder')));
                }
               if (trim($this->input->post('action')) == 'save') {
                          redirect(admin_url('rfqs/'));
                        exit;
                    }
                    if (trim($this->input->post('action')) == 'snew') {
                        redirect(admin_url('rfqs/rfq'));
                        exit;
                    }
                 
                    if (trim($this->input->post('action')) == 'slist') {
                         redirect(admin_url('rfqs/list_rfqs/' . $id));
                         
                    }
                    if (trim($this->input->post('action')) == 'cancel') {
                        redirect(admin_url());
                        exit;
                    }
            }
        }

        if ($id == '') {
            $title = _l('rfqs_list');
			$data['edit'] = false;
        } else {
            

           if($rfqsquote->status =='4'){
                access_denied('manageRfqs');
                die();
           }
          
            

              $rfqsquote = $this->rfqs_model->get($id);
			$rfqsquote->items = $this->rfqs_model->get_rfqs_items_unit($id);
		//order["items"]=$items;
		
		
			$created_by=$this->staff_model->get($rfqsquote->addedfrom);
		
			$rfqsquote->createdby=$created_by->firstname." ".$created_by->lastname;
			
            $data['rfqsquote']  = $rfqsquote;
            $data['edit'] = true;
            $title           = _l('edit',"purchase request");
        }
		
        

//        $data['customerdetails'] = $this->clients_model->get_client($customerid);
        
        
          $data['copy'] ='';
        if($function=="copy"){
			$data['edit'] = false;
            $data['copy'] =$id;
           $data['purchaseorders']['items'] =   $this->rfqs_model->get_items($id);
		   $title           = _l('copy',"purchase request");
        }
		$this->load->model('units_model');
        $uofm = $this->units_model->get_units();
        $data['uofm']     = $uofm;
        $data['title']     = $title;
		$this->load->model('warehouse_model');
		$warehouses=$this->warehouse_model->get();
		
        $data['warehouses']=$warehouses;
        $this->load->view('admin/rfqs/rfqs', $data);
    }

    public function init_order_items_ajax($id){
        echo json_encode($this->rfqs_model->get_purchaseorder_items($id));
    }
    
    public function get_term() {
       
 $terms = $this->rfqs_model->get_term($this->input->post('id'));
 $account_repy = $this->rfqs_model->get_sales_agent($this->input->post('id'));
  echo json_encode(array('payment_term'=>$terms,'account_rep'=>$account_repy));

    }
    
    /* Delete order */
    public function delete($id)
    {
         if(!has_permission('rfq_delete')){
            access_denied('rfq_delete');
         }

        if (!$id) {
            redirect(admin_url('rfqs'));
        }

        $success = $this->rfqs_model->delete($id);

        if ($success) {
           set_alert('success', _l('deleted','RFQ'));
        } else {
            set_alert('warning', _l('problem_deleting','RFQ'));
        }

        redirect(admin_url('rfqs'));
    }

    /* Get all order data used when user click on order number in a datatable left side*/
    public function get_order_data_ajax($id)
    {
        if(!has_permission('rfq')){
            access_denied('rfq');
        }

        if (!$id) {
            die('No order found');
        }

        $order = $this->rfqs_model->get($id);

        $order->podate    = _d($order->podate);
        $order->expecteddate = _d($order->expecteddate);

//        if($order->invoiceid !== NULL){
//            $this->load->model('invoices_model');
//            $order->invoice = $this->invoices_model->get($order->invoiceid);
//        }

        $this->load->model('emails_model');

        if ($order->sent == 0) {
            $data['template'] = $this->emails_model->parse_template('purchaseorder_send_to_client', $order->supplierid, false,false,false,$id);
        } else {
            $data['template'] = $this->emails_model->parse_template('purchaseorder_send_to_client', $order->supplierid, false,false,false,$id);
        }

        $data['activity'] = $this->rfqs_model->get_order_activity($id);
        $data['order']  = $order;
        $this->load->view('admin/purchaseorders/purchaseorder_preview_template', $data);
    }

    public function get_purchaseorders_total(){
        if(!has_permission('rfq')){
            access_denied('rfq');
        }
        if($this->input->post()){
            $data['totals'] = $this->rfqs_model->get_purchaseorders_total($this->input->post());
            $this->load->model('currencies_model');
            $base_currency = $this->currencies_model->get_base_currency()->id;
            if(is_using_multiple_currencies('tblpurchaseorders') || (total_rows('tblpurchaseorders',array('currency'=>$base_currency)) == 0) && total_rows('tblpurchaseorders') > 0){
                $this->load->model('currencies_model');
                $data['currencies'] = $this->currencies_model->get();
            }
            $this->load->view('admin/purchaseorders/purchaseorders_total_template',$data);
        }
    }

    /* Send order to email */
    public function send_to_email($id)
    {
         if(!has_permission('rfq')){
            access_denied('rfq');
         }
        $success = $this->rfqs_model->sent_order_to_client($id,'',$this->input->post('attach_pdf'));
        if ($success) {
            set_alert('success', _l('order_sent_to_client_success'));

        } else {
            set_alert('danger', _l('order_sent_to_client_fail'));
        }
        redirect(admin_url('purchaseorders/list_purchaseorders/' . $id));
    }

    /* Convert order to invoice */
    public function convert_to_invoice($id){

        if(!has_permission('rfq')){
            access_denied('rfq');
         }

        if(!$id){
            die('No order found');
        }

        $invoiceid = $this->rfqs_model->convert_to_invoice($id);

        if($invoiceid){
            set_alert('success',_l('order_convert_to_invoice_successfuly'));
            redirect(admin_url('invoices/list_invoices/'.$invoiceid));
        } else {
            redirect(admin_url('purchaseorders/list_purchaseorders/'.$id));
        }
    }

    /* Generates order PDF and senting to email of $send_to_email = true is passed */
    public function pdf($id, $send_to_email = false)
    {
        if(!has_permission('rfq')){
            access_denied('rfq');
        }

        if (!$id) {
            redirect(admin_url('rfqs/'));
        }

        $order = $this->rfqs_model->get($id);
		$order->items = $this->rfqs_model->get_rfqs_items_unit($id);
		//order["items"]=$items;
		
		
		$created_by=$this->staff_model->get($order->addedfrom);
		
		$order->createdby=$created_by->firstname." ".$created_by->lastname;
		
		$this->load->model('warehouse_model');
		$warehouses=$this->warehouse_model->get($order->warehouse);
        $order->warehouse=$warehouses->warehouse_name;
		
        $order_number = format_rfqsquote_number($order->number);
        $pdf              =   rqf_pdf($order);
        $pdf->Output($order_number . '.pdf', 'D');
    }
     public function change_order_status($status,$id){
          echo $this->rfqs_model->change_order_status($status,$id);
    }
    public function checkcreadit(){
        $invoice =  $this->rfqs_model->getinvoices($this->input->post('clientid'));
        $purchaseorders =  $this->rfqs_model->getpurchaseorders($this->input->post('clientid'));
        if($this->input->post('credit')){
            $this->rfqs_model->update_credit($this->input->post('credit'),$this->input->post('clientid'));
         }
        $client=  $this->rfqs_model->getcredit($this->input->post('clientid'));
        $creditbalance = $client->credit_limit-($purchaseorders->total+$invoice->total);
      
        if( $this->input->post('amount') > $creditbalance){
            echo json_encode(array('status'=>'0','creditbalance'=>$creditbalance));
        }else{
             echo  json_encode(array('status'=>'1','creditbalance'=>$creditbalance));
        }
        
        
        
    }
    public function get_contacts(){
       $contacts =  $this->rfqs_model->get_contacts($this->input->post('id'));
       $html = "<option value=''></option>";
       foreach ($contacts as $value) {
          $html .= "<option value='$value->id'>$value->firstname $value->lastname</opyion>"; 
       }
       echo json_encode(array('contacts'=>$html));
    }
     public function get_orders_total(){
        if(!has_permission('rfq')){
            access_denied('rfq');
        }
        if($this->input->post()){
            $data['totals'] = $this->rfqs_model->get_orders_total($this->input->post());
            $this->load->model('currencies_model');
            $base_currency = $this->currencies_model->get_base_currency()->id;
            if(is_using_multiple_currencies('tblpurchaseorders') || (total_rows('tblpurchaseorders',array('currency'=>$base_currency)) == 0) && total_rows('tblpurchaseorders') > 0){
                $this->load->model('currencies_model');
                $data['currencies'] = $this->currencies_model->get();
            }
            $this->load->view('admin/purchaseorders/purchaseorder_total_template',$data);
        }
    }

}
