<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Quotes_rep extends Admin_controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('estimates_model');
    }

    public function index() 
    {    
    	$clientid = "";
    	$status = "";
    	$from = "";
    	$to = "";
    	$filter_by = "";
    	$quotes = "";
		if ($this->input->post()) {
	       // echo "<pre>";
	       // print_r($this->input->post());
	       // die;

	       $filter_by = $this->input->post('filter_by');
	       if($this->input->post('filter_by') == "customer")
	       {
		       $clientid = $this->input->post('clientid');
	       }

	       if($this->input->post('filter_by') == "status")
	       {
		       $status = $this->input->post('status');
	       }
	       // echo $from_dt = $this->input->post('from');
	        $from_var = $this->input->post('from');
        	$from_dt = str_replace('/', '-', $from_var);
	        $from = date('Y-m-d',strtotime($from_dt));

	       	$var = $this->input->post('to');
        	$to_dt = str_replace('/', '-', $var);
	       	$to = date('Y-m-d',strtotime($to_dt));
	       
			$quotes = $this->estimates_model->get_list($clientid,$status,$from,$to);
	    }
	    $data['user_id'] = $clientid;
	    $data['status'] = $status;
	    $data['filter_by'] = $filter_by;
	    $data['quotes'] = $quotes;

		$this->load->model('clients_model');
		$data['clients'] = $this->clients_model->get();
		$data['title'] = _l('quotes_report');
		$this->load->view('admin/reports/quotes_report', $data);
    }

    public function pdf($from_date = "",$to_date = "")
    {	
    	$quotes = "";
    	if($from_date != "" || $to_date != "")
    	{
    		
    		$quotes = $this->estimates_model->get_quoterpdf($from_date,$to_date);
    	}

        $pdf = estimate_report_pdf($quotes,$from_date,$to_date);
        $pdf->Output('quotes_report.pdf', 'D');
    }

    public function excel($from_date = "",$to_date = "")
    {

    	$quotes = "";
    	if($from_date != "" || $to_date != "")
    	{
    		
    		$quotes = $this->estimates_model->get_quoterpdf($from_date,$to_date);
    	}

       $this->load->library('excel');
		//activate worksheet number 1
		$this->excel->setActiveSheetIndex(0);
		//name the worksheet
		$this->excel->getActiveSheet()->setTitle('Quotes Report');
		//set cell A1 content with some text
		
		$this->excel->getActiveSheet()->setCellValue('A2', get_option('invoice_company_name'));
		$this->excel->getActiveSheet()->getStyle('A2')->getFont()->setBold(true);
		// $this->excel->getActiveSheet()->getStyle('A2')->getFont()->setBold(true)->setName('freesans');
		$this->excel->getActiveSheet()->getStyle('A2')->getFont()->setSize(14);

		$this->excel->getActiveSheet()->setCellValue('A3', get_option('invoice_company_address'));
		$this->excel->getActiveSheet()->getStyle('A3')->getAlignment()->setWrapText(true);
		
		$this->excel->getActiveSheet()->setCellValue('A4', get_option('invoice_company_city').','.get_option('invoice_company_state').",".get_option('invoice_company_postal_code'));
		$this->excel->getActiveSheet()->setCellValue('A5', get_country_name(get_option('invoice_company_country_code')));
		if(get_option('invoice_company_phonenumber') != '')
		{
			$this->excel->getActiveSheet()->setCellValue('A6', 'P:'.get_option('invoice_company_phonenumber'));
		}

		$this->excel->getActiveSheet()->setCellValue('F2', _l('quote_report'));
		$this->excel->getActiveSheet()->getStyle('F2')->getFont()->setBold(true);
		$this->excel->getActiveSheet()->getStyle('F2')->getFont()->setSize(14);

		$this->excel->getActiveSheet()->setCellValue('F3', _l('run_date').': '._d(date('Y-m-d')));
		if (!empty($from_date)) 
		{
			$this->excel->getActiveSheet()->setCellValue('F4', _l('quote_from_date').': '._d($from_date));
		}

		if (!empty($to_date)) 
		{
			$this->excel->getActiveSheet()->setCellValue('F5', _l('quote_to_date').': '._d($to_date));
		}

		 if($quotes == "")
        {
            $count_quotes = 0;
        }
        else
        {
            $count_quotes = count($quotes);
        }

		$this->excel->getActiveSheet()->setCellValue('F6', _l('quote_count').': '.$count_quotes);

		$this->excel->getActiveSheet()->setCellValue('A9', _l('estimate_dt_table_heading_number'));
		$this->excel->getActiveSheet()->setCellValue('B9', _l('estimate_dt_table_heading_date'));
		$this->excel->getActiveSheet()->setCellValue('C9', _l('invoice_dt_table_heading_client'));
		$this->excel->getActiveSheet()->setCellValue('D9', _l('estimate_dt_table_heading_amount'));
		$this->excel->getActiveSheet()->setCellValue('E9', _l('estimate_dt_table_heading_duedate'));
		$this->excel->getActiveSheet()->setCellValue('F9', _l('estimate_dt_table_heading_status'));

		$i = 10;
		if($quotes != "")
		{
			foreach ($quotes as $key => $quote) 
			{
				$this->excel->getActiveSheet()->setCellValue('A'.$i, format_estimate_number($quote->number));
				$this->excel->getActiveSheet()->setCellValue('B'.$i, date('d/m/Y',strtotime($quote->date)));
				$this->excel->getActiveSheet()->setCellValue('C'.$i, $quote->accountname);
				$this->excel->getActiveSheet()->setCellValue('D'.$i, format_money($quote->total,$quote->symbol));
				$this->excel->getActiveSheet()->setCellValue('E'.$i, date('d/m/Y',strtotime($quote->expirydate)));
				$this->excel->getActiveSheet()->setCellValue('F'.$i, $this->format_estimatestatus($quote->status));
				$i++;
			}
		}

		// $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
		$this->excel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
		$this->excel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
		$this->excel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
		$this->excel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
		$this->excel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
		$this->excel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);

		$styleArray = array(
		    'font'  => array(
		        'bold'  => true,
		        'color' => array('rgb' => 'ffffff'),
		        'size'  => 15,
		        // 'name'  => 'Verdana'
		    ),
		    // 'alignment' => array(
	     //        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
	     //    )

		);

		$this->excel->getActiveSheet()->getStyle('A9:F9')->applyFromArray($styleArray);

		$this->excel->getActiveSheet()->getStyle('A9:F9')
		->applyFromArray(
	        array(
	            'fill' => array(
	                'type' => PHPExcel_Style_Fill::FILL_SOLID,
	                'color' => array('rgb' => '3A4656')
	            )
	        )
   		);

		//change the font size
		//make the font become bold
		//merge cell A1 until D1
		// $this->excel->getActiveSheet()->mergeCells('A1:D1');
		//set aligment to center for that merged cell (A1 to D1)
		// $this->excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

		// PHPExcel_Shared_Font::setAutoSizeMethod(PHPExcel_Shared_Font::AUTOSIZE_METHOD_EXACT);

		$filename='Quotes Report.xls'; //save our workbook as this file name
		header('Content-Type: application/vnd.ms-excel'); //mime type
		header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
		header('Cache-Control: max-age=0'); //no cache
		             
		//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
		//if you want to save it as .XLSX Excel 2007 format
		$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
		//force user to download the Excel file without writing it to server's HD
		$objWriter->save('php://output');
	}
	


	function format_estimatestatus($status, $classes = '', $label = true)
	{
	    $estimatestatus = ""; 
	    if ($status == 1) {
	        $estimatestatus      = _l('estimate_status_draft');
	        // $label_class = 'default';
	    } else if ($status == 2) {
	        $estimatestatus      = _l('estimate_status_sent');
	        // $label_class = 'info';
	    } else if ($status == 3) {
	        $estimatestatus      = _l('estimate_status_declined');
	        // $label_class = 'danger';
	    } else if ($status == 4) {
	        $estimatestatus      = _l('estimate_status_accepted');
	        // $label_class = 'success';
	    } else {
	        // status 5
	        $estimatestatus      = _l('estimate_status_expired');
	        // $label_class = 'warning';
	    }

	    return $estimatestatus;

	    
	}

}