<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Locations extends Admin_controller {

    function __construct() {
        parent::__construct();
         $this->load->model('locations_model');
    }

    public function index() {
        if ($this->input->is_ajax_request()) {
            $aColumns = array('tblwarehouse.warehouse_name','location_name', 'stock_type', 'length' ,'width' ,'height','volume','remarks');
            $sIndexColumn = "location_id";
            $sTable = 'tbllocations';
            $join = array(
                'LEFT JOIN tblwarehouse ON tblwarehouse.ware_id = tbllocations.ware_id'
            );
            $where= array('where tbllocations.active = 1');
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join,$where, array('location_name', 'location_id', 'tbllocations.active'));
            $output = $result['output'];
            $rResult = $result['rResult'];
            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                    $row[] = $_data;
                }                
                $options = icon_btn('#','pencil-square-o','edit-locations',array('data-id'=>$aRow['location_id']));
                $row[]  = $options .= icon_btn('admin/locations/delete/' . $aRow['location_id'], 'remove', '', array('data-toggle' => 'tooltip','onClick' => 'return deleteconf();','title' => _l('location_delete_tooltip')));
                    
                $output['aaData'][] = $row;
            }
            echo json_encode($output);
            die();
        }
        $data['warehouse']=  $this->locations_model->get_warehouse();
        $data['title'] = _l('locations');
        $this->load->view('admin/locations/manage', $data);
    }
    
      /* List all invoices datatables */

    public function list_locations($id = false, $ware_id = false, $active = false) {
        $has_permission = has_permission('manageSales');

        if (!$has_permission && !$this->input->is_ajax_request()) {
            access_denied('manageSales');
        }


        if ($this->input->is_ajax_request()) {
            // From client profile
            if (is_numeric($ware_id)) {
                if (!$has_permission) {
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array('location_name', 'stock_type','remarks', 'length' ,'width' ,'height','volume');
            

            $where = array();
            if($active=='1') { $where=$where; }
            if($active=='0') { $where=array('and active = 1'); }
            
            
            $sIndexColumn = "location_id";
            $sTable = 'tbllocations';

            $join = array(
                'LEFT JOIN tblwarehouse ON tblwarehouse.ware_id = tbllocations.ware_id'
            );
            
            
            if($active=='1') { $where= array('where tbllocations.ware_id=' . $ware_id .''); }
            else if($active=='0') { $where= array('where tbllocations.ware_id=' . $ware_id .' and tbllocations.active = 1');}
            else { $where= array('where tbllocations.ware_id=' . $ware_id .' and tbllocations.active = 1'); }
            
            
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join,$where, array('location_name', 'location_id', 'tbllocations.active'));
            $output = $result['output'];
            $rResult = $result['rResult'];
           
            
            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                    $row[] = $_data;
                }                
                $options = icon_btn('#','pencil-square-o','edit-locations',array('data-id'=>$aRow['location_id']));
                $row[]  = $options .= icon_btn('#', 'remove', ' delete-locations', array('data-id'=>$aRow['location_id']));
                    
                $output['aaData'][] = $row;
            }
            echo json_encode($output);
            die();
        } 
    }
    
    public function getAll($active) {
        if ($this->input->is_ajax_request()) {
            if($active=='1') { $where=array(); }
            if($active=='0') { $where=array('where tbllocations.active = 1'); }
            //$aColumns = array('location_name', 'stock_type', 'length' ,'width' ,'height','volume','remarks');
            $aColumns = array('tblwarehouse.warehouse_name','location_name', 'stock_type', 'length' ,'width' ,'height','volume','remarks');
            $sIndexColumn = "location_id";
            $sTable = 'tbllocations';
            $join = array(
                'LEFT JOIN tblwarehouse ON tblwarehouse.ware_id = tbllocations.ware_id'
            );
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable,  $join, $where, array('location_name', 'location_id', 'tbllocations.active'));
            $output = $result['output'];
            $rResult = $result['rResult'];
            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                    $row[] = $_data;
                }                
                $options = icon_btn('#','pencil-square-o','edit-locations',array('data-id'=>$aRow['location_id']));
                $row[]  = $options .= icon_btn('admin/locations/delete/' . $aRow['location_id'], 'remove', '', array('data-toggle' => 'tooltip', 'title' => _l('location_delete_tooltip')));
                    
                $output['aaData'][] = $row;
            }
            echo json_encode($output);
            die();
        }
        $data['title'] = _l('locations');
        $this->load->view('admin/locations/manage', $data);
    }
    
    public function add_location(){
        $this->locations_model->add_location_details();  
         redirect(admin_url('locations'));
    }

    public function addlocation(){
        $id = $this->locations_model->add_location_details();  
        echo $id;
    }

    public function updatelocation(){
        $id = $this->locations_model->update_location_details();  
        echo $id;
    }
    
     public function get_locations(){
        $id     = $this->input->post('id');
        $result = $this->locations_model->get_location_details($id);
        echo json_encode($result);
        
    }
    
     public function update_location(){
        $this->locations_model->update_location_details();  
        redirect(admin_url('locations'));
    }
    
    public function delete($id) {
        if (!$id) {
            redirect(admin_url('locations'));
        }
        $response = $this->locations_model->delete($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('location_lowercase')));
        } else if ($response == true) {
            set_alert('success', _l('deleted', _l('location_lowercase')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('location_lowercase')));
        }
        redirect(admin_url('locations'));
    }
    
    public function delete_locations()
    {
        $id=  $this->input->post('id');
        $response = $this->locations_model->delete($id);
       echo $response;     
    }

        public function changestatus(){
    echo $this->locations_model->changestatus();
    }

}
