<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Items_sales extends Admin_controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('invoices_model');
    }

    public function index() 
    {    
    	
    	$category_id = "";
    	$date = "";
    	$from = "";
    	$to = "";
    	$date_type = "";
    	$today_date = "";
    	
    	$invoices = "";

		if ($this->input->post()) {
	       // echo "<pre>";
	       // print_r($this->input->post());
	       // die;

	        // $date = $this->input->post('date');
	        if($this->input->post('date') == "custom")
	        {
		        if($this->input->post('from') != "")
		        {
			        $from_var = $this->input->post('from');
		        	$from_dt = str_replace('/', '-', $from_var);
			        $from = date('Y-m-d',strtotime($from_dt));
			    }

			    if($this->input->post('to') != "")
			    {
			       	$var = $this->input->post('to');
		        	$to_dt = str_replace('/', '-', $var);
			       	$to = date('Y-m-d',strtotime($to_dt));
			    }
			    $date = "";
			    $date_type = $this->input->post('date');
	        }
	        else if($this->input->post('date') == "today")
	        {
	       		$today_date = date('Y-m-d');
	       		$date_type = $this->input->post('date');
	        }
	        else if($this->input->post('date') == "this_week")
	        {
	       		$date = date('Y-m-d',strtotime('monday this week'));

	       		$date_type = $this->input->post('date');
	        }
	        else if($this->input->post('date') == "this_month")
	        {
	       		$date = date('Y-m-01');
	       		$date_type = $this->input->post('date');
	        }
	        else if($this->input->post('date') == "this_year")
	        {
	       		$date = date('Y-01-01');
	       		$date_type = $this->input->post('date');
	        }

	        if($this->input->post('category_id') != "")
	        {
		       $category_id = $this->input->post('category_id');
	        }
	       // echo $from_dt = $this->input->post('from');

	        
			$sale_items = $this->invoices_model->get_sale_item_list($category_id,$date,$today_date,$from,$to);
	       
	    }
	    $data['user_id'] = $clientid;
	    $data['category_id'] = $category_id;
	    $data['date'] = $date_type;
	    $data['sale_items'] = $sale_items;
	    $data['from'] = $from;
	    $data['to'] = $to;

		$this->load->model('categories_model');
		$data['categories'] = $this->categories_model->get_category();
		$data['title'] = _l('sales_by_item');
		$this->load->view('admin/reports/items_sales', $data);
    }

    public function pdf($category_id = "",$date = "",$from_date = "",$to_date = "")
    {	
    	// echo $date;
    	// die;
    	$sale_items = "";

    	if($date != "")
    	{
    		// if($this->input->post('date') == "custom")
	     //    {
		    //     if($this->input->post('from') != "")
		    //     {
			   //      $from_var = $this->input->post('from');
		    //     	$from_dt = str_replace('/', '-', $from_var);
			   //      $from = date('Y-m-d',strtotime($from_dt));
			   //  }

			   //  if($this->input->post('to') != "")
			   //  {
			   //     	$var = $this->input->post('to');
		    //     	$to_dt = str_replace('/', '-', $var);
			   //     	$to = date('Y-m-d',strtotime($to_dt));
			   //  }
			   //  $date = "";
			   //  $date_type = $this->input->post('date');
	     //    }
	        if($date == "today")
	        {
	       		$today_date = date('Y-m-d');
	       		$date_type = $this->input->post('date');
	        }
	        else if($date == "this_week")
	        {
	       		$date = date('Y-m-d',strtotime('monday this week'));

	       		$date_type = $this->input->post('date');
	        }
	        else if($date == "this_month")
	        {
	       		$date = date('Y-m-01');
	       		$date_type = $this->input->post('date');
	        }
	        else if($date == "this_year")
	        {
	       		$date = date('Y-01-01');
	       		$date_type = $this->input->post('date');
	        }
	    }

    	if($from_date != "" || $to_date != "" || $category_id != "")
    	{
    		
    		$sale_items = $this->invoices_model->get_sale_item_pdf($category_id,$date,$today_date,$from_date,$to_date);

    	}
    	
        $pdf = sale_items_report_pdf($sale_items,$from_date,$to_date);
        $pdf->Output('sale_item_report.pdf', 'D');
    }

    public function excel($category_id = "",$date = "",$from_date = "",$to_date = "")
    {
    	$sale_items = "";
    	
    	if($date != "")
    	{
    		// if($this->input->post('date') == "custom")
	     //    {
		    //     if($this->input->post('from') != "")
		    //     {
			   //      $from_var = $this->input->post('from');
		    //     	$from_dt = str_replace('/', '-', $from_var);
			   //      $from = date('Y-m-d',strtotime($from_dt));
			   //  }

			   //  if($this->input->post('to') != "")
			   //  {
			   //     	$var = $this->input->post('to');
		    //     	$to_dt = str_replace('/', '-', $var);
			   //     	$to = date('Y-m-d',strtotime($to_dt));
			   //  }
			   //  $date = "";
			   //  $date_type = $this->input->post('date');
	     //    }
	        if($date == "today")
	        {
	       		$today_date = date('Y-m-d');
	       		$date_type = $this->input->post('date');
	        }
	        else if($date == "this_week")
	        {
	       		$date = date('Y-m-d',strtotime('monday this week'));

	       		$date_type = $this->input->post('date');
	        }
	        else if($date == "this_month")
	        {
	       		$date = date('Y-m-01');
	       		$date_type = $this->input->post('date');
	        }
	        else if($date == "this_year")
	        {
	       		$date = date('Y-01-01');
	       		$date_type = $this->input->post('date');
	        }
	    }

    	if($from_date != "" || $to_date != "" || $category_id != "")
    	{
    		
    		$sale_items = $this->invoices_model->get_sale_item_pdf($category_id,$date,$today_date,$from_date,$to_date);

    	}

       $this->load->library('excel');
		//activate worksheet number 1
		$this->excel->setActiveSheetIndex(0);
		//name the worksheet
		$this->excel->getActiveSheet()->setTitle('Sales By Item');
		//set cell A1 content with some text
		
		$this->excel->getActiveSheet()->setCellValue('A2', get_option('invoice_company_name'));
		$this->excel->getActiveSheet()->getStyle('A2')->getFont()->setBold(true);
		// $this->excel->getActiveSheet()->getStyle('A2')->getFont()->setBold(true)->setName('freesans');
		$this->excel->getActiveSheet()->getStyle('A2')->getFont()->setSize(14);

		// $this->excel->getActiveSheet()->setCellValue('A3', nl2br(get_option('invoice_company_address')));

		$this->excel->getActiveSheet()->setCellValue('A3', get_option('invoice_company_address'));
		$this->excel->getActiveSheet()->getStyle('A3')->getAlignment()->setWrapText(true);
		
		$this->excel->getActiveSheet()->setCellValue('A4', get_option('invoice_company_city').','.get_option('invoice_company_state').",".get_option('invoice_company_postal_code'));
		$this->excel->getActiveSheet()->setCellValue('A5', get_country_name(get_option('invoice_company_country_code')));
		if(get_option('invoice_company_phonenumber') != '')
		{
			$this->excel->getActiveSheet()->setCellValue('A6', 'P:'.get_option('invoice_company_phonenumber'));
		}

		$this->excel->getActiveSheet()->setCellValue('F2', _l('sales_by_item'));
		$this->excel->getActiveSheet()->getStyle('F2')->getFont()->setBold(true);
		$this->excel->getActiveSheet()->getStyle('F2')->getFont()->setSize(14);

		$this->excel->getActiveSheet()->setCellValue('F3', _l('run_date').': '._d(date('Y-m-d')));
		if (!empty($from_date)) 
		{
			$this->excel->getActiveSheet()->setCellValue('F4', _l('sales_by_item_from_date').': '._d($from_date));
		}

		if (!empty($to_date)) 
		{
			$this->excel->getActiveSheet()->setCellValue('F5', _l('sales_by_item_to_date').': '._d($to_date));
		}

		if($sale_items == "")
		{
		    $count_sale_items = 0;
		}
		else
		{
		    $count_sale_items = count($sale_items);
		}

		$this->excel->getActiveSheet()->setCellValue('F6', _l('sale_items_count').': '.$count_sale_items);

		$this->excel->getActiveSheet()->setCellValue('A9', _l('item_number'));
		$this->excel->getActiveSheet()->setCellValue('B9', _l('description'));
		$this->excel->getActiveSheet()->setCellValue('C9', _l('category'));
		$this->excel->getActiveSheet()->setCellValue('D9', _l('sub_category'));
		$this->excel->getActiveSheet()->setCellValue('E9', _l('invoice_number'));
		$this->excel->getActiveSheet()->setCellValue('F9', _l('unit_quantity'));

		$i = 10;
		if($sale_items != "")
		{
			foreach ($sale_items as $key => $sale_item) 
			{
				$this->excel->getActiveSheet()->setCellValue('A'.$i, $sale_item->sku);
				$this->excel->getActiveSheet()->setCellValue('B'.$i, $sale_item->description);
				$this->excel->getActiveSheet()->setCellValue('C'.$i, $sale_item->category_name);
				$this->excel->getActiveSheet()->setCellValue('D'.$i, $sale_item->subcategory_name);
				$this->excel->getActiveSheet()->setCellValue('E'.$i, format_invoice_number($sale_item->number));
				$this->excel->getActiveSheet()->setCellValue('F'.$i, $sale_item->quantity );
				$i++;
			}
		}

		// $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
		$this->excel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
		$this->excel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
		$this->excel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
		$this->excel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
		$this->excel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
		$this->excel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);

		$styleArray = array(
		    'font'  => array(
		        'bold'  => true,
		        'color' => array('rgb' => 'ffffff'),
		        'size'  => 15,
		        // 'name'  => 'Verdana'
		    ),
		    // 'alignment' => array(
	     //        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
	     //    )

		);

		$this->excel->getActiveSheet()->getStyle('A9:F9')->applyFromArray($styleArray);

		$this->excel->getActiveSheet()->getStyle('A9:F9')
		->applyFromArray(
	        array(
	            'fill' => array(
	                'type' => PHPExcel_Style_Fill::FILL_SOLID,
	                'color' => array('rgb' => '3A4656')
	            )
	        )
   		);

		//change the font size
		//make the font become bold
		//merge cell A1 until D1
		// $this->excel->getActiveSheet()->mergeCells('A1:D1');
		//set aligment to center for that merged cell (A1 to D1)
		// $this->excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

		// PHPExcel_Shared_Font::setAutoSizeMethod(PHPExcel_Shared_Font::AUTOSIZE_METHOD_EXACT);

		$filename='Sale By Item.xls'; //save our workbook as this file name
		header('Content-Type: application/vnd.ms-excel'); //mime type
		header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
		header('Cache-Control: max-age=0'); //no cache
		             
		//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
		//if you want to save it as .XLSX Excel 2007 format
		$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
		//force user to download the Excel file without writing it to server's HD
		$objWriter->save('php://output');
	}

	function format_invoicestatus($status, $classes = '', $label = true)
	{
	    $invoicestatus ="";

	    if ($status == 1) {
	        $invoicestatus      = _l('invoice_status_unpaid');
	    } else if ($status == 2) {
	        $invoicestatus      = _l('invoice_status_paid');
	        // $label_class = 'success';
	    } else if ($status == 3) {
	        $invoicestatus      = _l('invoice_status_not_paid_completely');
	        // $label_class = 'warning';
	    } else {
	        // status 4
	        $invoicestatus      = _l('invoice_status_overdue');
	        // $label_class = 'warning';
	    }

	    return $invoicestatus;
	}
}