<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Item_departments extends Admin_controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('itemdepartments_model');
        if (!has_permission('manageDepartments')) {
            access_denied('manageDepartments');
        }
    }

    /* List all departments */
    public function index()
    {
        if ($this->input->is_ajax_request()) {
            $aColumns     = array(
                'name',
                'is_active',
            );
            $sIndexColumn = "departmentid";
            $sTable       = 'tbltemdepartments';

            $result  = data_tables_init($aColumns, $sIndexColumn, $sTable,array(),array(),array('departmentid'));
            $output  = $result['output'];
            $rResult = $result['rResult'];

                 foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                 
                    if ($aColumns[$i] == 'is_active') {
                        if ($aRow['is_active'] == '0') {
                            $_data = '<input class="ischeckbox" data-rowtype="department" data-rowid="' . $aRow['departmentid'] . '" value="' . $aRow['is_active'] . '" type="checkbox"/>';
                        } else {
                            $_data = '<input class="ischeckbox" data-rowtype="department" data-rowid="' . $aRow['departmentid'] . '" checked="checked" value="' . $aRow['is_active'] . '" type="checkbox"/>';
                        }
                    }
                    $row[] = $_data;
                }

                $options = icon_btn('#', 'pencil-square-o', 'edititemdepartment', array('data-id' => $aRow['departmentid']));
                $row[] = $options .= icon_btn('admin/item_departments/delete/' . $aRow['departmentid'], 'remove', '',array('onClick' => 'return deleteconf();'));

                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }
        $data['title'] = _l('departments');
        $this->load->view('admin/itemdepartments/manage', $data);
    }

    public function adddepartment() {
        $this->itemdepartments_model->adddepartment();
        redirect(admin_url('item_departments'));
    }

    public function add_department($value='')
    {
        $id = $this->itemdepartments_model->adddepartment();
        echo $id;
    }

    public function update_department($value='')
    {
        // print_r($this->input->post());
        // die;
        $id = $this->itemdepartments_model->editdepartment();
        echo $id;
    }

    public function updatedepartment() {
        $this->itemdepartments_model->editdepartment();
        redirect(admin_url('item_departments'));
    }

    public function changestatus() {
        echo $this->itemdepartments_model->changestatus();
    }

    public function getdatadapartment() {
        echo $this->itemdepartments_model->getdatadapartment();
    }
    /* Delete department from database */
    public function delete($id)
    {
        if (!$id) {
            redirect(admin_url('item_departments'));
        }

        $response = $this->itemdepartments_model->delete($id);
        if (is_array($response) && isset($response['referenced'])) {
           set_alert('warning',_l('is_referenced',_l('department_lowercase')));
        } else if ($response == true) {
           set_alert('success', _l('deleted',_l('department')));
        } else {
            set_alert('warning', _l('problem_deleting',_l('department_lowercase')));
        }

        redirect(admin_url('Item_departments'));
    }

}
