<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Internal_transfer extends Admin_controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('internal_transfer_model');
    }

    
    public function index($id = '')
    {
      
      $data['internal_transfers'] = $this->internal_transfer_model->get_list();

      $title = _l('internal_transfers');
      
      $data['title'] = $title;
	 
      $this->load->view('admin/internal_transfer/manage',$data);
    }

    public function internal_transfer($id = '')
    {
      
      if($this->input->post() && !$this->input->is_ajax_request())
      {
  			if(!has_permission('manageInternalTransfer')){
  				access_denied('manageInternalTransfer');
  			}

			  if($id == '')
        {
          // echo "<pre>";
          // print_r($this->input->post());
          // die;
				  $id = $this->internal_transfer_model->transfer_bin($this->input->post());
          if ($id) {
            set_alert('success', _l('internal_transfer'));
            redirect(admin_url('internal_transfer/internal_transfer'));
          } else {
            redirect(admin_url('internal_transfer/internal_transfer'));
          }                    
			  }
		  }

  		if($id == ''){
      } 
  		$title = _l('internal_transfer');

	        
      $data['from_warehouse'] = $this->internal_transfer_model->get_warehouse();
      $data['to_warehouse'] = $this->internal_transfer_model->get_warehouse();

      $this->load->model('taxes_model');
      $data['taxes'] = $this->taxes_model->get();
      $this->load->model('discount_model');
      $data['discount'] = $this->discount_model->get_discounts();
               
                
      $data['title'] = $title;
		  $this->load->view('admin/internal_transfer/internal_transfer',$data);
    }

    public function get_location()
    {
    	$ware_id =  $this->input->post('ware_id');
      $location = $this->internal_transfer_model->get_location($ware_id);
      $options ='<option value=""></option>';
      if(isset($location))
      {
          foreach ($location as $value) 
          {
            $options .='<option value="'.$value->location_id.'">'.$value->location_name.'</option>';   
          }
      }
      echo json_encode(array('options'=>$options));
    }

    public function get_item($value='')
    {
        $location_id =  $this->input->post('location_id');
        $warehouse_id =  $this->input->post('warehouse_id');
       
        $location = $this->internal_transfer_model->get_item($location_id,$warehouse_id);

        // $options ='<option value=""></option>';
        //   if(isset($location)){
        //       foreach ($location as $value) {
        //        $options .='<option value="'.$value->location_id.'">'.$value->location_name.'</option>';   
        //       }
        //   }
         echo json_encode($location);
    }

    public function unsel_location()
    {
      $location_id =  $this->input->post('location_id');
      $ware_id =  $this->input->post('ware_id');
       
        $location = $this->internal_transfer_model->unsel_location($location_id,$ware_id);
        $options ='<option value=""></option>';
          if(isset($location)){
              foreach ($location as $value) {
               $options .='<option value="'.$value->location_id.'">'.$value->location_name.'</option>';   
              }
          }
          echo json_encode(array('options'=>$options));
    }

    public function get_internal_transfer_data_ajax($id)
    {
      // echo $id;
      // die;
      $data['internal_transfer'] = $this->internal_transfer_model->get_internaltransfer($id);
      $data['internal_transfer_item'] = $this->internal_transfer_model->get_internaltransfer_item($id);
      $this->load->view('admin/internal_transfer/internal_transfer_preview', $data);
    }
}