<?php ob_start();
header('Content-Type: text/html; charset=utf-8');
defined('BASEPATH') OR exit('No direct script access allowed');

class Grns extends Admin_controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('grn_model');
    }

    /* Get all invoices in case user go on index page */
    public function index($id = false)
    {
        $this->list_grns($id);
    }

    /* List all invoices datatables */
    public function list_grns($id = false, $clientid = false)
    {
        // $has_permission = has_permission('manageGrn');
        $has_permission = has_permission('grn');

         if(!$has_permission && !$this->input->is_ajax_request()){
            // access_denied('manageGrn');
            access_denied('grn');
         }

        $_custom_view = '';
        $_status = '';

        if($this->input->get('custom_view')){
            $_custom_view = $this->input->get('custom_view');
        } else if($this->input->get('status')){
             $_status = $this->input->get('status');
        }

        if ($this->input->is_ajax_request()) {
            // From client profile
            if(is_numeric($clientid)){
                if(!$has_permission){
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'number',
                'date',
                'supplierid',
                'refrence',
             );

            $join = array(
                'LEFT JOIN tblsuppliers ON tblsuppliers.userid = tblgrns.supplierid',
//                'LEFT JOIN tblcurrencies ON tblcurrencies.id = tblinvoices.currency'
            );

            $where                    = array();

            if (is_numeric($clientid)) {
                $where                    = array(
                    'AND clientid=' . $clientid
                );

            }

            if ($this->input->post('status')) {
                array_push($where, 'AND status=' . $this->input->post('status'));
            }

          

            $sIndexColumn = "grnid";
            $sTable       = 'tblgrns';
            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array('grnid','supplier'));
            $output       = $result['output'];
            $rResult      = $result['rResult'];
  
            foreach ($rResult as $aRow) {
                $row = array();

                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data                    = $aRow[$aColumns[$i]];
                      if ($aColumns[$i] == 'number') {
                          // $_data =format_grn_number($aRow['number']);
                          $_data = '<a href="#" onclick="init_grn('.$aRow['grnid'].'); return false;">' . format_grn_number($aRow['number']) . '</a><br />';
                      }
                      if ($aColumns[$i] == 'supplierid') {
                          $_data ='<a href="' . admin_url('suppliers/supplier/' . $aRow['supplierid']) . '">' . $aRow['supplier'] . '</a>';
                      }
                      if ($aColumns[$i] == 'date') {
                          $_data =_d($aRow['date']);
                      }
                    $row[] = $_data;
                }
                $options='';
                
                 $options .= icon_btn('#','print','printonvoice',array('data-toggle' => 'tooltip', 'title' =>'Print Invoice','data-id'=>$aRow['grnid'],'data-hash'=>$aRow['hash']));
                 $options .= icon_btn('admin/grns/pdf/' . $aRow['grnid'],'download','',array('data-toggle' => 'tooltip', 'title' =>'Download Invoice'));
                $options .= icon_btn('#', 'eye','',array('data-toggle' => 'tooltip', 'title' =>'View Invoice', 'onclick'=>'init_grn('.$aRow['grnid'].'); return false;'));
                $row[] = $options;
                 $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        $data['invoiceid'] = '';
        if (is_numeric($id)) {
            $data['invoiceid'] = $id;
        }

        $data['custom_view'] = $_custom_view;
        $data['status'] = $_status;

        $data['bodyclass'] = 'small-table';
        $data['title']     = _l('invoices');
        $this->load->view('admin/grns/manage', $data);
    }
	public function get_grn_data_ajax($id)
	{
		// if(!has_permission('manageGrn')){
  //           access_denied('manageGrn');
  //       }

        if(!has_permission('grn')){
            access_denied('grn');
        }

        if (!$id) {
            die('No order found');
        }

        $order = $this->grn_model->get_grn($id);
        $data['po_id'] = $this->grn_model->get_poid($id);
   
		$data['rfq_id'] = $this->grn_model->get_rfqid($id);
      	
		$this->load->model('Bills_model');
       
        $data['someofbillsforpo'] = $this->grn_model->getbills_po($data['po_id']->id);
		$data['pur_total'] = $data['po_id']->pur_total;

        $data['activity'] = $this->grn_model->get_grn_activity($id);
        $data['order']  = $order;
	//	echo '<pre>';
	//	print_r($data);
        $this->load->view('admin/grns/grn_preview_template', $data);
	}
     /* Add new invoice or update existing */
    public function grn($customerid = '',$id = '')
    {
         // if(!has_permission('manageGrn')){
         //    access_denied('manageGrn');
         // }
$this->load->model('suppliers_model');
        if(!has_permission('grn')){
            access_denied('grn');
        }

        if ($this->input->post()) {
            if ($id == '') {
                // echo "<pre>";
                // print_r($this->input->post());
                // die;
                if(!has_permission('grn_add')){
                    access_denied('grn_add');
                }
                
               $id = $this->grn_model->add($this->input->post());       
        
                if ($id) {
                    
                    set_alert('success', _l('added_successfuly',_l('grn_lowercase')));
                    
                    if (trim($this->input->post('action')) == 'save') {
                          redirect(admin_url('grns/'));
                        exit;
                    }
                    if (trim($this->input->post('action')) == 'snew') {
                        redirect(admin_url('grns/grn'));
                        exit;
                    }
                 
                    if (trim($this->input->post('action')) == 'slist') {
                         redirect(admin_url('grns'));
                         
                    }
                    if (trim($this->input->post('action')) == 'cancel') {
                        redirect(admin_url());
                        exit;
                    }


                }
            } else {

                if(!has_permission('grn_edit')){
                    access_denied('grn_edit');
                }

                
                $success = $this->grn_model->update($this->input->post(), $id);
                if ($success) {
                   set_alert('success', _l('updated_successfuly',_l('grn_lowercase')));
                }
                     if (trim($this->input->post('action')) == 'save') {
                          redirect(admin_url('grns/'));
                        exit;
                    }
                    if (trim($this->input->post('action')) == 'snew') {
                        redirect(admin_url('grns/grn'));
                        exit;
                    }
                 
                    if (trim($this->input->post('action')) == 'slist') {
                         redirect(admin_url('grns/' ));
                         
                    }
                    if (trim($this->input->post('action')) == 'cancel') {
                        redirect(admin_url());
                        exit;
                    }
            }
        }
        if ($id == '') {
            $title = _l('create_new_grn');
        } else {
           
            $data['grn'] = $this->grn_model->get($id);   
       
            $data['edit'] = true;
            $title           = _l('edit',_l('grn_lowercase'));
        }

        $data['warehouses'] = $this->grn_model->get_warehouse();

        $this->load->model('suppliers_model');
        $data['supplier'] = $this->suppliers_model->get();
        $data['supplierdetails'] = $this->suppliers_model->get_client($customerid);
        $this->load->model('staff_model');
        $data['staff'] = $this->staff_model->get('',1);
        $data['uofm'] = $this->grn_model->get_uofm();
                     
        $data['title']     = $title;
        $data['bodyclass'] = 'grn';
		
		
		$this->load->model('purchaseorders_model');
        $po = $this->purchaseorders_model->get_po_by_status(4);
		$listPO=array();
		
		foreach($po as $p)
		{
			$p["items"]= $this->purchaseorders_model->get_purchaseorder_items($p["id"]);
			$listPO[]=$p;
		}
		// echo "<pre>";
  //       print_r($listPO);
  //       die;
		$data['po']=$listPO;
        $this->load->view('admin/grns/grn', $data);
    }


}
