<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Employee extends Admin_controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('employee_model');
    }

    public function index() 
    {    
      $data['employees'] = $this->employee_model->get_list();
      $data['department'] = $this->employee_model->get_departmentlist();
      $data['title'] = _l('employee');
      $this->load->view('admin/employee/manage', $data);
    }
    public function view($id = '')
	{
		$this->employee($id,true);
	}
    public function employee($id = '',$view_mode=false)
    {
       if ($this->input->post() && !$this->input->is_ajax_request()) {

          if ($id == '') 
          {
            $id = $this->employee_model->add($this->input->post());
           
              if ($id) {
				   $success = $this->employee_model->update($this->input->post(), $id);
                  set_alert('success', _l('added_successfuly', _l('employee')));
                  handle_emplyee_upload($id);
                      redirect(admin_url('employee/view/' . $id));
                      exit;
                  
              }
          } 
          else {
              // echo "<pre>";
              // print_r($this->input->post());
              // die;
              $success = $this->employee_model->update($this->input->post(), $id);
			  handle_emplyee_upload($id);
               set_alert('success', _l('updated_successfuly', _l('employee')));
                 
			  redirect(admin_url('employee/view/' . $id));
			  exit;
          }
        }

        if ($id == '') {
            $title = _l('add_new', _l('employee'));
        } else {
			
            $employee = $this->employee_model->get($id);
			 if (!$employee) {
                blank_page('Employee Not Found');
            }
			$data['employee'] = $employee;
            $title = $employee->firstname ." ". $employee->lastname;
			 

			
		}
           
            $data['banks'] = $this->employee_model->get_banks();
            $this->load->model('staff_model');
            $data['members'] = $this->staff_model->get('', 1);


            $this->load->model('race_model');
			
			
            $data['races'] = $this->race_model->get_list();

            $this->load->model('nationality_model');
            $data['nationalities'] = $this->nationality_model->get_list();

           
            $data['institutions'] = $this->employee_model->get_institutions();
            $data['grades'] = $this->employee_model->get_grades();
			
			$data['education'] = $this->employee_model->get_education();
            $data['contact'] = $this->employee_model->get_contact();
            /*$data['documents'] = $this->employee_model->get_document();
			$data['attachments'] = $this->employee_model->get_all_employee_attachments();*/

            $departments = $this->employee_model->getdepartments($id);
			
            
            $dep = array();
            foreach ($departments as $key => $value) {
              $dep[] = $value['department'];
            }
            // print_r($dep);
            // die;
            $data['department'] = $dep;
           
           
            // $this->load->model('payment_modes_model');
            // $data['payment_modes'] = $this->payment_modes_model->get();
            
            // Get all active staff members (used to add reminder)
            // $this->load->model('staff_model');
            // $data['members'] = $this->staff_model->get('', 1);
            // if ($this->input->is_ajax_request()) {
            //     AdminTicketsTable(array('userid' => $id));
            // }
            // $data['employee_groups'] = $this->clients_model->get_employee_groups($id);
      

        // $data['warehouses'] = $this->clients_model->get_warehouse();

        $acc = $this->employee_model->get_last_employee();
        if($acc){
          $res = explode('-',$acc->account_number);
        }else{
           $res = array();
        }
        if ($acc->account_number) {
            if(get_option('next_employee') >  $res[1] - 1) {
        
                $ac = get_option('employee_prefix') . get_option('employee_separator') . get_option('next_employee');
                $data['account_number'] = $ac;
            }else{
             $data['account_number'] = ++$acc->account_number;
            }
        } else {
            $ac = get_option('employee_prefix') . get_option('employee_separator') . get_option('employee_startnumber');
            $data['account_number'] = $ac;
        }


        $data['departments'] = $this->employee_model->get_departments();
        $data['salutation'] = $this->employee_model->get_salutation();
        $data['postion'] = $this->employee_model->get_postion();
        $data['roles'] = $this->employee_model->get_role();
        $this->load->model('currencies_model');
        $data['currencies'] = $this->currencies_model->get();
        // $data['clients'] = $this->clients_model->get();
             // $this->load->model('currencies_model');
        // $this->load->model('clients_model');
        // $this->load->model('contracts_model');
        $data['base_currency'] = $this->currencies_model->get_base_currency();
        // $data['types'] = $this->contracts_model->get_contract_types();
        // $data['staff'] = $this->staff_model->get('', 1);
        // $this->load->model('misc_model');
        // $data['employee_notes'] = $this->misc_model->get_employee_notes($id, 0);
        // $data['prev'] = $this->clients_model->get_prev_groups2();
        // $data['ledgers'] = $this->clients_model->get_ledgers();
        $data['title'] = $title;
		if($view_mode)
		$this->load->view('admin/employee/view', $data);
		else
        $this->load->view('admin/employee/employee', $data);
    }



    public function get_employee_reminders($id) 
    {
      if ($this->input->is_ajax_request()) {

          $aColumns = array('description', 'date', 'staff', 'isnotified');
          $sIndexColumn = "id";
          $sTable = 'tbladminemployeereminders';

          $where = array('AND empid=' . $id);
          $join = array(
              'JOIN tblstaff ON tblstaff.staffid = tbladminemployeereminders.staff'
          );
          $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array('firstname', 'lastname', 'id', 'creator'));
          $output = $result['output'];
          $rResult = $result['rResult'];

          foreach ($rResult as $aRow) {
              $row = array();
              for ($i = 0; $i < count($aColumns); $i++) {
                  $_data = $aRow[$aColumns[$i]];
                  if ($aColumns[$i] == 'staff') {
                      $_data = '<a href="' . admin_url('staff/profile/' . $aRow['staff']) . '">' . staff_profile_image($aRow['staff'], array(
                                  'staff-profile-image-small'
                              )) . ' ' . $aRow['firstname'] . ' ' . $aRow['lastname'] . '</a>';
                  } else if ($aColumns[$i] == 'staff') {
                      $_data = _d($_data);
                  } else if ($aColumns[$i] == 'isnotified') {
                      if ($_data == 1) {
                          $_data = _l('employee_reminder_is_notified_boolean_yes');
                      } else {
                          $_data = _l('employee_reminder_is_notified_boolean_no');
                      }
                  }
                  $row[] = $_data;
              }

              if ($aRow['creator'] == get_staff_user_id()) {
                  $row[] = icon_btn('admin/employee/delete_reminder/' . $id . '/' . $aRow['id'], 'remove', '');
              } else {
                  $row[] = '';
              }


              $output['aaData'][] = $row;
          }

          echo json_encode($output);
          die();
      }
    }

    public function add_employee_reminder($id) 
    {

        if ($this->input->post()) {
            $success = $this->employee_model->add_reminder($this->input->post(), $id);
            if ($success) {
                set_alert('success', _l('employee_reminder_added_successfuly'));
            }
        }

        redirect(admin_url('employee/employee/' . $id));
    }

    public function delete_reminder($empid, $id) 
    {
        if (!$id && !$empid) {
            die('No reminder found');
        }
        $success = $this->employee_model->delete_reminder($id);

        if ($success) {
            set_alert('success', _l('employee_reminder_deleted'));
        } else {
            set_alert('warning', _l('employee_reminder_failed_to_delete'));
        }

        redirect(admin_url('employee/employee/' . $id));
    }

    public function upload_attachment($id) {
        handle_employee_attachments_upload($id);
        // redirect(admin_url('employee/employee/' . $id));
    }

    public function get_attachments($id) {
        $data['empid'] = $id;
        $data['attachments'] = $this->employee_model->get_all_employee_attachments($id);
        $this->load->view('admin/employee/attachments_template', $data);
    }

    public function delete_attachment($id) {
        echo json_encode(array('success' => $this->employee_model->delete_attachment($id)));
    }

    public function notes($id) 
    {
      if ($this->input->is_ajax_request()) {

          $aColumns = array('description', 'staff','dateadded');
          $sIndexColumn = "empnoteid";
          $sTable = 'tblemployeeadminnotes';

          $where = array('AND empid=' . $id);
          $join = array(
              'JOIN tblstaff ON tblstaff.staffid = tblemployeeadminnotes.addedfrom'
          );
          $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array('firstname','lastname','empnoteid'));
          $output = $result['output'];
          $rResult = $result['rResult'];

          foreach ($rResult as $aRow) {
              $row = array();
              for ($i = 0; $i < count($aColumns); $i++) {
                  $_data = $aRow[$aColumns[$i]];
                  if ($aColumns[$i]== 'staff') {
                        $_data = '<a href="'.admin_url( 'profile/'.$aRow[ 'addedfrom']). '">'.$aRow[ 'firstname'] . ' ' . $aRow[ 'lastname'] . '</a>';
                  }
                  $row[] = $_data;
              }
              
                  $row[] = icon_btn('admin/misc/remove_employee_note/'. $aRow['empnoteid'] . '/' . $id .'/0', 'remove', '');

              $output['aaData'][] = $row;
          }

          echo json_encode($output);
          die();
      }
    }

    public function delete($id) {

        // check_access("employee","delete");

        if (!$id) {
            redirect(admin_url('employee'));
        }

        $response = $this->employee_model->delete($id);

        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('employee_lowercase')));
        } else if ($response == true) {
            set_alert('success', _l('deleted', _l('employee')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('employee_lowercase')));
        }

        redirect(admin_url('employee'));
    }

    public function education() 
    {
        if ($this->input->is_ajax_request()) {
            $data = $this->input->post();

            if ($data['id'] == '') {
                $success = $this->employee_model->add_education($data);
                $message = '';
                if ($success == true) {
                    $message = _l('added_successfuly', _l('education'));
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            } else {
        
                $success = $this->employee_model->edit_education($data);
                $message = '';
                if ($success == true) {
                    $message = _l('updated_successfuly', _l('education'));
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            }
        }
    }

    public function geteducation(){
      echo  json_encode($this->employee_model->geteducation());
    }

    public function delete_education($id,$empid)
    {
      $response = $this->employee_model->delete_education($id);
      
      if ($response == true) {
              set_alert('success', _l('deleted', _l('education')));
          } else {
              set_alert('warning', _l('problem_deleting', _l('education')));
          }

          redirect(admin_url('employee/employee/' . $empid));
    }

    public function document() 
    {
        if ($this->input->is_ajax_request()) {
            $data = $this->input->post();

            if ($data['id'] == '') {
                $success = $this->employee_model->add_document($data);
                $message = '';
                if ($success == true) {
                    $message = _l('added_successfuly', _l('document'));
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            } else {
        
                $success = $this->employee_model->edit_document($data);
                $message = '';
                if ($success == true) {
                    $message = _l('updated_successfuly', _l('document'));
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            }
        }
    }

    public function getdocument(){
      echo  json_encode($this->employee_model->getdocument());
    }

    public function delete_document($id,$empid)
    {
      $response = $this->employee_model->delete_document($id);
      
      if ($response == true) {
              set_alert('success', _l('deleted', _l('document')));
          } else {
              set_alert('warning', _l('problem_deleting', _l('document')));
          }

          redirect(admin_url('employee/employee/' . $empid));
    }

    public function contact() 
    {
        if ($this->input->is_ajax_request()) {
            $data = $this->input->post();
           
            if ($data['id'] == '') {
                $success = $this->employee_model->add_contact($data);
                $message = '';
                if ($success == true) {
                    $message = _l('added_successfuly', _l('contact'));
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            } else {
        
                $success = $this->employee_model->edit_contact($data);
                $message = '';
                if ($success == true) {
                    $message = _l('updated_successfuly', _l('contact'));
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            }
        }
    }

    public function getcontact(){
      echo  json_encode($this->employee_model->getcontact());
    }

    public function delete_contact($id,$empid)
    {
      $response = $this->employee_model->delete_contact($id);
      
      if ($response == true) {
              set_alert('success', _l('deleted', _l('contact')));
          } else {
              set_alert('warning', _l('problem_deleting', _l('contact')));
          }

          redirect(admin_url('employee/employee/' . $empid));
    }
}