<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Dictionary extends Admin_controller {

    function __construct() {
        parent::__construct();
        $this->load->model('departments_model');
    }

    public function index() {
        if ($this->input->is_ajax_request()) {

            $aColumns = array(
                // 'departmentid',
                'name',
                'is_active',
                'sort_order'
            );
            $sIndexColumn = "departmentid";
            $sTable = 'tbldepartments';
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join = array(), $where = array(), $additionalSelect = array('departmentid'));
            $output = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                    if ($aColumns[$i] == 'name') {
                        $_data = '<a href="' . admin_url('departments/department/' . $aRow['departmentid']) . '">' . $_data . '</a>';
                    }
                    if ($aColumns[$i] == 'is_active') {
                        if ($aRow['is_active'] == '0') {
                            $_data = '<input class="ischeckbox" data-rowtype="department" data-rowid="' . $aRow['departmentid'] . '" value="' . $aRow['is_active'] . '" type="checkbox"/>';
                        } else {
                            $_data = '<input class="ischeckbox" data-rowtype="department" data-rowid="' . $aRow['departmentid'] . '" checked="checked" value="' . $aRow['is_active'] . '" type="checkbox"/>';
                        }
                    }
                    $row[] = $_data;
                }

                $options = icon_btn('#', 'pencil-square-o', 'editdepartment', array('data-id' => $aRow['departmentid']));
                $row[] = $options .= icon_btn('admin/dictionary/delete/' . $aRow['departmentid'], 'remove', '');

                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }
        $data['title'] = _l('departments');
        $this->load->view('admin/dictionary/manage', $data);
    }
    /* Delete department from database */
    public function delete($id)
    {
        if (!$id) {
            redirect(admin_url('dictionary'));
        }

        $response = $this->departments_model->delete($id);
        if (is_array($response) && isset($response['referenced'])) {
           set_alert('warning',_l('is_referenced',_l('department_lowercase')));
        } else if ($response == true) {
           set_alert('success', _l('deleted',_l('department')));
        } else {
            set_alert('warning', _l('problem_deleting',_l('department_lowercase')));
        }

        redirect(admin_url('dictionary'));
    }
    public function salutation() {
        if ($this->input->is_ajax_request()) {
            $aColumns = array(
                //'sort_order',
                'description',
                'is_active',
                'sort_order'
            );
            $sIndexColumn = "id";
            $sTable = 'tblsalutation';

            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join = array(), $where = array(), $additionalSelect = array('id'), $orderby = 'ORDER BY sort_order ASC', $groupBy = '');
            $output = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                    if ($aColumns[$i] == 'is_active') {
                        if ($aRow['is_active'] == '0') {
                            $_data = '<input class="ischeckbox" data-rowtype="salutation" data-rowid="' . $aRow['id'] . '" value="' . $aRow['is_active'] . '" type="checkbox"/>';
                        } else {
                            $_data = '<input class="ischeckbox" data-rowtype="salutation" data-rowid="' . $aRow['id'] . '" checked="checked" value="' . $aRow['is_active'] . '" type="checkbox"/>';
                        }
                    }
                    $row[] = $_data;
                }

                $row[] = icon_btn('#', 'pencil-square-o', 'editsalutation', array('data-id' => $aRow['id']));

                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }
    }

    public function position() {
        if ($this->input->is_ajax_request()) {
            $aColumns = array(
                //'id',
                'description',
                'is_active',
                'sort_order'
            );
            $sIndexColumn = "id";
            $sTable = 'tblposition';

            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join = array(), $where = array(), $additionalSelect = array('id'), $orderby = 'ORDER BY sort_order ASC', $groupBy = '');
            $output = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                    if ($aColumns[$i] == 'is_active') {
                        if ($aRow['is_active'] == '0') {
                            $_data = '<input data-rowtype="position" class="ischeckbox" data-rowid="' . $aRow['id'] . '" value="' . $aRow['is_active'] . '" type="checkbox"/>';
                        } else {
                            $_data = '<input data-rowtype="position" class="ischeckbox" data-rowid="' . $aRow['id'] . '" checked="checked" value="' . $aRow['is_active'] . '" type="checkbox"/>';
                        }
                    }
                    $row[] = $_data;
                }

                $row[] = icon_btn('#', 'pencil-square-o', 'editposition', array('data-id' => $aRow['id']));

                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }
    }

    public function adddepartment() {
        $this->departments_model->adddepartment();
        redirect(admin_url('dictionary'));
    }

     public function add_department() {
        $id = $this->departments_model->adddepartment();
        echo $id;
    }

    public function addsalutation() {
         $this->departments_model->addsalutation();
         redirect(admin_url('dictionary'));
    }

    public function add_salutation() {
        $id = $this->departments_model->addsalutation();
        echo $id;
    }

    public function addposition() {
        $this->departments_model->addposition();
        redirect(admin_url('dictionary'));
    }

    public function add_position() {
        $id = $this->departments_model->addposition();
        echo $id;
    }

    public function updatedepartment() {
        $this->departments_model->editdepartment();
        redirect(admin_url('dictionary'));
    }
    public function update_department() {
        // print_r($this->input->post());
        // die;
        $id = $this->departments_model->editdepartment();
        echo $id;
    }

    public function updatesalutation() {
         $this->departments_model->editsalutation();
         redirect(admin_url('dictionary')); 
    }

    public function update_salutation() {
        $id = $this->departments_model->editsalutation();
        echo $id;
    }

    public function updateposition() {
         $this->departments_model->editposition();
         redirect(admin_url('dictionary'));
    }
    public function update_position() {
        $id = $this->departments_model->editposition();
        echo $id;
    }

    public function changestatus() {
        echo $this->departments_model->changestatus();
    }

    public function getdatadapartment() {
        echo $this->departments_model->getdatadapartment();
    }

    public function getdatasalutation() {
        echo $this->departments_model->getdatasalutation();
    }

    public function getdataposition() {
        echo $this->departments_model->getdataposition();
    }
       public function email_exists(){
        // First we need to check if the email is the same
        $departmentid = $this->input->post('departmentid');
        if ($departmentid != 'undefined') {
            $this->db->where('departmentid', $departmentid);
            $_current_email = $this->db->get('tbldepartments')->row();

            if ($_current_email->email == $this->input->post('email')) {
                echo json_encode(true);
                die();
            }
        }
        $exists = total_rows('tbldepartments',array('email'=>$this->input->post('email')));
        if($exists > 0){
            echo 'false';
        } else {
            echo 'true';
        }
    }

}
