<?php init_head(); ?>
<div id="wrapper">
	<div class="content">
		<div class="row">
			<?php include_once(APPPATH . 'views/admin/includes/alerts.php'); ?>
			<div class="col-md-12">
			<h2>Industries</h2>
				<div class="panel_s">
					<div class="panel-body">
					<div class="clearfix">
					<a href="#" onclick="new_source(); return false;" class="btn btn-info pull-left display-block"><?php echo _l('lead_new_industry'); ?></a>
					</div>
						<?php if(count($sources) > 0){ ?>
						<div class="table-responsive">
							<table class="table animated fadeIn mtop10">
								<thead>
									<th><?php echo _l('leads_sources_table_industry'); ?></th>
									<th><?php echo _l('options'); ?></th>
								</thead>
								<tbody>
									<?php foreach($sources as $source){ ?>
									<tr>
										<td><?php echo $source['name']; ?><br />
											<span class="text-muted">
												<?php echo _l('leads_table_total',total_rows('tblleads',array('industry'=>$source['id']))); ?>
											</span>
										</td>
										<td>
											<a href="#" onclick="edit_source(this,<?php echo $source['id']; ?>); return false" data-name="<?php echo $source['name']; ?>" class="btn btn-default btn-icon"><i class="fa fa-pencil-square-o"></i></a>
											<a href="<?php echo admin_url('leads/delete_industry/'.$source['id']); ?>" onClick="return deleteconf();" class="btn btn-danger btn-icon"><i class="fa fa-remove"></i></a>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
						<?php } else { ?>
						<p class="no-margin"><?php echo _l('leads_sources_not_found'); ?></p>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<div class="modal animated fadeIn" id="source" tabindex="-1" role="dialog">
	<div class="modal-dialog modal-lg">
		<?php echo form_open(admin_url('leads/industry')); ?>
		<div class="modal-content">
			<div class="modal-header">
				
			<div class="pull-right">
				<button type="button" class="btn btn-primary actionclose" data-dismiss="modal" >Exit</button>
				<button type="submit"  data-name="save" class="btn btn-primary actionbtn" ><?php echo _l('submit'); ?></button>
                <button type="submit"  data-name="snew" class="btn btn-primary actionbtn" >Save & New</button>
                <button type="submit" data-name="slist" class="btn btn-primary actionbtn" >Save & List</button>
				</div><h4 class="modal-title">
					<span class="edit-title"><?php echo _l('lead_add_edit_edit_industry'); ?></span>
					<span class="add-title"><?php echo _l('lead_new_industry'); ?></span>
				</h4>
			</div>
			<div class="modal-body">
				<div class="row">
					<div class="col-md-12">
						<div id="additional"></div>
						<?php echo render_input('name','leads_sources_table_industry'); ?>
					</div>
				</div>
			</div>
		</div><!-- /.modal-content -->
		<?php echo form_close(); ?>
	</div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<?php init_tail(); ?>
<script>
	 var submitActor = null;
	var $submitActors = $('form').find( '[type=submit]' );
	$(document).ready(function(){
		if (window.location.href.indexOf("?source=") > -1) {
		   var sId = window.location.href.split("?source=")[1];
		   $('a[onclick="edit_source(this,' +sId+ '); return false"]').click();
		}
		if (window.location.href.indexOf("?new") > -1) {
		   new_source();
		}
		_validate_form($('form'),{name:'required'},manage_leads_sources);
		$('#source').on('hidden.bs.modal', function(event) {
			$('#additional').html('');
			$('#source input').val('');
			$('.add-title').removeClass('hide');
			$('.edit-title').removeClass('hide');
		});
	});
	function manage_leads_sources(form) {
		var data = $(form).serialize();
		var url = form.action;
		$.post(url, data).success(function(response) {
			if($(submitActor).data("name") == "save"){
				window.location = window.location.pathname + "?source=" +response;
			}else if($(submitActor).data("name") == "snew"){
				window.location = window.location.pathname + "?new";
			}else if($(submitActor).data("name") == "slist"){
				window.location = window.location.pathname;
			}
			//window.location.reload();
		});
		return false;
	}
	function new_source(){
		$('#source').modal('show');
		$('.edit-title').addClass('hide');
	}
	function edit_source(invoker,id){
		var name = $(invoker).data('name');
		$('#additional').append(hidden_input('id',id));
		$('#source input[name="name"]').val(name);
		$('#source').modal('show');
		$('.add-title').addClass('hide');
	}
	$(".actionclose").click(function(){
		window.location = window.location.pathname;
	});
$submitActors.click( function( event )
    {
      submitActor = this;
    });
</script>
</body>
</html>
