<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <?php include_once(APPPATH . 'views/admin/includes/alerts.php'); ?>
            <div class="col-md-12">
                <h2>Contract Type</h2>
               <div class="panel_s">
                <div class="panel-body tableNoMTop">
					<div class="absoluteBtns">
                    <a href="#" onclick="new_type(); return false;" class="btn btn-info pull-left display-block"><?php echo _l('new_contract_type'); ?></a>
                   </div>
                    <div class="clearfix"></div>
                    <?php render_datatable(array(
                        _l('name'),
                        _l('options')
                        ),'contract-types'); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal animated fadeIn" id="type" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg">
        <?php echo form_open(admin_url('contracts/type')); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">
                    <span class="edit-title"><?php echo _l('contract_type_edit'); ?></span>
                    <span class="add-title"><?php echo _l('new_contract_type'); ?></span>
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div id="additional"></div>
                        <?php echo render_input('name','contract_type_name'); ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" data-dismiss="modal">Exit</button>
                <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
                <button type="button" class="btn btn-primary addsaveandnew">Save & New</button>
            </div>
        </div><!-- /.modal-content -->
        <?php echo form_close(); ?>
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<?php init_tail(); ?>
<script>
    $(document).ready(function(){
        _validate_form($('form'),{name:'required'},manage_contract_types);
        $('#type').on('hidden.bs.modal', function(event) {
            $('#additional').html('');
            $('#type input').val('');
            $('.add-title').removeClass('hide');
            $('.edit-title').removeClass('hide');
        });
    });
    function manage_contract_types(form) {
        var data = $(form).serialize();
        var url = form.action;
        $.post(url, data).success(function(response) {
            response = $.parseJSON(response);
            if(response.success == true){
                alert_float('success',response.message);
            }
            $('.table-contract-types').DataTable().ajax.reload();
            $('#type').modal('hide');
        });
        return false;
    }
    function new_type(){
        $('#type').modal('show');
        $('.edit-title').addClass('hide');
    }
    function edit_type(invoker,id){
        var name = $(invoker).data('name');
        $('#additional').append(hidden_input('id',id));
        $('#type input[name="name"]').val(name);
        $('#type').modal('show');
        $('.add-title').addClass('hide');
    }

    $(document).ready(function(){

        $('.addsaveandnew').on('click', function (e) {
            if($("form").valid() == true)
            {
                $.ajax({
                    type: "POST",
                    url: admin_url + 'contracts/type',
                    // data: {data: $('#add_category_form').serializeArray()},
                    data: {
                        name: $('#name').val(),
                        id: $('input[name="id"').val(),
                    },
                    // dataType: 'json',
                    success: function (response) {
                        // location.reload();
                        if (response.success == true) {
                            $('.table-customer-groups').DataTable().ajax.reload();
                            alert_float('success', response.message);
                        }
                        $('#name').val('');
                        $('input[name="id"').val('');
                        $('#customer_group_modal').modal('show');
                    }
                    
                });
            }
        });

      
    });

</script>
</body>
</html>
